/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.common;

import com.sun.wbem.solarisprovider.usermgr.auths.AuthAttrObj;
import com.sun.wbem.solarisprovider.usermgr.auths.SolarisAuthAttrTable;
import com.sun.wbem.solarisprovider.usermgr.common.ExtAttrObj;
import com.sun.wbem.solarisprovider.usermgr.common.UserException;
import com.sun.wbem.solarisprovider.usermgr.profs.SolarisProfAttrTable;
import com.sun.wbem.solarisprovider.usermgr.users.UserAttrObj;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class UserAttrUtil {
    private String scope;

    public UserAttrUtil(String string) {
        this.scope = string;
    }

    public void validateUserAttrKeys(UserAttrObj userAttrObj) throws UserException {
        int n = 0;
        String string = "";
        String string2 = userAttrObj.getUserType();
        String string3 = userAttrObj.getUserName();
        Hashtable hashtable = userAttrObj.attrSet;
        if (string2.equals("role")) {
            if (hashtable.containsKey("roles")) {
                string = string.concat("roles");
                ++n;
            }
            if (n > 0) {
                throw new UserException("EXM_UAV1", (Object)string3, string);
            }
        } else {
            if (hashtable.containsKey("members")) {
                string = string.concat("members");
                ++n;
            }
            if (hashtable.containsKey("mutex")) {
                if (n > 0) {
                    string = string.concat(", ");
                }
                string = string.concat("mutex");
                ++n;
            }
            if (hashtable.containsKey("cardinality")) {
                if (n > 0) {
                    string = string.concat(", ");
                }
                string = string.concat("cardinality");
                ++n;
            }
            if (n > 0) {
                throw new UserException("EXM_UAV2", (Object)string3, string);
            }
        }
    }

    public void validateAuthNames(ExtAttrObj extAttrObj, ExtAttrObj extAttrObj2) throws UserException {
        SolarisAuthAttrTable solarisAuthAttrTable = null;
        AuthAttrObj[] authAttrObjArray = null;
        Vector vector = extAttrObj2.getAttribute("auths");
        if (vector == null || vector.size() == 0) {
            return;
        }
        Vector vector2 = null;
        if (extAttrObj != null) {
            vector2 = extAttrObj.getAttribute("auths");
        }
        if (vector2 != null && vector2.size() > 0) {
            vector = this.getVectorDiff(vector, vector2);
        }
        if (vector.size() == 0) {
            return;
        }
        try {
            solarisAuthAttrTable = new SolarisAuthAttrTable(this.scope);
            authAttrObjArray = solarisAuthAttrTable.listAuthAttributes();
        }
        catch (Exception exception) {
            throw new UserException("EXM_UAV3", (Object)this.scope, exception.getLocalizedMessage());
        }
        String[] stringArray = new String[authAttrObjArray.length];
        int n = 0;
        while (n < authAttrObjArray.length) {
            stringArray[n] = authAttrObjArray[n].getAuthName();
            ++n;
        }
        int n2 = 0;
        String string = "";
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3;
            boolean bl = false;
            String string4 = string3 = (String)enumeration.nextElement();
            n = string3.lastIndexOf(46);
            if (n > 0 && ((string2 = string3.substring(n)).equals(".*") || string2.equals(".grant"))) {
                string4 = string3.substring(0, n + 1);
                bl = true;
            }
            boolean bl2 = true;
            n = 0;
            while (n < stringArray.length) {
                if (bl) {
                    if (stringArray[n].startsWith(string4)) {
                        bl2 = false;
                        break;
                    }
                } else if (stringArray[n].equals(string4)) {
                    bl2 = false;
                    break;
                }
                ++n;
            }
            if (!bl2) continue;
            if (n2 > 0) {
                string = string.concat(", ");
            }
            string = string.concat(string3);
            ++n2;
        }
        if (n2 > 0) {
            throw new UserException("EXM_UAV4", (Object)string, this.scope);
        }
    }

    public void validateProfNames(ExtAttrObj extAttrObj, ExtAttrObj extAttrObj2) throws UserException {
        String[] stringArray;
        SolarisProfAttrTable solarisProfAttrTable = null;
        Object var4_4 = null;
        Vector vector = extAttrObj2.getAttribute("profiles");
        if (vector == null || vector.size() == 0) {
            return;
        }
        Vector vector2 = null;
        if (extAttrObj != null) {
            vector2 = extAttrObj.getAttribute("profiles");
        }
        if (vector2 != null && vector2.size() > 0) {
            vector = this.getVectorDiff(vector, vector2);
        }
        if (vector.size() == 0) {
            return;
        }
        try {
            solarisProfAttrTable = new SolarisProfAttrTable(this.scope);
            stringArray = solarisProfAttrTable.getProfilesList();
        }
        catch (Exception exception) {
            throw new UserException("EXM_UAV5", (Object)this.scope, exception.getLocalizedMessage());
        }
        int n = 0;
        String string = "";
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            boolean bl = true;
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (string2.equals(stringArray[n2])) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (!bl) continue;
            if (n > 0) {
                string = string.concat(", ");
            }
            string = string.concat(string2);
            ++n;
        }
        if (n > 0) {
            throw new UserException("EXM_UAV6", (Object)string, this.scope);
        }
    }

    private Vector getVectorDiff(Vector vector, Vector vector2) {
        if (vector == null) {
            return new Vector(0);
        }
        Vector vector3 = (Vector)vector.clone();
        if (vector2 != null) {
            int n = 0;
            while (n < vector2.size()) {
                vector3.removeElement(vector2.elementAt(n));
                ++n;
            }
        }
        return vector3;
    }
}

