/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.serialport;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.serialport.SerialPortData;
import com.sun.wbem.solarisprovider.serialport.SerialPortException;
import com.sun.wbem.solarisprovider.serialport.SerialPortInfo;
import com.sun.wbem.utility.log.LogUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.MethodProvider;
import javax.wbem.query.NonJoinExp;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectList;
import javax.wbem.query.WQLParser;

public class Solaris_SerialPort
implements InstanceProvider,
MethodProvider,
Authorizable {
    public static final String SERIAL_MODIFY_RIGHT = "solaris.admin.serialmgr.modify";
    public static final String SERIAL_DELETE_RIGHT = "solaris.admin.serialmgr.delete";
    public static final String SERIAL_READ_RIGHT = "solaris.admin.serialmgr.read";
    public static final String PROVIDER_NAME = "SerialPort";
    SerialPortInfo dat = null;
    LogUtil util = null;
    int num_ports;
    private CIMOMHandle cimomhandle = null;
    private ProviderUtility provUtil = null;

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        this.util = LogUtil.getInstance((CIMOMHandle)cIMOMHandle);
        String string = this.util.getMessage("LM_SERIAL_APP_NAME");
        this.provUtil = new ProviderUtility(cIMOMHandle, string);
    }

    public void cleanup() throws CIMException {
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        CIMProperty cIMProperty;
        this.provUtil.checkRights(SERIAL_READ_RIGHT, cIMObjectPath);
        String string = "";
        SerialPortData serialPortData = null;
        this.dat = this.initData();
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            cIMProperty = (CIMProperty)enumeration.nextElement();
            if (!cIMProperty.getName().equalsIgnoreCase("DeviceID")) continue;
            string = (String)cIMProperty.getValue().getValue();
        }
        try {
            serialPortData = this.dat.getPortData(string);
        }
        catch (SerialPortException serialPortException) {
            String string2 = serialPortException.getLocalizedMessage();
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        catch (Exception exception) {
            String string3 = this.provUtil.writeLog(2, exception);
            throw new CIMException("CIM_ERR_FAILED", (Object)string3);
        }
        cIMProperty = cIMClass.newInstance();
        cIMProperty.setProperty("DeviceID", new CIMValue((Object)string));
        cIMProperty.setProperty("SettableBaudRate", new CIMValue((Object)new Boolean("false")));
        cIMProperty.setProperty("SettableDataBits", new CIMValue((Object)new Boolean("false")));
        cIMProperty.setProperty("SettableFlowControl", new CIMValue((Object)new Boolean("false")));
        cIMProperty.setProperty("SettableParity", new CIMValue((Object)new Boolean("false")));
        cIMProperty.setProperty("SettableParityCheck", new CIMValue((Object)new Boolean("false")));
        cIMProperty.setProperty("SettableStopBits", new CIMValue((Object)new Boolean("false")));
        cIMProperty.setProperty("SupportsParityCheck", new CIMValue((Object)new Boolean("false")));
        cIMProperty.setProperty("SupportsXOnXOff", new CIMValue((Object)new Boolean("false")));
        cIMProperty.setProperty("SupportsXOnXOffSet", new CIMValue((Object)new Boolean("false")));
        cIMProperty.setProperty("PortMonitor", new CIMValue((Object)serialPortData.getPortMonTag()));
        cIMProperty.setProperty("ServiceTag", new CIMValue((Object)serialPortData.getServiceTag()));
        cIMProperty.setProperty("Comment", new CIMValue((Object)serialPortData.getComment()));
        cIMProperty.setProperty("ServiceEnabled", new CIMValue((Object)new Boolean(serialPortData.isEnableSet())));
        if (bl) {
            cIMProperty = cIMProperty.localElements();
            return cIMProperty.filterProperties(stringArray, bl2, bl3);
        }
        cIMProperty.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
        try {
            cIMProperty.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        cIMProperty.setProperty("CreationClassName", new CIMValue((Object)"Solaris_SerialPort"));
        return cIMProperty.filterProperties(stringArray, bl2, bl3);
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        this.provUtil.checkRights(SERIAL_READ_RIGHT, cIMObjectPath);
        Vector<CIMInstance> vector = new Vector<CIMInstance>();
        SerialPortData serialPortData = null;
        CIMInstance cIMInstance = null;
        this.dat = this.initData();
        int n = 0;
        while (n < this.num_ports) {
            cIMInstance = cIMClass.newInstance();
            try {
                serialPortData = this.dat.getPortData(this.dat.getPortName(n));
                cIMInstance.setProperty("DeviceID", new CIMValue((Object)this.dat.getPortName(n)));
            }
            catch (SerialPortException serialPortException) {
                String string = serialPortException.getLocalizedMessage();
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
            }
            catch (Exception exception) {
                String string = this.provUtil.writeLog(2, exception);
                throw new CIMException("CIM_ERR_FAILED", (Object)string);
            }
            cIMInstance.setProperty("SettableBaudRate", new CIMValue((Object)new Boolean("false")));
            cIMInstance.setProperty("SettableDataBits", new CIMValue((Object)new Boolean("false")));
            cIMInstance.setProperty("SettableFlowControl", new CIMValue((Object)new Boolean("false")));
            cIMInstance.setProperty("SettableParity", new CIMValue((Object)new Boolean("false")));
            cIMInstance.setProperty("SettableParityCheck", new CIMValue((Object)new Boolean("false")));
            cIMInstance.setProperty("SettableStopBits", new CIMValue((Object)new Boolean("false")));
            cIMInstance.setProperty("SupportsParityCheck", new CIMValue((Object)new Boolean("false")));
            cIMInstance.setProperty("SupportsXOnXOff", new CIMValue((Object)new Boolean("false")));
            cIMInstance.setProperty("SupportsXOnXOffSet", new CIMValue((Object)new Boolean("false")));
            cIMInstance.setProperty("PortMonitor", new CIMValue((Object)serialPortData.getPortMonTag()));
            cIMInstance.setProperty("ServiceTag", new CIMValue((Object)serialPortData.getServiceTag()));
            cIMInstance.setProperty("Comment", new CIMValue((Object)serialPortData.getComment()));
            cIMInstance.setProperty("ServiceEnabled", new CIMValue((Object)new Boolean(serialPortData.isEnableSet())));
            cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            try {
                cIMInstance.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_SerialPort"));
            if (bl) {
                cIMInstance = cIMInstance.localElements();
            }
            vector.addElement(cIMInstance.filterProperties(stringArray, bl2, bl3));
            ++n;
        }
        CIMInstance[] cIMInstanceArray = new CIMInstance[vector.size()];
        vector.toArray(cIMInstanceArray);
        return cIMInstanceArray;
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        CIMObjectPath cIMObjectPath2;
        this.provUtil.checkRights(SERIAL_READ_RIGHT, cIMObjectPath);
        Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
        this.dat = this.initData();
        int n = 0;
        while (n < this.num_ports) {
            cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
            try {
                cIMObjectPath2.addKey("DeviceID", new CIMValue((Object)this.dat.getPortName(n)));
            }
            catch (Exception exception) {
                String string = this.provUtil.writeLog(2, exception);
                throw new CIMException("CIM_ERR_FAILED", (Object)string);
            }
            cIMObjectPath2.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            try {
                cIMObjectPath2.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_SerialPort"));
            vector.addElement(cIMObjectPath2);
            ++n;
        }
        cIMObjectPath2 = new CIMObjectPath[vector.size()];
        vector.toArray((T[])cIMObjectPath2);
        return cIMObjectPath2;
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public synchronized CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        if (string.equalsIgnoreCase("disableportservice")) {
            this.provUtil.checkRights(SERIAL_DELETE_RIGHT, cIMObjectPath);
            return new CIMValue((Object)this.DisablePortService(cIMObjectPath));
        }
        return null;
    }

    public Boolean DisablePortService(CIMObjectPath cIMObjectPath) throws CIMException {
        this.dat = this.initData();
        String string = "";
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            if (!cIMProperty.getName().equalsIgnoreCase("DeviceID")) continue;
            string = (String)cIMProperty.getValue().getValue();
        }
        try {
            this.dat.synchronizedDeletePort(string);
        }
        catch (SerialPortException serialPortException) {
            String string2 = serialPortException.getLocalizedMessage();
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        catch (Exception exception) {
            String string3 = this.provUtil.writeLog(2, exception);
            throw new CIMException("CIM_ERR_FAILED", (Object)string3);
        }
        return new Boolean(true);
    }

    private SerialPortInfo initData() throws CIMException {
        try {
            SerialPortInfo serialPortInfo = new SerialPortInfo(this.util);
            this.num_ports = serialPortInfo.initData();
            return serialPortInfo;
        }
        catch (SerialPortException serialPortException) {
            String string = serialPortException.getLocalizedMessage();
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        catch (Exception exception) {
            String string = this.provUtil.writeLog(2, exception);
            throw new CIMException("CIM_ERR_FAILED", (Object)string);
        }
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        CIMInstance[] cIMInstanceArray;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        WQLParser wQLParser = new WQLParser((InputStream)byteArrayInputStream);
        Vector<CIMElement> vector = new Vector<CIMElement>();
        try {
            cIMInstanceArray = (CIMInstance[])wQLParser.querySpecification();
            SelectList selectList = cIMInstanceArray.getSelectList();
            NonJoinExp nonJoinExp = (NonJoinExp)cIMInstanceArray.getFromClause();
            QueryExp queryExp = cIMInstanceArray.getWhereClause();
            CIMInstance[] cIMInstanceArray2 = this.enumerateInstances(cIMObjectPath, true, false, false, null, cIMClass);
            int n = 0;
            while (n < cIMInstanceArray2.length) {
                if (queryExp == null || queryExp.apply((CIMElement)cIMInstanceArray2[n])) {
                    vector.addElement(selectList.apply((CIMElement)cIMInstanceArray2[n]));
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
        cIMInstanceArray = new CIMInstance[vector.size()];
        vector.toArray(cIMInstanceArray);
        return cIMInstanceArray;
    }
}

