/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.patch;

import com.sun.patchpro.model.PatchProListener;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchInfo;
import com.sun.patchpro.patch.PatchList;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.patch.PPro;
import com.sun.wbem.solarisprovider.patch.PatchException;
import java.util.Vector;

public class AssessNeededPatches
extends PPro {
    boolean done = false;
    Vector patchIds = new Vector();
    Vector synopsis = new Vector();

    public AssessNeededPatches(ProviderUtility providerUtility) {
        provUtil = providerUtility;
    }

    public void initialize() throws PatchException {
        this.init();
        this.analyzeHost();
    }

    public void getAssessedPatchesNeeded() throws PatchException {
        try {
            if (this.host == null) {
                PatchException patchException = new PatchException("EXM_ANP_HOST_NOT_ANA");
                throw patchException;
            }
            PatchList patchList = this.getNeededPatches();
            this.setPatchProData(patchList);
        }
        catch (PatchException patchException) {
            throw patchException;
        }
        catch (Exception exception) {
            String string = exception.getLocalizedMessage();
            PatchException patchException = new PatchException(string);
            throw patchException;
        }
    }

    public Vector getPatchIds() {
        return this.patchIds;
    }

    public Vector getSynopsis() {
        return this.synopsis;
    }

    private void setPatchProData(PatchList patchList) throws PatchException {
        if (patchList == null || patchList.size() == 0) {
            PatchException patchException = new PatchException("EXM_ANP_PATCHLIST_EMPTY");
            throw patchException;
        }
        try {
            String string = null;
            String string2 = null;
            int n = patchList.size();
            int n2 = 0;
            while (n2 < n) {
                PatchInfo patchInfo;
                PatchID patchID;
                Patch patch = patchList.getPatchAt(n2);
                if (!(patch == null || (patchID = patch.getPatchID()) == null || (string = patchID.getPatchID()) == null && string.length() <= 0 || (patchInfo = patch.getPatchInfo()) == null || (string2 = patchInfo.getSynopsis()) == null && string2.length() <= 0)) {
                    this.patchIds.addElement(string);
                    this.synopsis.addElement(string2);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            PatchException patchException = new PatchException(exception.getLocalizedMessage());
            throw patchException;
        }
    }

    private void testGetAssessedPatchesNeeded() throws PatchException {
        this.getAssessedPatchesNeeded();
        int n = 0;
        while (this.patchIds != null && n < this.patchIds.size()) {
            System.out.print("Patch ID: " + (String)this.patchIds.elementAt(n) + "\tSynopsis: " + (String)this.synopsis.elementAt(n));
            ++n;
        }
    }

    public void test() {
        boolean bl = false;
        while (!bl) {
            System.out.println("1 - Get the needed patches:");
            System.out.println("q - To quit");
            System.out.println("");
            System.out.print("Enter option: ");
            try {
                byte[] byArray = new byte[100];
                char c = (char)System.in.read(byArray);
                System.out.println("");
                if (c != '\u0002') continue;
                char c2 = (char)byArray[0];
                switch (c2) {
                    case '1': {
                        this.testGetAssessedPatchesNeeded();
                        break;
                    }
                    case 'q': {
                        if (this.model != null) {
                            this.model.removeListener((PatchProListener)this);
                        }
                        bl = true;
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception);
                exception.printStackTrace();
            }
            System.out.println("");
        }
    }

    public static void main(String[] stringArray) {
        AssessNeededPatches assessNeededPatches = new AssessNeededPatches(null);
        try {
            assessNeededPatches.initialize();
        }
        catch (PatchException patchException) {
            patchException.printStackTrace();
        }
        assessNeededPatches.test();
    }
}

