/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.query;

import java.io.ByteArrayInputStream;
import javax.wbem.query.FromExp;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectList;
import javax.wbem.query.WQLExp;
import javax.wbem.query.WQLParser;

public class SelectExp
extends WQLExp {
    private SelectList attList;
    private QueryExp whereClause;
    private FromExp fromExp;

    public SelectExp(String string) {
        WQLParser wQLParser = new WQLParser(new ByteArrayInputStream(string.getBytes()));
        SelectExp selectExp = null;
        try {
            selectExp = (SelectExp)wQLParser.querySpecification();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.toString());
        }
        this.attList = selectExp.attList;
        this.whereClause = selectExp.whereClause;
        this.fromExp = selectExp.fromExp;
    }

    public SelectExp(SelectList selectList, FromExp fromExp) {
        this.attList = selectList;
        this.fromExp = fromExp;
    }

    public SelectExp(SelectList selectList, FromExp fromExp, QueryExp queryExp) {
        this.attList = selectList;
        this.fromExp = fromExp;
        this.whereClause = queryExp;
    }

    public SelectExp() {
    }

    public SelectList getSelectList() {
        return this.attList;
    }

    public QueryExp getWhereClause() {
        return this.whereClause;
    }

    public FromExp getFromClause() {
        return this.fromExp;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select ").append(this.attList).append(" from ").append(this.fromExp);
        if (this.whereClause != null) {
            stringBuffer.append(" where ").append(this.whereClause);
        }
        return stringBuffer.toString();
    }
}

