/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.patchmgr.common;

import com.sun.admin.patchmgr.common.PatchMgrObj;
import com.sun.admin.patchmgr.common.RequiredPatchesObj;
import com.sun.admin.patchmgr.common.SpooledPatchData;
import com.sun.admin.patchmgr.common.VerifyPatch;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PatchVerificationObj
implements Serializable {
    private Hashtable spoolPatchHashTable = new Hashtable();
    private Hashtable systemPatchHashTable = new Hashtable();
    private Vector patchObjVec;
    private String patchToBeChecked = new String();
    private String targetSystemOS = new String();
    private String targetSystemArch = new String();
    private Hashtable packageListHT = new Hashtable();
    private Vector preVerifiedList;
    private Hashtable preVerifiedListHT = new Hashtable();
    private boolean patchHasBeenApplied = false;
    private boolean olderPatchRevHasBeenApplied = false;
    private boolean newerPatchRevHasBeenApplied = false;
    private String patchBaseNum = new String();
    private String patchRevNum = new String();
    private boolean validSunOS = true;
    private boolean validArch = false;
    private boolean aPatchOnSystemHasConflict = false;
    private boolean thisPatchConflictsWithAnExistingPatch = false;
    private Vector thisPatchConflicts = new Vector();
    private Vector patchOnSystemHasConflict = new Vector();
    private boolean obsolescedByAnExistingPatch = false;
    private boolean aPatchOnSystemObsolescedThisPatch = false;
    private Vector thisPatchObsoletes = new Vector();
    private Vector thisPatchIsObsoletedBy = new Vector();
    private boolean allRequiredPkgsAreOnSystem = true;
    private Vector pkgsNotOnSystem = new Vector();
    private boolean thisPatchRequiresPatches = false;
    private RequiredPatchesObj rpo = new RequiredPatchesObj();
    private boolean conflictsWithPreVerifiedPatch = false;
    private boolean aPreVerifiedPatchHasConflict = false;
    private Vector thisPatchConflictsWithVerifiedPatch = new Vector();
    private Vector preVerifiedPatchHasConflict = new Vector();
    private boolean obsoletesAPreVerifiedPatch = false;
    private boolean preVerifiedPatchObsoletesThisPatch = false;
    private Vector thisPatchObsoletesAPreVerifiedPatch = new Vector();
    private Vector aPreVerifiedPatchObsoletesThisPatch = new Vector();
    private boolean thisPatchIsInThePreVerifiedList = false;
    private boolean preVerifiedListHasOlderRev = false;
    private boolean preVerifiedListHasNewerRev = false;

    public PatchVerificationObj(String string, Hashtable hashtable, Vector vector, Hashtable hashtable2, String string2, String string3, Vector vector2) {
        this.patchToBeChecked = string;
        this.targetSystemOS = string2;
        this.targetSystemArch = string3;
        this.spoolPatchHashTable = hashtable;
        this.patchObjVec = vector;
        this.packageListHT = hashtable2;
        this.preVerifiedList = vector2;
        this.makeSystemPatchHashTabel();
        if (this.preVerifiedList != null && this.preVerifiedList.size() > 0) {
            this.makePreVerifiedListHT();
        }
    }

    public String getPatchToBeChecked() {
        return this.patchToBeChecked;
    }

    public boolean getValidSunOS() {
        return this.validSunOS;
    }

    public boolean getValidArch() {
        return this.validArch;
    }

    public boolean getPatchHasBeenApplied() {
        return this.patchHasBeenApplied;
    }

    public boolean getPatchIsInThePreVerifiedList() {
        return this.thisPatchIsInThePreVerifiedList;
    }

    public boolean getPreVerifiedListHasOlderRev() {
        return this.preVerifiedListHasOlderRev;
    }

    public boolean getPreVerifiedListHasNewerRev() {
        return this.preVerifiedListHasNewerRev;
    }

    public boolean getObsoletesAPreVerifiedPatch() {
        return this.obsoletesAPreVerifiedPatch;
    }

    public boolean getPreVerifiedPatchObsoletesThisPatch() {
        return this.preVerifiedPatchObsoletesThisPatch;
    }

    public boolean getConflictsWithPreVerifiedPatch() {
        return this.conflictsWithPreVerifiedPatch;
    }

    public boolean getPreVerifiedPatchHasConflict() {
        return this.aPreVerifiedPatchHasConflict;
    }

    public boolean getOlderPatchRevHasBeenApplied() {
        return this.olderPatchRevHasBeenApplied;
    }

    public boolean getNewerPatchRevHasBeenApplied() {
        return this.newerPatchRevHasBeenApplied;
    }

    public boolean getAPatchOnSystemHasConflict() {
        return this.aPatchOnSystemHasConflict;
    }

    public boolean getThisPatchConflictsWithAnExistingPatch() {
        return this.thisPatchConflictsWithAnExistingPatch;
    }

    public boolean getObsolescedByAnExistingPatch() {
        return this.obsolescedByAnExistingPatch;
    }

    public boolean getAPatchOnSystemObsolescedThisPatch() {
        return this.aPatchOnSystemObsolescedThisPatch;
    }

    public boolean getAllRequiredPkgsAreOnSystem() {
        return this.allRequiredPkgsAreOnSystem;
    }

    public String getTargetedSystemOS() {
        return this.targetSystemOS;
    }

    public String getTargetedSystemArch() {
        return this.targetSystemArch;
    }

    public Hashtable getPackageListHT() {
        return this.packageListHT;
    }

    public Vector getPkgsNotOnSystem() {
        return this.pkgsNotOnSystem;
    }

    public boolean getThisPatchRequiresPatches() {
        return this.thisPatchRequiresPatches;
    }

    public RequiredPatchesObj getRequiredPatchesObj() {
        return this.rpo;
    }

    public Vector getPatchConflictsWithVerifiedPatchList() {
        return this.thisPatchConflictsWithVerifiedPatch;
    }

    public Vector getPreVerifiedPatchHasConflictList() {
        return this.preVerifiedPatchHasConflict;
    }

    public Vector getPatchObsoletesAPreVerifiedPatchList() {
        return this.thisPatchObsoletesAPreVerifiedPatch;
    }

    public Vector getPreVerifiedPatchObsoletesThisPatchList() {
        return this.aPreVerifiedPatchObsoletesThisPatch;
    }

    public Vector getThisPatchConflictsList() {
        return this.thisPatchConflicts;
    }

    public Vector getPatchOnSystemHasConflictList() {
        return this.patchOnSystemHasConflict;
    }

    public Vector getPatchObsoletesList() {
        return this.thisPatchObsoletes;
    }

    public Vector getPatchIsObsoletedByList() {
        return this.thisPatchIsObsoletedBy;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkRequiredPatches() {
        PatchMgrObj patchMgrObj = null;
        SpooledPatchData spooledPatchData = this.getSpooledPatchData();
        if (spooledPatchData == null) {
            patchMgrObj = this.getPatchMgrObj();
            if (patchMgrObj == null) return;
            Vector vector = patchMgrObj.getRequires();
            if (vector != null && vector.size() > 0) {
                this.thisPatchRequiresPatches = true;
            }
        } else {
            Vector vector = spooledPatchData.getRequires();
            if (vector != null && vector.size() > 0) {
                this.thisPatchRequiresPatches = true;
            }
        }
        if (!this.thisPatchRequiresPatches) return;
        this.rpo.setSpoolList(this.spoolPatchHashTable);
        this.rpo.setSystemList(this.systemPatchHashTable);
        if (spooledPatchData != null) {
            this.rpo.setSpooledPatchData(spooledPatchData);
        } else {
            if (patchMgrObj == null) return;
            this.rpo.setPatchMgrObj(patchMgrObj);
        }
        this.rpo.processRequireDependency();
    }

    public void checkRequiredPackages() {
        SpooledPatchData spooledPatchData = this.getSpooledPatchData();
        Vector vector = null;
        if (spooledPatchData != null) {
            vector = spooledPatchData.getPackages();
        }
        if (vector != null && vector.size() > 0) {
            int n = vector.size();
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                String string = (String)vector.elementAt(n3);
                String string2 = (String)this.packageListHT.get(string);
                if (string2 == null && n == 1) {
                    this.allRequiredPkgsAreOnSystem = false;
                    this.pkgsNotOnSystem.addElement(string);
                    return;
                }
                if (string2 == null) {
                    ++n2;
                    this.pkgsNotOnSystem.addElement(string);
                }
                ++n3;
            }
            if (n2 == n) {
                this.allRequiredPkgsAreOnSystem = false;
                return;
            }
            return;
        }
    }

    public void checkObsolescedPatches() {
        Object object;
        int n;
        int n2;
        SpooledPatchData spooledPatchData = this.getSpooledPatchData();
        Vector vector = null;
        if (spooledPatchData != null) {
            vector = spooledPatchData.getObsoletes();
        }
        if (vector != null) {
            n2 = vector.size();
            boolean bl = false;
            n = 0;
            while (n < n2) {
                object = (String)vector.elementAt(n);
                bl = this.resolveSystemPatchRevs((String)object);
                if (bl) {
                    this.obsolescedByAnExistingPatch = true;
                    this.thisPatchObsoletes.addElement(object);
                }
                ++n;
            }
        }
        if (this.patchObjVec == null) {
            return;
        }
        object = new Vector();
        n = 0;
        while (n < this.patchObjVec.size()) {
            PatchMgrObj patchMgrObj = (PatchMgrObj)this.patchObjVec.elementAt(n);
            if (patchMgrObj != null) {
                object = patchMgrObj.getObsoletes();
                n2 = 0;
                if (object != null) {
                    n2 = ((Vector)object).size();
                }
                int n3 = 0;
                while (n3 < n2) {
                    String string = (String)((Vector)object).elementAt(n3);
                    if (string != null && string.length() > 0) {
                        if (this.patchToBeChecked.equals(string)) {
                            this.aPatchOnSystemObsolescedThisPatch = true;
                            this.thisPatchIsObsoletedBy.add(patchMgrObj.getPatchName());
                            break;
                        }
                        String string2 = VerifyPatch.getPatchBaseNum(string);
                        if (string2 != null && this.patchBaseNum.equals(string2)) {
                            this.aPatchOnSystemObsolescedThisPatch = true;
                            this.thisPatchIsObsoletedBy.add(patchMgrObj.getPatchName());
                            break;
                        }
                    }
                    ++n3;
                }
            }
            ++n;
        }
    }

    public void checkConflictingPatches() {
        PatchMgrObj patchMgrObj;
        Object object;
        int n;
        SpooledPatchData spooledPatchData = this.getSpooledPatchData();
        Vector vector = null;
        if (spooledPatchData != null) {
            vector = spooledPatchData.getConflicting();
        }
        if (vector != null && vector.size() > 0) {
            n = vector.size();
            object = null;
            int n2 = 0;
            while (n2 < n) {
                object = (String)vector.elementAt(n2);
                patchMgrObj = (PatchMgrObj)this.systemPatchHashTable.get(object);
                if (patchMgrObj != null) {
                    this.thisPatchConflictsWithAnExistingPatch = true;
                    this.thisPatchConflicts.addElement(object);
                }
                ++n2;
            }
        }
        if (this.patchObjVec == null) {
            return;
        }
        object = new Vector();
        int n3 = 0;
        while (n3 < this.patchObjVec.size()) {
            patchMgrObj = (PatchMgrObj)this.patchObjVec.elementAt(n3);
            if (patchMgrObj != null) {
                object = patchMgrObj.getIncompatibles();
                n = 0;
                if (object != null) {
                    n = ((Vector)object).size();
                }
                int n4 = 0;
                while (n4 < n) {
                    String string = (String)((Vector)object).elementAt(n4);
                    if (string != null && string.length() > 0 && this.patchToBeChecked.equals(string)) {
                        this.aPatchOnSystemHasConflict = true;
                        this.patchOnSystemHasConflict.addElement(patchMgrObj.getPatchName());
                    }
                    ++n4;
                }
            }
            ++n3;
        }
    }

    public void checkSunOsAndArch() {
        SpooledPatchData spooledPatchData = this.getSpooledPatchData();
        if (spooledPatchData == null) {
            return;
        }
        String string = spooledPatchData.getSunOsRelease();
        String string2 = spooledPatchData.getArchitecture();
        if (string2 != null && string2.startsWith(this.targetSystemArch)) {
            this.validArch = true;
        }
    }

    public void hasBeenApplied() {
        if (this.patchToBeChecked == null || this.patchToBeChecked.length() == 0 || this.patchObjVec == null) {
            return;
        }
        this.patchBaseNum = VerifyPatch.getPatchBaseNum(this.patchToBeChecked);
        this.patchRevNum = VerifyPatch.getPatchRevNum(this.patchToBeChecked);
        if (this.patchBaseNum == null || this.patchRevNum == null) {
            return;
        }
        int n = this.patchObjVec.size();
        int n2 = 0;
        while (n2 < n) {
            PatchMgrObj patchMgrObj = (PatchMgrObj)this.patchObjVec.elementAt(n2);
            if (this.patchToBeChecked.equals(patchMgrObj.getPatchName())) {
                this.patchHasBeenApplied = true;
            } else {
                String string = VerifyPatch.getPatchBaseNum(patchMgrObj.getPatchName());
                if (string != null && string.equals(this.patchBaseNum)) {
                    Integer n3 = new Integer(this.patchRevNum);
                    String string2 = VerifyPatch.getPatchRevNum(patchMgrObj.getPatchName());
                    Integer n4 = new Integer(string2);
                    if (n3 > n4) {
                        this.olderPatchRevHasBeenApplied = true;
                    } else {
                        this.newerPatchRevHasBeenApplied = true;
                    }
                }
            }
            ++n2;
        }
    }

    public void checkIfInPreVerifiedList() {
        if (this.patchToBeChecked == null || this.patchToBeChecked.length() == 0) {
            return;
        }
        if (this.preVerifiedList == null) {
            return;
        }
        if (this.patchBaseNum == null || this.patchBaseNum.length() == 0) {
            this.patchBaseNum = VerifyPatch.getPatchBaseNum(this.patchToBeChecked);
        }
        if (this.patchRevNum == null || this.patchRevNum.length() == 0) {
            this.patchRevNum = VerifyPatch.getPatchRevNum(this.patchToBeChecked);
        }
        int n = this.preVerifiedList.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.preVerifiedList.elementAt(n2);
            if (this.patchToBeChecked.equals(string)) {
                this.thisPatchIsInThePreVerifiedList = true;
            } else {
                String string2 = VerifyPatch.getPatchBaseNum(string);
                if (string2 != null && string2.equals(this.patchBaseNum)) {
                    Integer n3 = new Integer(this.patchRevNum);
                    String string3 = VerifyPatch.getPatchRevNum(string);
                    Integer n4 = new Integer(string3);
                    if (n3 > n4) {
                        this.preVerifiedListHasOlderRev = true;
                    } else {
                        this.preVerifiedListHasNewerRev = true;
                    }
                }
            }
            ++n2;
        }
    }

    public void checkPreVerfiedListForConflicts() {
        String string;
        int n;
        SpooledPatchData spooledPatchData = this.getSpooledPatchData();
        Vector vector = null;
        if (spooledPatchData != null) {
            vector = spooledPatchData.getConflicting();
        }
        if (vector != null) {
            n = vector.size();
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                string = (String)vector.elementAt(n2);
                bl = this.resolvePreVerifyListRevs(string, 1);
                if (bl) {
                    this.conflictsWithPreVerifiedPatch = true;
                    this.thisPatchConflictsWithVerifiedPatch.addElement(string);
                }
                ++n2;
            }
        }
        Enumeration enumeration = this.preVerifiedListHT.elements();
        while (enumeration.hasMoreElements()) {
            SpooledPatchData spooledPatchData2 = (SpooledPatchData)enumeration.nextElement();
            if (spooledPatchData2 == null) continue;
            vector = spooledPatchData2.getConflicting();
            n = 0;
            if (vector != null) {
                n = vector.size();
            }
            int n3 = 0;
            while (n3 < n) {
                string = (String)vector.elementAt(n3);
                String string2 = VerifyPatch.getPatchBaseNum(this.patchToBeChecked);
                String string3 = VerifyPatch.getPatchBaseNum(string);
                if (string3 != null && string2 != null && string3.equals(string2)) {
                    String string4 = VerifyPatch.getPatchRevNum(this.patchToBeChecked);
                    String string5 = VerifyPatch.getPatchRevNum(string);
                    if (string5 != null && string4 != null) {
                        Integer n4 = new Integer(string4);
                        Integer n5 = new Integer(string5);
                        if (n4 >= n5) {
                            this.aPreVerifiedPatchHasConflict = true;
                            this.preVerifiedPatchHasConflict.addElement(spooledPatchData2.getPatchId());
                        }
                    }
                }
                ++n3;
            }
        }
    }

    public void checkPreVerfiedListForObsoletes() {
        int n;
        SpooledPatchData spooledPatchData = this.getSpooledPatchData();
        String string = null;
        Vector vector = null;
        if (spooledPatchData != null) {
            vector = spooledPatchData.getObsoletes();
        }
        if (vector != null) {
            n = vector.size();
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                string = (String)vector.elementAt(n2);
                bl = this.resolvePreVerifyListRevs(string, 0);
                if (bl) {
                    this.obsoletesAPreVerifiedPatch = true;
                    this.thisPatchObsoletesAPreVerifiedPatch.addElement(string);
                }
                ++n2;
            }
        }
        Enumeration enumeration = this.preVerifiedListHT.elements();
        block1: while (enumeration.hasMoreElements()) {
            SpooledPatchData spooledPatchData2 = (SpooledPatchData)enumeration.nextElement();
            vector = spooledPatchData2.getObsoletes();
            if (vector == null) continue;
            n = vector.size();
            int n3 = 0;
            while (n3 < n) {
                string = (String)vector.elementAt(n3);
                if (string != null && string.length() > 0) {
                    if (this.patchToBeChecked.equals(string)) {
                        this.preVerifiedPatchObsoletesThisPatch = true;
                        this.aPreVerifiedPatchObsoletesThisPatch.addElement(spooledPatchData2.getPatchId());
                    } else {
                        String string2 = VerifyPatch.getPatchBaseNum(string);
                        if (string2 != null && this.patchBaseNum.equals(string2)) {
                            this.preVerifiedPatchObsoletesThisPatch = true;
                            this.aPreVerifiedPatchObsoletesThisPatch.addElement(spooledPatchData2.getPatchId());
                            continue block1;
                        }
                    }
                }
                ++n3;
            }
        }
    }

    private void makeSystemPatchHashTabel() {
        int n = 0;
        if (this.patchObjVec != null) {
            n = this.patchObjVec.size();
        }
        int n2 = 0;
        while (n2 < n) {
            PatchMgrObj patchMgrObj = (PatchMgrObj)this.patchObjVec.elementAt(n2);
            if (patchMgrObj != null) {
                this.systemPatchHashTable.put(patchMgrObj.getPatchName(), patchMgrObj);
            }
            ++n2;
        }
    }

    private void makePreVerifiedListHT() {
        if (this.spoolPatchHashTable == null) {
            return;
        }
        int n = this.preVerifiedList.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.preVerifiedList.elementAt(n2);
            SpooledPatchData spooledPatchData = (SpooledPatchData)this.spoolPatchHashTable.get(string);
            if (spooledPatchData != null) {
                this.preVerifiedListHT.put(string, spooledPatchData);
            }
            ++n2;
        }
    }

    protected SpooledPatchData getSpooledPatchData() {
        if (this.spoolPatchHashTable != null && this.patchToBeChecked != null && this.patchToBeChecked.length() > 0) {
            SpooledPatchData spooledPatchData = (SpooledPatchData)this.spoolPatchHashTable.get(this.patchToBeChecked);
            return spooledPatchData;
        }
        return null;
    }

    private PatchMgrObj getPatchMgrObj() {
        if (this.systemPatchHashTable != null && this.patchToBeChecked != null && this.patchToBeChecked.length() > 0) {
            PatchMgrObj patchMgrObj = (PatchMgrObj)this.systemPatchHashTable.get(this.patchToBeChecked);
            return patchMgrObj;
        }
        return null;
    }

    private boolean resolveSystemPatchRevs(String string) {
        PatchMgrObj patchMgrObj = (PatchMgrObj)this.systemPatchHashTable.get(string);
        if (patchMgrObj != null) {
            return true;
        }
        String string2 = VerifyPatch.getPatchBaseNum(string);
        if (string2 == null) {
            return false;
        }
        Enumeration enumeration = this.systemPatchHashTable.keys();
        String string3 = null;
        String string4 = null;
        while (string2 != null && enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            string4 = VerifyPatch.getPatchBaseNum(string3);
            if (string4 == null || !string2.equals(string4)) continue;
            return true;
        }
        return false;
    }

    private boolean resolvePreVerifyListRevs(String string, int n) {
        SpooledPatchData spooledPatchData = (SpooledPatchData)this.preVerifiedListHT.get(string);
        if (spooledPatchData != null) {
            return true;
        }
        String string2 = VerifyPatch.getPatchBaseNum(string);
        if (string2 == null) {
            return false;
        }
        String string3 = null;
        Enumeration enumeration = this.preVerifiedListHT.keys();
        String string4 = null;
        String string5 = null;
        String string6 = null;
        while (enumeration.hasMoreElements()) {
            string4 = (String)enumeration.nextElement();
            string5 = VerifyPatch.getPatchBaseNum(string4);
            if (string5 == null) continue;
            if (string2.equals(string5) && n == 0) {
                return true;
            }
            if (!string2.equals(string5) || n != 1) continue;
            string3 = VerifyPatch.getPatchRevNum(string);
            string6 = VerifyPatch.getPatchRevNum(string4);
            Integer n2 = new Integer(string3);
            Integer n3 = new Integer(string6);
            if (n3 < n2) continue;
            return true;
        }
        return false;
    }

    public String reportVerificationAnalysis() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\n---------------------------------------------\n\n");
        stringBuffer.append("Patch Id: ");
        stringBuffer.append(this.patchToBeChecked);
        stringBuffer.append("\n");
        stringBuffer.append("target system OS release: ");
        stringBuffer.append(this.targetSystemOS);
        stringBuffer.append("\n");
        stringBuffer.append("target system architecture: ");
        stringBuffer.append(this.targetSystemArch);
        stringBuffer.append("\n");
        stringBuffer.append("\n\n---------------------------------------------\n\n");
        stringBuffer.append("Patch has been applied: ");
        stringBuffer.append(this.patchHasBeenApplied);
        stringBuffer.append("\n");
        stringBuffer.append("Older patch revision has been applied: ");
        stringBuffer.append(this.olderPatchRevHasBeenApplied);
        stringBuffer.append("\n");
        stringBuffer.append("Newer patch revision has been applied: ");
        stringBuffer.append(this.newerPatchRevHasBeenApplied);
        stringBuffer.append("\n");
        stringBuffer.append("Valid SunOS release: ");
        stringBuffer.append(this.validSunOS);
        stringBuffer.append("\n");
        stringBuffer.append("Valid Architecture: ");
        stringBuffer.append(this.validArch);
        stringBuffer.append("\n");
        stringBuffer.append("A patch on this system has a conflict with this patch, ");
        stringBuffer.append(this.patchToBeChecked);
        stringBuffer.append(" : ");
        stringBuffer.append(this.aPatchOnSystemHasConflict);
        stringBuffer.append("\n");
        stringBuffer.append("This patch, ");
        stringBuffer.append(this.patchToBeChecked);
        stringBuffer.append(", conflicts with an existing patch: ");
        stringBuffer.append(this.thisPatchConflictsWithAnExistingPatch);
        stringBuffer.append("\n");
        stringBuffer.append("This patch, ");
        stringBuffer.append(this.patchToBeChecked);
        stringBuffer.append(",  obsolesced an existing patch on the system: ");
        stringBuffer.append(this.obsolescedByAnExistingPatch);
        stringBuffer.append("\n");
        stringBuffer.append("A patch on this system has obsolesced this patch, ");
        stringBuffer.append(this.patchToBeChecked);
        stringBuffer.append(" : ");
        stringBuffer.append(this.aPatchOnSystemObsolescedThisPatch);
        stringBuffer.append("\n");
        if (this.allRequiredPkgsAreOnSystem) {
            stringBuffer.append("All required packages are on the system.\n");
        } else {
            stringBuffer.append("List of required packages not on the system:\n");
            if (this.pkgsNotOnSystem != null) {
                int n = 0;
                while (n < this.pkgsNotOnSystem.size()) {
                    stringBuffer.append("\tPackage Name: ");
                    stringBuffer.append((String)this.pkgsNotOnSystem.elementAt(n));
                    stringBuffer.append("\n");
                    ++n;
                }
            }
        }
        if (this.thisPatchRequiresPatches) {
            Vector vector = this.rpo.getRequiredPatchVector();
            if (vector != null) {
                stringBuffer.append("The required patches are:\n");
                Vector vector2 = this.rpo.getRequiredPatchIndex();
                int n = 0;
                while (n < vector.size()) {
                    stringBuffer.append("\tPatchId: ");
                    stringBuffer.append((String)vector.elementAt(n));
                    stringBuffer.append(" ");
                    Integer n2 = (Integer)vector2.elementAt(n);
                    int n3 = n2;
                    stringBuffer.append(RequiredPatchesObj.requiredPatchIs[n3]);
                    stringBuffer.append("\n");
                    ++n;
                }
            }
        } else {
            stringBuffer.append("This patch ");
            stringBuffer.append(this.patchToBeChecked);
            stringBuffer.append(", does not require other patches.\n\n");
        }
        if (this.thisPatchIsInThePreVerifiedList) {
            stringBuffer.append("This patch is already in the pre verified list.\n");
        } else {
            stringBuffer.append("This patch is NOT in the pre verified list.\n");
        }
        stringBuffer.append("A pre verified patch has an older revision: ");
        stringBuffer.append(this.preVerifiedListHasOlderRev);
        stringBuffer.append("\n");
        stringBuffer.append("A pre verified patch has a newer revision: ");
        stringBuffer.append(this.preVerifiedListHasNewerRev);
        stringBuffer.append("\n");
        stringBuffer.append("A pre verified patch obsoletes this patch, ");
        stringBuffer.append(this.patchToBeChecked);
        stringBuffer.append(" : ");
        stringBuffer.append(this.preVerifiedPatchObsoletesThisPatch);
        stringBuffer.append("\n");
        stringBuffer.append("This patch, ");
        stringBuffer.append(this.patchToBeChecked);
        stringBuffer.append(" , obsoletes a pre-verified patch: ");
        stringBuffer.append(this.obsoletesAPreVerifiedPatch);
        stringBuffer.append("\n");
        stringBuffer.append("A pre verified patch conflicts with this patch, ");
        stringBuffer.append(this.patchToBeChecked);
        stringBuffer.append(" : ");
        stringBuffer.append(this.aPreVerifiedPatchHasConflict);
        stringBuffer.append("\n");
        stringBuffer.append("This patch, ");
        stringBuffer.append(this.patchToBeChecked);
        stringBuffer.append(" , conflicts with a pre-verified patch: ");
        stringBuffer.append(this.conflictsWithPreVerifiedPatch);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

