/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.patchmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.patchmgr.client.MultiSysPatchAddWiz;
import com.sun.admin.patchmgr.client.PatchContextHelpListener;
import com.sun.admin.patchmgr.client.VPatchMgr;
import com.sun.management.viper.console.gui.wizard.VWizardCard;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class MultiPatchLocStep
extends VWizardCard {
    private VPatchMgr theApp;
    private ActionString actionString;
    private ResourceBundle bundle;
    private MultiSysPatchAddWiz wiz;
    private GenInfoPanel infoPanel;
    private PatchContextHelpListener overviewHelpListener;
    private JTextField netSrvrName;
    private JTextField netDirectory;
    public static final int HELP_CACHE_SIZE = 3;

    public MultiPatchLocStep(VPatchMgr vPatchMgr, MultiSysPatchAddWiz multiSysPatchAddWiz) {
        this.theApp = vPatchMgr;
        this.wiz = multiSysPatchAddWiz;
        this.bundle = vPatchMgr.getResourceBundle();
        super.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"mm_wiz_patch_loc_step"));
        this.constructStep();
    }

    public void constructStep() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.actionString = new ActionString(this.bundle, "mm_wiz_server_name");
        JLabel jLabel = new JLabel(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
        Constraints.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)24, (int)12, (int)0, (int)0);
        this.netSrvrName = new JTextField("", 20);
        this.netSrvrName.setMinimumSize(this.netSrvrName.getPreferredSize());
        this.netSrvrName.addCaretListener(new TextCaretListener());
        jLabel.setLabelFor(this.netSrvrName);
        Constraints.constrain((Container)((Object)this), (Component)this.netSrvrName, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)24, (int)12, (int)0, (int)0);
        this.actionString = new ActionString(this.bundle, "mm_wiz_server_dir");
        jLabel = new JLabel(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
        Constraints.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)5, (int)12, (int)0, (int)0);
        this.netDirectory = new JTextField("", 20);
        jLabel.setLabelFor(this.netDirectory);
        this.netDirectory.setMinimumSize(this.netDirectory.getPreferredSize());
        this.netDirectory.addCaretListener(new TextCaretListener());
        Constraints.constrain((Container)((Object)this), (Component)this.netDirectory, (int)1, (int)1, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)1.0, (int)5, (int)12, (int)0, (int)0);
    }

    protected void updateStatus() {
        String string = this.netSrvrName.getText();
        String string2 = this.netDirectory.getText();
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
            this.setProperty("vwp.canmoveforward", "vwp.true");
        } else {
            this.setProperty("vwp.canmoveforward", "vwp.false");
        }
    }

    public void loadHelp() {
        Vector vector = new Vector(3);
        this.infoPanel = this.wiz.getInfoPanel();
        this.overviewHelpListener = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, "add_multi_wiz_s3_overview");
        PatchContextHelpListener patchContextHelpListener = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, "add_multi_wiz_s3_server_name");
        this.netSrvrName.addFocusListener((FocusListener)((Object)patchContextHelpListener));
        PatchContextHelpListener patchContextHelpListener2 = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, "add_multi_wiz_s3_directory");
        this.netDirectory.addFocusListener((FocusListener)((Object)patchContextHelpListener2));
        ContextHelpListener.loadHelp(vector);
    }

    public void start() {
        super.start();
        String string = this.wiz.getMMWNetserverName();
        String string2 = this.wiz.getMMWSharedDir();
        if (string != null) {
            this.netSrvrName.setText(string);
        }
        if (string2 != null) {
            this.netDirectory.setText(string2);
        }
        this.netSrvrName.requestFocus();
        this.updateStatus();
        this.setProperty("vwp.canmovebackward", "vwp.true");
        this.setProperty("vwp.finishstate", "vwp.false");
        this.infoPanel.setFocusListener((FocusListener)((Object)this.overviewHelpListener), true);
    }

    public boolean stop(boolean bl) {
        if (!bl) {
            return true;
        }
        this.wiz.setCursor(Cursor.getPredefinedCursor(3));
        String string = "";
        string = this.netSrvrName.getText();
        if (string == null || string.length() == 0) {
            String string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_missing_srvr_name");
            this.wiz.setCursor(Cursor.getPredefinedCursor(0));
            new ErrorDialog(null, string2);
            this.netSrvrName.setText("");
            return false;
        }
        this.wiz.setMMWNetserverName(string);
        String string3 = this.netDirectory.getText();
        if (string3 == null || string3.length() == 0) {
            String string4 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_missing_srvr_dir");
            this.wiz.setCursor(Cursor.getPredefinedCursor(0));
            new ErrorDialog(null, string4);
            this.netDirectory.setText("");
            return false;
        }
        this.wiz.setMMWSharedDir(string3);
        String string5 = string + ":" + string3;
        boolean bl2 = false;
        String string6 = this.wiz.getServerDirToMount();
        if (string6 == null || string6.length() == 0) {
            bl2 = true;
        } else if (!string6.equals(string5)) {
            bl2 = true;
        }
        if (bl2) {
            this.wiz.setAvailablePatches(null);
            try {
                if (string6 != null) {
                    this.theApp.getpatchM().unmountPatchServer(string6);
                }
                this.theApp.getpatchM().mountPatchServer(string5);
                this.wiz.setServerDirToMount(string5);
            }
            catch (AdminException adminException) {
                this.wiz.setCursor(Cursor.getPredefinedCursor(0));
                this.theApp.reportErrorException((Exception)((Object)adminException));
                this.wiz.setServerDirToMount(null);
                return false;
            }
            try {
                Vector vector = this.theApp.getpatchM().getPatchIdsFromSpool(null);
                this.wiz.setAvailablePatches(vector);
            }
            catch (AdminException adminException) {
                this.wiz.setCursor(Cursor.getPredefinedCursor(0));
                this.theApp.reportErrorException((Exception)((Object)adminException));
                this.wiz.setAvailablePatches(null);
                return false;
            }
        }
        this.wiz.setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    public void reset() {
    }

    public boolean isSubStep() {
        return false;
    }

    class TextCaretListener
    implements CaretListener {
        TextCaretListener() {
        }

        public void caretUpdate(CaretEvent caretEvent) {
            MultiPatchLocStep.this.updateStatus();
        }
    }
}

