/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.BitSet;

public class DirectoryMask {
    public static int NONE_SET = -1;
    private BitSet mask;
    private TableDefinitions tableDefinitions;
    private int numberOfColumns;
    private int lastColumnSet;

    public DirectoryMask(TableDefinitions tableDefinitions) {
        this.tableDefinitions = tableDefinitions;
        this.numberOfColumns = this.tableDefinitions.getNumberOfColumns();
        this.lastColumnSet = NONE_SET;
        this.mask = new BitSet(this.numberOfColumns);
    }

    public void setColumn(int n) throws DirectoryTableException {
        this.mask.set(n - 1);
        if (this.lastColumnSet == NONE_SET) {
            this.lastColumnSet = n;
        } else if (n > this.lastColumnSet) {
            this.lastColumnSet = n;
        }
    }

    public void setAllColumns() throws DirectoryTableException {
        int n = 0;
        while (n < this.numberOfColumns) {
            this.mask.set(n);
            ++n;
        }
        this.lastColumnSet = this.numberOfColumns;
    }

    public void setIndexedColumns() throws DirectoryTableException {
        int n = NONE_SET;
        int n2 = 0;
        while (n2 < this.numberOfColumns) {
            if ((this.tableDefinitions.getColumnAttributes(n2 + 1) & 1) == 1) {
                this.mask.set(n2);
                n = n2 + 1;
            }
            ++n2;
        }
        if (this.lastColumnSet == NONE_SET) {
            this.lastColumnSet = n;
        } else if (n > this.lastColumnSet) {
            this.lastColumnSet = n;
        }
    }

    public void clearColumn(int n) throws DirectoryTableException {
        int n2 = 0;
        this.mask.clear(n - 1);
        if (this.lastColumnSet != NONE_SET && n == this.lastColumnSet) {
            n2 = this.lastColumnSet;
            while (n2 > 0) {
                if (this.mask.get(n2 - 1)) {
                    this.lastColumnSet = n2;
                    break;
                }
                --n2;
            }
            if (n2 == 0) {
                this.lastColumnSet = NONE_SET;
            }
        }
    }

    public void clearAllColumns() throws DirectoryTableException {
        int n = 0;
        while (n < this.numberOfColumns) {
            this.mask.clear(n);
            ++n;
        }
        this.lastColumnSet = NONE_SET;
    }

    public boolean getColumn(int n) throws DirectoryTableException {
        return this.mask.get(n - 1);
    }

    public int getLastColumnSet() throws DirectoryTableException {
        return this.lastColumnSet;
    }
}

