/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.DirectoryTableLibrary;
import com.sun.wbem.utility.directorytable.DirectoryUtility;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;

public class DirectoryFilter
implements SearchTemplate {
    public static final int COMBINATION_METHOD_NULL = 1;
    public static final int COMBINATION_METHOD_AND = 2;
    public static final int COMBINATION_METHOD_OR = 3;
    public static final int MAX_COMBINATION_METHOD = 3;
    public static final int SEARCH_ATTRIBUTE_CONTAINS = 1;
    public static final int SEARCH_ATTRIBUTE_DOES_NOT_CONTAIN = 2;
    public static final int SEARCH_ATTRIBUTE_STARTS_WITH = 3;
    public static final int SEARCH_ATTRIBUTE_ENDS_WITH = 4;
    public static final int SEARCH_ATTRIBUTE_EQUALS = 5;
    public static final int SEARCH_ATTRIBUTE_DOES_NOT_EQUAL = 6;
    public static final int SEARCH_ATTRIBUTE_LESS_THAN = 7;
    public static final int SEARCH_ATTRIBUTE_GREATER_THAN = 8;
    public static final int SEARCH_ATTRIBUTE_MATCHES_REGULAR_EXPRESSION = 9;
    public static final int MAX_SEARCH_ATTRIBUTE = 9;
    private int[] columnNumbers;
    private int[] combinationMethods;
    private int[] searchAttributes;
    private String[] values;
    private boolean[] truthValues;
    private int size;
    private int nextAvail;

    public DirectoryFilter(int n) {
        this.columnNumbers = new int[n];
        this.combinationMethods = new int[n];
        this.searchAttributes = new int[n];
        this.values = new String[n];
        this.truthValues = new boolean[n];
        this.nextAvail = 0;
        this.size = n;
    }

    public boolean matchRow(DirectoryRow directoryRow, TableDefinitions tableDefinitions) throws DirectoryTableException {
        return this.matchRow(directoryRow, 1, tableDefinitions);
    }

    public boolean matchRow(DirectoryRow directoryRow, int n, TableDefinitions tableDefinitions) throws DirectoryTableException {
        int n2;
        boolean bl;
        boolean bl2 = bl = (tableDefinitions.getTableAttributes() & 8) != 8;
        if (this.nextAvail == 0) {
            return true;
        }
        int n3 = 0;
        while (n3 < this.nextAvail) {
            String string;
            String string2;
            if (bl) {
                string2 = directoryRow.getColumn(this.columnNumbers[n3], n).toLowerCase();
                string = this.values[n3].toLowerCase();
            } else {
                string2 = directoryRow.getColumn(this.columnNumbers[n3], n);
                string = this.values[n3];
            }
            switch (this.searchAttributes[n3]) {
                case 1: {
                    this.truthValues[n3] = string2.indexOf(string) != -1;
                    break;
                }
                case 2: {
                    this.truthValues[n3] = string2.indexOf(string) == -1;
                    break;
                }
                case 3: {
                    this.truthValues[n3] = string2.regionMatches(0, string, 0, string.length());
                    break;
                }
                case 9: {
                    this.truthValues[n3] = DirectoryTableLibrary.matchRegexp(string, string2);
                    break;
                }
                case 4: {
                    this.truthValues[n3] = string2.regionMatches(string2.length() - string.length(), string, 0, string.length());
                    break;
                }
                case 5: {
                    this.truthValues[n3] = string2.equals(string);
                    break;
                }
                case 6: {
                    this.truthValues[n3] = !string2.equals(string);
                    break;
                }
                case 7: {
                    this.truthValues[n3] = DirectoryUtility.compareColumns(string, string2, tableDefinitions.getColumnAttributes(this.columnNumbers[n3]) & 0xE) > 0;
                    break;
                }
                case 8: {
                    this.truthValues[n3] = DirectoryUtility.compareColumns(string, string2, tableDefinitions.getColumnAttributes(this.columnNumbers[n3]) & 0xE) < 0;
                    break;
                }
                default: {
                    this.truthValues[n3] = false;
                }
            }
            ++n3;
        }
        int n4 = 0;
        boolean bl3 = false;
        boolean bl4 = true;
        if (this.nextAvail > 1) {
            int n5;
            n2 = 1;
            while (n2 < this.nextAvail) {
                if (this.combinationMethods[n2] == 3) {
                    bl3 = true;
                    bl4 = true;
                    n5 = n4;
                    while (n5 < n2) {
                        if (!this.truthValues[n5]) {
                            bl4 = false;
                        }
                        ++n5;
                    }
                    if (bl4) {
                        return true;
                    }
                    n4 = n2;
                }
                ++n2;
            }
            if (bl3) {
                bl4 = true;
                n5 = n4;
                while (n5 < this.nextAvail) {
                    if (!this.truthValues[n5]) {
                        bl4 = false;
                    }
                    ++n5;
                }
                if (bl4) {
                    return true;
                }
            }
        }
        if (!bl3) {
            n2 = 0;
            while (n2 < this.nextAvail) {
                if (!this.truthValues[n2]) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public DirectoryRow getTemplateAsRow(TableDefinitions tableDefinitions) throws DirectoryTableException {
        DirectoryRow directoryRow = null;
        if (this.nextAvail == 0) {
            return null;
        }
        int n = 0;
        while (n < this.nextAvail) {
            if (this.searchAttributes[n] == 5 && this.combinationMethods[n] != 3) {
                if (directoryRow == null) {
                    directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns(), 1);
                }
            } else {
                return null;
            }
            directoryRow.putColumn(this.columnNumbers[n], this.values[n]);
            ++n;
        }
        return directoryRow;
    }

    public void add(int n, int n2, int n3, String string) throws DirectoryTableException {
        if (n2 < 1 || n2 > 3) {
            throw new DirectoryTableInvalidParameterException("EXM_INVALID");
        }
        if (n3 < 1 || n3 > 9) {
            throw new DirectoryTableInvalidParameterException("EXM_INVALID");
        }
        if (this.nextAvail >= this.size) {
            throw new DirectoryTableInvalidParameterException("EXM_INVALID");
        }
        this.columnNumbers[this.nextAvail] = n;
        this.combinationMethods[this.nextAvail] = n2;
        this.searchAttributes[this.nextAvail] = n3;
        this.values[this.nextAvail] = string;
        ++this.nextAvail;
    }
}

