/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.solarisprovider.logsvc.Filterable;
import com.sun.wbem.solarisprovider.logsvc.LogRecord;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMDateTime;

public class LogFilter
implements Filterable,
Serializable {
    public static final int REVERSE = 0;
    public static final int FORWARD = 1;
    private static final String MARKER = "@#@";
    private Vector appNames;
    private int[] category = new int[3];
    private int[] severity = new int[3];
    private Date start_date = null;
    private Date end_date = null;
    private String start_date_str = null;
    private String end_date_str = null;
    private String user = null;
    private String clientHostName = null;
    private String agentHostName = null;
    private String fileName = null;
    private int reverse;

    public LogFilter() {
        this.appNames = new Vector();
        this.category[0] = -1;
        this.category[1] = -1;
        this.category[2] = -1;
        this.severity[0] = -1;
        this.severity[1] = -1;
        this.severity[2] = -1;
        this.start_date_str = null;
        this.end_date_str = null;
        this.user = null;
        this.clientHostName = null;
        this.agentHostName = null;
        this.reverse = 0;
    }

    public LogFilter(String string, int n, int n2, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n3) {
        this.appNames = new Vector();
        if (string != null) {
            this.appNames.addElement(string);
        }
        this.category[0] = n;
        this.severity[0] = n2;
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        simpleDateFormat.applyPattern("MM/dd/yyyy 'at' hh:mm:ss a");
        SimpleDateFormat simpleDateFormat2 = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        simpleDateFormat2.applyPattern("MM/dd/yyyy 'at' HH:mm:ss");
        if (string2 != null && string3 != null) {
            this.start_date_str = string2 + " at " + string3;
            try {
                this.start_date = simpleDateFormat.parse(this.start_date_str);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.start_date == null) {
                try {
                    this.start_date = simpleDateFormat2.parse(this.start_date_str);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (string4 != null && string5 != null) {
            this.end_date_str = string4 + " at " + string5;
            try {
                this.end_date = simpleDateFormat.parse(this.end_date_str);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.end_date == null) {
                try {
                    this.end_date = simpleDateFormat2.parse(this.end_date_str);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.user = string6;
        this.clientHostName = string7;
        this.agentHostName = string8;
        this.reverse = n3;
    }

    public LogFilter(String string) {
        this.category[0] = -1;
        this.category[1] = -1;
        this.category[2] = -1;
        this.severity[0] = -1;
        this.severity[1] = -1;
        this.severity[2] = -1;
        this.start_date_str = null;
        this.end_date_str = null;
        this.user = null;
        this.clientHostName = null;
        this.agentHostName = null;
        this.reverse = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, MARKER);
        int n = 0;
        int n2 = 0;
        if (string == null) {
            return;
        }
        try {
            long l;
            n = Integer.parseInt(stringTokenizer.nextToken());
            n2 = 0;
            while (n2 < n) {
                this.category[n2] = Integer.parseInt(stringTokenizer.nextToken());
                ++n2;
            }
            n = Integer.parseInt(stringTokenizer.nextToken());
            n2 = 0;
            while (n2 < n) {
                this.severity[n2] = Integer.parseInt(stringTokenizer.nextToken());
                ++n2;
            }
            String string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("dateErr")) {
                this.start_date = null;
            } else {
                l = Long.parseLong(string2);
                this.start_date = new Date(l);
            }
            string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("dateErr")) {
                this.end_date = null;
            } else {
                l = Long.parseLong(string2);
                this.end_date = new Date(l);
            }
            this.user = stringTokenizer.nextToken();
            if (this.user.equalsIgnoreCase("userUnknown")) {
                this.user = null;
            }
            this.clientHostName = stringTokenizer.nextToken();
            if (this.clientHostName.equalsIgnoreCase("clientUnknown")) {
                this.clientHostName = null;
            }
            this.agentHostName = stringTokenizer.nextToken();
            if (this.agentHostName.equalsIgnoreCase("agentUnknown")) {
                this.agentHostName = null;
            }
            this.reverse = Integer.parseInt(stringTokenizer.nextToken());
            this.fileName = stringTokenizer.nextToken();
            if (this.fileName.equalsIgnoreCase("fileUnknown")) {
                this.fileName = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String flattenFilter() {
        long l;
        String string = "";
        int n = 0;
        boolean bl = false;
        string = string + String.valueOf(this.category.length) + MARKER;
        n = 0;
        while (n < this.category.length) {
            string = string + String.valueOf(this.category[n]) + MARKER;
            ++n;
        }
        string = string + String.valueOf(this.severity.length) + MARKER;
        n = 0;
        while (n < this.severity.length) {
            string = string + String.valueOf(this.severity[n]) + MARKER;
            ++n;
        }
        if (this.start_date != null) {
            l = this.start_date.getTime();
            string = string + String.valueOf(l);
        } else {
            string = string + "dateErr";
        }
        string = string + MARKER;
        if (this.end_date != null) {
            l = this.end_date.getTime();
            string = string + String.valueOf(l);
        } else {
            string = string + "dateErr";
        }
        string = string + MARKER;
        string = this.user != null ? string + this.user : string + "userUnknown";
        string = string + MARKER;
        string = this.clientHostName != null ? string + this.clientHostName : string + "clientUnknown";
        string = string + MARKER;
        string = this.agentHostName != null ? string + this.agentHostName : string + "agentUnknown";
        string = string + MARKER;
        string = string + String.valueOf(this.reverse) + MARKER;
        string = string + MARKER;
        string = this.fileName != null ? string + this.fileName : string + "fileUnknown";
        return string;
    }

    public int[] getCategory() {
        return this.category;
    }

    public int[] getSeverity() {
        return this.severity;
    }

    public String getStartDate() {
        if (this.start_date_str != null) {
            return this.start_date_str;
        }
        return null;
    }

    public String getEndDate() {
        if (this.end_date_str != null) {
            return this.end_date_str;
        }
        return null;
    }

    public String getUser() {
        return this.user;
    }

    public String getclientHostName() {
        return this.clientHostName;
    }

    public String getAgentHostName() {
        return this.agentHostName;
    }

    public int getSortDirection() {
        return this.reverse;
    }

    public void setCategory(int n, int n2, int n3) {
        this.category[0] = n;
        this.category[1] = n2;
        this.category[2] = n3;
        this.category = this.makeFirstValid(this.category);
    }

    public void setSeverity(int n, int n2, int n3) {
        this.severity[0] = n;
        this.severity[1] = n2;
        this.severity[2] = n3;
        this.severity = this.makeFirstValid(this.severity);
    }

    public void setStartDate(String string, String string2) {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        SimpleDateFormat simpleDateFormat2 = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        simpleDateFormat.applyPattern("MM/dd/yyyy 'at' hh:mm:ss a");
        simpleDateFormat2.applyPattern("MM/dd/yyyy 'at' HH:mm:ss");
        if (string == null || string.length() == 0) {
            return;
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "00:00:00 AM";
        }
        this.start_date_str = string + " at " + string2;
        try {
            this.start_date = simpleDateFormat.parse(this.start_date_str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.start_date == null) {
            try {
                this.start_date = simpleDateFormat2.parse(this.start_date_str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setEndDate(String string, String string2) {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        SimpleDateFormat simpleDateFormat2 = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        simpleDateFormat.applyPattern("MM/dd/yyyy 'at' hh:mm:ss a");
        simpleDateFormat2.applyPattern("MM/dd/yyyy 'at' HH:mm:ss");
        if (string == null || string.length() == 0) {
            return;
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "11:59:59 PM";
        }
        this.end_date_str = string + " at " + string2;
        try {
            this.end_date = simpleDateFormat.parse(this.end_date_str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.end_date == null) {
            try {
                this.end_date = simpleDateFormat2.parse(this.end_date_str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setUser(String string) {
        if (string != null && string.length() != 0) {
            this.user = string;
        }
    }

    public void setClientHostName(String string) {
        if (string != null && string.length() != 0) {
            this.clientHostName = string;
        }
    }

    public void setAgentHostName(String string) {
        if (string != null && string.length() != 0) {
            this.agentHostName = string;
        }
    }

    public void setDirection(int n) {
        this.reverse = n;
    }

    public boolean checkConstraints(LogRecord logRecord) {
        if ((this.category[0] != -1 || this.category[1] != -1 || this.category[2] != -1) && this.category[0] != logRecord.getCategory() && this.category[1] != logRecord.getCategory() && this.category[2] != logRecord.getCategory()) {
            return false;
        }
        if ((this.severity[0] != -1 || this.severity[1] != -1 || this.severity[2] != -1) && this.severity[0] != logRecord.getSeverity() && this.severity[1] != logRecord.getSeverity() && this.severity[2] != logRecord.getSeverity()) {
            return false;
        }
        if (this.start_date != null && this.end_date != null && (this.start_date.after(logRecord.getDate()) || this.end_date.before(logRecord.getDate()))) {
            return false;
        }
        if (this.start_date == null && this.end_date != null && this.end_date.before(logRecord.getDate())) {
            return false;
        }
        if (this.start_date != null && this.end_date == null && this.start_date.after(logRecord.getDate())) {
            return false;
        }
        if (this.user != null && !this.user.equalsIgnoreCase(logRecord.getUserName())) {
            return false;
        }
        if (this.clientHostName != null && !this.clientHostName.equalsIgnoreCase(logRecord.getClientHostName())) {
            return false;
        }
        if (this.agentHostName != null && !this.agentHostName.equalsIgnoreCase(logRecord.getAgentHostName())) {
            return false;
        }
        return this.fileName == null || this.fileName.equalsIgnoreCase(logRecord.getFileName());
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String createQueryString() {
        int n;
        String string = "select * from Solaris_LogRecord where ";
        if (this.fileName != null) {
            string = string + "( FileName = '" + this.fileName + "' )";
        }
        if (this.category.length > 0 && this.category[0] != -1) {
            string = string + " AND (  category = " + this.category[0];
            n = 1;
            while (n < this.category.length) {
                if (this.category[n] != -1) {
                    string = string + " OR category = " + this.category[n];
                }
                ++n;
            }
            string = string + " )";
        }
        if (this.severity.length > 0 && this.severity[0] != -1) {
            string = string + " AND (  severity =" + this.severity[0];
            n = 1;
            while (n < this.severity.length) {
                if (this.severity[n] != -1) {
                    string = string + " OR severity = " + this.severity[n];
                }
                ++n;
            }
            string = string + " )";
        }
        if (this.start_date != null || this.end_date != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSS000");
            CIMDateTime cIMDateTime = null;
            simpleDateFormat.setLenient(false);
            try {
                String string2;
                if (this.start_date != null) {
                    cIMDateTime = new CIMDateTime(this.start_date);
                    string2 = cIMDateTime.toString();
                    string = string + " AND ( RecordDate >= '" + string2 + "' ) ";
                }
                if (this.end_date != null) {
                    cIMDateTime = new CIMDateTime(this.end_date);
                    string2 = cIMDateTime.toString();
                    string = string + " AND ( RecordDate <= '" + string2 + "' ) ";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.user != null) {
            string = string + " AND (  UserName = '" + this.user + "' ) ";
        }
        if (this.clientHostName != null) {
            string = string + " AND (  ClientMachineName = '" + this.clientHostName + "' ) ";
        }
        if (this.agentHostName != null) {
            string = string + " AND (  ServerMachineName = '" + this.agentHostName + "' ) ";
        }
        return string;
    }

    private int[] makeFirstValid(int[] nArray) {
        if (nArray[0] == -1) {
            int n = 1;
            while (n < nArray.length) {
                if (nArray[n] != -1) {
                    int n2 = nArray[0];
                    nArray[0] = nArray[n];
                    nArray[n] = n2;
                    break;
                }
                ++n;
            }
        }
        return nArray;
    }
}

