/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.common;

import com.sun.wbem.solarisprovider.common.PropertyUtilException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class PropertyUtil {
    public static final String ADMIN_SERVER_PROP_PATH = "/usr/sadm/lib/wbem";
    public static final String ADMIN_SERVER_PROP_FILE = "WbemServices.properties";
    public static final String ADMIN_PROP_SERVER_HDR = "Wbem Services properties file";
    public static final int ADMIN_PROP_MODE_READ = 0;
    public static final int ADMIN_PROP_MODE_WRITE = 1;
    public static final int ADMIN_PROP_MODE_CREATE = 2;
    public static final String ADMIN_PROP_ON_VALUE = "on";
    public static final String ADMIN_PROP_OFF_VALUE = "off";
    private String propfile;
    private int propmode;
    private Properties props = null;

    public PropertyUtil(String string, String string2, int n) throws PropertyUtilException {
        String string3 = null;
        if (string == null || string.trim().length() == 0) {
            throw new PropertyUtilException("EXCOM_PROP_PATH");
        }
        try {
            string3 = System.getProperty(string);
        }
        catch (Exception exception) {
            string3 = null;
        }
        if (string3 == null) {
            throw new PropertyUtilException("EXCOM_PROP_PATH");
        }
        if (string2 == null || string2.trim().length() == 0) {
            throw new PropertyUtilException("EXCOM_PROP_PATH");
        }
        this.propmode = n;
        string3 = string3.concat(File.separator);
        this.propfile = string3.concat(string2);
    }

    public PropertyUtil(String string, int n) throws PropertyUtilException {
        this.propfile = string;
        this.propmode = n;
    }

    public String getProp(String string) throws PropertyUtilException {
        String string2;
        if (this.props == (Properties)null) {
            this.loadProperties();
        }
        try {
            string2 = this.props.getProperty(string);
        }
        catch (Exception exception) {
            throw new PropertyUtilException("EXCOM_PROP_NOT_FOUND", string);
        }
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public Vector getPropList(String string) throws PropertyUtilException {
        Vector<String> vector = new Vector<String>();
        boolean bl = true;
        if (this.props == (Properties)null) {
            this.loadProperties();
        }
        int n = 1;
        String string2 = string.concat(".");
        while (bl) {
            string2 = string + "." + n;
            try {
                String string3 = this.props.getProperty(string2);
                if (string3 == null) {
                    bl = false;
                } else {
                    vector.addElement(string3);
                }
            }
            catch (Exception exception) {
                bl = false;
            }
            ++n;
        }
        return vector;
    }

    public Vector getPropNames() throws PropertyUtilException {
        Vector<String> vector = new Vector<String>();
        if (this.props == (Properties)null) {
            this.loadProperties();
        }
        Enumeration<?> enumeration = this.props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = new String((String)enumeration.nextElement());
            vector.addElement(string);
        }
        return vector;
    }

    public void putProp(String string, String string2) throws PropertyUtilException {
        if (this.props == (Properties)null) {
            this.loadProperties();
        }
        String string3 = string2 == null ? "" : string2.trim();
        try {
            this.props.put(string, string3);
        }
        catch (Exception exception) {
            throw new PropertyUtilException("EXCOM_PNS", string);
        }
    }

    public void delProp(String string) throws PropertyUtilException {
        if (this.props == (Properties)null) {
            this.loadProperties();
        }
        try {
            String string2 = (String)this.props.remove(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveProps(String string) throws PropertyUtilException {
        this.saveProps(this.propfile, string);
    }

    public void saveProps(String string, String string2) throws PropertyUtilException {
        if (this.props != (Properties)null) {
            if (string2 == null) {
                this.saveProperties(string, "*** DO NOT EDIT THIS FILE ***");
            } else {
                this.saveProperties(string, string2);
            }
        }
    }

    private void loadProperties() throws PropertyUtilException {
        boolean bl = false;
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.propfile);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = true;
        }
        if (bl && (this.propmode ^ 2) == 0) {
            throw new PropertyUtilException("EXCOM_BPF", this.propfile);
        }
        this.props = new Properties();
        if (!bl) {
            try {
                this.props.load(bufferedInputStream);
            }
            catch (IOException iOException) {
                throw new PropertyUtilException("EXCOM_LPF", (Object)this.propfile, iOException.getMessage());
            }
        }
        try {
            fileInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveProperties(String string, String string2) throws PropertyUtilException {
        BufferedOutputStream bufferedOutputStream;
        FileOutputStream fileOutputStream;
        try {
            fileOutputStream = new FileOutputStream(string);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        }
        catch (SecurityException securityException) {
            throw new PropertyUtilException("EXCOM_NAP", string);
        }
        catch (IOException iOException) {
            throw new PropertyUtilException("EXCOM_NWP", string);
        }
        try {
            this.props.store(bufferedOutputStream, string2);
        }
        catch (Exception exception) {
            throw new PropertyUtilException("EXCOM_NWP", (Object)string, exception);
        }
        try {
            bufferedOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new PropertyUtilException("EXCOM_NWP", (Object)string, exception);
        }
    }
}

