/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.patchmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.patchmgr.client.DownloadPatchWizard;
import com.sun.admin.patchmgr.client.PatchContextHelpListener;
import com.sun.admin.patchmgr.client.VPatchMgr;
import com.sun.admin.patchmgr.common.RemoteFileData;
import com.sun.management.viper.console.gui.wizard.VWizardCard;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DownloadDirectoryCard
extends VWizardCard {
    private VPatchMgr theApp;
    private ResourceBundle bundle;
    private DownloadPatchWizard wiz;
    private ActionString actionString;
    private GenInfoPanel infoPanel;
    private PatchContextHelpListener overviewHelpListener;
    private JTextField downloadDir;
    public static final int HELP_CACHE_SIZE = 1;
    private static final String DOWNLOAD_STEP3_OVERVIEW = "download_wiz_s3_down_dir";

    public DownloadDirectoryCard(VPatchMgr vPatchMgr, DownloadPatchWizard downloadPatchWizard) {
        this.theApp = vPatchMgr;
        this.bundle = vPatchMgr.getResourceBundle();
        this.wiz = downloadPatchWizard;
        super.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"download_dir_step"));
        this.constructStep();
    }

    private void constructStep() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.actionString = new ActionString(this.bundle, "dl_wiz_directory");
        JLabel jLabel = new JLabel(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
        Constraints.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)24, (int)12, (int)0, (int)0);
        this.downloadDir = new JTextField("", 20);
        this.downloadDir.setMinimumSize(this.downloadDir.getPreferredSize());
        this.downloadDir.addFocusListener((FocusListener)((Object)this.overviewHelpListener));
        this.downloadDir.getDocument().addDocumentListener(new DownloadDirFieldListener());
        jLabel.setLabelFor(this.downloadDir);
        Constraints.constrain((Container)((Object)this), (Component)this.downloadDir, (int)1, (int)0, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)1.0, (int)24, (int)12, (int)0, (int)0);
    }

    public void loadHelp() {
        Vector vector = new Vector(1);
        this.infoPanel = this.wiz.getInfoPanel();
        this.overviewHelpListener = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, DOWNLOAD_STEP3_OVERVIEW);
        ContextHelpListener.loadHelp(vector);
    }

    public void start() {
        super.start();
        this.downloadDir.requestFocus();
        this.setProperty("vwp.canmovebackward", "vwp.true");
        this.setProperty("vwp.finishstate", "vwp.false");
        String string = this.wiz.getDownloadDir();
        if (string != null && string.length() > 0) {
            this.downloadDir.setText(string);
            this.setProperty("vwp.canmoveforward", "vwp.true");
        } else {
            this.setProperty("vwp.canmoveforward", "vwp.false");
        }
        this.infoPanel.setFocusListener((FocusListener)((Object)this.overviewHelpListener), true);
    }

    public boolean stop(boolean bl) {
        if (bl) {
            String string = this.downloadDir.getText();
            if (string == null || string.length() == 0) {
                new ErrorDialog(null, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"dl_wiz_bad_dirname"));
                return false;
            }
            try {
                RemoteFileData remoteFileData = this.theApp.getpatchM().getDirInfo(string);
                if (!remoteFileData.isDirectory()) {
                    String string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_aa_bad_dir_name");
                    Object[] objectArray = new Object[]{string};
                    new ErrorDialog(null, MessageFormat.format(string2, objectArray));
                    return false;
                }
            }
            catch (AdminException adminException) {
                this.theApp.reportErrorException((Exception)((Object)adminException));
                return false;
            }
            this.wiz.setDownloadDir(string);
            this.getManager().setNext(this.getManager().getCurrent(), "downloadreviewcard");
        }
        return true;
    }

    public boolean isSubStep() {
        return false;
    }

    public void reset() {
    }

    class DownloadDirFieldListener
    implements DocumentListener {
        DownloadDirFieldListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            String string = DownloadDirectoryCard.this.downloadDir.getText();
            if (string != null && string.length() > 0) {
                DownloadDirectoryCard.this.setProperty("vwp.canmoveforward", "vwp.true");
            } else {
                DownloadDirectoryCard.this.setProperty("vwp.canmoveforward", "vwp.false");
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.insertUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.insertUpdate(documentEvent);
        }
    }
}

