/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.patchmgr.cli;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.CheckSyntax;
import com.sun.admin.cis.common.CommandLineOption;
import com.sun.admin.cis.common.IClientResource;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.patchmgr.client.ApplicationContext;
import com.sun.admin.patchmgr.client.DownloadPatchWizard;
import com.sun.admin.patchmgr.client.ServiceWrapper;
import com.sun.admin.patchmgr.client.SystemComparator;
import com.sun.admin.patchmgr.common.AssessedPatchData;
import com.sun.admin.patchmgr.common.DownloadPatchesResults;
import com.sun.admin.patchmgr.common.InstallPatchesByPolicyResults;
import com.sun.admin.patchmgr.common.PatchCliArgParsingException;
import com.sun.admin.patchmgr.common.PatchCliHelpException;
import com.sun.admin.patchmgr.common.PatchException;
import com.sun.admin.patchmgr.common.PatchHostData;
import com.sun.admin.patchmgr.common.PatchInstallOrder;
import com.sun.admin.patchmgr.common.PatchMgrObj;
import com.sun.admin.patchmgr.common.VerifyPatch;
import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.CriticalStopException;
import com.sun.management.viper.Tool;
import com.sun.management.viper.ToolContext;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.VException;
import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.util.CommandOption;
import com.sun.management.viper.util.CommandParser;
import com.sun.management.viper.util.ResourceManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class PatchMgrCli
implements Tool,
IClientResource {
    public static final int ADD_PATCH = 0;
    public static final int REMOVE_PATCH = 1;
    public static final int DOWNLOAD_PATCH = 2;
    public static final int ANALYZE_PATCH = 3;
    public static final int LIST_PATCH = 4;
    public static final int UPDATE_PATCH = 5;
    private static final String DEFAULT_PATCHSPOOL_DIR = "/var/sadm/spool";
    private static final String DEFAULT_PATCHPRO_SEQ = "patchproSequester";
    private Vector vMObjs = new Vector();
    private Vector vObjs = new Vector();
    private Vector vMachines = new Vector();
    private Vector vPatches = new Vector();
    private int iOperation = -1;
    private boolean bDebug = false;
    private boolean bCmdMachine = false;
    private boolean bCmdPatchid = false;
    private boolean bCmdVerifyPassed = false;
    private boolean bDownloadForHost = false;
    private boolean bDownloadOp = false;
    private boolean bUpdateOp = false;
    private ServiceWrapper patchMgrServiceWrapper = null;
    private VConsoleProperties properties = null;
    private ToolInfrastructure infrastructure = null;
    private boolean bRunning = false;
    private ResourceBundle resourceBundle = null;
    private ApplicationContext pmApplicationContext = null;
    private ToolContext toolContext = null;
    private String nameServerType = null;
    private String nameServer = null;
    private AdminMgmtScope nameServerScope = null;
    protected CommandLineOption coTaskFile;
    protected CommandLineOption coHelp;

    public PatchMgrCli() {
        String string = System.getProperty("patchmgr.Debugging");
        if (string != null && string.equals("ON")) {
            this.setDebugStatus(true);
            this.trace("Debugging enabled");
        }
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceManager.getBundle((String)"com.sun.admin.patchmgr.cli.resources.Resources", this.getClass());
            this.setResourceBundle(resourceBundle);
        }
        catch (Exception exception) {
            resourceBundle = null;
            this.trace("Debugging enabled");
        }
        if (resourceBundle == null) {
            resourceBundle = ResourceBundle.getBundle("com.sun.admin.patchmgr.cli.resources.Resources", Locale.getDefault(), this.getClass().getClassLoader());
            this.setResourceBundle(resourceBundle);
        }
        if (resourceBundle == null) {
            this.trace("PatchMgrCli Constructor....Null resBundle!!!");
        }
    }

    public ServiceWrapper getPatchMgrServiceWrapper() {
        this.trace("in PatchMgrCli->getPatchMgrServiceWrapper()");
        return this.patchMgrServiceWrapper;
    }

    public ServiceWrapper getMachineServiceWrapper(String string) {
        ApplicationContext applicationContext = null;
        AdminMgmtScope adminMgmtScope = null;
        ServiceWrapper serviceWrapper = null;
        this.trace("in PatchMgrCli->getMachineServiceWrapper()");
        try {
            adminMgmtScope = new AdminMgmtScope("file", "patchmgmtscope" + string, string, string);
            this.trace(" --- Created Mgmtscope for: " + string);
        }
        catch (VException vException) {
            System.out.println("\n");
            this.trace(" --- Exception from AdminMgmtScope");
            System.out.println(vException.getLocalizedMessage());
            return null;
        }
        applicationContext = new ApplicationContext(this, this.toolContext, adminMgmtScope);
        try {
            serviceWrapper = applicationContext.getServiceWrapper(this.infrastructure);
            this.trace(" --- wrapper was created for: " + string);
        }
        catch (AdminException adminException) {
            System.out.println("\n");
            this.trace(" --- Exception from getServiceWrapper");
            if (this.getDebugStatus()) {
                adminException.printStackTrace();
            }
            System.out.println(adminException.getLocalizedMessage());
            return null;
        }
        return serviceWrapper;
    }

    public void setPatchMgrServiceWrapper(ServiceWrapper serviceWrapper) {
        this.patchMgrServiceWrapper = serviceWrapper;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public void setTaskOperation(char c) {
        switch (c) {
            case 'A': {
                this.iOperation = 0;
                this.trace("Action: Add patches");
                break;
            }
            case 'D': {
                this.iOperation = 2;
                this.trace("Action:  Download patches");
                break;
            }
            case 'X': {
                this.iOperation = 1;
                this.trace("Action:  REMOVE patch");
                break;
            }
            case 'V': {
                this.iOperation = 3;
                this.trace("Action: Analyze machine");
                break;
            }
            case 'L': {
                this.iOperation = 4;
                this.trace("Action: List patches");
                break;
            }
            case 'U': {
                this.iOperation = 5;
                this.trace("Action: Update machine");
                break;
            }
            default: {
                this.trace("Action: UNKNOWN");
            }
        }
    }

    public String getOperationType() {
        String string = "";
        switch (this.iOperation) {
            case 0: {
                string = this.getLocalizedMessage("smpatch_add");
                break;
            }
            case 2: {
                string = this.getLocalizedMessage("smpatch_download");
                break;
            }
            case 1: {
                string = this.getLocalizedMessage("smpatch_remove");
                break;
            }
            case 3: {
                string = this.getLocalizedMessage("smpatch_analyze");
                break;
            }
            case 4: {
                string = this.getLocalizedMessage("smpatch_list");
                break;
            }
            case 5: {
                string = this.getLocalizedMessage("smpatch_update");
                break;
            }
            default: {
                string = "unrecognized action ";
            }
        }
        return string;
    }

    public void doOperation() throws AdminException {
        switch (this.iOperation) {
            case 0: {
                this.installPatches();
                break;
            }
            case 2: {
                this.dloadPatches(false);
                break;
            }
            case 1: {
                this.removePatches();
                break;
            }
            case 3: {
                this.analyzeHost();
                break;
            }
            case 4: {
                this.listPatches();
                break;
            }
            case 5: {
                this.updateHost();
                break;
            }
        }
    }

    public void installPatches() throws AdminException {
        PatchHostData patchHostData = null;
        PatchMgrObj patchMgrObj = null;
        ServiceWrapper serviceWrapper = null;
        String string = null;
        String string2 = null;
        this.trace("in PatchMgrCli->installPatches()");
        this.trace(" ----- vObjs: " + this.vObjs);
        this.trace(" ----- vMObjs: " + this.vMObjs);
        if (this.vObjs.size() == 0) {
            throw new PatchException("EXM_INTERNAL", "AddNoPatchObject ");
        }
        if (this.vMObjs.size() == 0) {
            throw new PatchException("EXM_INTERNAL", "AddNoHostObject ");
        }
        int n = 0;
        while (n < this.vMObjs.size()) {
            try {
                patchHostData = (PatchHostData)this.vMObjs.elementAt(n);
            }
            catch (Exception exception) {
                throw new PatchException("EXM_INTERNAL", "PatchInstMObjErr");
            }
            serviceWrapper = patchHostData.getHostSvrWrapper();
            string = patchHostData.getPatchHost();
            string2 = this.mountPatchDir(patchHostData);
            System.out.println("\n\t" + this.getLocalizedMessage("machine_name") + " " + string + " ...");
            int n2 = 0;
            while (n2 < this.vObjs.size()) {
                try {
                    patchMgrObj = (PatchMgrObj)this.vObjs.elementAt(n2);
                }
                catch (Exception exception) {
                    throw new PatchException("EXM_INTERNAL", "AddObjectErr");
                }
                patchMgrObj.setPatchDirName(string2);
                String string3 = patchMgrObj.getPatchName();
                System.out.println("\t\t" + this.getLocalizedMessage("install_patch") + " " + string3);
                try {
                    serviceWrapper.addPatchData(patchMgrObj);
                }
                catch (AdminException adminException) {
                    this.unmountPatchDir(patchHostData);
                    System.out.println(adminException.getLocalizedMessage());
                }
                ++n2;
            }
            this.unmountPatchDir(patchHostData);
            ++n;
        }
        System.out.println("\n");
    }

    public void installPatchesByPolicy() throws AdminException {
        PatchHostData patchHostData = null;
        PatchMgrObj patchMgrObj = null;
        ServiceWrapper serviceWrapper = null;
        String string = null;
        String string2 = null;
        this.trace("in PatchMgrCli->installPatches()");
        int n = this.vMObjs.size();
        int n2 = this.vObjs.size();
        this.trace(" ----- vObjs: " + this.vObjs);
        this.trace(" ----- vMObjs: " + this.vMObjs);
        if (n2 == 0) {
            throw new PatchException("EXM_INTERNAL", "AddNoPatchObject ");
        }
        if (n == 0) {
            throw new PatchException("EXM_INTERNAL", "AddNoHostObject ");
        }
        int n3 = 0;
        while (n3 < n) {
            Object object;
            try {
                patchHostData = (PatchHostData)this.vMObjs.elementAt(n3);
            }
            catch (Exception exception) {
                throw new PatchException("EXM_INTERNAL", "PatchInstMObjErr");
            }
            serviceWrapper = patchHostData.getHostSvrWrapper();
            string = patchHostData.getPatchHost();
            string2 = this.mountPatchDir(patchHostData);
            Object[] objectArray = new Object[]{string};
            System.out.println("\n");
            System.out.println(MessageFormat.format(this.getLocalizedMessage("installing_patches"), objectArray));
            Vector<Object> vector = new Vector<Object>();
            int n4 = 0;
            while (n4 < n2) {
                try {
                    patchMgrObj = (PatchMgrObj)this.vObjs.elementAt(n4);
                }
                catch (Exception exception) {
                    throw new PatchException("EXM_INTERNAL", "AddObjectErr");
                }
                object = patchMgrObj.getPatchName();
                vector.add(object);
                ++n4;
            }
            object = null;
            try {
                object = serviceWrapper.installPatchesByPolicy(vector, string2);
            }
            catch (AdminException adminException) {
                System.out.println(adminException.getLocalizedMessage());
            }
            this.unmountPatchDir(patchHostData);
            if (object != null) {
                Vector vector2;
                Object object2;
                Object object3;
                Vector vector3 = ((InstallPatchesByPolicyResults)object).getInstalledPatches();
                if (vector3.size() != 0) {
                    object3 = null;
                    System.out.println(this.getLocalizedMessage("policy_installed_patches"));
                    int n5 = 0;
                    while (n5 < vector3.size()) {
                        try {
                            object3 = (String)vector3.elementAt(n5);
                        }
                        catch (Exception exception) {
                            throw new PatchException("EXM_INTERNAL", "AddObjectErr");
                        }
                        System.out.println("\t" + (String)object3);
                        ++n5;
                    }
                    System.out.println("\n");
                }
                if (((Vector)(object3 = ((InstallPatchesByPolicyResults)object).getSequesteredPatches())).size() != 0) {
                    String string3 = null;
                    object2 = new Object[]{string2 + System.getProperty("file.separator") + DEFAULT_PATCHPRO_SEQ};
                    String string4 = MessageFormat.format(this.getLocalizedMessage("sequestered_patches"), object2);
                    System.out.println(string4);
                    int n6 = 0;
                    while (n6 < ((Vector)object3).size()) {
                        try {
                            string3 = (String)((Vector)object3).elementAt(n6);
                        }
                        catch (Exception exception) {
                            throw new PatchException("EXM_INTERNAL", "AddObjectErr");
                        }
                        System.out.println("\t" + string3);
                        ++n6;
                    }
                }
                if ((vector2 = ((InstallPatchesByPolicyResults)object).getInstallationErrors()).size() != 0) {
                    object2 = null;
                    System.out.println(this.getLocalizedMessage("installation_errors"));
                    int n7 = 0;
                    while (n7 < vector2.size()) {
                        try {
                            object2 = (String)vector2.elementAt(n7);
                        }
                        catch (Exception exception) {
                            throw new PatchException("EXM_INTERNAL", "AddObjectErr");
                        }
                        System.out.println((String)object2);
                        ++n7;
                    }
                }
            }
            ++n3;
        }
        System.out.println("\n");
    }

    public void dloadPatches(boolean bl) throws AdminException {
        Object[] objectArray;
        int n;
        int n2;
        Object object;
        Object object2;
        PatchHostData patchHostData = null;
        PatchMgrObj patchMgrObj = null;
        Vector<String> vector = null;
        Vector<String> vector2 = new Vector<String>();
        String string = null;
        String string2 = null;
        String string3 = null;
        ServiceWrapper serviceWrapper = null;
        Vector vector3 = new Vector();
        this.trace("in PatchMgrCli->dloadPatches(): ");
        this.trace(" ----- vObjs: " + this.vObjs);
        this.trace(" ----- vMObjs: " + this.vMObjs);
        if (this.vMObjs.size() == 0) {
            throw new PatchException("EXM_INTERNAL", "DLOADNoHostObject ");
        }
        try {
            patchHostData = (PatchHostData)this.vMObjs.elementAt(0);
        }
        catch (Exception exception) {
            throw new PatchException("EXM_INTERNAL", "DLOADMObjErr");
        }
        string2 = patchHostData.getPatchHost();
        this.trace(" ----- download machine: " + string2);
        string = patchHostData.getPatchDir();
        this.trace(" ----- download dir: " + string);
        serviceWrapper = patchHostData.getHostSvrWrapper();
        try {
            if (!serviceWrapper.isPatchProOnSystem()) {
                System.out.println(this.getLocalizedMessage("no_patchpro") + " " + string2);
                throw new PatchException("");
            }
        }
        catch (AdminException adminException) {
            this.trace(" ----- call isPatchProOnSystem failed");
            System.out.println(adminException.getLocalizedMessage());
            throw new PatchException("EXM_PM_CLI_GET_PPRO");
        }
        Vector vector4 = serviceWrapper.getPatchIdsFromSpool(string);
        this.trace(" ----- Patches in spool dir before download: " + vector4);
        System.out.println("\n");
        if (this.bDownloadForHost) {
            this.trace(" ----- download for host");
            vector = null;
            vector2 = this.outNeededPatches(serviceWrapper, string2);
            object2 = new Object[]{string2};
            string3 = MessageFormat.format(this.getLocalizedMessage("download_host_patches"), (Object[])object2);
        } else {
            this.trace(" ----- download user specified patches");
            System.out.println(this.getLocalizedMessage("requested_patches"));
            if (this.vObjs.size() == 0) {
                this.trace("no obj to download,  patch object is null!");
                throw new PatchException("EXM_INTERNAL", "NoDnlPatchObject");
            }
            vector = new Vector<String>();
            int n3 = 0;
            while (n3 < this.vObjs.size()) {
                patchMgrObj = (PatchMgrObj)this.vObjs.elementAt(n3);
                object = patchMgrObj.getPatchName();
                System.out.println("\t" + (String)object);
                vector.add((String)object);
                ++n3;
            }
            string3 = this.getLocalizedMessage("download_patches");
            vector2 = vector;
        }
        this.trace(" ----- download patches: " + vector2);
        System.out.println("\n" + string3);
        this.trace(" ----- downloadPatches(" + vector + ", " + string + ")");
        object2 = null;
        try {
            object2 = bl ? serviceWrapper.downloadPatchesInJarFormat(vector, string) : serviceWrapper.downloadPatches(vector, string);
        }
        catch (AdminException adminException) {
            this.trace(" ----- patchpro call downloadPatches failed");
            System.out.println(adminException.getLocalizedMessage());
            throw new PatchException("");
        }
        vector3 = serviceWrapper.getPatchIdsFromSpool(string);
        if (vector3 == null) {
            vector3 = new Vector();
        }
        this.trace(" ----- Patches in spool dir after download: " + vector3);
        System.out.println("\n");
        object = ((DownloadPatchesResults)object2).getPatchesToBeDownloaded();
        this.trace("getPatchesToBeDownloaded: " + object);
        Vector vector5 = ((DownloadPatchesResults)object2).getPatchListClosure();
        vector5 = vector5 == null ? new Vector() : (Vector)vector5.clone();
        this.trace("getPatchListClosure: " + vector5);
        Vector vector6 = (Vector)vector2.clone();
        int n4 = vector2.size();
        int n5 = 0;
        while (n5 < n4) {
            String string4 = (String)vector2.elementAt(n5);
            if (vector5.contains(string4)) {
                vector5.removeElement(string4);
                vector6.removeElement(string4);
            }
            ++n5;
        }
        int n6 = vector6.size();
        if (n6 != 0) {
            System.out.println(this.getLocalizedMessage("download_exclude"));
            n2 = 0;
            while (n2 < n6) {
                System.out.println("\t" + vector6.elementAt(n2));
                ++n2;
            }
            System.out.println("\n");
        }
        if ((n2 = vector5.size()) != 0) {
            System.out.println(this.getLocalizedMessage("download_added"));
            int n7 = 0;
            while (n7 < n2) {
                System.out.println("\t" + vector5.elementAt(n7));
                ++n7;
            }
            System.out.println("\n");
        }
        Vector vector7 = ((DownloadPatchesResults)object2).getPatchesNotDownloaded();
        this.trace("getPatchesNotDownloaded: " + vector7);
        if (vector7 == null) {
            vector7 = new Vector();
        }
        if ((n = vector7.size()) != 0) {
            this.bUpdateOp = false;
            objectArray = (Vector)vector7.clone();
            int n8 = 0;
            while (n8 < n) {
                String string5 = (String)vector7.elementAt(n8);
                if (vector6.contains(string5) || vector3.contains(string5)) {
                    objectArray.removeElement(string5);
                }
                ++n8;
            }
            int n9 = objectArray.size();
            if (n9 != 0) {
                System.out.println(this.getLocalizedMessage("downloaded_not"));
                int n10 = 0;
                while (n10 < n9) {
                    System.out.println("\t" + objectArray.elementAt(n10));
                    ++n10;
                }
                System.out.println("\n");
            }
        }
        objectArray = new Object[]{string};
        System.out.println(MessageFormat.format(this.getLocalizedMessage("download_done"), objectArray));
        if (this.bUpdateOp) {
            Vector vector8 = ((DownloadPatchesResults)object2).getPatchListClosure();
            this.createPatchElements(vector8);
        }
    }

    public void removePatches() throws AdminException {
        PatchMgrObj patchMgrObj = null;
        PatchHostData patchHostData = null;
        this.trace("in PatchMgrCli->removePatches(): ");
        System.out.println("\n");
        if (this.vObjs.size() == 0) {
            this.trace("no obj to remove,  patch object is null!");
            throw new PatchException("EXM_INTERNAL", "NoRemovePatchObject");
        }
        if (this.vMObjs.size() == 0) {
            this.trace("no Host for add patch,  patch host object is null!");
            throw new PatchException("EXM_INTERNAL", "NoRemoveHostObject ");
        }
        int n = 0;
        while (n < this.vMObjs.size()) {
            try {
                patchHostData = (PatchHostData)this.vMObjs.elementAt(n);
            }
            catch (Exception exception) {
                throw new PatchException("EXM_INTERNAL", "PatchInstMObjError");
            }
            String string = patchHostData.getPatchHost();
            System.out.println("\n\t" + this.getLocalizedMessage("machine_name") + " " + string + " ...");
            int n2 = 0;
            while (n2 < this.vObjs.size()) {
                try {
                    patchMgrObj = (PatchMgrObj)this.vObjs.elementAt(n2);
                }
                catch (Exception exception) {
                    throw new PatchException("EXM_INTERNAL", "PatchRmObjError");
                }
                String string2 = patchMgrObj.getPatchName();
                System.out.println("\t\t" + this.getLocalizedMessage("remove_patch") + " " + string2);
                try {
                    patchHostData.getHostSvrWrapper().deletePatchData(patchMgrObj);
                }
                catch (AdminException adminException) {
                    System.out.println(adminException.getLocalizedMessage());
                }
                ++n2;
            }
            ++n;
        }
    }

    public void analyzeHost() throws AdminException {
        PatchHostData patchHostData = null;
        String string = null;
        ServiceWrapper serviceWrapper = null;
        this.trace("in PatchMgrCli->analyzeHost()");
        this.trace(" ---- vMObjs: " + this.vMObjs);
        if (this.vMObjs.size() == 0) {
            this.trace("no Host for add patch,  patch host object is null!");
            throw new PatchException("EXM_INTERNAL", "NoListHostObject ");
        }
        System.out.println("\n");
        int n = 0;
        while (n < this.vMObjs.size()) {
            Object[] objectArray;
            try {
                patchHostData = (PatchHostData)this.vMObjs.elementAt(n);
            }
            catch (Exception exception) {
                throw new PatchException("EXM_INTERNAL", "PatchInstMObjError");
            }
            string = patchHostData.getPatchHost();
            serviceWrapper = this.getMachineServiceWrapper(string);
            if (serviceWrapper == null) {
                objectArray = new Object[]{string};
                System.out.println("\n");
                System.out.println(MessageFormat.format(this.getLocalizedMessage("er_host_not_connect"), objectArray));
            } else {
                try {
                    if (!serviceWrapper.isPatchProOnSystem()) {
                        System.out.println(this.getLocalizedMessage("no_patchpro") + " " + string);
                        throw new PatchException("");
                    }
                }
                catch (AdminException adminException) {
                    this.trace(" ----- call isPatchProOnSystem failed");
                    System.out.println(adminException.getLocalizedMessage());
                    throw new PatchException("EXM_PM_CLI_GET_PPRO");
                }
                objectArray = this.outNeededPatches(serviceWrapper, string);
            }
            ++n;
        }
    }

    public void listPatches() throws AdminException {
        PatchHostData patchHostData = null;
        Vector vector = new Vector();
        String string = null;
        String string2 = null;
        ServiceWrapper serviceWrapper = null;
        this.trace("in PatchMgrCli->listPatches()");
        this.trace(" ---- vMObjs: " + this.vMObjs);
        if (this.vMObjs.size() == 0) {
            this.trace("no Host for add patch,  patch host object is null!");
            throw new PatchException("EXM_INTERNAL", "NoListHostObject ");
        }
        System.out.println("\n");
        int n = 0;
        while (n < this.vMObjs.size()) {
            try {
                patchHostData = (PatchHostData)this.vMObjs.elementAt(n);
            }
            catch (Exception exception) {
                throw new PatchException("EXM_INTERNAL", "PatchInstMObjError");
            }
            string2 = patchHostData.getPatchHost();
            serviceWrapper = this.getMachineServiceWrapper(string2);
            if (serviceWrapper == null) {
                Object[] objectArray = new Object[]{string2};
                System.out.println("\n");
                System.out.println(MessageFormat.format(this.getLocalizedMessage("er_host_not_connect"), objectArray));
            } else {
                System.out.println("\n\t" + this.getLocalizedMessage("machine_name") + " " + string2);
                System.out.println("\t\t" + this.getLocalizedMessage("machine_arch") + " " + serviceWrapper.getArch() + "\t" + this.getLocalizedMessage("machine_osr") + " " + serviceWrapper.getOS().getSunOSRelease() + "\t" + this.getLocalizedMessage("machine_osv") + " " + serviceWrapper.getOS().getSunOSVersion());
                System.out.println("\t\t" + this.getLocalizedMessage("installed_patches"));
                try {
                    vector = serviceWrapper.getAllInstalledPatches();
                }
                catch (AdminException adminException) {
                    System.out.println(adminException.getLocalizedMessage());
                }
                int n2 = vector.size();
                if (n2 == 0) {
                    System.out.println("\t\t\t" + this.getLocalizedMessage("nopatch"));
                }
                int n3 = 0;
                while (n3 < n2) {
                    string = ((PatchMgrObj)vector.elementAt(n3)).getPatchName();
                    System.out.println("\t\t\t" + string);
                    ++n3;
                }
            }
            ++n;
        }
    }

    public void updateHost() throws AdminException {
        this.dloadPatches(true);
        if (this.bUpdateOp) {
            this.installPatchesByPolicy();
        }
    }

    public VScopeNode getScopeNode() {
        return null;
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        this.trace("in PatchMgrCli->setProperties()");
        this.properties = vConsoleProperties;
    }

    public VConsoleProperties getProperties() {
        this.trace("in PatchMgrCli->getProperties()");
        return this.properties;
    }

    public void addConsoleActionListener(VConsoleActionListener vConsoleActionListener) {
    }

    public void init(ToolInfrastructure toolInfrastructure) throws CriticalStopException {
        this.infrastructure = toolInfrastructure;
        try {
            this.patchMgrServiceWrapper = this.pmApplicationContext.getServiceWrapper(toolInfrastructure);
        }
        catch (Exception exception) {
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            System.out.println(exception.getMessage());
            throw new CriticalStopException(exception.getMessage());
        }
        AdminCommonTools.CMN_TraceOpen((int)2, (String)"stdout");
    }

    public void setToolContext(ToolContext toolContext) {
        this.toolContext = toolContext;
        this.pmApplicationContext = new ApplicationContext(this, toolContext);
    }

    public int runCommandLine(String[] stringArray, InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        this.trace("in PatchMgrCli->runCommandLine()");
        int n = 0;
        if (stringArray == null) {
            this.trace(" ----->args = null");
            return 1;
        }
        try {
            this.nameServerScope = (AdminMgmtScope)this.toolContext.getParameter("ToolContext.MGMTSCOPE");
            this.nameServer = this.nameServerScope.getMgmtServerName();
            this.trace(" ----->nameServer: " + this.nameServer);
            this.nameServerType = this.nameServerScope.getMgmtScopeType();
            this.trace(" ----->nameServerType: " + this.nameServerType);
            this.trace(" ----->calling initCommandLineOptions");
            this.initCommandLineOptions();
            this.trace(" ----->calling doFirstArgPass");
            this.doFirstArgPass(stringArray);
            this.initCommandLineOptions();
            this.trace(" ----->calling parseAndValidateArgs");
            this.parseAndValidateArgs(stringArray);
        }
        catch (PatchCliHelpException patchCliHelpException) {
            this.trace(" ----->got PatchCliHelpException: " + (Object)((Object)patchCliHelpException));
            return 0;
        }
        catch (PatchCliArgParsingException patchCliArgParsingException) {
            this.trace(" ----->got PatchCliArgParsingException: " + patchCliArgParsingException.getLocalizedMessage());
            return 1;
        }
        catch (PatchException patchException) {
            this.trace(" ----->got PatchException: " + (Object)((Object)patchException));
            System.out.println(patchException.getLocalizedMessage());
            return 2;
        }
        catch (Exception exception) {
            this.trace(" ----->got Exception: " + exception);
            return 2;
        }
        try {
            this.trace(" ----->calling doOperation");
            this.doOperation();
        }
        catch (PatchException patchException) {
            this.trace(" ----->runCommandLine, PatchException:  " + patchException.getLocalizedMessage());
            System.out.println(patchException.getLocalizedMessage());
            n = 2;
        }
        catch (AdminException adminException) {
            this.trace(" ----->runCommandLine, AdminException:  " + adminException.getLocalizedMessage());
            n = 2;
        }
        catch (Exception exception) {
            this.trace(" ----->runCommandLine, Exception:  " + exception.getLocalizedMessage());
            System.out.println(exception.getLocalizedMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            n = 2;
        }
        return n;
    }

    private void parseAndValidateArgs(String[] stringArray) throws Exception {
        switch (this.getOperation()) {
            case 0: {
                this.checkForAddOptions(stringArray);
                break;
            }
            case 2: {
                this.checkForDownloadOptions(stringArray);
                break;
            }
            case 1: {
                this.checkForRemoveOptions(stringArray);
                break;
            }
            case 3: {
                this.checkForAnalyzeOptions(stringArray);
                break;
            }
            case 4: {
                this.checkForListOptions(stringArray);
                break;
            }
            case 5: {
                this.checkForUpdateOptions(stringArray);
                break;
            }
            default: {
                this.trace("parseAndValidateArgs: should never get here");
                this.trace("couldn't recognize switch:  " + this.getOperation());
                break;
            }
        }
    }

    private void doFirstArgPass(String[] stringArray) throws Exception {
        block8: {
            this.trace("in PatchMgrCli->doFirstArgPass()");
            this.trace(" --- parseMyArgs->args.length = " + stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.trace(" --- args[" + n + "] = " + stringArray[n]);
                ++n;
            }
            PmCommandParser pmCommandParser = new PmCommandParser("PatchMgrCli", "Command line tool for manipulating jobs", true, null, null, this.getResourceBundle());
            try {
                pmCommandParser.addOption((CommandOption)this.coTaskFile);
                pmCommandParser.addOption((CommandOption)this.coHelp);
                if (pmCommandParser.parseArgs(stringArray)) {
                    if (this.coTaskFile.wasSet()) {
                        String string = (String)this.coTaskFile.getValue();
                        this.trace(" --- Task = " + string);
                        this.setTaskOperation(string.charAt(0));
                    }
                    if (this.coHelp.wasSet()) {
                        // empty if block
                    }
                } else {
                    this.trace(" --- Error parsing args");
                    throw new PatchCliArgParsingException("EXM_PM_CLI_MISSING_ARG");
                }
                if (this.getOperation() == -1) {
                    this.trace(" --- Error:  iOperation == -1");
                    throw new PatchException("EXM_PM_CLI_NO_PATCHMGR_TASK");
                }
            }
            catch (Throwable throwable) {
                this.trace(" --- doFirstArgPass: Throwable type-of-exception");
                if (!this.getDebugStatus()) break block8;
                throwable.printStackTrace();
            }
        }
    }

    private void checkForAddOptions(String[] stringArray) throws Exception {
        this.trace("in PatchMgrCli->checkForAddOptions()");
        Vector vector = new Vector();
        String string = null;
        PmCommandParser pmCommandParser = new PmCommandParser("smpatch_add", this.getLocalizedMessage("smpatchadd_description"), true, null, null, this.getResourceBundle());
        CommandLineOption commandLineOption = new CommandLineOption("patch ID", this.getLocalizedMessage("arg_patchid_desc"), "i", 1, true, true, null, false, false);
        CommandLineOption commandLineOption2 = new CommandLineOption("patchdir", this.getLocalizedMessage("arg_homedir_desc"), "d", 1, true, false, (Object)"", false, false);
        CommandLineOption commandLineOption3 = new CommandLineOption("machinename", this.getLocalizedMessage("arg_machinename_desc"), "n", 1, true, true, null, false, false);
        CommandLineOption commandLineOption4 = new CommandLineOption("xArgs", this.getLocalizedMessage("arg_xargpminatall_desc"), "x", 1, true, true, null, false, false);
        try {
            pmCommandParser.addOption((CommandOption)this.coTaskFile);
            pmCommandParser.addOption((CommandOption)commandLineOption);
            pmCommandParser.addOption((CommandOption)commandLineOption2);
            pmCommandParser.addOption((CommandOption)commandLineOption3);
            pmCommandParser.addOption((CommandOption)commandLineOption4);
            pmCommandParser.addOption((CommandOption)this.coHelp);
            if (pmCommandParser.parseArgs(stringArray)) {
                if (commandLineOption2.wasSet()) {
                    string = (String)commandLineOption2.getValue();
                    this.trace(" ----- strHomedir: " + string);
                }
                if (commandLineOption.wasSet()) {
                    this.vPatches = commandLineOption.getValues();
                    this.bCmdPatchid = true;
                }
                if (commandLineOption3.wasSet()) {
                    this.vMachines = commandLineOption3.getValues();
                    this.bCmdMachine = true;
                }
                if (commandLineOption4.wasSet()) {
                    vector = commandLineOption4.getValues();
                    this.trace("xarg was set : " + vector);
                    this.parseXAddOptions(vector);
                    this.trace(" ----- XArgs=" + vector);
                }
                if (this.coHelp.wasSet()) {
                    this.trace(" ----- read in help");
                    pmCommandParser.printUsage();
                    throw new PatchCliHelpException(null);
                }
            } else {
                this.trace(" ----- Error parsing args");
                throw new Exception("parseArgs failed");
            }
            String[] stringArray2 = pmCommandParser.getUnmatchedOptions();
            if (stringArray2.length > 0) {
                String string2 = "";
                int n = 0;
                while (n < stringArray2.length) {
                    string2 = string2 + stringArray2[n] + " ";
                    ++n;
                }
                throw new PatchCliArgParsingException("EXM_PM_CLI_BAD_ARGS", string2);
            }
            if (!this.bCmdPatchid) {
                System.out.println("\n");
                throw new PatchException("EXM_PM_CLI_NO_PATCHIDS");
            }
            this.bCmdVerifyPassed = true;
            if (this.vMachines.size() == 0) {
                this.vMachines.add(this.nameServer);
            }
            this.vMachines = this.validateMachineNames(this.vMachines);
            if (this.vMachines.size() == 0) {
                System.out.println("\n");
                throw new PatchException("EXM_PM_CLI_NO_ADD");
            }
            if (string == null) {
                string = this.nameServer + ":" + DEFAULT_PATCHSPOOL_DIR;
                this.trace(" ----- get default strHomedir: " + string);
            }
            this.createMachineElements(string, this.vMachines);
            if (this.vMObjs.size() == 0) {
                System.out.println("\n");
                throw new PatchException("EXM_PM_CLI_NO_ADD");
            }
            PatchHostData patchHostData = (PatchHostData)this.vMObjs.elementAt(0);
            String string3 = this.mountPatchDir(patchHostData);
            this.vMachines = this.verifyMachines();
            if (!this.bCmdVerifyPassed) {
                this.unmountPatchDir(patchHostData);
                System.out.println("\n");
                throw new PatchException("EXM_PM_CLI_NO_ADD");
            }
            this.vPatches = this.validatePatchIds(this.vPatches);
            if (this.vPatches.size() == 0) {
                this.unmountPatchDir(patchHostData);
                System.out.println("\n");
                throw new PatchException("EXM_PM_CLI_NO_ADD");
            }
            this.createPatchElements(this.preVerifyPatches(this.vPatches, string3, string));
            this.unmountPatchDir(patchHostData);
            if (!this.bCmdVerifyPassed) {
                System.out.println("\n");
                throw new PatchException("EXM_PM_CLI_NO_ADD");
            }
        }
        catch (PatchCliHelpException patchCliHelpException) {
            throw patchCliHelpException;
        }
        catch (PatchCliArgParsingException patchCliArgParsingException) {
            this.trace("print usage for PatchCliArgParsingException");
            pmCommandParser.printUsage(patchCliArgParsingException.getLocalizedMessage());
            throw patchCliArgParsingException;
        }
        catch (PatchException patchException) {
            this.trace("checkForAddOptions:  PatchException");
            throw patchException;
        }
        catch (Throwable throwable) {
            this.trace("checkForAddOptions:  Throwable type-of-exception");
            if (this.getDebugStatus()) {
                throwable.printStackTrace();
            }
            throw new PatchCliArgParsingException("EXM_PM_CLI_GENERIC_ERROR");
        }
    }

    private void checkForRemoveOptions(String[] stringArray) throws Exception {
        Vector vector = new Vector();
        PmCommandParser pmCommandParser = new PmCommandParser("smpatch_remove", this.getLocalizedMessage("smpatchremove_description"), true, null, null, this.getResourceBundle());
        CommandLineOption commandLineOption = new CommandLineOption("patch ID", this.getLocalizedMessage("arg_patchid_desc"), "i", 1, true, false, null, false, false);
        CommandLineOption commandLineOption2 = new CommandLineOption("machinename", this.getLocalizedMessage("arg_machinename_desc"), "n", 1, true, false, null, false, false);
        try {
            pmCommandParser.addOption((CommandOption)this.coTaskFile);
            pmCommandParser.addOption((CommandOption)commandLineOption);
            pmCommandParser.addOption((CommandOption)commandLineOption2);
            pmCommandParser.addOption((CommandOption)this.coHelp);
            if (pmCommandParser.parseArgs(stringArray)) {
                if (commandLineOption.wasSet()) {
                    this.vPatches = commandLineOption.getValues();
                    this.bCmdPatchid = true;
                }
                if (commandLineOption2.wasSet()) {
                    this.vMachines = commandLineOption2.getValues();
                    this.bCmdMachine = true;
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    pmCommandParser.printUsage();
                    throw new PatchCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed");
            }
            String[] stringArray2 = pmCommandParser.getUnmatchedOptions();
            if (stringArray2.length > 0) {
                String string = "";
                int n = 0;
                while (n < stringArray2.length) {
                    string = string + stringArray2[n] + " ";
                    ++n;
                }
                throw new PatchCliArgParsingException("EXM_PM_CLI_BAD_ARGS", string);
            }
            this.trace("checkForRemoveOptions ----- ");
            if (!this.bCmdPatchid) {
                throw new PatchException("EXM_PM_CLI_NO_PATCHIDS");
            }
            this.bCmdVerifyPassed = true;
            this.vPatches = this.validatePatchIds(this.vPatches);
            if (this.vPatches.size() == 0) {
                throw new PatchException("");
            }
            if (this.vMachines.size() == 0) {
                this.vMachines.add(this.nameServer);
            }
            this.vMachines = this.validateMachineNames(this.vMachines);
            if (this.vMachines.size() == 0) {
                throw new PatchException("");
            }
            this.createMachineElements("/", this.vMachines);
            if (this.vMObjs.size() == 0) {
                throw new PatchException("");
            }
            this.vMachines = this.verifyMachines();
            this.createPatchElements(this.preVerifyPatchRm(this.vPatches));
            if (!this.bCmdVerifyPassed) {
                throw new PatchException("");
            }
        }
        catch (PatchCliHelpException patchCliHelpException) {
            throw patchCliHelpException;
        }
        catch (PatchCliArgParsingException patchCliArgParsingException) {
            pmCommandParser.printUsage(patchCliArgParsingException.getLocalizedMessage());
            throw patchCliArgParsingException;
        }
        catch (PatchException patchException) {
            this.trace("checkRemoveAddOptions:  PatchException");
            throw patchException;
        }
        catch (Throwable throwable) {
            this.trace("checkForRemoveOptions:  Throwable type-of-exception");
            if (this.getDebugStatus()) {
                throwable.printStackTrace();
            }
            throw new PatchCliArgParsingException("EXM_PM_CLI_GENERIC_ERROR");
        }
    }

    private void checkForDownloadOptions(String[] stringArray) throws Exception {
        Vector vector = new Vector();
        String string = null;
        String string2 = null;
        this.trace("in PatchMgrCli->checkForDownloadOptions()");
        PmCommandParser pmCommandParser = new PmCommandParser("smpatch_download", this.getLocalizedMessage("smpatchdownload_description"), true, null, null, this.getResourceBundle());
        CommandLineOption commandLineOption = new CommandLineOption("patch ID", this.getLocalizedMessage("arg_patchid_desc"), "i", 1, true, true, null, false, false);
        CommandLineOption commandLineOption2 = new CommandLineOption("patchdir", this.getLocalizedMessage("arg_homedir_desc"), "d", 1, true, false, (Object)"", false, false);
        CommandLineOption commandLineOption3 = new CommandLineOption("target machine", this.getLocalizedMessage("arg_refmachine_desc"), "n", 1, true, false, (Object)"", false, false);
        CommandLineOption commandLineOption4 = new CommandLineOption("xArgs", this.getLocalizedMessage("arg_xargpmdownl_desc"), "x", 1, true, true, null, false, false);
        try {
            pmCommandParser.addOption((CommandOption)this.coTaskFile);
            pmCommandParser.addOption((CommandOption)commandLineOption);
            pmCommandParser.addOption((CommandOption)commandLineOption2);
            pmCommandParser.addOption((CommandOption)commandLineOption3);
            pmCommandParser.addOption((CommandOption)commandLineOption4);
            pmCommandParser.addOption((CommandOption)this.coHelp);
            if (pmCommandParser.parseArgs(stringArray)) {
                if (commandLineOption2.wasSet()) {
                    string = (String)commandLineOption2.getValue();
                    this.trace(" ----- strDlDir: " + string);
                }
                if (commandLineOption3.wasSet()) {
                    string2 = (String)commandLineOption3.getValue();
                    this.bDownloadForHost = true;
                    this.trace(" ----- strTrgMachine: " + string2);
                }
                if (commandLineOption.wasSet()) {
                    if (this.bDownloadForHost) {
                        throw new PatchCliArgParsingException("EXM_PM_CLI_HOST_OR_ID");
                    }
                    this.vPatches = commandLineOption.getValues();
                    this.bCmdPatchid = true;
                }
                if (commandLineOption4.wasSet()) {
                    vector = commandLineOption4.getValues();
                    this.trace(" ----- xarg was set : " + vector);
                    this.parseXDownloadOptions(vector);
                    this.trace(" ----- XArgs=" + vector);
                }
                if (this.coHelp.wasSet()) {
                    this.trace(" ----- read in help");
                    pmCommandParser.printUsage();
                    throw new PatchCliHelpException(null);
                }
            } else {
                this.trace(" ----- Error parsing args");
                throw new Exception("parseArgs failed");
            }
            String[] stringArray2 = pmCommandParser.getUnmatchedOptions();
            if (stringArray2.length > 0) {
                String string3 = "";
                int n = 0;
                while (n < stringArray2.length) {
                    string3 = string3 + stringArray2[n] + " ";
                    ++n;
                }
                throw new PatchCliArgParsingException("EXM_PM_CLI_BAD_ARGS", string3);
            }
            if (!(this.bCmdPatchid ^= this.bDownloadForHost)) {
                string2 = this.nameServer;
                this.bDownloadForHost = true;
                this.trace(" ----- get host - as default" + string2);
            }
            if (string2 == null) {
                string2 = this.nameServer;
            }
            if (string == null) {
                string = DEFAULT_PATCHSPOOL_DIR;
            }
            this.bCmdVerifyPassed = true;
            this.bDownloadOp = true;
            this.vMachines.add(string2);
            this.createMachineElements(string, this.vMachines);
            if (!this.bCmdVerifyPassed) {
                throw new PatchException("");
            }
            if (!this.bDownloadForHost) {
                this.vPatches = this.validatePatchIds(this.vPatches);
                if (!this.bCmdVerifyPassed) {
                    throw new PatchException("");
                }
                if (this.vPatches.size() == 0) {
                    System.out.println("\n");
                    throw new PatchException("");
                }
                this.createPatchElements(this.vPatches);
            }
        }
        catch (PatchCliHelpException patchCliHelpException) {
            throw patchCliHelpException;
        }
        catch (PatchCliArgParsingException patchCliArgParsingException) {
            this.trace("print usage for PatchCliArgParsingException");
            pmCommandParser.printUsage(patchCliArgParsingException.getLocalizedMessage());
            throw patchCliArgParsingException;
        }
        catch (PatchException patchException) {
            this.trace("checkForAddOptions:  PatchException");
            throw patchException;
        }
        catch (Throwable throwable) {
            this.trace("checkForAddOptions:  Throwable type-of-exception");
            if (this.getDebugStatus()) {
                throwable.printStackTrace();
            }
            throw new PatchCliArgParsingException("EXM_PM_CLI_GENERIC_ERROR");
        }
    }

    private void checkForAnalyzeOptions(String[] stringArray) throws Exception {
        this.trace("in PatchMgrCli->checkForAnalyzeOptions()");
        String string = null;
        PmCommandParser pmCommandParser = new PmCommandParser("smpatch_analyze", this.getLocalizedMessage("smpatchanalyze_description"), true, null, null, this.getResourceBundle());
        CommandLineOption commandLineOption = new CommandLineOption("machinename", this.getLocalizedMessage("arg_machinename_desc"), "n", 1, true, false, null, false, false);
        try {
            pmCommandParser.addOption((CommandOption)this.coTaskFile);
            pmCommandParser.addOption((CommandOption)commandLineOption);
            pmCommandParser.addOption((CommandOption)this.coHelp);
            if (pmCommandParser.parseArgs(stringArray)) {
                if (commandLineOption.wasSet()) {
                    string = (String)commandLineOption.getValue();
                    this.bCmdMachine = true;
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    pmCommandParser.printUsage();
                    throw new PatchCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed");
            }
            String[] stringArray2 = pmCommandParser.getUnmatchedOptions();
            if (stringArray2.length > 0) {
                String string2 = "";
                int n = 0;
                while (n < stringArray2.length) {
                    string2 = string2 + stringArray2[n] + " ";
                    ++n;
                }
                throw new PatchCliArgParsingException("EXM_PM_CLI_BAD_ARGS", string2);
            }
            this.trace(" --- Parsing done");
            if (!this.bCmdMachine) {
                string = this.nameServer;
            }
            this.trace(" --- " + string);
            PatchHostData patchHostData = new PatchHostData();
            patchHostData.setPatchHost(string);
            this.vMObjs.addElement(patchHostData);
        }
        catch (PatchCliHelpException patchCliHelpException) {
            throw patchCliHelpException;
        }
        catch (PatchCliArgParsingException patchCliArgParsingException) {
            pmCommandParser.printUsage(patchCliArgParsingException.getLocalizedMessage());
            throw patchCliArgParsingException;
        }
        catch (PatchException patchException) {
            throw patchException;
        }
        catch (Throwable throwable) {
            this.trace(" ---  Throwable type-of-exception");
            if (this.getDebugStatus()) {
                throwable.printStackTrace();
            }
            throw new PatchCliArgParsingException("EXM_PM_CLI_GENERIC_ERROR");
        }
    }

    private void checkForUpdateOptions(String[] stringArray) throws Exception {
        this.trace("in PatchMgrCli->checkForUpdateOptions()");
        String string = null;
        String string2 = null;
        this.bUpdateOp = true;
        PmCommandParser pmCommandParser = new PmCommandParser("smpatch_update", this.getLocalizedMessage("smpatchupdate_description"), true, null, null, this.getResourceBundle());
        CommandLineOption commandLineOption = new CommandLineOption("patchdir", this.getLocalizedMessage("arg_homedir_desc"), "d", 1, true, false, (Object)"", false, false);
        CommandLineOption commandLineOption2 = new CommandLineOption("machinename", this.getLocalizedMessage("arg_machinename_desc"), "n", 1, true, false, null, false, false);
        try {
            pmCommandParser.addOption((CommandOption)this.coTaskFile);
            pmCommandParser.addOption((CommandOption)commandLineOption);
            pmCommandParser.addOption((CommandOption)commandLineOption2);
            pmCommandParser.addOption((CommandOption)this.coHelp);
            if (pmCommandParser.parseArgs(stringArray)) {
                if (commandLineOption.wasSet()) {
                    string2 = (String)commandLineOption.getValue();
                    this.trace(" --------- strDlDir: " + string2);
                }
                if (commandLineOption2.wasSet()) {
                    string = (String)commandLineOption2.getValue();
                    this.bDownloadForHost = true;
                    this.trace(" ----- strTrgMachine: " + string);
                }
                if (this.coHelp.wasSet()) {
                    this.trace(" ------- read in help");
                    pmCommandParser.printUsage();
                    throw new PatchCliHelpException(null);
                }
            } else {
                this.trace(" ----- Error parsing args");
                throw new Exception("parseArgs failed");
            }
            String[] stringArray2 = pmCommandParser.getUnmatchedOptions();
            if (stringArray2.length > 0) {
                String string3 = "";
                int n = 0;
                while (n < stringArray2.length) {
                    string3 = string3 + stringArray2[n] + " ";
                    ++n;
                }
                throw new PatchCliArgParsingException("EXM_PM_CLI_BAD_ARGS", string3);
            }
            this.trace(" ------ Parsing Done");
            if (string == null) {
                string = this.nameServer;
            }
            if (string2 == null) {
                string2 = DEFAULT_PATCHSPOOL_DIR;
            }
            this.bCmdVerifyPassed = true;
            this.bUpdateOp = true;
            this.bDownloadForHost = true;
            this.vMachines.add(string);
            this.createMachineElements(string2, this.vMachines);
            if (!this.bCmdVerifyPassed) {
                throw new PatchException("");
            }
        }
        catch (PatchCliHelpException patchCliHelpException) {
            throw patchCliHelpException;
        }
        catch (PatchCliArgParsingException patchCliArgParsingException) {
            this.trace("print usage for PatchCliArgParsingException");
            pmCommandParser.printUsage(patchCliArgParsingException.getLocalizedMessage());
            throw patchCliArgParsingException;
        }
        catch (PatchException patchException) {
            this.trace("checkForUpdateOptions:  PatchException");
            throw patchException;
        }
        catch (Throwable throwable) {
            this.trace("checkForUpdateOptions:  Throwable type-of-exception");
            if (this.getDebugStatus()) {
                throwable.printStackTrace();
            }
            throw new PatchCliArgParsingException("EXM_PM_CLI_GENERIC_ERROR");
        }
    }

    private void checkForListOptions(String[] stringArray) throws Exception {
        this.trace("in PatchMgrCli->checkForListOptions()");
        Vector vector = new Vector();
        PmCommandParser pmCommandParser = new PmCommandParser("smpatch_list", this.getLocalizedMessage("smpatchlist_description"), true, null, null, this.getResourceBundle());
        CommandLineOption commandLineOption = new CommandLineOption("machinename", this.getLocalizedMessage("arg_machinename_desc"), "n", 1, true, true, null, false, false);
        CommandLineOption commandLineOption2 = new CommandLineOption("xArgs", this.getLocalizedMessage("arg_xargpminatall_desc"), "x", 1, true, true, null, false, false);
        try {
            pmCommandParser.addOption((CommandOption)this.coTaskFile);
            pmCommandParser.addOption((CommandOption)commandLineOption);
            pmCommandParser.addOption((CommandOption)commandLineOption2);
            pmCommandParser.addOption((CommandOption)this.coHelp);
            if (pmCommandParser.parseArgs(stringArray)) {
                if (commandLineOption.wasSet()) {
                    this.vMachines = commandLineOption.getValues();
                    this.bCmdMachine = true;
                }
                if (commandLineOption2.wasSet()) {
                    vector = commandLineOption2.getValues();
                    this.trace("xarg was set : " + vector);
                    this.parseXListOptions(vector);
                    this.trace(" --- XArgs=" + vector);
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    pmCommandParser.printUsage();
                    throw new PatchCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new Exception("parseArgs failed");
            }
            String[] stringArray2 = pmCommandParser.getUnmatchedOptions();
            if (stringArray2.length > 0) {
                String string = "";
                int n = 0;
                while (n < stringArray2.length) {
                    string = string + stringArray2[n] + " ";
                    ++n;
                }
                throw new PatchCliArgParsingException("EXM_PM_CLI_BAD_ARGS", string);
            }
            this.trace(" --- Parsing done");
            if (!this.bCmdMachine) {
                this.vMachines.add(this.nameServer);
            }
            this.trace(" --- " + this.vMachines);
            if (this.vMachines.size() == 0) {
                throw new PatchException("EXM_INTERNAL", "CheckkListHost");
            }
            Enumeration enumeration = this.vMachines.elements();
            while (enumeration.hasMoreElements()) {
                PatchHostData patchHostData = new PatchHostData();
                patchHostData.setPatchHost((String)enumeration.nextElement());
                this.vMObjs.addElement(patchHostData);
            }
        }
        catch (PatchCliHelpException patchCliHelpException) {
            throw patchCliHelpException;
        }
        catch (PatchCliArgParsingException patchCliArgParsingException) {
            pmCommandParser.printUsage(patchCliArgParsingException.getLocalizedMessage());
            throw patchCliArgParsingException;
        }
        catch (PatchException patchException) {
            throw patchException;
        }
        catch (Throwable throwable) {
            this.trace(" ---  Throwable type-of-exception");
            if (this.getDebugStatus()) {
                throwable.printStackTrace();
            }
            throw new PatchCliArgParsingException("EXM_PM_CLI_GENERIC_ERROR");
        }
    }

    public void parseXAddOptions(Vector vector) throws PatchException, PatchCliArgParsingException, PatchCliHelpException {
        int n = 0;
        String string = null;
        String string2 = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            n = (string = string.trim()).indexOf("=");
            if (n == -1) {
                throw new PatchCliArgParsingException("EXM_PM_CLI_UNKNOWN_X_ARG", string);
            }
            string2 = string.substring(n + 1, string.length());
            string2 = string2.trim();
            string = string.substring(0, n);
            this.trace("Parsed out x property:  " + string);
            this.trace("Parsed out x property value:\t " + string2);
            if (0 == string.compareTo(this.getLocalizedMessage("xprop_idlist"))) {
                if (!this.bCmdPatchid) {
                    this.vPatches = this.fileToVectorOfStrings(string2);
                    if (this.vPatches.size() == 0) {
                        throw new PatchException("EXM_PM_CLI_EMPTY_PLIST", string2);
                    }
                    this.bCmdPatchid = true;
                    continue;
                }
                throw new PatchCliArgParsingException("EXM_PM_CLI_DUP_PATCH_OPTION");
            }
            if (0 == string.compareTo(this.getLocalizedMessage("xprop_mlist"))) {
                if (!this.bCmdMachine) {
                    this.vMachines = this.fileToVectorOfStrings(string2);
                    if (this.vMachines.size() == 0) {
                        throw new PatchException("EXM_PM_CLI_EMPTY_MLIST", string2);
                    }
                    this.bCmdMachine = true;
                    continue;
                }
                throw new PatchCliArgParsingException("EXM_PM_CLI_DUP_MACHINE_OPTION");
            }
            throw new PatchCliArgParsingException("EXM_PM_CLI_UNKNOWN_X_ARG", string);
        }
    }

    public void parseXRemoveOptions(Vector vector) throws PatchException, PatchCliArgParsingException, PatchCliHelpException {
        int n = 0;
        String string = null;
        String string2 = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            n = (string = string.trim()).indexOf("=");
            if (n == -1) {
                throw new PatchCliArgParsingException("EXM_PM_CLI_UNKNOWN_X_ARG", string);
            }
            string2 = string.substring(n + 1, string.length());
            string2 = string2.trim();
            string = string.substring(0, n);
            this.trace("Parsed out x property:  " + string);
            this.trace("Parsed out x property value:\t " + string2);
            if (0 == string.compareTo(this.getLocalizedMessage("xprop_idlist"))) {
                if (!this.bCmdPatchid) {
                    this.vPatches = this.fileToVectorOfStrings(string2);
                    if (this.vPatches.size() == 0) {
                        throw new PatchException("EXM_PM_CLI_EMPTY_PLIST", string2);
                    }
                    this.bCmdPatchid = true;
                    continue;
                }
                throw new PatchCliArgParsingException("EXM_PM_CLI_DUP_PATCH_OPTION");
            }
            if (0 == string.compareTo(this.getLocalizedMessage("xprop_mlist"))) {
                if (!this.bCmdMachine) {
                    this.vMachines = this.fileToVectorOfStrings(string2);
                    if (this.vMachines.size() == 0) {
                        throw new PatchException("EXM_PM_CLI_EMPTY_MLIST", string2);
                    }
                    this.bCmdMachine = true;
                    continue;
                }
                throw new PatchCliArgParsingException("EXM_PM_CLI_DUP_MACHINE_OPTION");
            }
            throw new PatchCliArgParsingException("EXM_PM_CLI_UNKNOWN_X_ARG", string);
        }
    }

    public void parseXListOptions(Vector vector) throws PatchException, PatchCliArgParsingException, PatchCliHelpException {
        int n = 0;
        String string = null;
        String string2 = null;
        this.trace("in PatchMgrCli->parseXListOptions()");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            n = (string = string.trim()).indexOf("=");
            if (n == -1) {
                throw new PatchCliArgParsingException("EXM_PM_CLI_UNKNOWN_X_ARG", string);
            }
            string2 = string.substring(n + 1, string.length());
            string2 = string2.trim();
            string = string.substring(0, n);
            this.trace(" ----- Parsed out x property:  " + string);
            this.trace(" ----- Parsed out x property value:\t " + string2);
            if (0 == string.compareTo(this.getLocalizedMessage("xprop_mlist"))) {
                if (!this.bCmdMachine) {
                    this.vMachines = this.fileToVectorOfStrings(string2);
                    this.bCmdMachine = true;
                    continue;
                }
                throw new PatchCliArgParsingException("EXM_PM_CLI_DUP_MACHINE_OPTION");
            }
            throw new PatchCliArgParsingException("EXM_PM_CLI_UNKNOWN_X_ARG", string);
        }
    }

    public void parseXDownloadOptions(Vector vector) throws PatchException, PatchCliArgParsingException, PatchCliHelpException {
        int n = 0;
        String string = null;
        String string2 = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            n = (string = string.trim()).indexOf("=");
            if (n == -1) {
                throw new PatchCliArgParsingException("EXM_PM_CLI_UNKNOWN_X_ARG", string);
            }
            string2 = string.substring(n + 1, string.length());
            string2 = string2.trim();
            string = string.substring(0, n);
            this.trace("Parsed out x property:  " + string);
            this.trace("Parsed out x property value:\t " + string2);
            if (0 == string.compareTo(this.getLocalizedMessage("xprop_idlist"))) {
                if (!this.bCmdPatchid) {
                    if (this.bDownloadForHost) {
                        throw new PatchCliArgParsingException("EXM_PM_CLI_HOST_OR_ID");
                    }
                    this.vPatches = this.fileToVectorOfStrings(string2);
                    if (this.vPatches.size() == 0) {
                        throw new PatchException("EXM_PM_CLI_EMPTY_PLIST", string2);
                    }
                    this.bCmdPatchid = true;
                    continue;
                }
                throw new PatchCliArgParsingException("EXM_PM_CLI_DUP_PATCH_OPTION");
            }
            throw new PatchCliArgParsingException("EXM_PM_CLI_UNKNOWN_X_ARG", string);
        }
    }

    public void start() {
        this.bRunning = true;
    }

    public void stop() {
        this.bRunning = false;
    }

    public void destroy() {
    }

    public void setDebugStatus(boolean bl) {
        this.bDebug = bl;
    }

    public boolean getDebugStatus() {
        return this.bDebug;
    }

    public void trace(String string) {
        if (this.getDebugStatus()) {
            System.out.println(string);
        }
    }

    public String getLocalizedMessage(String string) {
        return ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)string);
    }

    public void setOperation(int n) {
        this.iOperation = n;
    }

    public int getOperation() {
        return this.iOperation;
    }

    private void initCommandLineOptions() {
        this.coTaskFile = new CommandLineOption("task", this.getLocalizedMessage("arg_task_desc"), "K", 1, false, false, (Object)"", false, true);
        this.coHelp = new CommandLineOption("help", this.getLocalizedMessage("arg_help_desc"), "h", 0, true, false, (Object)"", false);
        this.coHelp.setPriority(true);
    }

    private void createMachineElements(String string, Vector vector) throws AdminException, PatchException {
        String string2 = "";
        String string3 = null;
        this.trace("createMachineElements ----- " + vector);
        if (string.indexOf(":") > -1) {
            string2 = string.substring(0, string.indexOf(":"));
            string3 = string.substring(string.indexOf(":") + 1);
        }
        String string4 = null;
        ServiceWrapper serviceWrapper = null;
        String string5 = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string4 = (String)enumeration.nextElement();
            this.trace(" ----- dir/obj for next host strMachine: " + string4);
            PatchHostData patchHostData = new PatchHostData();
            serviceWrapper = this.getMachineServiceWrapper(string4);
            if (serviceWrapper == null) {
                Object[] objectArray = new Object[]{string4};
                System.out.println("\n");
                System.out.println(MessageFormat.format(this.getLocalizedMessage("er_host_not_connect"), objectArray));
                this.bCmdVerifyPassed = false;
                continue;
            }
            patchHostData.setPatchHost(string4);
            patchHostData.setHostSvrWrapper(serviceWrapper);
            if ((this.bDownloadOp || this.bUpdateOp) && string.endsWith(DEFAULT_PATCHSPOOL_DIR)) {
                try {
                    serviceWrapper.makeDefaultDir(DEFAULT_PATCHSPOOL_DIR);
                }
                catch (Exception exception) {
                    System.out.println("\n");
                    if (this.getDebugStatus()) {
                        exception.printStackTrace();
                    }
                    System.out.println("\n");
                    throw new PatchException("EXM_PM_CLI_MAKEDIR_ERR", DEFAULT_PATCHSPOOL_DIR);
                }
            }
            if (string.indexOf(":") == -1) {
                this.trace(" ----- local/NFS-mounted dir strHomedir: " + string);
                try {
                    if (!serviceWrapper.getDirInfo(string).isDirectory()) {
                        this.trace(" ----- networkmountDir:  isDirectory = false");
                        throw new PatchException("EXM_PM_CLI_DIR_ACCESS_ERR", (Object)string4, string);
                    }
                }
                catch (AdminException adminException) {
                    System.out.println("\n");
                    if (this.getDebugStatus()) {
                        adminException.printStackTrace();
                    }
                    System.out.println(adminException.getLocalizedMessage());
                    throw new PatchException("");
                }
                patchHostData.setPatchDir(string);
                patchHostData.setDirNotShared();
                this.vMObjs.addElement(patchHostData);
                this.trace(" ----- networkmountDir hostobj: " + patchHostData);
                continue;
            }
            this.trace(" ----- patch dir host - strDirHost: " + string2);
            if (string2.equals(string4)) {
                this.trace(" ----- directory is on the same host strDir: " + string3);
                try {
                    if (!serviceWrapper.getDirInfo(string3).isDirectory()) {
                        this.trace(" -----dir on default host: isDirectory=false");
                        throw new PatchException("EXM_PM_CLI_DIR_ACCESS_ERR", (Object)string4, string);
                    }
                }
                catch (AdminException adminException) {
                    System.out.println("\n");
                    if (this.getDebugStatus()) {
                        adminException.printStackTrace();
                    }
                    System.out.println(adminException.getLocalizedMessage());
                    throw new PatchException("");
                }
                patchHostData.setPatchDir(string3);
                patchHostData.setDirNotShared();
                this.vMObjs.addElement(patchHostData);
                this.trace(" ----- directory on host -  hostobj: " + patchHostData);
                continue;
            }
            patchHostData.setPatchDir(string);
            patchHostData.setDirShared();
            this.vMObjs.addElement(patchHostData);
            this.trace(" ----- shared directory hostobj: " + patchHostData);
            string5 = this.mountPatchDir(patchHostData);
            this.trace(" ----- directory is mounted strPatchdir: " + string5);
            try {
                if (!serviceWrapper.getDirInfo(string5).isDirectory()) {
                    this.trace(" ----- dir mounted: isDirectory=false");
                    throw new PatchException("EXM_PM_CLI_DIR_ACCESS_ERR", (Object)string4, string);
                }
            }
            catch (AdminException adminException) {
                this.unmountPatchDir(patchHostData);
                System.out.println("\n");
                if (this.getDebugStatus()) {
                    adminException.printStackTrace();
                }
                System.out.println(adminException.getLocalizedMessage());
                throw new PatchException("");
            }
            this.unmountPatchDir(patchHostData);
        }
    }

    private Vector verifyMachines() throws PatchException {
        PatchHostData patchHostData = null;
        Vector<String> vector = new Vector<String>();
        this.trace("in PatchMgrCli->verifyMachines()");
        if (this.vMObjs.size() == 0) {
            throw new PatchException("EXM_INTERNAL", "VerifyMNoHostObject");
        }
        SystemComparator systemComparator = new SystemComparator(this, this.getResourceBundle());
        try {
            patchHostData = (PatchHostData)this.vMObjs.elementAt(0);
        }
        catch (Exception exception) {
            throw new PatchException("EXM_INTERNAL", "MachineVerifyNObjError");
        }
        this.trace(" ----  mobj[0]: " + patchHostData);
        String string = systemComparator.setTemplate(patchHostData.getPatchHost(), patchHostData.getHostSvrWrapper());
        if (string != null) {
            this.unmountPatchDir(patchHostData);
            System.out.println("\n");
            System.out.println(string);
            throw new PatchException("");
        }
        vector.add(patchHostData.getPatchHost());
        int n = 1;
        while (n < this.vMObjs.size()) {
            try {
                patchHostData = (PatchHostData)this.vMObjs.elementAt(n);
            }
            catch (Exception exception) {
                this.unmountPatchDir((PatchHostData)this.vMObjs.elementAt(0));
                throw new PatchException("EXM_INTERNAL", "NextMachineVerifyNObjError");
            }
            this.trace(" ----  mobj: " + n + "  " + patchHostData);
            string = systemComparator.compareToTemplate(patchHostData.getPatchHost(), patchHostData.getHostSvrWrapper());
            if (string != null) {
                System.out.println("\n");
                System.out.println(string);
                this.bCmdVerifyPassed = false;
            } else {
                vector.add(patchHostData.getPatchHost());
            }
            ++n;
        }
        return vector;
    }

    private Vector preVerifyPatches(Vector vector, String string, String string2) throws PatchException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Vector vector2 = new Vector();
        this.trace("in PatchMgrCli->preVerifyPatches()");
        if (this.vMObjs.size() == 0) {
            throw new PatchException("EXM_INTERNAL", "NoAddHostObject ");
        }
        PatchHostData patchHostData = (PatchHostData)this.vMObjs.elementAt(0);
        ServiceWrapper serviceWrapper = patchHostData.getHostSvrWrapper();
        Hashtable hashtable = new Hashtable();
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        Hashtable hashtable2 = new Hashtable();
        String string3 = "";
        String string4 = "";
        String string5 = "";
        this.trace(" ---- PreVerifyProcess, strPatchDir=" + string);
        this.trace(" ---- PreVerifyProcess, strHomeDir=" + string2);
        try {
            hashtable = serviceWrapper.getSpooledPatchHashTable(string);
            vector3 = serviceWrapper.getAllInstalledPatches();
            hashtable2 = serviceWrapper.getPkgHashTable();
            string3 = serviceWrapper.getOS().getSunOSRelease();
            string4 = serviceWrapper.getOS().getSunOSVersion();
            string5 = serviceWrapper.getArch();
            vector4 = serviceWrapper.getPatchIdsFromSpool(string);
        }
        catch (AdminException adminException) {
            this.unmountPatchDir((PatchHostData)this.vMObjs.elementAt(0));
            System.out.println("\n");
            if (this.getDebugStatus()) {
                adminException.printStackTrace();
            }
            System.out.println(adminException.getLocalizedMessage());
            this.trace(" ---- PV - Some error related to getPatchIdsFromSpool");
            throw new PatchException("");
        }
        if (vector4 == null) {
            this.unmountPatchDir((PatchHostData)this.vMObjs.elementAt(0));
            System.out.println("\n");
            throw new PatchException("EXM_PM_CLI_BAD_DIRPATH", string2);
        }
        this.trace(" ---- PV - systemPatchesVec: " + vector3);
        this.trace(" ---- PV - systemSunOS Release: " + string3);
        this.trace(" ---- PV - systemSunOS Version: " + string4);
        this.trace(" ---- PV - systemArch: " + string5);
        Vector<Object> vector5 = new Vector<Object>();
        boolean bl = false;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            int n;
            object4 = (String)enumeration.nextElement();
            if (!vector4.contains(object4)) {
                vector5.add(object4);
                object3 = new Object[]{object4};
                System.out.println("\n");
                System.out.println(MessageFormat.format(this.getLocalizedMessage("verified_nopatch"), (Object[])object3));
                this.bCmdVerifyPassed = false;
                continue;
            }
            if (vector2.contains(object4) || vector5.contains(object4)) continue;
            this.trace(" ----- call 1st VerifyPatch.verifyPatchToAdd strPatch=" + (String)object4 + "  vVerPatches=" + vector2);
            object3 = new Vector();
            object2 = new Vector();
            object = VerifyPatch.verifyPatchToAdd(object4, object2, (Vector)object3, hashtable, vector3, hashtable2, vector2, string3, string5, this.getResourceBundle());
            if (object != null) {
                vector5.add(object4);
                System.out.println("\n");
                this.trace(" ----- error from VerifyPatch.verifyPatchToAdd");
                System.out.println((String)object);
                this.bCmdVerifyPassed = false;
                continue;
            }
            this.trace(" ---- display warnings -- " + object2);
            int n2 = ((Vector)object2).size();
            if (n2 != 0) {
                bl = true;
                n = 0;
                while (n < n2) {
                    System.out.println("\n" + (String)((Vector)object2).elementAt(n));
                    ++n;
                }
            }
            this.trace(" ---- required patches -- " + object3);
            n = 0;
            while (n < ((Vector)object3).size()) {
                String string6 = (String)((Vector)object3).elementAt(n);
                if (!vector2.contains(string6)) {
                    vector2.add(string6);
                }
                if (!vector.contains(string6)) {
                    Object[] objectArray = new Object[]{object4, string6};
                    System.out.println("\n");
                    System.out.println(MessageFormat.format(this.getLocalizedMessage("er_requires_patch"), objectArray));
                    this.bCmdVerifyPassed = false;
                }
                ++n;
            }
            if (vector2.contains(object4)) continue;
            vector2.add(object4);
        }
        if (vector2.size() <= 1 || !this.bCmdVerifyPassed) {
            return vector2;
        }
        if (bl) {
            this.trace(" ----- before reverse: vVerPatches= " + vector2);
            vector = this.reverseVec(vector2);
            this.trace(" ----- before reverse: vPatchids= " + vector);
            object4 = new Vector<Object>();
            object3 = vector.elements();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                this.trace(" ----- call 2x VerifyPatch.verifyPatchToAdd strPatch=" + (String)object2 + "  vXVerPatches=" + object4);
                object = new Vector();
                Vector vector6 = new Vector();
                String string7 = VerifyPatch.verifyPatchToAdd((String)object2, null, (Vector)object, hashtable, vector3, hashtable2, object4, string3, string5, this.getResourceBundle());
                if (string7 != null) {
                    System.out.println("\n");
                    System.out.println(string7);
                    this.bCmdVerifyPassed = false;
                    continue;
                }
                ((Vector)object4).add(object2);
            }
            if (!this.bCmdVerifyPassed) {
                return vector2;
            }
        }
        this.trace(" ---- patches before sequencing: " + vector2);
        object4 = new PatchInstallOrder(vector2, hashtable);
        try {
            vector2 = ((PatchInstallOrder)object4).getInstallOrder();
        }
        catch (AdminException adminException) {
            this.unmountPatchDir((PatchHostData)this.vMObjs.elementAt(0));
            System.out.println("\n");
            System.out.println(adminException.getLocalizedMessage());
            if (this.getDebugStatus()) {
                adminException.printStackTrace();
            }
            throw new PatchException("EXM_PM_CLI_SEQUENCE_ERROR");
        }
        this.trace(" ---- patches after sequencing: " + vector2);
        return vector2;
    }

    private Vector preVerifyPatchRm(Vector vector) throws PatchException {
        Vector vector2 = new Vector();
        this.trace("in PatchMgrCli->preVerifyPatchRm()");
        if (this.vMObjs.size() == 0) {
            throw new PatchException("EXM_INTERNAL", "NoAddHostObject ");
        }
        PatchHostData patchHostData = (PatchHostData)this.vMObjs.elementAt(0);
        try {
            vector2 = patchHostData.getHostSvrWrapper().getAllInstalledPatches();
            this.trace(" ---- PVR - installedPatches: " + vector2);
        }
        catch (AdminException adminException) {
            if (this.getDebugStatus()) {
                adminException.printStackTrace();
            }
            System.out.println(adminException.getLocalizedMessage());
            throw new PatchException("EXM_INTERNAL", "PVRmInstPatches");
        }
        Object var4_5 = null;
        this.trace(" ---- After sequencing: " + vector);
        return vector;
    }

    private void createPatchElements(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PatchMgrObj patchMgrObj = new PatchMgrObj();
            patchMgrObj.setPatchName((String)enumeration.nextElement());
            this.vObjs.addElement(patchMgrObj);
        }
    }

    private Vector validatePatchIds(Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        this.trace("in PatchMgrCli->validatePatchIds()");
        this.trace(" -- start ----- " + vector);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray;
            String string = (String)enumeration.nextElement();
            if (vector2.contains(string)) {
                objectArray = new Object[]{string};
                System.out.println("\n");
                System.out.println(MessageFormat.format(this.getLocalizedMessage("dup_patchids"), objectArray));
                continue;
            }
            if (!DownloadPatchWizard.isValidPatchID(string)) {
                objectArray = new Object[]{string};
                System.out.println("\n");
                System.out.println(MessageFormat.format(this.getLocalizedMessage("err_patchid"), objectArray));
                this.bCmdVerifyPassed = false;
                continue;
            }
            vector2.add(string);
        }
        this.trace(" -- result ----- " + vector2);
        return vector2;
    }

    private Vector validateMachineNames(Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        this.trace("in PatchMgrCli->validateMachineNames()");
        this.trace(" --- start ----- " + vector);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray;
            String string = (String)enumeration.nextElement();
            if (vector2.contains(string)) {
                objectArray = new Object[]{string};
                System.out.println("\n");
                System.out.println(MessageFormat.format(this.getLocalizedMessage("dup_machinename"), objectArray));
                continue;
            }
            if (!CheckSyntax.isHomeDirServerOK((String)string)) {
                objectArray = new Object[]{string};
                System.out.println("\n");
                System.out.println(MessageFormat.format(this.getLocalizedMessage("err_machinename"), objectArray));
                this.bCmdVerifyPassed = false;
                continue;
            }
            vector2.add(string);
        }
        this.trace(" --- result ----- " + vector2);
        return vector2;
    }

    private String mountPatchDir(PatchHostData patchHostData) throws PatchException {
        String string = patchHostData.getPatchDir();
        if (patchHostData.isDirShared()) {
            this.unmountPatchDir(patchHostData);
            try {
                this.trace(" ----- mountPatchServer(" + string + ")");
                patchHostData.getHostSvrWrapper().mountPatchServer(string);
            }
            catch (AdminException adminException) {
                System.out.println("\n");
                throw new PatchException("EXM_PM_CLI_MOUNT_ERR", (Object)string, patchHostData.getPatchHost());
            }
            return "/patch_spool";
        }
        return string;
    }

    private void unmountPatchDir(PatchHostData patchHostData) throws PatchException {
        if (patchHostData.isDirShared()) {
            try {
                patchHostData.getHostSvrWrapper().unmountPatchServer(patchHostData.getPatchDir());
                this.trace(" ---- unmountPatchServer(" + patchHostData.getPatchDir() + ")");
            }
            catch (AdminException adminException) {
                System.out.println("\n");
                throw new PatchException("EXM_PM_CLI_UNMOUNT_ERR", (Object)patchHostData.getPatchDir(), patchHostData.getPatchHost());
            }
        }
    }

    private Vector outNeededPatches(ServiceWrapper serviceWrapper, String string) throws PatchException {
        Vector<String> vector = new Vector<String>();
        Object[] objectArray = new Object[]{string};
        System.out.println(MessageFormat.format(this.getLocalizedMessage("host_needed_patches"), objectArray));
        Vector vector2 = null;
        try {
            vector2 = serviceWrapper.assessNeededPatches();
        }
        catch (AdminException adminException) {
            this.trace(" ----- assessNeededPatche failed");
            System.out.println(adminException.getLocalizedMessage());
            throw new PatchException("");
        }
        if (vector2 == null || vector2.size() == 0) {
            System.out.println("\n\t\t" + this.getLocalizedMessage("noreqpatch"));
            throw new PatchException("");
        }
        System.out.println("\n\t" + this.getLocalizedMessage("recom_patches"));
        int n = 0;
        while (n < vector2.size()) {
            AssessedPatchData assessedPatchData = (AssessedPatchData)vector2.elementAt(n);
            System.out.println("\t" + assessedPatchData.getPatchId() + "   " + assessedPatchData.getSynopsis());
            vector.add(assessedPatchData.getPatchId());
            ++n;
        }
        return vector;
    }

    private Vector fileToVectorOfStrings(String string) throws PatchException, PatchCliHelpException {
        if (string == null || string.length() == 0) {
            System.out.println("\n");
            throw new PatchException("EXM_PM_CLI_MISSING_PATH");
        }
        File file = new File(string);
        if (!file.exists() || !file.isFile() || file.length() == 0L) {
            System.out.println("\n");
            throw new PatchException("EXM_PM_CLI_BAD_FILE", string);
        }
        Vector<String> vector = new Vector<String>();
        String string2 = null;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string), 8192);
            string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (string2.trim().length() != 0) {
                    vector.add(string2);
                }
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            if (this.getDebugStatus()) {
                iOException.printStackTrace();
            }
            System.out.println("\n");
            throw new PatchException("EXM_PM_CLI_READ_ERR", string);
        }
        return vector;
    }

    private Vector reverseVec(Vector vector) {
        Vector vector2 = null;
        int n = vector.size();
        if (vector == null || n < 2) {
            return vector;
        }
        vector2 = new Vector(n);
        int n2 = n - 1;
        while (n2 >= 0) {
            vector2.addElement(vector.elementAt(n2));
            --n2;
        }
        return vector2;
    }

    private static class PmCommandParser
    extends CommandParser {
        private String prefix = null;
        private ResourceBundle resBundle = null;

        public PmCommandParser(String string, String string2, boolean bl, InputStream inputStream, PrintStream printStream, ResourceBundle resourceBundle) {
            super(string, string2, bl, inputStream, printStream);
            this.prefix = string;
            this.resBundle = resourceBundle;
            this.setCombineFlags(false);
        }

        public void printUsage(String string) {
            int n = 1;
            String string2 = null;
            if (string != null) {
                this.outStream.println(CommandParser.getMessage((String)"Error: {0}", (Object[])new String[]{string}));
            }
            String string3 = ResourceStrings.getString((ResourceBundle)this.resBundle, (String)"usage_header");
            this.outStream.println(string3);
            while ((string3 = ResourceStrings.getString((ResourceBundle)this.resBundle, (String)(string2 = this.prefix + "_usage_" + n))).compareTo(string2) != 0) {
                this.outStream.println(string3);
                ++n;
            }
        }

        public void printUsage() {
            this.printUsage(null);
        }
    }
}

