/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.compiler.mofc;

import com.sun.wbem.compiler.mofc.BeanGenerator;
import com.sun.wbem.compiler.mofc.BeanGeneratorConstants;
import com.sun.wbem.compiler.mofc.I18N;
import com.sun.wbem.compiler.mofc.JavaDocElement;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMParameter;
import javax.wbem.cim.CIMProperty;
import javax.wbem.client.Debug;

class BeanInterfaceWriter
implements BeanGeneratorConstants {
    private CIMClass cimClass = null;
    private Vector vProperties = null;
    private Vector vMethods = null;
    private String superClass = null;
    private String className = null;

    public BeanInterfaceWriter(CIMClass cIMClass) {
        this.cimClass = cIMClass;
        Debug.trace2((String)("Generating Java Interface source for " + cIMClass.getName()));
        I18N.setResourceName("com.sun.wbem.compiler.mofc.Compiler");
        this.populateClassData();
        this.generateInterface();
    }

    private void populateClassData() {
        this.superClass = BeanGenerator.getSuperClass(this.cimClass);
        this.className = BeanGenerator.getClassName(this.cimClass.getName());
        this.vProperties = this.cimClass.getProperties();
        this.vMethods = this.cimClass.getMethods();
    }

    private void generateInterface() {
        StringBuffer stringBuffer = new StringBuffer(this.className);
        stringBuffer.append("Bean");
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(BeanGenerator.getFileHeader());
        stringBuffer2.append(BeanGenerator.getPackageStatement());
        stringBuffer2.append(BeanGenerator.getImportStatements());
        stringBuffer2.append(this.getInterfaceOpen());
        stringBuffer2.append(this.getPropertyMethods());
        stringBuffer2.append(this.getInvokeMethods());
        stringBuffer2.append(this.getInterfaceClose());
        BeanGenerator.writeToFile(stringBuffer, stringBuffer2);
    }

    private StringBuffer getInterfaceOpen() {
        Debug.trace3((String)("Generating Interface definition for: " + this.className));
        String string = I18N.loadStringFormat("BEAN_INTERFACE_JAVADOC", this.className);
        StringBuffer stringBuffer = BeanGenerator.getClassDescription(this.cimClass);
        StringBuffer stringBuffer2 = BeanGenerator.getJavaDoc(string, stringBuffer, null, 0);
        String string2 = BeanGenerator.hasContents(this.superClass) ? BeanGenerator.format("public interface {0}Bean extends {1}Bean ", this.className, this.superClass) : BeanGenerator.format("public interface {0}Bean ", this.className);
        stringBuffer2.append(string2).append("{\n").append("\n");
        return stringBuffer2;
    }

    private StringBuffer getInterfaceClose() {
        StringBuffer stringBuffer = new StringBuffer("}");
        stringBuffer.append(BeanGenerator.format(" // Interface {0}Bean", this.className));
        return stringBuffer;
    }

    private StringBuffer getPropertyMethods() {
        Debug.trace3((String)("Generating Interface property definitions for: " + this.className));
        StringBuffer stringBuffer = new StringBuffer();
        if (!BeanGenerator.hasContents(this.vProperties)) {
            return stringBuffer;
        }
        Enumeration enumeration = this.vProperties.elements();
        while (enumeration.hasMoreElements()) {
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            stringBuffer.append(this.generatePropertyMethods(cIMProperty));
        }
        return stringBuffer.append("\n");
    }

    private StringBuffer generatePropertyMethods(CIMProperty cIMProperty) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = BeanGenerator.hasQualifier(cIMProperty, "Override");
        boolean bl3 = bl = BeanGenerator.hasQualifier(cIMProperty, "ValueMap") || BeanGenerator.hasQualifier(cIMProperty, "Values");
        if (bl2 && !bl) {
            return stringBuffer;
        }
        cIMProperty.setOriginClass(this.className);
        if (!bl2) {
            StringBuffer stringBuffer2;
            if (!bl) {
                stringBuffer.append(BeanGenerator.getAccessorDoc(cIMProperty));
                stringBuffer.append(this.getAccessor(cIMProperty));
                stringBuffer.append(BeanGenerator.getMutatorDoc(cIMProperty));
                stringBuffer.append(this.getMutator(cIMProperty));
            }
            if (BeanGenerator.hasContents(stringBuffer2 = BeanGenerator.getUnitsDoc(cIMProperty))) {
                stringBuffer.append(stringBuffer2).append(this.getUnits(cIMProperty));
            }
            if (BeanGenerator.hasContents(stringBuffer2 = BeanGenerator.getDisplayNameDoc(cIMProperty))) {
                stringBuffer.append(stringBuffer2).append(this.getDisplayName(cIMProperty));
            }
        }
        if (bl && !bl2) {
            stringBuffer.append(this.getConstants(cIMProperty));
            stringBuffer.append(this.getConstantsMethods(cIMProperty));
        }
        return stringBuffer;
    }

    private StringBuffer getAccessor(CIMProperty cIMProperty) {
        Debug.trace3((String)("Generating Interface property accessor for: " + this.className + "." + cIMProperty.getName()));
        String string = BeanGenerator.format("public {0} get{1}(){2};", BeanGenerator.getPropertyDataType(cIMProperty).toString(), BeanGenerator.firstCharUpper(cIMProperty.getName()).toString(), BeanGenerator.getExceptions().toString());
        StringBuffer stringBuffer = BeanGenerator.getSourceLine(string, 1);
        return stringBuffer.append("\n").append("\n");
    }

    private StringBuffer getMutator(CIMProperty cIMProperty) {
        Debug.trace3((String)("Generating Interface property mutator for: " + this.className + "." + cIMProperty.getName()));
        String string = BeanGenerator.format("public void set{0}({1} {2}){3};", BeanGenerator.firstCharUpper(cIMProperty.getName()).toString(), BeanGenerator.getPropertyDataType(cIMProperty).toString(), BeanGenerator.getParameterName(cIMProperty.getName()), BeanGenerator.getExceptions().toString());
        StringBuffer stringBuffer = BeanGenerator.getSourceLine(string, 1);
        return stringBuffer.append("\n").append("\n");
    }

    private StringBuffer getUnits(CIMProperty cIMProperty) {
        Debug.trace3((String)("Generating Interface property units accessor for: " + this.className + "." + cIMProperty.getName()));
        String string = BeanGenerator.format("public String get{0}Units(){1};", BeanGenerator.firstCharUpper(cIMProperty.getName()).toString(), BeanGenerator.getExceptions().toString());
        StringBuffer stringBuffer = BeanGenerator.getSourceLine(string, 1);
        return stringBuffer.append("\n").append("\n");
    }

    private StringBuffer getDisplayName(CIMProperty cIMProperty) {
        Debug.trace3((String)("Generating Interface property display name accessor for: " + this.className + "." + cIMProperty.getName()));
        String string = BeanGenerator.format("public String get{0}DisplayName(){1};", BeanGenerator.firstCharUpper(cIMProperty.getName()).toString(), BeanGenerator.getExceptions().toString());
        StringBuffer stringBuffer = BeanGenerator.getSourceLine(string, 1);
        return stringBuffer.append("\n").append("\n");
    }

    private StringBuffer getConstants(CIMProperty cIMProperty) {
        StringBuffer stringBuffer = BeanGenerator.getJavaDoc(I18N.loadStringFormat("PROP_VALUEMAP_CONSTANTS_JAVADOC", cIMProperty.getName()), new StringBuffer(), null, 1);
        String string = cIMProperty.getName().toUpperCase() + "VALUE_";
        Enumeration enumeration = BeanGenerator.getConstantNames(cIMProperty, string).elements();
        Enumeration enumeration2 = BeanGenerator.getValuesConstantValues(cIMProperty).elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)enumeration2.nextElement();
            stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("public final static String {0} = new String(\"{1}\");\n", string2, string3), 1));
        }
        return stringBuffer.append("\n");
    }

    private StringBuffer getConstants(CIMParameter cIMParameter, String string) {
        StringBuffer stringBuffer = BeanGenerator.getJavaDoc(I18N.loadStringFormat("PARAM_VALUEMAP_CONSTANTS_JAVADOC", cIMParameter.getName(), (Object)string), new StringBuffer(), null, 1);
        String string2 = string.toUpperCase() + "_" + cIMParameter.getName().toUpperCase() + "VALUE_";
        Enumeration enumeration = BeanGenerator.getConstantNames(cIMParameter, string2).elements();
        Enumeration enumeration2 = BeanGenerator.getValuesConstantValues(cIMParameter).elements();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = (String)enumeration2.nextElement();
            stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("public final static String {0} = new String(\"{1}\");\n", string3, string4), 1));
        }
        return stringBuffer.append("\n");
    }

    private StringBuffer getConstantsMethods(CIMProperty cIMProperty) {
        boolean bl = BeanGenerator.hasQualifier(cIMProperty, "Values");
        StringBuffer stringBuffer = new StringBuffer("String");
        StringBuffer stringBuffer2 = BeanGenerator.getDataType(cIMProperty.getType());
        if (BeanGenerator.isArrayType(stringBuffer2)) {
            stringBuffer = new StringBuffer("String[]");
        }
        StringBuffer stringBuffer3 = new StringBuffer("String[]");
        String string = BeanGenerator.firstCharUpper(cIMProperty.getName()).toString();
        JavaDocElement javaDocElement = new JavaDocElement("@return", stringBuffer, I18N.loadStringFormat("ACCESSOR_RETURN_DESCRIPTION", string));
        Vector<JavaDocElement> vector = new Vector<JavaDocElement>(1);
        vector.addElement(javaDocElement);
        StringBuffer stringBuffer4 = BeanGenerator.getJavaDoc(I18N.loadStringFormat("BEAN_ACCESSOR_JAVADOC", this.className, (Object)cIMProperty.getName()), BeanGenerator.getPropertyDescription(cIMProperty), vector, 1);
        stringBuffer4.append(BeanGenerator.getSourceLine(BeanGenerator.format("public {0} get{1}(){2};", stringBuffer.toString(), string, BeanGenerator.getExceptions().toString()), 1));
        stringBuffer4.append("\n").append("\n");
        javaDocElement = new JavaDocElement("@param", stringBuffer, I18N.loadStringFormat("MUTATOR_PARAM_DESCRIPTION", string));
        vector = new Vector(2);
        vector.addElement(javaDocElement);
        javaDocElement = new JavaDocElement("@exception", new StringBuffer("IllegalArgumentException"), I18N.loadString("ILLEGAL_EXCEPTION_DESCRIPTION"));
        vector.addElement(javaDocElement);
        stringBuffer4.append(BeanGenerator.getJavaDoc(I18N.loadStringFormat("BEAN_MUTATOR_JAVADOC", this.className, (Object)cIMProperty.getName()), BeanGenerator.getPropertyDescription(cIMProperty), vector, 1));
        stringBuffer4.append(BeanGenerator.getSourceLine(BeanGenerator.format("public void set{0}({1} {2}){3};", string, stringBuffer.toString(), BeanGenerator.getParameterName(cIMProperty.getName()), " throws IllegalArgumentException"), 1));
        stringBuffer4.append("\n").append("\n");
        javaDocElement = new JavaDocElement("@return", stringBuffer3, I18N.loadString("VALUESACCESSOR_RETURN_DESCRIPTION"));
        vector = new Vector(1);
        vector.addElement(javaDocElement);
        stringBuffer4.append(BeanGenerator.getJavaDoc(I18N.loadStringFormat("PROP_VALUES_ACCESSOR_JAVADOC", this.className, (Object)cIMProperty.getName()), BeanGenerator.getPropertyDescription(cIMProperty), vector, 1));
        stringBuffer4.append(BeanGenerator.getSourceLine(BeanGenerator.format("public String[] get{0}Values();", string), 1));
        stringBuffer4.append("\n").append("\n");
        return stringBuffer4;
    }

    private StringBuffer getConstantsMethod(CIMParameter cIMParameter, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer("String[]");
        String string2 = BeanGenerator.firstCharUpper(cIMParameter.getName()).toString();
        String string3 = BeanGenerator.firstCharUpper(string).toString() + "_" + string2;
        JavaDocElement javaDocElement = new JavaDocElement("@return", stringBuffer2, I18N.loadString("VALUESACCESSOR_RETURN_DESCRIPTION"));
        Vector<JavaDocElement> vector = new Vector<JavaDocElement>(1);
        vector.addElement(javaDocElement);
        Object[] objectArray = new Object[]{this.className, string, string2};
        stringBuffer.append(BeanGenerator.getJavaDoc(I18N.loadStringFormat("PARAM_VALUES_ACCESSOR_JAVADOC", objectArray), new StringBuffer(), vector, 1));
        stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("public String[] get{0}Values();", string3), 1));
        stringBuffer.append("\n").append("\n");
        return stringBuffer;
    }

    private StringBuffer getInvokeMethods() {
        Debug.trace3((String)("Generating Interface invokeMethods for: " + this.className));
        StringBuffer stringBuffer = new StringBuffer();
        if (!BeanGenerator.hasContents(this.vMethods)) {
            return stringBuffer;
        }
        Enumeration enumeration = this.vMethods.elements();
        while (enumeration.hasMoreElements()) {
            CIMMethod cIMMethod = (CIMMethod)enumeration.nextElement();
            Vector vector = cIMMethod.getParameters();
            if (BeanGenerator.hasContents(vector)) {
                Enumeration enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    CIMParameter cIMParameter = (CIMParameter)enumeration2.nextElement();
                    if (!BeanGenerator.hasQualifier(cIMParameter, "Values") && !BeanGenerator.hasQualifier(cIMParameter, "ValueMap")) continue;
                    stringBuffer.append(this.getConstants(cIMParameter, cIMMethod.getName()));
                    stringBuffer.append(this.getConstantsMethod(cIMParameter, cIMMethod.getName()));
                }
            }
            cIMMethod.setOriginClass(this.className);
            stringBuffer.append(BeanGenerator.getInvokeMethodDoc(cIMMethod));
            stringBuffer.append(this.getInvokeMethod(cIMMethod));
            if (!BeanGenerator.hasOutParameter(cIMMethod)) continue;
            BeanGenerator.writeToFile(BeanGenerator.getOutputInterfaceName(cIMMethod), this.getMethodOutputInterface(cIMMethod));
        }
        stringBuffer = new StringBuffer(stringBuffer.substring(0, stringBuffer.length() - 1));
        return stringBuffer.append("\n");
    }

    private StringBuffer getInvokeMethod(CIMMethod cIMMethod) {
        Debug.trace3((String)("Generating Interface invokeMethod for: " + this.className + "." + cIMMethod.getName()));
        String string = BeanGenerator.format("public {0} {1}({2}){3};", BeanGenerator.getDataType(cIMMethod.getType()).toString(), cIMMethod.getName(), BeanGenerator.getInvokeMethodParams(cIMMethod).toString(), BeanGenerator.getInvokeMethodExceptions().toString());
        StringBuffer stringBuffer = BeanGenerator.getSourceLine(string, 1);
        return stringBuffer.append("\n").append("\n");
    }

    private StringBuffer getMethodOutputInterface(CIMMethod cIMMethod) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = BeanGenerator.getOutputInterfaceName(cIMMethod).toString();
        stringBuffer.append(BeanGenerator.getFileHeader());
        stringBuffer.append(BeanGenerator.getPackageStatement());
        stringBuffer.append(BeanGenerator.getImportStatements());
        stringBuffer.append(BeanGenerator.getJavaDoc(I18N.loadStringFormat("METHODOUTPUT_INTERFACE_JAVADOC", cIMMethod.getOriginClass(), (Object)cIMMethod.getName()), BeanGenerator.getMethodDescription(cIMMethod), null, 0));
        stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("public interface {0} ", string) + "{\n" + "\n", 0));
        Enumeration enumeration = BeanGenerator.getOutParameters(cIMMethod).elements();
        Vector<JavaDocElement> vector = new Vector<JavaDocElement>(1);
        while (enumeration.hasMoreElements()) {
            CIMParameter cIMParameter = (CIMParameter)enumeration.nextElement();
            String string2 = BeanGenerator.firstCharUpper(cIMParameter.getName()).toString();
            StringBuffer stringBuffer2 = BeanGenerator.getDataType(cIMParameter.getType());
            vector.addElement(new JavaDocElement("@return", stringBuffer2, I18N.loadStringFormat("ACCESSOR_RETURN_DESCRIPTION", string2)));
            stringBuffer.append(BeanGenerator.getJavaDoc(BeanGenerator.format(I18N.loadString("METHODOUTPUT_ACCESSOR_JAVADOC"), string2, cIMMethod.getOriginClass(), cIMMethod.getName()), new StringBuffer(), vector, 1));
            stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("public {0} get{1}(){2};", stringBuffer2.toString(), string2, ""), 1)).append("\n").append("\n");
            vector.removeAllElements();
        }
        stringBuffer.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // Interface {0}", string), 0));
        return stringBuffer;
    }
}

