/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.compiler.mofc;

import com.sun.wbem.compiler.mofc.BeanGenerator;
import com.sun.wbem.compiler.mofc.BeanGeneratorConstants;
import com.sun.wbem.compiler.mofc.I18N;
import com.sun.wbem.compiler.mofc.JavaDocElement;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMParameter;
import javax.wbem.cim.CIMProperty;

class BeanClassWriter
implements BeanGeneratorConstants {
    private CIMClass cimClass = null;
    private String versionStr = null;
    private boolean isAbstractClass = false;
    private Vector vProperties = null;
    private Vector vKeys = null;
    private Vector vMethods = null;
    private String superClass = null;
    private String className = null;
    private static final String invalidChars = "!@#$%^&*(-){[}}+=?/\"'<,>.:;\\| \t";

    public BeanClassWriter(CIMClass cIMClass) {
        this.cimClass = cIMClass;
        this.vProperties = cIMClass.getProperties();
        this.isAbstractClass = BeanGenerator.hasQualifier(cIMClass, "Abstract");
        I18N.setResourceName("com.sun.wbem.compiler.mofc.Compiler");
        this.populateClassData();
        this.generateClass();
    }

    private void populateClassData() {
        this.superClass = BeanGenerator.getSuperClass(this.cimClass);
        this.className = BeanGenerator.getClassName(this.cimClass.getName());
        this.vKeys = this.cimClass.getKeys();
        this.vMethods = this.cimClass.getMethods();
    }

    private void generateClass() {
        StringBuffer stringBuffer = new StringBuffer(this.className);
        stringBuffer.append("BeanImpl");
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(BeanGenerator.getFileHeader());
        stringBuffer2.append(BeanGenerator.getPackageStatement());
        stringBuffer2.append(BeanGenerator.getImportStatements());
        stringBuffer2.append(this.getClassOpen());
        stringBuffer2.append(this.getClassVariables());
        stringBuffer2.append(this.getConstructor());
        if (BeanGenerator.hasQualifier(this.cimClass, "Version")) {
            stringBuffer2.append(this.getVersionMethod());
        }
        if (BeanGenerator.hasContents(this.vKeys)) {
            stringBuffer2.append(this.getBeanKeysMethod());
        }
        stringBuffer2.append(this.getPropertyMethods());
        stringBuffer2.append(this.getInvokeMethods());
        stringBuffer2.append(this.getClassClose());
        BeanGenerator.writeToFile(stringBuffer, stringBuffer2);
    }

    private StringBuffer getClassOpen() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = I18N.loadStringFormat("BEAN_CLASS_JAVADOC", this.className);
        StringBuffer stringBuffer2 = BeanGenerator.getClassDescription(this.cimClass);
        stringBuffer.append(BeanGenerator.getJavaDoc(string, stringBuffer2, null, 0));
        String string2 = BeanGenerator.hasQualifier(this.cimClass, "Terminal") ? "public final class {0}BeanImpl extends {1}BeanImpl implements {0}Bean " : "public class {0}BeanImpl extends {1}BeanImpl implements {0}Bean ";
        stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format(string2, this.className, this.superClass) + "{\n" + "\n", 0));
        return stringBuffer;
    }

    private StringBuffer getClassVariables() {
        StringBuffer stringBuffer = BeanGenerator.getSourceLine("private CIMOMHandle cimomHandle = null;\n", 1);
        stringBuffer.append(BeanGenerator.getSourceLine("private CIMInstance cimInstance = null;\n", 1));
        String string = "null";
        if (BeanGenerator.hasContents(this.vKeys)) {
            Enumeration enumeration = this.vKeys.elements();
            string = "{";
            while (enumeration.hasMoreElements()) {
                CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
                string = string + "\"" + cIMProperty.getName() + "\", ";
            }
            string = string.substring(0, string.lastIndexOf(",")) + "}";
        }
        stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("private final static String[] keysArr = {0};\n", string), 1));
        if (BeanGenerator.hasQualifier(this.cimClass, "Version")) {
            this.versionStr = BeanGenerator.getQualifier(this.cimClass, "Version");
            stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("private final String versionStr = \"{0}\";\n", this.versionStr), 1));
        }
        return stringBuffer.append("\n");
    }

    private StringBuffer getConstructor() {
        String string = I18N.loadStringFormat("BEAN_CONSTRUCTOR_JAVADOC", this.className);
        StringBuffer stringBuffer = BeanGenerator.getClassDescription(this.cimClass);
        Vector<JavaDocElement> vector = new Vector<JavaDocElement>(2);
        JavaDocElement javaDocElement = new JavaDocElement("@param", new StringBuffer("CIMOMHandle"), I18N.loadString("CIMOM_PARAM_DESCRIPTION"));
        vector.addElement(javaDocElement);
        javaDocElement = new JavaDocElement("@param", new StringBuffer("CIMInstance"), I18N.loadString("INSTANCE_PARAM_DESCRIPTION"));
        vector.addElement(javaDocElement);
        StringBuffer stringBuffer2 = BeanGenerator.getJavaDoc(string, stringBuffer, vector, 1);
        String string2 = "public {0}BeanImpl(CIMOMHandle handle, CIMInstance instance) ";
        if (this.isAbstractClass) {
            string2 = "protected {0}BeanImpl(CIMOMHandle handle, CIMInstance instance) ";
        }
        stringBuffer2.append(BeanGenerator.getSourceLine(BeanGenerator.format(string2, this.className) + "{\n" + "\n", 1));
        stringBuffer2.append(BeanGenerator.getSourceLine("super(handle, instance);\n", 2)).append("\n");
        stringBuffer2.append(BeanGenerator.getSourceLine("this.cimomHandle = handle;\n", 2));
        stringBuffer2.append(BeanGenerator.getSourceLine("this.cimInstance = instance;\n", 2)).append("\n");
        stringBuffer2.append(BeanGenerator.getSourceLine("} // constructor\n", 1));
        return stringBuffer2.append("\n");
    }

    private StringBuffer getBeanKeysMethod() {
        String string = I18N.loadString("BEAN_GETKEYS_JAVADOC");
        Vector<JavaDocElement> vector = new Vector<JavaDocElement>(1);
        JavaDocElement javaDocElement = new JavaDocElement("@return", new StringBuffer("String[]"), I18N.loadString("KEYS_RETURN_DESCRIPTION"));
        vector.addElement(javaDocElement);
        StringBuffer stringBuffer = BeanGenerator.getJavaDoc(string, new StringBuffer(), vector, 1);
        return stringBuffer.append("    public String[] getBeanKeys() {\n\n\treturn keysArr;\n\n    } // getBeanKeys\n").append("\n");
    }

    private StringBuffer getVersionMethod() {
        String string = I18N.loadStringFormat("BEAN_GETVERSION_JAVADOC", this.className);
        Vector<JavaDocElement> vector = new Vector<JavaDocElement>(1);
        JavaDocElement javaDocElement = new JavaDocElement("@return", new StringBuffer("String"), I18N.loadString("VERSION_RETURN_DESCRIPTION"));
        vector.addElement(javaDocElement);
        StringBuffer stringBuffer = BeanGenerator.getJavaDoc(string, new StringBuffer(), vector, 1);
        return stringBuffer.append("    public String getBeanVersion() {\n\n\treturn versionStr;\n\n    } // getBeanVersion\n").append("\n");
    }

    private StringBuffer getBeanKeysClass() {
        JavaDocElement javaDocElement;
        CIMProperty cIMProperty;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(BeanGenerator.getFileHeader());
        stringBuffer.append(BeanGenerator.getPackageStatement());
        stringBuffer.append(BeanGenerator.getImportStatements());
        String string = I18N.loadStringFormat("BEANKEYS_JAVADOC", this.className);
        stringBuffer.append(BeanGenerator.getJavaDoc(string, new StringBuffer(), null, 0));
        stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("public class {0}BeanKeys implements CIMBeanKeys, Serializable ", this.className) + "{\n" + "\n", 0));
        Enumeration enumeration = this.vKeys.elements();
        while (enumeration.hasMoreElements()) {
            cIMProperty = (CIMProperty)enumeration.nextElement();
            stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("private {0} {1} = null;\n", BeanGenerator.getDataType(cIMProperty.getType()).toString(), BeanGenerator.getParameterName(cIMProperty.getName())), 1));
        }
        stringBuffer.append("\n");
        Vector<JavaDocElement> vector = new Vector<JavaDocElement>(this.vKeys.size());
        this.addPropsToVector(vector, this.vKeys);
        stringBuffer.append(BeanGenerator.getJavaDoc(I18N.loadStringFormat("BEANKEYS_CONSTRUCTOR_JAVADOC", this.className), new StringBuffer(), vector, 1));
        stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("public {0}BeanKeys({1}) ", this.className, this.getBeanKeysParameters()) + "{\n" + "\n", 1));
        stringBuffer.append(BeanGenerator.getSourceLine("super();\n", 2));
        enumeration = this.vKeys.elements();
        while (enumeration.hasMoreElements()) {
            cIMProperty = (CIMProperty)enumeration.nextElement();
            stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("this.{0} = {0};\n", BeanGenerator.getParameterName(cIMProperty.getName())), 2));
        }
        stringBuffer.append("\n");
        stringBuffer.append(BeanGenerator.getSourceLine("} // constructor\n\n", 1));
        enumeration = this.vKeys.elements();
        while (enumeration.hasMoreElements()) {
            cIMProperty = (CIMProperty)enumeration.nextElement();
            vector.removeAllElements();
            javaDocElement = new JavaDocElement("@return", BeanGenerator.getDataType(cIMProperty.getType()), I18N.loadString("ACCESSOR_RETURN_DESCRIPTION"));
            vector.addElement(javaDocElement);
            stringBuffer.append(BeanGenerator.getJavaDoc(I18N.loadStringFormat("BEANKEYS_ACCESSOR_JAVADOC", cIMProperty.getName()), new StringBuffer(), vector, 1));
            stringBuffer.append(this.getBeanKeysAccessor(cIMProperty));
        }
        vector.removeAllElements();
        javaDocElement = new JavaDocElement("@return", new StringBuffer("CIMObjectPath"), I18N.loadString("CIMOBJPATH_RETURN_DESCRIPTION"));
        vector.addElement(javaDocElement);
        stringBuffer.append(BeanGenerator.getJavaDoc(I18N.loadString("BEANKEYS_CIMOBJPATH_JAVADOC"), new StringBuffer(), vector, 1));
        stringBuffer.append(BeanGenerator.getSourceLine("public CIMObjectPath getCIMObjectPath() {\n\n", 1));
        stringBuffer.append(BeanGenerator.getSourceLine("Vector vKeys = new Vector()\n;", 2));
        enumeration = this.vKeys.elements();
        while (enumeration.hasMoreElements()) {
            cIMProperty = (CIMProperty)enumeration.nextElement();
            stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("vKeys.addElement(new CIMProperty(\"{0}\", new CIMValue({1})));\n", cIMProperty.getName(), BeanGenerator.getParameterName(cIMProperty.getName())), 2));
        }
        stringBuffer.append("\n");
        stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("return (new CIMObjectPath(\"{0}\", vKeys));\n", this.className), 2));
        stringBuffer.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // get{0}\n", "CIMObjectPath") + "\n", 1));
        stringBuffer.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // Class {0}BeanKeys\n", this.className), 0));
        return stringBuffer;
    }

    private StringBuffer getClassClose() {
        StringBuffer stringBuffer = new StringBuffer("}");
        stringBuffer.append(BeanGenerator.format(" // Class {0}BeanImpl", this.className));
        return stringBuffer;
    }

    private StringBuffer getPropertyMethods() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!BeanGenerator.hasContents(this.vProperties)) {
            return stringBuffer;
        }
        Enumeration enumeration = this.vProperties.elements();
        while (enumeration.hasMoreElements()) {
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            stringBuffer.append(this.generatePropertyMethods(cIMProperty));
        }
        return stringBuffer.append("\n");
    }

    private StringBuffer generatePropertyMethods(CIMProperty cIMProperty) {
        StringBuffer stringBuffer;
        boolean bl = BeanGenerator.hasQualifier(cIMProperty, "ValueMap") || BeanGenerator.hasQualifier(cIMProperty, "Values");
        StringBuffer stringBuffer2 = new StringBuffer();
        cIMProperty.setOriginClass(this.className);
        if (!bl) {
            stringBuffer2.append(BeanGenerator.getAccessorDoc(cIMProperty));
            stringBuffer2.append(this.getAccessor(cIMProperty));
            stringBuffer2.append(BeanGenerator.getMutatorDoc(cIMProperty));
            stringBuffer2.append(this.getMutator(cIMProperty));
        }
        if (BeanGenerator.hasContents(stringBuffer = BeanGenerator.getUnitsDoc(cIMProperty))) {
            stringBuffer2.append(stringBuffer).append(this.getUnits(cIMProperty));
        }
        if (BeanGenerator.hasContents(stringBuffer = BeanGenerator.getDisplayNameDoc(cIMProperty))) {
            stringBuffer2.append(stringBuffer).append(this.getDisplayName(cIMProperty));
        }
        if (bl && !BeanGenerator.hasQualifier(cIMProperty, "Override")) {
            stringBuffer2.append(this.getConstants(cIMProperty));
            stringBuffer2.append(this.getConstantsMethods(cIMProperty));
        }
        return stringBuffer2;
    }

    private StringBuffer getAccessor(CIMProperty cIMProperty) {
        String string = BeanGenerator.firstCharUpper(cIMProperty.getName()).toString();
        StringBuffer stringBuffer = BeanGenerator.getPropertyDataType(cIMProperty);
        if (BeanGenerator.hasQualifier(cIMProperty, "Override")) {
            stringBuffer = BeanGenerator.getOverriddenDataType(this.cimClass, cIMProperty);
        }
        StringBuffer stringBuffer2 = BeanGenerator.getSourceLine(BeanGenerator.format("public {0} get{1}(){2} ", stringBuffer.toString(), string, BeanGenerator.getExceptions().toString()) + "{\n" + "\n", 1);
        if (BeanGenerator.isArrayType(BeanGenerator.getDataType(cIMProperty.getType()))) {
            if (stringBuffer.lastIndexOf("[]") > 0) {
                stringBuffer = new StringBuffer(stringBuffer.substring(0, stringBuffer.length() - 2));
            }
            stringBuffer2.append(BeanGenerator.getSourceLine(BeanGenerator.format("Vector v = (Vector)getProperty(\"{0}\");\n", string), 2));
            stringBuffer2.append(BeanGenerator.getSourceLine(BeanGenerator.format("{0}[] returnArr = null;\n", stringBuffer.toString()), 2));
            stringBuffer2.append(BeanGenerator.getSourceLine("if (v != null) {\n\n", 2));
            stringBuffer2.append(BeanGenerator.getSourceLine(BeanGenerator.format("returnArr = new {0}[v.size()];\n", stringBuffer.toString()), 3));
            stringBuffer2.append("\t    Enumeration enum = v.elements();\n\t    int counter = 0;\n\t    while (enum.hasMoreElements()) {\n\n");
            stringBuffer2.append(BeanGenerator.getSourceLine(BeanGenerator.format("returnArr[counter] = ({0})enum.nextElement();\n", stringBuffer.toString()), 4));
            stringBuffer2.append("\t\tcounter++;\n\n\t    }\n\n\t}\n\treturn (returnArr);\n\n");
        } else if (cIMProperty.isReference()) {
            stringBuffer2.append(BeanGenerator.getSourceLine(BeanGenerator.format("{0}Impl beanImpl = new {0}Impl(null, null);\n", stringBuffer.toString()), 2));
            stringBuffer2.append(BeanGenerator.getSourceLine("try {\n\n", 2));
            stringBuffer2.append(BeanGenerator.getSourceLine(BeanGenerator.format("getAssociationProperty((CIMObjectPath)getProperty(\"{0}\"), beanImpl);\n\n", string), 3));
            stringBuffer2.append(BeanGenerator.getSourceLine("} catch (CIMException cex) {\n\n", 2));
            stringBuffer2.append(BeanGenerator.getSourceLine("}\n", 2));
            stringBuffer2.append(BeanGenerator.getSourceLine(BeanGenerator.format("return (({0})beanImpl);\n\n", stringBuffer.toString()), 2));
        } else {
            stringBuffer2.append(BeanGenerator.getSourceLine(BeanGenerator.format("return ({0})getProperty(\"{1}\");\n", stringBuffer.toString(), string) + "\n", 2));
        }
        stringBuffer2.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // get{0}\n", cIMProperty.getName()), 1));
        return stringBuffer2.append("\n");
    }

    private StringBuffer getBeanKeysAccessor(CIMProperty cIMProperty) {
        String string = BeanGenerator.firstCharUpper(cIMProperty.getName()).toString();
        StringBuffer stringBuffer = BeanGenerator.getSourceLine(BeanGenerator.format("public {0} get{1}() ", BeanGenerator.getDataType(cIMProperty.getType()).toString(), string) + "{\n" + "\n", 1);
        stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("return this.{0};\n", BeanGenerator.getParameterName(string)) + "\n", 2));
        stringBuffer.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // get{0}\n", string), 1));
        return stringBuffer.append("\n");
    }

    private StringBuffer getMutator(CIMProperty cIMProperty) {
        String string = BeanGenerator.firstCharUpper(cIMProperty.getName()).toString();
        String string2 = BeanGenerator.getParameterName(string);
        StringBuffer stringBuffer = BeanGenerator.getPropertyDataType(cIMProperty);
        if (BeanGenerator.hasQualifier(cIMProperty, "Override")) {
            stringBuffer = BeanGenerator.getOverriddenDataType(this.cimClass, cIMProperty);
        }
        StringBuffer stringBuffer2 = BeanGenerator.getSourceLine(BeanGenerator.format("public void set{0}({1} {2}){3} ", string, stringBuffer.toString(), string2, BeanGenerator.getExceptions().toString()) + "{\n" + "\n", 1);
        if (BeanGenerator.isArrayType(BeanGenerator.getDataType(cIMProperty.getType()))) {
            stringBuffer2.append(BeanGenerator.getSourceLine(BeanGenerator.format("Vector v = new Vector({0}.length);\n", string2), 2));
            stringBuffer2.append(BeanGenerator.getSourceLine(BeanGenerator.format("for (int i = 0; i < {0}.length; i++) ", string2) + "{\n", 2));
            stringBuffer2.append("\n");
            stringBuffer2.append(BeanGenerator.getSourceLine(BeanGenerator.format("v.addElement({0}[i]);\n", string2) + "\n", 3));
            stringBuffer2.append(BeanGenerator.getSourceLine("}\n", 2));
            stringBuffer2.append(BeanGenerator.getSourceLine(BeanGenerator.format("setProperty(\"{0}\", v);\n", cIMProperty.getName(), string2) + "\n", 2));
        } else {
            stringBuffer2.append(BeanGenerator.getSourceLine(BeanGenerator.format("setProperty(\"{0}\", {1});\n", cIMProperty.getName(), string2) + "\n", 2));
        }
        stringBuffer2.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // set{0}\n", cIMProperty.getName()), 1));
        return stringBuffer2.append("\n");
    }

    private StringBuffer getUnits(CIMProperty cIMProperty) {
        StringBuffer stringBuffer = BeanGenerator.getSourceLine(BeanGenerator.format("public String get{0}Units(){1} ", cIMProperty.getName(), BeanGenerator.getExceptions().toString()) + "{\n" + "\n", 1);
        stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("return \"{0}\";\n", BeanGenerator.getQualifier(cIMProperty, "Units")) + "\n", 2));
        stringBuffer.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // get{0}Units\n", cIMProperty.getName()), 1));
        return stringBuffer.append("\n");
    }

    private StringBuffer getDisplayName(CIMProperty cIMProperty) {
        StringBuffer stringBuffer = BeanGenerator.getSourceLine(BeanGenerator.format("public String get{0}DisplayName(){1} ", BeanGenerator.firstCharUpper(cIMProperty.getName()).toString(), BeanGenerator.getExceptions().toString()) + "{\n" + "\n", 1);
        stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("return \"{0}\";\n", BeanGenerator.getQualifier(cIMProperty, "DisplayName")) + "\n", 2));
        stringBuffer.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // get{0}DisplayName\n", BeanGenerator.firstCharUpper(cIMProperty.getName()).toString()), 1));
        return stringBuffer.append("\n");
    }

    private StringBuffer getConstants(CIMProperty cIMProperty) {
        String string;
        StringBuffer stringBuffer = BeanGenerator.getJavaDoc(I18N.loadStringFormat("PROP_VALUEMAP_CONSTANTS_JAVADOC", cIMProperty.getName()), new StringBuffer(), null, 1);
        String string2 = cIMProperty.getName().toUpperCase() + "VALUEMAP_";
        String string3 = BeanGenerator.getPropertyDataType(cIMProperty).toString();
        Enumeration enumeration = BeanGenerator.getConstantNames(cIMProperty, string2).elements();
        Enumeration enumeration2 = BeanGenerator.getValueMapConstantValues(cIMProperty).elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            String string4 = (String)enumeration2.nextElement();
            stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("final static {0} {1} = new {0}(\"{2}\");\n", string3, string, string4), 1));
        }
        String string5 = this.getValueMapArrayName(cIMProperty);
        StringBuffer stringBuffer2 = new StringBuffer("{");
        enumeration = BeanGenerator.getConstantNames(cIMProperty, string2).elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            stringBuffer2.append(string).append(", ");
        }
        String string6 = stringBuffer2.substring(0, stringBuffer2.lastIndexOf(", ")) + "}";
        stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("private final {0}[] {1} = {2};\n", string3, string5, string6), 1));
        string2 = cIMProperty.getName().toUpperCase() + "VALUE_";
        string5 = this.getValuesArrayName(cIMProperty);
        stringBuffer2 = new StringBuffer("{");
        enumeration = BeanGenerator.getConstantNames(cIMProperty, string2).elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            stringBuffer2.append(string).append(", ");
        }
        string6 = stringBuffer2.substring(0, stringBuffer2.lastIndexOf(", ")) + "}";
        stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("private final String[] {0} = {1};\n", string5, string6), 1));
        return stringBuffer.append("\n");
    }

    private StringBuffer getConstants(CIMParameter cIMParameter, String string) {
        String string2;
        StringBuffer stringBuffer = BeanGenerator.getJavaDoc(I18N.loadStringFormat("PARAM_VALUEMAP_CONSTANTS_JAVADOC", cIMParameter.getName(), (Object)string), new StringBuffer(), null, 1);
        String string3 = string.toUpperCase() + "_" + cIMParameter.getName().toUpperCase() + "VALUEMAP_";
        String string4 = BeanGenerator.getDataType(cIMParameter.getType()).toString();
        Enumeration enumeration = BeanGenerator.getConstantNames(cIMParameter, string3).elements();
        Enumeration enumeration2 = BeanGenerator.getValueMapConstantValues(cIMParameter).elements();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            String string5 = (String)enumeration2.nextElement();
            stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("final static {0} {1} = new {0}(\"{2}\");\n", string4, string2, string5), 1));
        }
        String string6 = this.getValueMapArrayName(cIMParameter, string);
        StringBuffer stringBuffer2 = new StringBuffer("{");
        enumeration = BeanGenerator.getConstantNames(cIMParameter, string3).elements();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            stringBuffer2.append(string2).append(", ");
        }
        String string7 = stringBuffer2.substring(0, stringBuffer2.lastIndexOf(", ")) + "}";
        stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("private final {0}[] {1} = {2};\n", string4, string6, string7), 1));
        string3 = string.toUpperCase() + "_" + cIMParameter.getName().toUpperCase() + "VALUE_";
        string6 = this.getValuesArrayName(cIMParameter, string);
        stringBuffer2 = new StringBuffer("{");
        enumeration = BeanGenerator.getConstantNames(cIMParameter, string3).elements();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            stringBuffer2.append(string2).append(", ");
        }
        string7 = stringBuffer2.substring(0, stringBuffer2.lastIndexOf(", ")) + "}";
        stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("private final String[] {0} = {1};\n", string6, string7), 1));
        return stringBuffer.append("\n");
    }

    private String getValueMapArrayName(CIMProperty cIMProperty) {
        String string = BeanGenerator.format("{0}ValueMapArr", BeanGenerator.firstCharLower(cIMProperty.getName()).toString());
        return string;
    }

    private String getValueMapArrayName(CIMParameter cIMParameter, String string) {
        String string2 = BeanGenerator.format("{0}ValueMapArr", BeanGenerator.firstCharLower(string).toString() + "_" + BeanGenerator.firstCharUpper(cIMParameter.getName()).toString());
        return string2;
    }

    private String getValuesArrayName(CIMProperty cIMProperty) {
        String string = BeanGenerator.format("{0}ValueArr", BeanGenerator.firstCharLower(cIMProperty.getName()).toString());
        return string;
    }

    private String getValuesArrayName(CIMParameter cIMParameter, String string) {
        String string2 = BeanGenerator.format("{0}ValueArr", BeanGenerator.firstCharLower(string).toString() + "_" + BeanGenerator.firstCharUpper(cIMParameter.getName()).toString());
        return string2;
    }

    private StringBuffer getConstantsMethods(CIMProperty cIMProperty) {
        boolean bl = BeanGenerator.hasQualifier(cIMProperty, "Values") || BeanGenerator.hasQualifier(cIMProperty, "ValueMap");
        StringBuffer stringBuffer = new StringBuffer("String");
        StringBuffer stringBuffer2 = BeanGenerator.getDataType(cIMProperty.getType());
        boolean bl2 = BeanGenerator.isArrayType(stringBuffer2);
        if (bl2) {
            stringBuffer = new StringBuffer("String[]");
        }
        StringBuffer stringBuffer3 = new StringBuffer("String[]");
        String string = BeanGenerator.getPropertyDataType(cIMProperty).toString();
        String string2 = BeanGenerator.firstCharUpper(cIMProperty.getName()).toString();
        JavaDocElement javaDocElement = new JavaDocElement("@return", stringBuffer, I18N.loadStringFormat("ACCESSOR_RETURN_DESCRIPTION", string2));
        Vector<JavaDocElement> vector = new Vector<JavaDocElement>(1);
        vector.addElement(javaDocElement);
        StringBuffer stringBuffer4 = BeanGenerator.getJavaDoc(I18N.loadStringFormat("BEAN_ACCESSOR_JAVADOC", this.className, (Object)cIMProperty.getName()), BeanGenerator.getPropertyDescription(cIMProperty), vector, 1);
        stringBuffer4.append(BeanGenerator.getSourceLine(BeanGenerator.format("public {0} get{1}(){2} ", stringBuffer.toString(), string2, BeanGenerator.getExceptions().toString()), 1));
        stringBuffer4.append("{\n").append("\n");
        if (bl2) {
            stringBuffer4.append(BeanGenerator.getSourceLine(BeanGenerator.format("return (getArrayProperty(\"{0}\", {1}, {2}));\n", string2, this.getValuesArrayName(cIMProperty), this.getValueMapArrayName(cIMProperty)), 2));
        } else {
            stringBuffer4.append(BeanGenerator.getSourceLine(BeanGenerator.format("int index = getArrayIndex({0}, ({1})getProperty(\"{2}\"));\n", this.getValueMapArrayName(cIMProperty), string, cIMProperty.getName()), 2));
            stringBuffer4.append("\tif (index < 0) {\n\n\t    return (null);\n\n\t}\n");
            stringBuffer4.append(BeanGenerator.getSourceLine(BeanGenerator.format("return ({0}[index]);\n", this.getValuesArrayName(cIMProperty)), 2));
        }
        stringBuffer4.append("\n");
        stringBuffer4.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // get{0}\n", string2), 1));
        stringBuffer4.append("\n");
        javaDocElement = new JavaDocElement("@param", stringBuffer, I18N.loadStringFormat("MUTATOR_PARAM_DESCRIPTION", string2));
        vector = new Vector(2);
        vector.addElement(javaDocElement);
        javaDocElement = new JavaDocElement("@exception", new StringBuffer("IllegalArgumentException"), I18N.loadString("ILLEGAL_EXCEPTION_DESCRIPTION"));
        vector.addElement(javaDocElement);
        stringBuffer4.append(BeanGenerator.getJavaDoc(I18N.loadStringFormat("BEAN_MUTATOR_JAVADOC", this.className, (Object)cIMProperty.getName()), BeanGenerator.getPropertyDescription(cIMProperty), vector, 1));
        String string3 = BeanGenerator.getParameterName(string2);
        stringBuffer4.append(BeanGenerator.getSourceLine(BeanGenerator.format("public void set{0}({1} {2}){3} ", string2, stringBuffer.toString(), string3, " throws IllegalArgumentException"), 1));
        stringBuffer4.append("{\n").append("\n");
        if (bl2) {
            stringBuffer4.append(BeanGenerator.getSourceLine(BeanGenerator.format("setArrayProperty(\"{0}\", {1}, {2}, {3});\n", string2, this.getValuesArrayName(cIMProperty), this.getValueMapArrayName(cIMProperty), string3), 2));
        } else {
            stringBuffer4.append(BeanGenerator.getSourceLine(BeanGenerator.format("int index = getArrayIndex({0}, {1});\n", this.getValuesArrayName(cIMProperty), string3), 2));
            stringBuffer4.append("\tif (index < 0) {\n\n\t    throw new IllegalArgumentException();\n\n\t}\n");
            stringBuffer4.append(BeanGenerator.getSourceLine(BeanGenerator.format("setProperty(\"{0}\", {1}[index]);\n", string2, this.getValueMapArrayName(cIMProperty)), 2));
        }
        stringBuffer4.append("\n");
        stringBuffer4.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // set{0}\n", string2), 1));
        stringBuffer4.append("\n");
        if (bl) {
            javaDocElement = new JavaDocElement("@return", new StringBuffer("String[]"), I18N.loadString("VALUESACCESSOR_RETURN_DESCRIPTION"));
            vector = new Vector(1);
            vector.addElement(javaDocElement);
            stringBuffer4.append(BeanGenerator.getJavaDoc(I18N.loadStringFormat("PROP_VALUES_ACCESSOR_JAVADOC", this.className, (Object)cIMProperty.getName()), new StringBuffer(), vector, 1));
            stringBuffer4.append(BeanGenerator.getSourceLine(BeanGenerator.format("public String[] get{0}Values()", string2) + " " + "{\n" + "\n", 1));
            stringBuffer4.append(BeanGenerator.getSourceLine(BeanGenerator.format("return ({0});\n", this.getValuesArrayName(cIMProperty)), 2));
            stringBuffer4.append("\n");
            stringBuffer4.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // get{0}Values\n", string2), 1));
        }
        return stringBuffer4.append("\n");
    }

    private StringBuffer getConstantsMethod(CIMParameter cIMParameter, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer("String[]");
        String string2 = BeanGenerator.firstCharUpper(cIMParameter.getName()).toString();
        String string3 = BeanGenerator.firstCharUpper(string).toString() + "_" + string2;
        JavaDocElement javaDocElement = new JavaDocElement("@return", stringBuffer2, I18N.loadString("VALUESACCESSOR_RETURN_DESCRIPTION"));
        Vector<JavaDocElement> vector = new Vector<JavaDocElement>(1);
        vector.addElement(javaDocElement);
        Object[] objectArray = new Object[]{this.className, string, string2};
        stringBuffer.append(BeanGenerator.getJavaDoc(I18N.loadStringFormat("PARAM_VALUES_ACCESSOR_JAVADOC", objectArray), new StringBuffer(), vector, 1));
        stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("public String[] get{0}Values()", string3) + " " + "{\n" + "\n", 1));
        stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("return ({0});\n", this.getValuesArrayName(cIMParameter, string)), 2));
        stringBuffer.append("\n");
        stringBuffer.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // get{0}Values\n", string3), 1));
        return stringBuffer.append("\n");
    }

    private StringBuffer getInvokeMethods() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!BeanGenerator.hasContents(this.vMethods)) {
            return stringBuffer;
        }
        Enumeration enumeration = this.vMethods.elements();
        while (enumeration.hasMoreElements()) {
            CIMMethod cIMMethod = (CIMMethod)enumeration.nextElement();
            Vector vector = cIMMethod.getParameters();
            if (BeanGenerator.hasContents(vector)) {
                Enumeration enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    CIMParameter cIMParameter = (CIMParameter)enumeration2.nextElement();
                    if (!BeanGenerator.hasQualifier(cIMParameter, "Values") && !BeanGenerator.hasQualifier(cIMParameter, "ValueMap")) continue;
                    stringBuffer.append(this.getConstants(cIMParameter, cIMMethod.getName()));
                    stringBuffer.append(this.getConstantsMethod(cIMParameter, cIMMethod.getName()));
                }
            }
            cIMMethod.setOriginClass(this.className);
            stringBuffer.append(BeanGenerator.getInvokeMethodDoc(cIMMethod));
            stringBuffer.append(this.getInvokeMethod(cIMMethod));
            if (!BeanGenerator.hasOutParameter(cIMMethod)) continue;
            stringBuffer.append(this.getMethodOutputClass(cIMMethod));
        }
        return new StringBuffer(stringBuffer.substring(0, stringBuffer.length() - 1));
    }

    private StringBuffer getInvokeMethod(CIMMethod cIMMethod) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = cIMMethod.getName();
        StringBuffer stringBuffer2 = BeanGenerator.getDataType(cIMMethod.getType());
        stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("public {0} {1}({2}){3} ", stringBuffer2.toString(), string, BeanGenerator.getInvokeMethodParams(cIMMethod).toString(), BeanGenerator.getInvokeMethodExceptions().toString()) + "{\n" + "\n", 1));
        stringBuffer.append(BeanGenerator.getSourceLine("Vector vInParams = new Vector();\n", 2));
        stringBuffer.append(BeanGenerator.getSourceLine("Vector vOutParams = new Vector();\n\n", 2));
        Vector vector = BeanGenerator.getInParameters(cIMMethod);
        if (BeanGenerator.hasContents(vector)) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string2;
                CIMParameter cIMParameter = (CIMParameter)enumeration.nextElement();
                boolean bl = BeanGenerator.hasQualifier(cIMParameter, "Values") || BeanGenerator.hasQualifier(cIMParameter, "ValueMap");
                String string3 = string2 = BeanGenerator.getParameterName(cIMParameter.getName());
                if (bl) {
                    string3 = BeanGenerator.format("{0}[getArrayIndex({1}, {2})]", this.getValueMapArrayName(cIMParameter, string), this.getValuesArrayName(cIMParameter, string), string2);
                }
                stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("vInParams.addElement(new CIMValue({0}));\n", string3), 2));
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("CIMValue cv = cimomHandle.invokeMethod(cimInstance.getObjectPath(), \"{0}\", vInParams, vOutParams);", string) + "\n", 2));
        if (BeanGenerator.hasContents(BeanGenerator.getOutParameters(cIMMethod))) {
            stringBuffer.append(BeanGenerator.getSourceLine("if (vOutParams != null && vOutParams.size() > 0) {\n\n", 2));
            stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("{0}[0] = ({1})(new {2}({3}));\n", BeanGenerator.getOutputParameterName(cIMMethod).toString(), BeanGenerator.getOutputInterfaceName(cIMMethod).toString(), BeanGenerator.getOutputClassName(cIMMethod).toString(), this.getOutputParameters(cIMMethod)) + "\n", 3));
            stringBuffer.append(BeanGenerator.getSourceLine("}\n", 2));
        }
        stringBuffer.append(BeanGenerator.getSourceLine(BeanGenerator.format("return ({0})cv.getValue();\n", BeanGenerator.getDataType(cIMMethod.getType()).toString()), 2));
        stringBuffer.append("\n" + BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // {0}\n", string), 1));
        return stringBuffer.append("\n").append("\n");
    }

    private StringBuffer getMethodOutputClass(CIMMethod cIMMethod) {
        StringBuffer stringBuffer;
        CIMParameter cIMParameter;
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = BeanGenerator.getOutputClassName(cIMMethod).toString();
        stringBuffer2.append(BeanGenerator.getJavaDoc(I18N.loadStringFormat("METHODOUTPUT_CLASS_JAVADOC", cIMMethod.getOriginClass(), (Object)cIMMethod.getName()), BeanGenerator.getMethodDescription(cIMMethod), null, 1));
        stringBuffer2.append(BeanGenerator.getSourceLine(BeanGenerator.format("private class {0} implements {1} ", string, BeanGenerator.getOutputInterfaceName(cIMMethod).toString()) + "{\n" + "\n", 1));
        Vector vector = BeanGenerator.getOutParameters(cIMMethod);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            cIMParameter = (CIMParameter)enumeration.nextElement();
            stringBuffer = BeanGenerator.getDataType(cIMParameter.getType());
            stringBuffer2.append(BeanGenerator.getSourceLine(BeanGenerator.format("private {0} {1} = null;\n", stringBuffer.toString(), BeanGenerator.getParameterName(cIMParameter.getName())), 2));
        }
        stringBuffer2.append("\n");
        Vector<JavaDocElement> vector2 = new Vector<JavaDocElement>(vector.size());
        this.addParamsToVector(vector2, vector);
        stringBuffer2.append(BeanGenerator.getJavaDoc(BeanGenerator.format(I18N.loadString("METHODOUTPUT_CONSTRUCTOR_JAVADOC"), string, cIMMethod.getOriginClass(), cIMMethod.getName()), new StringBuffer(), vector2, 2));
        stringBuffer2.append(BeanGenerator.getSourceLine(BeanGenerator.format("public {0}({1}) ", string, this.getOutputConstructorParameters(cIMMethod)) + "{\n" + "\n", 2));
        stringBuffer2.append(BeanGenerator.getSourceLine("super();\n", 3));
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            cIMParameter = (CIMParameter)enumeration.nextElement();
            stringBuffer2.append(BeanGenerator.getSourceLine(BeanGenerator.format("this.{0} = {0};\n", BeanGenerator.getParameterName(cIMParameter.getName())), 3));
        }
        stringBuffer2.append("\n");
        stringBuffer2.append(BeanGenerator.getSourceLine("} // constructor\n\n", 2));
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            cIMParameter = (CIMParameter)enumeration.nextElement();
            String string2 = BeanGenerator.firstCharUpper(cIMParameter.getName()).toString();
            String string3 = BeanGenerator.getParameterName(string2);
            stringBuffer = BeanGenerator.getDataType(cIMParameter.getType());
            vector2.removeAllElements();
            vector2.addElement(new JavaDocElement("@return", stringBuffer, I18N.loadStringFormat("ACCESSOR_RETURN_DESCRIPTION", string2)));
            stringBuffer2.append(BeanGenerator.getJavaDoc(BeanGenerator.format(I18N.loadString("METHODOUTPUT_ACCESSOR_JAVADOC"), string2, cIMMethod.getOriginClass(), cIMMethod.getName()), new StringBuffer(), vector2, 2));
            stringBuffer2.append(BeanGenerator.getSourceLine(BeanGenerator.format("public {0} get{1}() ", stringBuffer.toString(), string2) + "{\n" + "\n", 2));
            stringBuffer2.append(BeanGenerator.getSourceLine(BeanGenerator.format("return this.{0};\n", string3) + "\n", 3));
            stringBuffer2.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // get{0}\n", string2) + "\n", 2));
        }
        stringBuffer2.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // Class {0}\n", string) + "\n", 1));
        return stringBuffer2.append("\n");
    }

    private String getOutputParameters(CIMMethod cIMMethod) {
        String string = "";
        int n = 0;
        Enumeration enumeration = BeanGenerator.getOutParameters(cIMMethod).elements();
        while (enumeration.hasMoreElements()) {
            String string2;
            CIMParameter cIMParameter = (CIMParameter)enumeration.nextElement();
            StringBuffer stringBuffer = BeanGenerator.getDataType(cIMParameter.getType());
            if (BeanGenerator.isArrayType(stringBuffer)) {
                string2 = "({0}[])((Vector)(((CIMValue)(vOutParams.elementAt({1}))).getValue())).toArray(new {0}[0]), ";
                stringBuffer = new StringBuffer(stringBuffer.substring(0, stringBuffer.indexOf("[]")));
            } else {
                string2 = "({0})((CIMValue)(vOutParams.elementAt({1}))).getValue(), ";
            }
            string = string + BeanGenerator.format(string2, stringBuffer.toString(), Integer.toString(n));
            ++n;
        }
        return string.substring(0, string.lastIndexOf(","));
    }

    private String getOutputConstructorParameters(CIMMethod cIMMethod) {
        String string = "";
        Enumeration enumeration = BeanGenerator.getOutParameters(cIMMethod).elements();
        while (enumeration.hasMoreElements()) {
            CIMParameter cIMParameter = (CIMParameter)enumeration.nextElement();
            StringBuffer stringBuffer = BeanGenerator.getDataType(cIMParameter.getType());
            string = string + BeanGenerator.format("{0} {1}, ", stringBuffer.toString(), BeanGenerator.getParameterName(cIMParameter.getName()));
        }
        return string.substring(0, string.lastIndexOf(","));
    }

    private StringBuffer removeArraySuffix(StringBuffer stringBuffer) {
        int n = stringBuffer.indexOf("[]");
        if (n > 0) {
            stringBuffer = new StringBuffer(stringBuffer.substring(0, n));
        }
        return stringBuffer;
    }

    private String getBeanKeysParameters() {
        String string = "";
        Enumeration enumeration = this.vKeys.elements();
        while (enumeration.hasMoreElements()) {
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            string = string + BeanGenerator.format("{0} {1}, ", BeanGenerator.getDataType(cIMProperty.getType()).toString(), BeanGenerator.getParameterName(cIMProperty.getName()));
        }
        return string.substring(0, string.lastIndexOf(","));
    }

    private void addPropsToVector(Vector vector, Vector vector2) {
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            JavaDocElement javaDocElement = new JavaDocElement("@param", BeanGenerator.getDataType(cIMProperty.getType()), BeanGenerator.getPropertyDescription(cIMProperty).toString());
            vector.addElement(javaDocElement);
        }
    }

    private void addParamsToVector(Vector vector, Vector vector2) {
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            CIMParameter cIMParameter = (CIMParameter)enumeration.nextElement();
            JavaDocElement javaDocElement = new JavaDocElement("@param", BeanGenerator.getDataType(cIMParameter.getType()), I18N.loadStringFormat("INVOKEMETHOD_PARAM_DESCRIPTION", cIMParameter.getName()));
            vector.addElement(javaDocElement);
        }
    }
}

