/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.compiler.mib2mof;

import com.sun.wbem.compiler.mib2mof.ASTMib;
import com.sun.wbem.compiler.mib2mof.ASTNamedType;
import com.sun.wbem.compiler.mib2mof.ASTObjectTypeDefinition;
import com.sun.wbem.compiler.mib2mof.BeanGenerator;
import com.sun.wbem.compiler.mib2mof.Def;
import com.sun.wbem.compiler.mib2mof.Enumerated;
import com.sun.wbem.compiler.mib2mof.MessageHandler;
import com.sun.wbem.compiler.mib2mof.MibNode;
import com.sun.wbem.compiler.mib2mof.ResourceManager;
import com.sun.wbem.compiler.mib2mof.SyntaxMapper;
import com.sun.wbem.compiler.mib2mof.TableCimGenerator;
import com.sun.wbem.compiler.mib2mof.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMValue;

public class MofGenerator
extends BeanGenerator
implements Serializable {
    public static final String OID_PREFIX = "snmp:";
    public static final int OID_PREFIX_LEN = "snmp:".length();
    public static final String Q_KEY = "Key";
    public static final String Q_MAPPING_STRING = "MappingString";
    public static final String Q_PROPAGATED = "Propagated";
    public static final char INDEX_DELIM = ':';
    public static final char OID_DELIM = '.';
    private static final String PRAGMA_NAMESPACE = "#pragma namespace(\"root/snmp\")";
    protected String module = "";
    protected String translatedMibName = "";
    protected String className = "";
    protected CIMClass cim = null;
    protected CIMClass cimAssociation = null;
    protected String[] tableIndexNames = null;
    protected MibNode importedMibNode = null;
    protected Vector importedMibNodes = null;

    public MofGenerator(ResourceManager resourceManager, String string, String string2, String string3, MibNode mibNode, ASTMib aSTMib) throws IOException {
        super(resourceManager, string, string2, string3, mibNode, aSTMib);
        this.oid = this.node.getComputedOid();
        this.varName = this.node.getSymbolName();
        if (this.varName == null) {
            this.varName = this.getClassName(this.node.getComputedOid());
        }
        this.symboleName = string2 + this.varName;
        Trace.info(MessageHandler.getMessage("generate.info.var", this.varName));
        this.module = aSTMib.getModuleName();
        this.translatedMibName = this.translateMibName();
        this.className = Def.MOF_FILEPREFIX + this.translatedMibName + this.symboleName;
        this.out = this.openFile(this.className + Def.MOF);
        this.writeHeader();
        this.cim = new CIMClass(this.className);
        this.addCIMInfo(this.oid, this.className);
    }

    protected void writeClassDeclaration() throws IOException {
    }

    protected void writeHeader() throws IOException {
        this.write(MessageHandler.getMessage("generate.mof.comment.hdr.separator") + "\n");
        this.write(MessageHandler.getMessage("generate.mof.comment.hdr.title", this.className, this.translatedMibName) + "\n");
        this.write(MessageHandler.getMessage("generate.mof.comment.hdr.warning") + "\n");
        this.write(MessageHandler.getMessage("generate.mof.comment.hdr.separator") + "\n");
        this.write("\n#pragma namespace(\"root/snmp\")\n\n");
    }

    private void addCIMInfo(String string, String string2) {
        CIMQualifier cIMQualifier = new CIMQualifier(Def.MOF_QUAL_PROVIDER);
        CIMValue cIMValue = new CIMValue((Object)Def.MOF_PROVIDERPATH);
        cIMQualifier.setValue(cIMValue);
        this.cim.addQualifier(cIMQualifier);
        cIMQualifier = new CIMQualifier(Def.MOF_QUAL_MAPPINGSTRING);
        cIMValue = new CIMValue((Object)(Def.MOF_MAPPINGSNMP + string));
        cIMQualifier.setValue(cIMValue);
        this.cim.addQualifier(cIMQualifier);
        try {
            CIMProperty cIMProperty = new CIMProperty();
            cIMProperty.setName(Def.MOF_PROPERTY_SCCN);
            CIMProperty cIMProperty2 = new CIMProperty();
            cIMProperty2.setName(Def.MOF_PROPERTY_SN);
            CIMDataType cIMDataType = new CIMDataType(8);
            cIMProperty.setType(cIMDataType);
            cIMProperty2.setType(cIMDataType);
            cIMQualifier = new CIMQualifier(Def.MOF_QUAL_KEY);
            cIMProperty.addQualifier(cIMQualifier);
            cIMProperty2.addQualifier(cIMQualifier);
            cIMQualifier = new CIMQualifier(Def.MOF_QUAL_PROPAGATED);
            cIMValue = new CIMValue((Object)Def.MOF_PROPAGATED_SCCN);
            cIMQualifier.setValue(cIMValue);
            cIMProperty.addQualifier(cIMQualifier);
            cIMQualifier = new CIMQualifier(Def.MOF_QUAL_PROPAGATED);
            cIMValue = new CIMValue((Object)Def.MOF_PROPAGATED_SN);
            cIMQualifier.setValue(cIMValue);
            cIMProperty2.addQualifier(cIMQualifier);
            this.cim.addProperty(cIMProperty);
            this.cim.addProperty(cIMProperty2);
        }
        catch (CIMException cIMException) {
            System.out.println("Exception in addCIMInfo");
            System.out.println(cIMException.getMessage());
            return;
        }
        this.cimAssociation = this.createAssociation(string2);
    }

    private CIMClass createAssociation(String string) {
        CIMClass cIMClass = new CIMClass(string + "_" + Def.MOF_ASSOCNAME);
        cIMClass.setIsAssociation(true);
        CIMQualifier cIMQualifier = new CIMQualifier(Def.MOF_QUAL_ASSOCIATION);
        cIMClass.addQualifier(cIMQualifier);
        cIMQualifier = new CIMQualifier(Def.MOF_QUAL_PROVIDER);
        CIMValue cIMValue = new CIMValue((Object)Def.MOF_PROVIDERPATH);
        cIMQualifier.setValue(cIMValue);
        cIMClass.addQualifier(cIMQualifier);
        try {
            CIMProperty cIMProperty = new CIMProperty();
            cIMProperty.setName(Def.MOF_REF_SYSCONFIG);
            CIMDataType cIMDataType = new CIMDataType(Def.MOF_CIM_ASSOCNAME);
            cIMProperty.setType(cIMDataType);
            cIMQualifier = new CIMQualifier(Def.MOF_QUAL_KEY);
            cIMProperty.addQualifier(cIMQualifier);
            cIMClass.addProperty(cIMProperty);
            cIMProperty = new CIMProperty();
            cIMProperty.setName(Def.MOF_REF_MIB);
            cIMDataType = new CIMDataType(string);
            cIMProperty.setType(cIMDataType);
            cIMQualifier = new CIMQualifier(Def.MOF_QUAL_KEY);
            cIMProperty.addQualifier(cIMQualifier);
            cIMQualifier = new CIMQualifier(Def.MOF_QUAL_WEAK);
            cIMProperty.addQualifier(cIMQualifier);
            cIMClass.addProperty(cIMProperty);
        }
        catch (CIMException cIMException) {
            System.out.println("Exception in createAssociation");
            System.out.println(cIMException.getMessage());
            return null;
        }
        return cIMClass;
    }

    public String getSnmpClassName() {
        return this.symboleName;
    }

    public Vector orderCimProperties(CIMClass cIMClass) throws IOException {
        int n;
        CIMValue cIMValue;
        String string;
        String string2;
        CIMQualifier cIMQualifier;
        CIMQualifier cIMQualifier2;
        CIMProperty cIMProperty;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        vector = cIMClass.getProperties();
        int n2 = 2;
        while (n2 < vector.size()) {
            int n3;
            Integer n4;
            int n5;
            cIMProperty = (CIMProperty)vector.elementAt(n2);
            cIMQualifier2 = cIMProperty.getQualifier(Q_KEY);
            if (cIMQualifier2 != null && (cIMQualifier = cIMProperty.getQualifier(Q_MAPPING_STRING)) != null && n2 != (n5 = (n4 = new Integer(string2 = (string = (String)(cIMValue = cIMQualifier.getValue()).getValue()).substring((n = string.indexOf(58, OID_PREFIX_LEN + 1)) + 1, n3 = string.indexOf(58, n + 1)))).intValue()) + 1) {
                CIMProperty cIMProperty2 = (CIMProperty)vector.elementAt(n5 + 1);
                vector.setElementAt(cIMProperty, n5 + 1);
                vector.setElementAt(cIMProperty2, n2);
            }
            ++n2;
        }
        int n6 = 2;
        while (n6 < vector.size()) {
            cIMProperty = (CIMProperty)vector.elementAt(n6);
            cIMQualifier2 = cIMProperty.getQualifier(Q_KEY);
            if (cIMQualifier2 == null) break;
            cIMQualifier = cIMProperty.getQualifier(Q_MAPPING_STRING);
            if (cIMQualifier != null) {
                cIMValue = cIMQualifier.getValue();
                string = (String)cIMValue.getValue();
                n = string.indexOf(58, OID_PREFIX_LEN + 1);
                string2 = string.substring(0, n);
                CIMValue cIMValue2 = new CIMValue((Object)string2);
                cIMQualifier.setValue(cIMValue2);
                try {
                    cIMProperty.setQualifier(cIMQualifier);
                }
                catch (CIMException cIMException) {
                    // empty catch block
                }
            }
            ++n6;
        }
        return vector;
    }

    public void endOfGroup() throws IOException {
        if (this.importedMibNodes != null && this.importedMibNodes.size() > 0) {
            int n = 0;
            while (n < this.importedMibNodes.size()) {
                MibNode mibNode = (MibNode)this.importedMibNodes.elementAt(n);
                this.handleNode(mibNode);
                ++n;
            }
        }
        Vector vector = this.orderCimProperties(this.cim);
        this.cim.setProperties(vector);
        if (this.cim != null && this.cimAssociation != null) {
            this.write(this.cim.toMOF() + "\n\n" + this.cimAssociation.toMOF());
        }
        this.closeIO();
    }

    protected void handleNestedGroups(MibNode mibNode) throws IOException {
    }

    public void handleNode(MibNode mibNode) throws IOException {
        if (mibNode.isGroup() || mibNode.hasNestedGroups()) {
            this.handleNestedGroups(mibNode);
            return;
        }
        if (mibNode.isTable()) {
            this.handleTable(mibNode);
            return;
        }
        String string = mibNode.getSymbolName();
        ASTObjectTypeDefinition aSTObjectTypeDefinition = mibNode.getObjectType();
        if (aSTObjectTypeDefinition == null) {
            return;
        }
        ASTNamedType aSTNamedType = aSTObjectTypeDefinition.getSyntax();
        String string2 = "";
        String string3 = "";
        CIMQualifier cIMQualifier = null;
        CIMQualifier cIMQualifier2 = null;
        if (aSTNamedType.isEnumeratedType()) {
            String string4;
            String string5;
            Enumerated enumerated = aSTNamedType.getEnumeratedDef();
            string2 = aSTNamedType.getMofSyntax();
            Hashtable hashtable = enumerated.getEnum();
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string5 = (String)enumeration.nextElement();
                string4 = (String)hashtable.get(string5);
                vector.addElement(string4);
                vector2.addElement(string5);
            }
            string5 = new CIMValue(vector);
            string4 = new CIMValue(vector2);
            cIMQualifier = new CIMQualifier(Def.MOF_QUAL_VALUEMAP);
            cIMQualifier.setValue((CIMValue)string5);
            cIMQualifier2 = new CIMQualifier(Def.MOF_QUAL_VALUES);
            cIMQualifier2.setValue((CIMValue)string4);
            mibNode.setEnumerated(true);
            mibNode.setEnumeratedType(string2);
        } else {
            string2 = aSTNamedType.getMofSyntax();
        }
        string3 = aSTNamedType.getCimSnmpSyntax();
        long l = aSTNamedType.getFixedLength();
        mibNode.setFixedLength(l);
        this.addMofVar(mibNode, string2, string3, l, cIMQualifier, cIMQualifier2, string);
    }

    protected void handleTable(MibNode mibNode) throws IOException {
        TableCimGenerator tableCimGenerator = new TableCimGenerator(this.manager, this.packageName, this.prefix, this.targetDir, mibNode, this.mib);
    }

    protected void addMofVar(MibNode mibNode, String string, String string2, long l, CIMQualifier cIMQualifier, CIMQualifier cIMQualifier2, String string3) throws IOException {
        CIMQualifier cIMQualifier3 = null;
        CIMQualifier cIMQualifier4 = null;
        CIMQualifier cIMQualifier5 = null;
        CIMQualifier cIMQualifier6 = null;
        CIMQualifier cIMQualifier7 = new CIMQualifier(Def.MOF_QUAL_MAPPINGSTRING);
        CIMProperty cIMProperty = new CIMProperty();
        cIMProperty.setName(string3);
        CIMDataType cIMDataType = SyntaxMapper.getCimDataTypeSyntax(string);
        cIMProperty.setType(cIMDataType);
        CIMValue cIMValue = new CIMValue((Object)(Def.MOF_MAPPINGSNMP + mibNode.getOid()));
        cIMQualifier7.setValue(cIMValue);
        CIMValue cIMValue2 = new CIMValue((Object)string2);
        cIMQualifier4 = new CIMQualifier(Def.MOF_QUAL_SMI);
        cIMQualifier4.setValue(cIMValue2);
        ASTObjectTypeDefinition aSTObjectTypeDefinition = mibNode.getObjectType();
        int n = aSTObjectTypeDefinition.getDefinition().getAccess();
        if (n == 68 || n == 85 || n == 66) {
            cIMValue2 = new CIMValue((Object)new Boolean(true));
            cIMQualifier3 = new CIMQualifier(Def.MOF_QUAL_WRITE);
            cIMQualifier3.setValue(cIMValue2);
        } else {
            cIMValue2 = new CIMValue((Object)new Boolean(false));
            cIMQualifier3 = new CIMQualifier(Def.MOF_QUAL_WRITE);
            cIMQualifier3.setValue(cIMValue2);
        }
        String string4 = aSTObjectTypeDefinition.getDefinition().getMofDescription();
        if (this.mib.isDescriptionOn() && string4 != null) {
            cIMValue2 = new CIMValue((Object)string4);
            cIMQualifier5 = new CIMQualifier(Def.MOF_QUAL_DESCRIPTION);
            cIMQualifier5.setValue(cIMValue2);
        }
        if (this.tableIndexNames != null) {
            int n2 = 0;
            while (n2 < this.tableIndexNames.length) {
                if (string3.equals(this.tableIndexNames[n2])) {
                    cIMQualifier6 = new CIMQualifier(Def.MOF_QUAL_KEY);
                    cIMValue = new CIMValue((Object)(Def.MOF_MAPPINGSNMP + mibNode.getOid() + ":" + new Integer(n2 + 1) + ":"));
                    cIMQualifier7.setValue(cIMValue);
                    break;
                }
                ++n2;
            }
        }
        try {
            if (cIMQualifier6 != null) {
                cIMProperty.addQualifier(cIMQualifier6);
            }
            cIMProperty.addQualifier(cIMQualifier7);
            cIMProperty.addQualifier(cIMQualifier4);
            if (cIMQualifier3 != null) {
                cIMProperty.addQualifier(cIMQualifier3);
            }
            if (cIMQualifier != null && cIMQualifier2 != null) {
                cIMProperty.addQualifier(cIMQualifier);
                cIMProperty.addQualifier(cIMQualifier2);
            }
            if (cIMQualifier5 != null) {
                cIMProperty.addQualifier(cIMQualifier5);
            }
        }
        catch (CIMException cIMException) {
            return;
        }
        if (this.cim != null) {
            this.cim.addProperty(cIMProperty);
        }
    }

    private String translateMibName() throws IOException {
        String string = this.module.trim();
        string = string.replace('-', '_');
        string = string.replace('.', '_');
        string = string.replace(',', '_');
        string = string.replace(',', '_');
        string = string.replace(' ', '_');
        return string;
    }
}

