/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.apps.cimworkshop;

import com.sun.wbem.apps.cimworkshop.CIMTableTabbedPane;
import com.sun.wbem.apps.cimworkshop.QualifierWindow;
import com.sun.wbem.apps.common.ActionString;
import com.sun.wbem.apps.common.AdminDialog;
import com.sun.wbem.apps.common.CIMClientObject;
import com.sun.wbem.apps.common.CIMErrorDialog;
import com.sun.wbem.apps.common.ColumnLayout;
import com.sun.wbem.apps.common.ContextHelpListener;
import com.sun.wbem.apps.common.DefaultProperties;
import com.sun.wbem.apps.common.GenInfoPanel;
import com.sun.wbem.apps.common.I18N;
import com.sun.wbem.apps.common.LAYOUT_ALIGNMENT;
import com.sun.wbem.apps.common.TextFieldFocusListener;
import com.sun.wbem.apps.common.Util;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.client.CIMClient;

public class AddClassDialog
extends AdminDialog
implements DocumentListener,
ListSelectionListener {
    protected JButton btnOK;
    protected JButton btnCancel;
    protected GenInfoPanel infoPanel = this.getInfoPanel();
    protected JTextField classNameField;
    protected String className;
    private JButton btnAddProperty;
    private JButton btnDeleteProperty;
    private JButton btnPropertyQualifiers;
    private JButton btnClassQualifiers;
    private CIMTableTabbedPane tables;
    private CIMClass cimClass;
    private CIMClient cimClient;
    private int parentPropertyCount = 0;
    private JPopupMenu popupMenu;

    public AddClassDialog(Frame frame, String string) {
        super(frame, I18N.loadString("TTL_NEW_CLASS"), false);
        this.btnOK = this.getOKBtn();
        this.btnOK.addActionListener(new ButtonListener());
        this.btnCancel = this.getCancelBtn();
        this.btnCancel.addActionListener(new ButtonListener());
        JPanel jPanel = this.getRightPanel();
        String string2 = I18N.loadString("LBL_UNTITLED", "com.sun.wbem.apps.common.common");
        this.cimClient = CIMClientObject.getClient();
        this.cimClass = new CIMClass(string2);
        if (!string.equals("")) {
            this.cimClass.setSuperClass(string);
            this.copySuperClassElements(string);
        }
        this.classNameField = new JTextField(20);
        this.classNameField.addFocusListener(new TextFieldFocusListener());
        this.classNameField.getDocument().addDocumentListener(this);
        this.classNameField.setText(string2);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new ColumnLayout(LAYOUT_ALIGNMENT.EXPAND));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ActionString actionString = new ActionString("LBL_CLASS_NAME");
        JLabel jLabel = new JLabel(actionString.getString());
        jLabel.setDisplayedMnemonic(actionString.getMnemonic());
        jLabel.setLabelFor(this.classNameField);
        jPanel2.add(jLabel);
        jPanel2.add(this.classNameField);
        jPanel.add("North", jPanel2);
        this.tables = new CIMTableTabbedPane(true);
        this.tables.removeMethodsTab();
        this.tables.addListSelectionListener(this);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel3.add("Center", this.tables);
        this.setUpControls();
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createEmptyBorder(25, 5, 5, 5));
        jPanel4.setLayout(new ColumnLayout());
        jPanel4.add(this.btnAddProperty);
        jPanel4.add(this.btnDeleteProperty);
        jPanel4.add(this.btnPropertyQualifiers);
        jPanel4.add(this.btnClassQualifiers);
        jPanel3.add("East", jPanel4);
        jPanel.add("Center", jPanel3);
        this.populateTables(this.cimClass);
        this.setDefaultFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "NewClass_000.htm"), true);
        this.btnOK.addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "NewClass_000.htm"));
        this.btnCancel.addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "NewClass_000.htm"));
        this.classNameField.addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "NewClass_010.htm"));
        this.btnAddProperty.addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "NewClass_020.htm"));
        this.btnDeleteProperty.addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "NewClass_030.htm"));
        this.btnPropertyQualifiers.addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "NewClass_040.htm"));
        this.btnClassQualifiers.addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "NewClass_050.htm"));
        this.setOKEnabled();
        this.setSize(DefaultProperties.addClassDlgSize);
        Util.positionWindow(this, frame);
        this.setVisible(true);
    }

    private void setUpControls() {
        ActionString actionString = new ActionString("MNU_ADD_PROPERTY");
        ActionString actionString2 = new ActionString("MNU_DELETE_PROPERTY");
        ActionString actionString3 = new ActionString("MNU_PROPERTY_QUALIFIERS");
        ActionString actionString4 = new ActionString("MNU_CLASS_QUALIFIERS");
        this.btnAddProperty = new JButton(actionString.getString());
        this.btnAddProperty.setMnemonic(actionString.getMnemonic());
        this.btnAddProperty.addActionListener(this.tables.getPropertiesTable());
        this.btnAddProperty.setActionCommand("ADD_PROPERTY");
        this.btnAddProperty.setToolTipText(actionString.getString());
        this.btnAddProperty.setEnabled(true);
        this.btnDeleteProperty = new JButton(actionString2.getString());
        this.btnDeleteProperty.setMnemonic(actionString2.getMnemonic());
        this.btnDeleteProperty.addActionListener(this.tables.getPropertiesTable());
        this.btnDeleteProperty.setActionCommand("DELETE_PROPERTY");
        this.btnDeleteProperty.setToolTipText(actionString2.getString());
        this.btnDeleteProperty.setEnabled(false);
        this.btnPropertyQualifiers = new JButton(actionString3.getString());
        this.btnPropertyQualifiers.setMnemonic(actionString3.getMnemonic());
        this.btnPropertyQualifiers.addActionListener(this.tables.getPropertiesTable());
        this.btnPropertyQualifiers.setActionCommand("QUALIFIERS");
        this.btnPropertyQualifiers.setToolTipText(actionString3.getString());
        this.btnPropertyQualifiers.setEnabled(false);
        this.btnClassQualifiers = new JButton(actionString4.getString());
        this.btnClassQualifiers.setMnemonic(actionString4.getMnemonic());
        this.btnClassQualifiers.addActionListener(new ButtonListener());
        this.btnClassQualifiers.setToolTipText(actionString4.getString());
        this.btnClassQualifiers.setEnabled(true);
    }

    private void copySuperClassElements(String string) {
        try {
            Object object;
            Object object2;
            Object object3;
            CIMClass cIMClass = this.cimClient.getClass(new CIMObjectPath(string), false, true, true, null);
            Vector<Object> vector = new Vector<Object>();
            Vector vector2 = cIMClass.getProperties();
            if (vector2 != null) {
                object3 = vector2.elements();
                while (object3.hasMoreElements()) {
                    object2 = (CIMProperty)((CIMProperty)object3.nextElement()).clone();
                    if (object2.getOriginClass() == null) {
                        object2.setOriginClass(string);
                    }
                    vector.addElement(object2);
                }
            }
            this.cimClass.setProperties(vector);
            vector = new Vector();
            object3 = cIMClass.getQualifiers();
            if (object3 != null) {
                object2 = ((Vector)object3).elements();
                while (object2.hasMoreElements()) {
                    object = (CIMQualifier)((CIMQualifier)object2.nextElement()).clone();
                    vector.addElement(object);
                }
            }
            this.cimClass.setQualifiers(vector);
            vector = new Vector();
            object2 = cIMClass.getMethods();
            if (object2 != null) {
                object = ((Vector)object2).elements();
                while (object.hasMoreElements()) {
                    CIMMethod cIMMethod = (CIMMethod)((CIMMethod)object.nextElement()).clone();
                    vector.addElement(cIMMethod);
                }
            }
            this.cimClass.setMethods(vector);
        }
        catch (CIMException cIMException) {
            return;
        }
    }

    private void populateTables(CIMClass cIMClass) {
        this.tables.populateTables(this.cimClient, (CIMElement)cIMClass);
        this.parentPropertyCount = this.tables.getProperties().size();
        this.btnDeleteProperty.setEnabled(false);
        Vector<Integer> vector = new Vector<Integer>();
        int n = 0;
        while (n < this.parentPropertyCount) {
            vector.addElement(new Integer(n));
            ++n;
        }
        this.tables.setUneditableProperties(vector);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.btnPropertyQualifiers.setEnabled(true);
        int n = this.tables.getPropertiesTable().getSelectedRow();
        boolean bl = n > this.parentPropertyCount - 1;
        this.btnDeleteProperty.setEnabled(bl);
    }

    private boolean saveValues() {
        boolean bl = true;
        Util.setWaitCursor(this);
        Vector vector = this.tables.getProperties();
        Vector vector2 = new Vector();
        int n = this.parentPropertyCount;
        while (n < vector.size()) {
            vector2.addElement(vector.elementAt(n));
            ++n;
        }
        if (vector.size() > 0) {
            this.cimClass.setProperties(vector2);
        }
        this.cimClass.setName(this.className);
        try {
            this.cimClient.createClass(new CIMObjectPath(this.className), this.cimClass);
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("CIM_ERR_INVALID_PARAMETER")) {
                JOptionPane.showMessageDialog(null, Util.wrapText(I18N.loadString("MSG_INVALID_CLASS_NAME")), I18N.loadString("TTL_CIM_ERROR"), 0);
            } else {
                CIMErrorDialog.display(this, cIMException);
            }
            bl = false;
        }
        Util.setDefaultCursor(this);
        return bl;
    }

    public String getClassName() {
        return this.className;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.setOKEnabled();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.setOKEnabled();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.setOKEnabled();
    }

    public void setOKEnabled() {
        this.btnOK.setEnabled(this.classNameField.getText().trim().length() != 0);
    }

    public void windowOpened(WindowEvent windowEvent) {
        this.classNameField.requestFocus();
    }

    public void focusGained(FocusEvent focusEvent) {
        JTextField jTextField;
        if (focusEvent.getComponent() instanceof JTextField && (jTextField = (JTextField)focusEvent.getComponent()).isEditable() && jTextField.getText().length() > 0) {
            jTextField.setCaretPosition(jTextField.getText().length());
            jTextField.selectAll();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getComponent() instanceof JTextField) {
            JTextField jTextField = (JTextField)focusEvent.getComponent();
            jTextField.select(0, 0);
        }
    }

    public boolean verifyClassName() {
        String string;
        String string2 = this.classNameField.getText().trim();
        if (string2.equals(string = I18N.loadString("LBL_UNTITLED", "com.sun.wbem.apps.common.common"))) {
            JOptionPane.showMessageDialog(null, I18N.loadStringFormat("ERR_CHANGE_CLASSNAME", string), I18N.loadString("TTL_CIM_ERROR"), 0);
            return false;
        }
        this.className = string2;
        return true;
    }

    public void okClicked() {
        if (!this.verifyClassName()) {
            return;
        }
        if (this.saveValues()) {
            this.dispose();
        }
    }

    public void cancelClicked() {
        this.className = null;
        this.dispose();
    }

    public void classQualifiersClicked() {
        this.cimClass.setName(this.classNameField.getText().trim());
        QualifierWindow qualifierWindow = new QualifierWindow(Util.getFrame(this), this.cimClient, (CIMElement)this.cimClass, true);
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == AddClassDialog.this.btnCancel) {
                AddClassDialog.this.cancelClicked();
            } else if (actionEvent.getSource() == AddClassDialog.this.btnOK) {
                AddClassDialog.this.okClicked();
            } else if (actionEvent.getSource() == AddClassDialog.this.btnClassQualifiers) {
                AddClassDialog.this.classQualifiersClicked();
            }
        }
    }
}

