/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.wizards.cards;

import com.sun.admin.volmgr.client.Content;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.wizards.cards.SimpleVWizardCard;
import com.sun.admin.volmgr.common.Device;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ReviewCard
extends SimpleVWizardCard {
    public static final int NAME_INDEX = 0;
    public static final int DISKSET_INDEX = 1;
    public static final int DEVICES_INDEX = 2;
    public static final int COMMANDS_INDEX = 3;
    private static final int VISIBLE_ROWS = 5;
    protected String comment;
    protected JLabel nameValue;
    protected JLabel disksetValue;
    protected JList compValue;
    protected JTextArea cmdValue;

    public ReviewCard(String string, String string2, String string3, String string4) {
        super(string, string2, string3);
        this.comment = string4;
    }

    protected static JScrollPane getScrollPane(Component component) {
        JScrollPane jScrollPane = new JScrollPane(component, 20, 30);
        return jScrollPane;
    }

    protected LabeledComponent[] getLabeledComponents() {
        this.nameValue = new JLabel();
        this.disksetValue = new JLabel();
        this.compValue = new JList();
        this.compValue.setVisibleRowCount(5);
        this.cmdValue = new JTextArea();
        this.cmdValue.setRows(5);
        this.cmdValue.setEditable(false);
        JButton jButton = new JButton();
        Util.initButton(jButton, "ReviewCard_show_commands_label");
        final Runnable runnable = new Runnable(){

            public void run() {
                Content content = Util.getApp().getTree().getCurrentContent();
                content.showCommands();
            }
        };
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(runnable);
            }
        });
        JScrollPane jScrollPane = ReviewCard.getScrollPane(this.cmdValue);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jButton, gridBagConstraints);
        return new LabeledComponent[]{new LabeledComponent(this.getNameLabelResource(), this.nameValue), new LabeledComponent(this.getDiskSetLabelResource(), this.disksetValue), new LabeledComponent(this.getComponentsLabelResource(), ReviewCard.getScrollPane(this.compValue), true), new LabeledComponent(this.getCommandsLabelResource(), jPanel, true)};
    }

    protected String getDeviceName() {
        return null;
    }

    protected String getDeviceDiskSetName() {
        return null;
    }

    protected Device[] getDevices() {
        return new Device[0];
    }

    protected String[] getCommands() {
        return new String[0];
    }

    public String getNameLabelResource() {
        return "ReviewCard_name_label";
    }

    public String getDiskSetLabelResource() {
        return "ReviewCard_diskset_label";
    }

    public String getComponentsLabelResource() {
        return "ReviewCard_comp_label";
    }

    public String getCommandsLabelResource() {
        return "ReviewCard_cmd_label";
    }

    protected boolean executeCmds(String[] stringArray, String string) {
        if (stringArray == null) {
            return true;
        }
        return Util.executeCommands(stringArray, Util.getResourceString(string));
    }

    protected Component getMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(15, 15));
        jPanel.add(super.getMainPanel(), "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        LabeledComponent[] labeledComponentArray = this.getLabeledComponents();
        int n = 0;
        while (n < labeledComponentArray.length) {
            JLabel jLabel = new JLabel(Util.getResourceString(labeledComponentArray[n].resource));
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets.right = 10;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets.bottom = n == labeledComponentArray.length - 1 ? 0 : 10;
            jPanel2.add((Component)jLabel, gridBagConstraints);
            if (labeledComponentArray[n].stretch) {
                gridBagConstraints.fill = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
            } else {
                gridBagConstraints.fill = 0;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
            }
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets.right = 0;
            jPanel2.add(labeledComponentArray[n].component, gridBagConstraints);
            ++n;
        }
        jPanel.add((Component)jPanel2, "Center");
        return jPanel;
    }

    public void refresh() {
        this.nameValue.setText(this.getDeviceName());
        String string = this.getDeviceDiskSetName();
        if (string == null || string.equals("")) {
            string = Util.getResourceString("diskset_none");
        }
        this.disksetValue.setText(string);
        this.compValue.setListData(Util.getDeviceNameArray(this.getDevices()));
        String[] stringArray = this.getCommands();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            if (n != stringArray.length - 1) {
                stringBuffer.append('\n');
            }
            ++n;
        }
        this.cmdValue.setText(stringBuffer.toString());
        this.cmdValue.scrollRectToVisible(new Rectangle());
    }

    public boolean stop(boolean bl) {
        if (bl && this.finish()) {
            this.getWizard().cancelWizard();
        }
        return true;
    }

    public boolean finish() {
        return this.executeCmds(this.getCommands(), this.comment);
    }

    public static class LabeledComponent {
        public String resource;
        public Component component;
        public boolean stretch;

        public LabeledComponent(String string, Component component) {
            this(string, component, false);
        }

        public LabeledComponent(String string, Component component, boolean bl) {
            this.resource = string;
            this.component = component;
            this.stretch = bl;
        }
    }
}

