/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.wizards.cards;

import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.volmgr.client.util.HelpCache;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.wizards.command.ReplicaCommandFactory;
import com.sun.management.viper.console.gui.wizard.VWizardCard;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ReplicaLengthCard
extends VWizardCard {
    private ReplicaCommandFactory factory;
    private JTextField lengthText;
    private JTextField countText;

    public ReplicaLengthCard(ReplicaCommandFactory replicaCommandFactory) {
        this.factory = replicaCommandFactory;
        this.setTitle(Util.getResourceString("replica_add_wiz_length_title"));
        this.setHelpHTML(HelpCache.getHelpText("ReplicaLengthCard.html"));
        this.setLayout(new GridBagLayout());
        FlowArea flowArea = new FlowArea(Util.getResourceString("replica_add_wiz_length_header"));
        Constraints.constrain((Container)((Object)this), (Component)flowArea, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)5, (int)5, (int)5, (int)5);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Constraints.constrain((Container)((Object)this), (Component)jPanel, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        JLabel jLabel = new JLabel();
        Constraints.constrain((Container)jPanel, (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)10, (int)10, (int)0, (int)10);
        this.lengthText = new JTextField(25);
        Util.initLabel(jLabel, "replica_add_wiz_length_label", this.lengthText);
        this.lengthText.setMinimumSize(this.lengthText.getPreferredSize());
        this.lengthText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
                String string = ReplicaLengthCard.this.lengthText.getText().trim();
                if (!ReplicaLengthCard.this.isValidLength(string)) {
                    ReplicaLengthCard.this.refresh();
                    String string2 = Util.getResourceString("invalid_replica_length", string);
                    new ErrorDialog(null, string2);
                } else {
                    ReplicaLengthCard.this.lengthText.setText(string);
                    ReplicaLengthCard.this.factory.setLength(Integer.parseInt(string));
                }
            }

            public void focusGained(FocusEvent focusEvent) {
            }
        });
        Constraints.constrain((Container)jPanel, (Component)this.lengthText, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)10, (int)0, (int)0, (int)10);
        JLabel jLabel2 = new JLabel();
        Constraints.constrain((Container)jPanel, (Component)jLabel2, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)10, (int)10, (int)0, (int)10);
        this.countText = new JTextField(25);
        Util.initLabel(jLabel2, "replica_add_wiz_count_label", this.countText);
        this.countText.setMinimumSize(this.countText.getPreferredSize());
        this.countText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
                String string = ReplicaLengthCard.this.countText.getText().trim();
                if (!ReplicaLengthCard.this.isValidCount(string)) {
                    ReplicaLengthCard.this.refresh();
                    String string2 = Util.getResourceString("invalid_replica_count", string);
                    new ErrorDialog(null, string2);
                } else {
                    ReplicaLengthCard.this.countText.setText(string);
                    ReplicaLengthCard.this.factory.setCount(Integer.parseInt(string));
                }
            }

            public void focusGained(FocusEvent focusEvent) {
            }
        });
        Constraints.constrain((Container)jPanel, (Component)this.countText, (int)1, (int)1, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)10, (int)0, (int)0, (int)10);
    }

    public void refresh() {
        this.lengthText.setText(Long.toString(this.factory.getLength()));
        this.countText.setText(Integer.toString(this.factory.getCount()));
    }

    public void start() {
        this.setProperty("vwp.canmoveforward", "vwp.true");
        this.setProperty("vwp.canmovebackward", "vwp.true");
        this.setProperty("vwp.finishstate", "vwp.false");
        this.refresh();
    }

    public boolean stop(boolean bl) {
        long l = Long.parseLong(this.lengthText.getText());
        int n = Integer.parseInt(this.countText.getText());
        this.factory.setLength(l);
        this.factory.setCount(n);
        return true;
    }

    private boolean isValidLength(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        try {
            int n = Integer.parseInt(string);
            if ((long)n < 64L || (long)n > 8192L) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private boolean isValidCount(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        try {
            int n = Integer.parseInt(string);
            if (n < 1) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public void reset() {
    }

    public boolean isSubStep() {
        return false;
    }
}

