/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.wizards.cards;

import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.volmgr.client.DeviceTableSelectorManager;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.wizards.cards.SimpleVWizardCard;
import com.sun.admin.volmgr.common.Device;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

public abstract class MultiDeviceChooserCard
extends SimpleVWizardCard {
    private DeviceTableSelectorManager manager;
    private int minimumSelection;
    protected boolean haveMovedForward = false;

    public MultiDeviceChooserCard(String string, String string2, String string3) {
        this(string, string2, string3, 1);
    }

    public MultiDeviceChooserCard(String string, String string2, String string3, int n) {
        super(string, string2, string3);
        this.setMinimumSelection(n);
        this.manager = this.createManager();
    }

    protected DeviceTableSelectorManager getTableSelectorManager() {
        return this.manager;
    }

    protected void setMinimumSelection(int n) {
        this.minimumSelection = n;
    }

    public int getMinimumSelection() {
        return this.minimumSelection;
    }

    public synchronized void refresh() {
        if (this.haveMovedForward) {
            this.haveMovedForward = false;
        } else {
            Device[] deviceArray = this.getDevices();
            this.manager.setInItems(deviceArray);
            this.manager.setOutItems(null);
        }
    }

    public synchronized boolean stop(boolean bl) {
        if (!bl) {
            return true;
        }
        this.haveMovedForward = true;
        Device[] deviceArray = this.manager.getOutItems();
        int n = this.getMinimumSelection();
        if (deviceArray == null && n > 0 || deviceArray.length < n) {
            new ErrorDialog(null, Util.getResourceString("minimum_devices_not_selected", Integer.toString(n)));
            return false;
        }
        return this.setDevices(deviceArray);
    }

    protected Component getMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(15, 15));
        jPanel.add(super.getMainPanel(), "North");
        jPanel.add((Component)this.manager.getTableSelector(), "Center");
        return jPanel;
    }

    protected DeviceTableSelectorManager createManager() {
        return new DeviceTableSelectorManager(null, null);
    }

    protected abstract Device[] getDevices();

    protected abstract boolean setDevices(Device[] var1);
}

