/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.wizards.cards;

import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.volmgr.client.DeviceTable;
import com.sun.admin.volmgr.client.DeviceTableModel;
import com.sun.admin.volmgr.client.InterlacePanel;
import com.sun.admin.volmgr.client.ttk.table.TableRowUtil;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.wizards.cards.SimpleVWizardCard;
import com.sun.admin.volmgr.client.wizards.command.VolumeCommandFactory;
import com.sun.admin.volmgr.common.Device;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class InterlaceAndOrderCard
extends SimpleVWizardCard {
    private static final int SCROLLPANEHEIGHT = 250;
    private static String TITLE = "add_wiz_interlace_order_title";
    private static final String HELPFILE = "InterlaceAndOrderCard.html";
    private static String HEADER = "add_wiz_interlace_order_header";
    private VolumeCommandFactory factory;
    private InterlacePanel panel;
    private DeviceTable table;
    private DeviceTableModel model;

    public InterlaceAndOrderCard(VolumeCommandFactory volumeCommandFactory) {
        super(TITLE, HELPFILE, HEADER);
        this.factory = volumeCommandFactory;
        this.initGUI();
    }

    protected Component getMainPanel() {
        this.model = new DeviceTableModel(new Device[0]);
        this.table = new DeviceTable(this.model);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        Dimension dimension = jScrollPane.getPreferredSize();
        jScrollPane.setPreferredSize(new Dimension(dimension.width, 250));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(this.table.getBackground());
        jPanel.add(jScrollPane);
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(true);
        jScrollPane.setCorner("UPPER_LEFT_CORNER", jPanel2);
        jScrollPane.getViewport().setBackground(this.table.getBackground());
        JButton jButton = TableRowUtil.createMoveDownButton(this.table, this.model, true, true);
        Util.initButton(jButton, "button_move_down");
        JButton jButton2 = TableRowUtil.createMoveUpButton(this.table, this.model, true, true);
        Util.initButton(jButton2, "button_move_up");
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        jPanel3.add(jButton2);
        jPanel3.add(jButton);
        this.panel = new InterlacePanel();
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        jPanel4.add(super.getMainPanel(), gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.top = 15;
        jPanel4.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.anchor = 13;
        jPanel4.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.insets.top = 15;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)this.panel, gridBagConstraints);
        return jPanel4;
    }

    public void refresh() {
        Object[] objectArray = this.factory.getComponents();
        this.model.removeAllRows();
        this.model.addRows(objectArray);
        this.panel.setInterlaceInBlocks(this.factory.getInterlaceInBlocks());
    }

    public boolean stop(boolean bl) {
        if (!bl) {
            return true;
        }
        if (!this.panel.isValidInterlace()) {
            Util.DeviceSize deviceSize = Util.getSizeInGreatestUnits(16L, 1001);
            Util.DeviceSize deviceSize2 = Util.getSizeInGreatestUnits(204800L, 1001);
            Object[] objectArray = new Object[]{Util.getUnitText(deviceSize.size, deviceSize.units), Util.getUnitText(deviceSize2.size, deviceSize2.units)};
            String string = Util.getResourceString("invalid_interlace_value", objectArray);
            new ErrorDialog(null, string);
            return false;
        }
        this.factory.setInterlaceInBlocks(this.panel.getInterlaceInBlocks());
        Object[] objectArray = this.model.getAllRows();
        Device[] deviceArray = new Device[objectArray.length];
        System.arraycopy(objectArray, 0, deviceArray, 0, objectArray.length);
        this.factory.setComponents(deviceArray);
        return true;
    }
}

