/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.wizards.cards;

import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.wizards.cards.ReviewCard;
import com.sun.admin.volmgr.client.wizards.command.DiskSetCommandFactory;
import com.sun.admin.volmgr.common.Device;
import javax.swing.JLabel;
import javax.swing.JList;

public class DiskSetReviewCard
extends ReviewCard {
    private static String TITLE = "add_wiz_review_title";
    private static final String HELPFILE = "DiskSetReviewCard.html";
    private static String HEADER = "diskset_add_wiz_review_header";
    private DiskSetCommandFactory factory;
    private JList hostsValue;
    private JLabel lengthValue;

    public DiskSetReviewCard(DiskSetCommandFactory diskSetCommandFactory) {
        super(TITLE, HELPFILE, HEADER, null);
        this.factory = diskSetCommandFactory;
        this.initGUI();
    }

    public String[] getHosts() {
        return this.factory.getHosts();
    }

    public String getReplicaLength() {
        return Long.toString(this.factory.getReplicaLength());
    }

    protected String getDeviceName() {
        return this.factory.getDeviceName();
    }

    protected Device[] getDevices() {
        return this.factory.getDisks();
    }

    protected String[] getCommands() {
        return (String[])Util.getCombinedArray(new String[][]{this.factory.getCreateDiskSetCommands()});
    }

    protected ReviewCard.LabeledComponent[] getLabeledComponents() {
        ReviewCard.LabeledComponent[] labeledComponentArray = super.getLabeledComponents();
        this.hostsValue = new JList();
        this.hostsValue.setVisibleRowCount(3);
        this.lengthValue = new JLabel();
        return new ReviewCard.LabeledComponent[]{labeledComponentArray[0], labeledComponentArray[2], new ReviewCard.LabeledComponent("replica_add_wiz_review_length_label", this.lengthValue), new ReviewCard.LabeledComponent("diskset_add_wiz_review_hosts_label", ReviewCard.getScrollPane(this.hostsValue), true), labeledComponentArray[3]};
    }

    public void refresh() {
        super.refresh();
        this.hostsValue.setListData(this.getHosts());
        this.lengthValue.setText(this.getReplicaLength());
    }

    public boolean finish() {
        return this.executeCmds(this.factory.getCreateDiskSetCommands(), "diskset_add_cmd");
    }
}

