/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.volumes;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.volmgr.client.Content;
import com.sun.admin.volmgr.client.DeviceStatisticalInformation;
import com.sun.admin.volmgr.client.NavigationSelectionListener;
import com.sun.admin.volmgr.client.ServiceWrapper;
import com.sun.admin.volmgr.client.TreeNodeData;
import com.sun.admin.volmgr.client.VVolMgr;
import com.sun.admin.volmgr.client.util.GUIUtil;
import com.sun.admin.volmgr.client.util.HelpCache;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.volumes.ConfVolumePanel;
import com.sun.admin.volmgr.client.volumes.VMgrVolumesMenuBar;
import com.sun.admin.volmgr.client.volumes.VMgrVolumesTBar;
import com.sun.admin.volmgr.client.volumes.VolumeFilterControl;
import com.sun.admin.volmgr.client.wizards.MirrorResyncWizard;
import com.sun.admin.volmgr.client.wizards.RAIDResyncWizard;
import com.sun.admin.volmgr.client.wizards.RenameVolumeWizard;
import com.sun.admin.volmgr.client.wizards.SimpleVWizard;
import com.sun.admin.volmgr.common.Device;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VFilter;
import com.sun.management.viper.console.gui.VFrame;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.tree.MutableTreeNode;

public class VolumesContent
extends Content
implements PropertyChangeListener {
    private VFilter filterControl;
    private static String[][] columnHeaders = null;
    private String[][] detailsColumnHeaders;
    private String[][] perfColumnHeaders;
    private Hashtable deviceStats = new Hashtable();
    public static final int PERF_UNITS_OPS = 0;
    public static final int PERF_UNITS_KB = 1;
    public static final int PERF_TIMER_DELAY = 30;
    private boolean perfViewEnabled = false;
    private boolean perfViewSelected = false;
    private boolean perfViewPollingEnabled = false;
    private int perfViewMode = 0;
    private Timer perfViewTimer = null;
    private ActionListener perfViewTimerListener;
    private int perfViewTimerDelay = 30;
    private String perfViewModeKey;
    private String perfViewSelectedKey;
    private String perfViewPollingEnabledKey;
    private String perfViewTimerDelayKey;
    private boolean firstTime = true;
    private boolean stopped = false;

    public VolumesContent() {
        this.sortPreferencesKey = this.getClass().getName() + ".sortPreferences";
        this.perfViewModeKey = this.getClass().getName() + ".perfViewMode";
        this.perfViewSelectedKey = this.getClass().getName() + ".perfViewSelected";
        this.perfViewPollingEnabledKey = this.getClass().getName() + ".perfViewPollingEnabled";
        this.perfViewTimerDelayKey = this.getClass().getName() + ".perfViewTimerDelayKey";
        Object[][] objectArray = new Object[][]{{Util.getResourceString("type"), new Integer(8)}, {Util.getResourceString("Diskset"), new Integer(8)}, {Util.getResourceString("state"), new Integer(8)}, {Util.getResourceString("size"), new Integer(20012)}, {Util.getResourceString("usage"), new Integer(17)}, {Util.getResourceString("HSP"), new Integer(6)}};
        Object[][] objectArray2 = new Object[][]{{Util.getResourceString("view_totals"), new Integer(20008)}, {Util.getResourceString("view_reads"), new Integer(20008)}, {Util.getResourceString("view_writes"), new Integer(20008)}, {Util.getResourceString("view_wait_queue"), new Integer(20008)}, {Util.getResourceString("view_svc_time"), new Integer(20008)}, {Util.getResourceString("view_wait_pcnt"), new Integer(20008)}, {Util.getResourceString("view_load_pcnt"), new Integer(20008)}};
        this.detailsColumnHeaders = this.constructColumnHeaders(objectArray);
        this.perfColumnHeaders = this.constructColumnHeaders(objectArray2);
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)VMgrVolumesMenuBar.getMenuBar(this));
        this.rootNode.setToolBar((JToolBar)VMgrVolumesTBar.getToolBar(this));
        try {
            this.listProperties = new ListProperties();
            this.listProperties.setFilters(new Vector());
        }
        catch (AdminException adminException) {
            Util.getApp().reportErrorException((Exception)((Object)adminException));
        }
        this.perfViewTimerListener = new ActionListener(){

            public synchronized void actionPerformed(ActionEvent actionEvent) {
                VolumesContent.this.repaintColumns();
            }
        };
        final VMgrVolumesMenuBar vMgrVolumesMenuBar = VMgrVolumesMenuBar.getMenuBar(this);
        final VMgrVolumesTBar vMgrVolumesTBar = VMgrVolumesTBar.getToolBar(this);
        Util.getApp().addNavigationSelectionListener(new NavigationSelectionListener(){

            public void valueChanged(VScopeNode vScopeNode) {
                String string;
                String string2;
                String string3;
                Object object;
                Object object2;
                if (vScopeNode != null && vScopeNode.getPayload() instanceof TreeNodeData && (object2 = (TreeNodeData)vScopeNode.getPayload()) != null && !((object = ((TreeNodeData)object2).getContent()) instanceof VolumesContent)) {
                    return;
                }
                object2 = Util.getApp().getProperties();
                object = object2.getProperty("vconsole.iconstyle");
                if (((String)object).equals("details")) {
                    VolumesContent.this.perfViewEnabled = true;
                } else {
                    VolumesContent.this.perfViewEnabled = false;
                }
                String string4 = object2.getProperty(VolumesContent.this.perfViewSelectedKey);
                if (string4 != null) {
                    VolumesContent.this.perfViewSelected = new Boolean(string4);
                }
                if ((string3 = object2.getProperty(VolumesContent.this.perfViewPollingEnabledKey)) != null) {
                    VolumesContent.this.perfViewPollingEnabled = new Boolean(string3);
                }
                if ((string2 = object2.getProperty(VolumesContent.this.perfViewModeKey)) != null) {
                    try {
                        VolumesContent.this.perfViewMode = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((string = object2.getProperty(VolumesContent.this.perfViewTimerDelayKey)) != null) {
                    try {
                        VolumesContent.this.perfViewTimerDelay = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                vMgrVolumesMenuBar.setPerfViewItemState(VolumesContent.this.perfViewEnabled, VolumesContent.this.perfViewSelected);
                vMgrVolumesTBar.setUpdatePanelState(VolumesContent.this.perfViewEnabled, VolumesContent.this.perfViewSelected, VolumesContent.this.perfViewPollingEnabled, VolumesContent.this.perfViewMode, VolumesContent.this.perfViewTimerDelay);
                if (VolumesContent.this.firstTime) {
                    object2.addPropertyChangeListener((PropertyChangeListener)VolumesContent.this);
                    VolumesContent.this.firstTime = false;
                }
            }

            public void toolStopped() {
                VolumesContent.this.stopPerfTimer();
                VConsoleProperties vConsoleProperties = Util.getApp().getProperties();
                vConsoleProperties.setProperty(VolumesContent.this.perfViewSelectedKey, new Boolean(VolumesContent.this.perfViewSelected).toString());
                vConsoleProperties.setProperty(VolumesContent.this.perfViewPollingEnabledKey, new Boolean(VolumesContent.this.perfViewPollingEnabled).toString());
                vConsoleProperties.setProperty(VolumesContent.this.perfViewModeKey, Integer.toString(VolumesContent.this.perfViewMode));
                vConsoleProperties.setProperty(VolumesContent.this.perfViewTimerDelayKey, Integer.toString(VolumesContent.this.perfViewTimerDelay));
            }

            public void toolDestroyed() {
                this.toolStopped();
            }
        });
    }

    public String[][] getColumnHeaders() {
        if (this.perfViewSelected) {
            return this.perfColumnHeaders;
        }
        return this.detailsColumnHeaders;
    }

    public Hashtable getColumnValues(Device device) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (this.perfViewSelected) {
            String string = Util.getDeviceFullName(device);
            if (string == null) {
                return hashtable;
            }
            DeviceStatisticalInformation deviceStatisticalInformation = (DeviceStatisticalInformation)this.deviceStats.get(string);
            if (deviceStatisticalInformation == null) {
                deviceStatisticalInformation = new DeviceStatisticalInformation(string);
                this.deviceStats.put(string, deviceStatisticalInformation);
            } else {
                deviceStatisticalInformation.refresh();
            }
            if (this.perfViewMode == 0) {
                hashtable.put(Util.getResourceString("view_totals"), Util.formatDouble(deviceStatisticalInformation.totalOpsPerSecond));
                hashtable.put(Util.getResourceString("view_reads"), Util.formatDouble(deviceStatisticalInformation.readOpsPerSecond));
                hashtable.put(Util.getResourceString("view_writes"), Util.formatDouble(deviceStatisticalInformation.writeOpsPerSecond));
            } else {
                hashtable.put(Util.getResourceString("view_totals"), Util.formatDouble(deviceStatisticalInformation.totalKbytesPerSecond));
                hashtable.put(Util.getResourceString("view_reads"), Util.formatDouble(deviceStatisticalInformation.kbytesReadPerSecond));
                hashtable.put(Util.getResourceString("view_writes"), Util.formatDouble(deviceStatisticalInformation.kbytesWrittenPerSecond));
            }
            hashtable.put(Util.getResourceString("view_wait_queue"), Util.formatDouble(deviceStatisticalInformation.avgTransactionsWaiting));
            hashtable.put(Util.getResourceString("view_svc_time"), Util.formatDouble(deviceStatisticalInformation.avgServiceTimeInMS));
            hashtable.put(Util.getResourceString("view_wait_pcnt"), Util.formatDouble(deviceStatisticalInformation.pcntTimeTransactionWaiting));
            hashtable.put(Util.getResourceString("view_load_pcnt"), Util.formatDouble(deviceStatisticalInformation.pcntTimeTransactionRunning));
        } else {
            String string = Util.getResourceString((String)device.getProperty("type"));
            if (string == null) {
                string = "";
            }
            hashtable.put(Util.getResourceString("type"), string);
            String string2 = Util.getDisplayableDiskSetName(device);
            hashtable.put(Util.getResourceString("Diskset"), string2);
            hashtable.put(Util.getResourceString("state"), Util.formatProperty(device, "state"));
            hashtable.put(Util.getResourceString("size"), Util.getDeviceSizeWithUnits(device));
            hashtable.put(Util.getResourceString("usage"), Util.getDeviceUsage(device));
            String string3 = Util.getDisplayableHSPName(device);
            hashtable.put(Util.getResourceString("HSP"), string3);
        }
        return hashtable;
    }

    public Device[] getDevices() {
        ServiceWrapper serviceWrapper = Util.getApp().getServiceWrapper();
        ListProperties listProperties = this.getListProperties();
        ArrayList<Device> arrayList = new ArrayList<Device>();
        arrayList.addAll(serviceWrapper.getDevices("Trans", listProperties));
        arrayList.addAll(serviceWrapper.getDevices("Raid", listProperties));
        arrayList.addAll(serviceWrapper.getDevices("Mirror", listProperties));
        arrayList.addAll(serviceWrapper.getDevices("Concat", listProperties));
        Vector vector = serviceWrapper.getDevices("Stripe", listProperties);
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            Device device = (Device)vector.get(n);
            if (!Util.isInnerStripe(device)) {
                arrayList.add(device);
            }
            ++n;
        }
        arrayList.addAll(serviceWrapper.getDevices("SoftPartition", listProperties));
        return arrayList.toArray(new Device[arrayList.size()]);
    }

    public void deleteSelected() {
        String string;
        Object object;
        Object object2;
        Object object3;
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        int n = vector.size();
        final String[] stringArray = new String[n];
        final String[] stringArray2 = new String[n];
        int n2 = 0;
        int n3 = vector.size();
        while (n2 < n3) {
            object3 = (VScopeNode)vector.get(n2);
            object2 = (Device)object3.getPayload();
            object = Util.getDeviceBaseName((Device)object2);
            string = Util.getDiskSetFlag((Device)object2);
            stringArray[n2] = Util.getBasedir() + "usr/sbin/metaclear" + string + ' ' + (String)object;
            stringArray2[n2] = Util.getResourceString("volume_delete_cmd", object);
            ++n2;
        }
        object3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Util.executeCommands(stringArray, stringArray2);
            }
        };
        object2 = Util.getResourceString("sure_delete_volume");
        object = new ConfVolumePanel(stringArray, (String)object2);
        string = new String(Util.getResourceString("warning_delete_volume"));
        WarningDialog warningDialog = new WarningDialog(GUIUtil.getAppFrame(), string, (JPanel)object, (ActionListener)object3, Util.getResourceString("warning_delete"));
    }

    public String whatAmI() {
        return Util.getResourceString("volumes");
    }

    public void updateStatusBar() {
        String string = Util.getResourceString("VolumesListContents", new Integer(this.getDataCache().size()));
        Util.getApp().setStatusBar(string);
    }

    public boolean isFilteringSupported() {
        return true;
    }

    public synchronized VFilter getFilterControl() {
        if (this.isFilteringSupported() && this.filterControl == null) {
            this.filterControl = new VolumeFilterControl(this);
        }
        return this.filterControl;
    }

    public void appendToResultsPane(Device[] deviceArray) {
        Object object;
        Object object2;
        if (deviceArray.length == 0) {
            return;
        }
        ProgressPanel progressPanel = new ProgressPanel(GUIUtil.getAppFrame(), 2, 30, true, true);
        progressPanel.setTitle(Util.getResourceString("device_refresh_progress_title"));
        progressPanel.setRange(0, deviceArray.length);
        progressPanel.setVisible(true);
        progressPanel.setStopListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VolumesContent.this.stopped = true;
            }
        });
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        int n = 0;
        while (n < deviceArray.length) {
            if (this.stopped) {
                this.stopped = false;
                break;
            }
            object2 = Util.getDeviceFullName(deviceArray[n]);
            object = Util.getResourceString("volume_refresh_loading_device", object2);
            progressPanel.setText((String)object);
            progressPanel.setValue(n + 1);
            VMgrVolumesMenuBar vMgrVolumesMenuBar = VMgrVolumesMenuBar.getMenuBar(this);
            VScopeNode vScopeNode = new VScopeNode(null, null, null, null, null, vMgrVolumesMenuBar.getPopupMenu(), Util.getSmallIcon(deviceArray[n]), Util.getLargeIcon(deviceArray[n]), (String)object2, (String)object2, null, -1, (Object)deviceArray[n]);
            vScopeNode.setToolTipText(Util.getResourceString("tooltip_content_type") + " " + Util.getResourceString("Volume") + "  " + Util.getResourceString("tooltip_content_name") + " " + (String)object2);
            vScopeNode.setHTMLText(HelpCache.getHelpText(deviceArray[n]));
            vScopeNode.setColumnValues(this.getColumnValues(deviceArray[n]));
            this.rootNode.add((MutableTreeNode)vScopeNode);
            this.vDataCache.addElement(deviceArray[n]);
            ++n;
        }
        object2 = Util.getApp();
        object = new VConsoleEvent(object2, "vconsole.updatescope", (Object)this.getTreeNode());
        ((VVolMgr)object2).fireConsoleAction((VConsoleEvent)object);
        progressPanel.dispose();
    }

    public void clear(boolean bl) {
        this.clearSelection();
        this.getDataCache().removeAllElements();
        System.gc();
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)VMgrVolumesMenuBar.getMenuBar(this));
        this.rootNode.setToolBar((JToolBar)VMgrVolumesTBar.getToolBar(this));
        this.getTreeNode().setInternalRoot(this.rootNode);
        VVolMgr vVolMgr = Util.getApp();
        if (bl) {
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)vVolMgr, "vconsole.updatescope", (Object)this.treeNode);
            vVolMgr.fireConsoleAction(vConsoleEvent);
        }
        this.bRefresh = true;
    }

    public boolean isPerformanceViewSelected() {
        return this.perfViewSelected;
    }

    public void setPerformanceViewSelected(boolean bl) {
        this.perfViewSelected = bl;
        this.refresh(false);
        if (this.perfViewEnabled && bl && this.perfViewPollingEnabled) {
            this.startPerfTimer();
        } else {
            this.stopPerfTimer();
        }
        VMgrVolumesMenuBar.getMenuBar(this).setPerfViewItemState(this.perfViewEnabled, bl);
        VMgrVolumesTBar.getToolBar(this).setUpdatePanelState(this.perfViewEnabled, bl, this.perfViewPollingEnabled, this.perfViewMode, this.perfViewTimerDelay);
    }

    public int getPerformanceViewMode() {
        return this.perfViewMode;
    }

    public void setPerformanceViewMode(int n) {
        this.perfViewMode = n;
        this.refresh(false);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("vconsole.iconstyle")) {
            if (propertyChangeEvent.getNewValue().equals("details")) {
                this.perfViewEnabled = true;
            } else {
                this.perfViewEnabled = false;
                this.stopPerfTimer();
            }
            VMgrVolumesMenuBar.getMenuBar(this).setPerfViewItemState(this.perfViewEnabled, this.perfViewSelected);
            VMgrVolumesTBar.getToolBar(this).setUpdatePanelState(this.perfViewEnabled, this.perfViewSelected, this.perfViewPollingEnabled, this.perfViewMode, this.perfViewTimerDelay);
        }
    }

    public void stopPerfTimer() {
        if (this.perfViewTimer != null) {
            this.perfViewTimer.stop();
            this.perfViewTimer = null;
        }
    }

    public boolean isPerformanceViewPollingEnabled() {
        return this.perfViewPollingEnabled;
    }

    public void setPerformanceViewPollingEnabled(boolean bl) {
        this.perfViewPollingEnabled = bl;
        if (this.perfViewEnabled && this.perfViewSelected && bl) {
            this.startPerfTimer();
        } else {
            this.stopPerfTimer();
        }
    }

    public void startPerfTimer() {
        this.stopPerfTimer();
        this.perfViewTimer = new Timer(this.perfViewTimerDelay * 1000, this.perfViewTimerListener);
        this.perfViewTimer.start();
    }

    public int getPerfTimerDelay() {
        return this.perfViewTimerDelay;
    }

    public void setPerfTimerDelay(int n) {
        this.perfViewTimerDelay = n;
        if (this.perfViewEnabled && this.perfViewSelected && this.perfViewPollingEnabled) {
            this.startPerfTimer();
        }
    }

    public void refresh(boolean bl) {
        this.stopPerfTimer();
        super.refresh(bl);
        VMgrVolumesMenuBar.getMenuBar(this).clearRenameCache();
        if (this.perfViewSelected && this.perfViewPollingEnabled) {
            this.startPerfTimer();
        }
    }

    public void resync() {
        final Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        new Thread(){

            public void run() {
                SimpleVWizard simpleVWizard;
                VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
                Device device = (Device)vScopeNode.getPayload();
                Object object = device.getProperty("type");
                VFrame vFrame = new VFrame();
                ComponentListener componentListener = Util.makeModal(GUIUtil.getAppFrame(), (Window)vFrame, true);
                if ("Mirror".equals(object)) {
                    simpleVWizard = new MirrorResyncWizard(device);
                } else if ("Raid".equals(object)) {
                    simpleVWizard = new RAIDResyncWizard(device);
                } else {
                    componentListener.componentHidden(null);
                    return;
                }
                simpleVWizard.init();
                simpleVWizard.setContainer((Component)vFrame);
                vFrame.showCenter((Component)GUIUtil.getAppFrame());
                simpleVWizard.start();
            }
        }.start();
    }

    public void makeRoot() {
        Vector vector = this.getSelected();
        if (vector.size() != 1) {
            return;
        }
        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
        Device device = (Device)vScopeNode.getPayload();
        String string = Util.getDeviceBaseName(device);
        final String[] stringArray = new String[]{Util.getBasedir() + "usr/sbin/metaroot " + string};
        final String string2 = Util.getResourceString("mount_root_cmd", string);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Util.executeCommands(stringArray, string2);
            }
        };
        String string3 = Util.getResourceString("sure_mount_root");
        ConfVolumePanel confVolumePanel = new ConfVolumePanel(stringArray, string3);
        String string4 = new String(Util.getResourceString("warning_mount_root"));
        WarningDialog warningDialog = new WarningDialog(GUIUtil.getAppFrame(), string4, (JPanel)confVolumePanel, actionListener, Util.getResourceString("warning_mount"));
    }

    public void unMakeRoot() {
        Vector vector = this.getSelected();
        if (vector.isEmpty() || vector.size() > 1) {
            return;
        }
        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
        Device device = (Device)vScopeNode.getPayload();
        Object object = device.getProperty("type");
        Device device2 = null;
        if ("Mirror".equals(object)) {
            device2 = Util.getFirstUnderlyingSliceFromMirror(device);
        } else if ("Concat".equals(object) || "Stripe".equals(object)) {
            device2 = Util.getUnderlyingSliceFrom1x1Concat(device);
        } else {
            return;
        }
        String string = Util.getDeviceBaseName(device);
        if (device2 == null) {
            String string2 = "Mirror".equals(object) ? "VolumesContent_umetaroot_mirror_error" : "VolumesContent_umetaroot_concat_error";
            String string3 = Util.getResourceString(string2, string);
            new ErrorDialog(null, string3);
            return;
        }
        final String[] stringArray = new String[]{Util.getBasedir() + "usr/sbin/metaroot " + Util.getDeviceBaseName(device2)};
        final String string4 = Util.getResourceString("umount_root_cmd", string);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Util.executeCommands(stringArray, string4);
            }
        };
        String string5 = Util.getResourceString("sure_unmount_root");
        ConfVolumePanel confVolumePanel = new ConfVolumePanel(stringArray, string5);
        String string6 = Util.getResourceString("warning_unmount_root");
        WarningDialog warningDialog = new WarningDialog(GUIUtil.getAppFrame(), string6, (JPanel)confVolumePanel, actionListener, Util.getResourceString("warning_unmount"));
    }

    public void renameSelected() {
        final Vector vector = this.getSelected();
        if (vector.isEmpty() || vector.size() > 1) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                GUIUtil.waitOn();
                VFrame vFrame = new VFrame();
                VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
                Device device = (Device)vScopeNode.getPayload();
                RenameVolumeWizard renameVolumeWizard = new RenameVolumeWizard(device);
                renameVolumeWizard.init();
                renameVolumeWizard.setContainer((Component)vFrame);
                vFrame.showCenter((Component)GUIUtil.getAppFrame());
                renameVolumeWizard.start();
                GUIUtil.waitOff();
            }
        };
        thread.start();
    }
}

