/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.volumes;

import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.volmgr.client.DeviceTablePropertySheet;
import com.sun.admin.volmgr.client.util.GUIUtil;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.volumes.ConfVolumePanel;
import com.sun.admin.volmgr.client.wizards.AddTransLogWizard;
import com.sun.admin.volmgr.common.Device;
import com.sun.management.viper.console.gui.VFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;

public class TransLogPropertySheet
extends DeviceTablePropertySheet {
    private static final String TITLE = "log_props_tab";
    private static final String HELPFILE = "TransLogPropertySheet.html";
    private Device device;
    private String disksetFlag;
    private JButton attachButton;
    private JButton removeButton;

    public TransLogPropertySheet(Device device) {
        super(TITLE, HELPFILE);
        this.device = device;
        this.initGUI();
    }

    protected synchronized String getDiskSetFlag() {
        if (this.disksetFlag == null) {
            this.disksetFlag = Util.getDiskSetFlag(this.device);
        }
        return this.disksetFlag;
    }

    private void setButtonState() {
        boolean bl = false;
        boolean bl2 = false;
        if (Util.getApp().getServiceWrapper().hasVolMgrWriteAuth()) {
            if (this.table.getSelectedRows().length == 1) {
                bl2 = true;
            }
            if (this.table.getRowCount() == 0) {
                bl = true;
            }
        }
        this.attachButton.setEnabled(bl);
        this.removeButton.setEnabled(bl2);
    }

    private void attachComp() {
        new Thread(){

            public void run() {
                VFrame vFrame = new VFrame();
                Util.makeModal(GUIUtil.getParentJFrame((Component)((Object)TransLogPropertySheet.this)), (Window)vFrame, true);
                AddTransLogWizard addTransLogWizard = new AddTransLogWizard(TransLogPropertySheet.this.device);
                addTransLogWizard.init();
                addTransLogWizard.setContainer((Component)vFrame);
                vFrame.showCenter((Component)GUIUtil.getAppFrame());
                addTransLogWizard.start();
            }
        }.start();
    }

    private void removeComp() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length != 1) {
            return;
        }
        String string = Util.getDeviceBaseName(this.device);
        Device device = (Device)this.model.getRow(nArray[0]);
        String string2 = Util.getDeviceBaseName(device);
        String[] stringArray = new String[]{Util.getResourceString("detach_log_cmd", string2)};
        String[] stringArray2 = new String[]{Util.getBasedir() + "usr/sbin/metadetach" + this.getDiskSetFlag() + " -f " + string};
        ActionListener actionListener = Util.getConfirmListener(stringArray, stringArray2);
        String string3 = Util.getResourceString("sure_detach_log");
        ConfVolumePanel confVolumePanel = new ConfVolumePanel(stringArray2, string3);
        String string4 = new String(Util.getResourceString("warning_detach_log"));
        WarningDialog warningDialog = new WarningDialog(GUIUtil.getParentJFrame((Component)((Object)this)), string4, (JPanel)confVolumePanel, actionListener, Util.getResourceString("warning_detach"));
    }

    protected Device[] getDevices() {
        Vector vector = Util.getApp().getServiceWrapper().getAntecedents(this.device, "TransLogOn");
        return vector.toArray(new Device[vector.size()]);
    }

    public void tableSelectionChanged(ListSelectionEvent listSelectionEvent) {
        this.setButtonState();
    }

    protected Component getMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        this.attachButton = new JButton();
        this.attachButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TransLogPropertySheet.this.attachComp();
            }
        });
        Util.initButton(this.attachButton, "attach_log");
        jPanel.add(this.attachButton);
        this.removeButton = new JButton();
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TransLogPropertySheet.this.removeComp();
            }
        });
        Util.initButton(this.removeButton, "remove_log");
        jPanel.add(this.removeButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add(super.getMainPanel(), "Center");
        jPanel2.add((Component)jPanel, "South");
        return jPanel2;
    }

    protected void refresh() {
        super.refresh();
        this.setButtonState();
    }
}

