/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.ttk.table;

import com.sun.admin.volmgr.client.ttk.MouseHeldWrapper;
import com.sun.admin.volmgr.client.ttk.event.MouseHeldEvent;
import com.sun.admin.volmgr.client.ttk.event.MouseHeldListener;
import com.sun.admin.volmgr.client.ttk.icon.ArrowIcon;
import com.sun.admin.volmgr.client.ttk.table.RowGroup;
import com.sun.admin.volmgr.client.ttk.table.RowGroupable;
import com.sun.admin.volmgr.client.ttk.table.RowMoveable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class TableRowUtil {
    public static void addRowMoveUpListeners(AbstractButton abstractButton, JTable jTable, RowMoveable rowMoveable, boolean bl, boolean bl2) {
        TableRowUtil.addRowMoveListeners(abstractButton, jTable, rowMoveable, -1, bl, bl2);
    }

    public static void addRowMoveDownListeners(AbstractButton abstractButton, JTable jTable, RowMoveable rowMoveable, boolean bl, boolean bl2) {
        TableRowUtil.addRowMoveListeners(abstractButton, jTable, rowMoveable, 1, bl, bl2);
    }

    private static void addRowMoveListeners(final AbstractButton abstractButton, final JTable jTable, final RowMoveable rowMoveable, final int n, boolean bl, final boolean bl2) {
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                boolean bl = false;
                int[] nArray = jTable.getSelectedRows();
                if (nArray.length != 0) {
                    int[][] nArray2 = TableRowUtil.getContiguousSections(nArray);
                    bl = true;
                    int n2 = 0;
                    while (n2 < nArray2.length) {
                        nArray = nArray2[n2];
                        bl = n > 0 ? rowMoveable.canMoveRowsDown(nArray[0], nArray[nArray.length - 1]) : rowMoveable.canMoveRowsUp(nArray[0], nArray[nArray.length - 1]);
                        if (!bl) break;
                        ++n2;
                    }
                }
                abstractButton.setEnabled(bl);
            }
        };
        listSelectionListener.valueChanged(new ListSelectionEvent(jTable, 0, 0, false));
        jTable.getSelectionModel().addListSelectionListener(listSelectionListener);
        final Runnable runnable = new Runnable(){

            public void run() {
                int[] nArray = jTable.getSelectedRows();
                if (nArray.length != 0) {
                    int n6;
                    int n2;
                    int[][] nArray2 = TableRowUtil.getContiguousSections(nArray);
                    int n3 = 0;
                    while (n3 < nArray2.length) {
                        if (n > 0) {
                            nArray = nArray2[nArray2.length - 1 - n3];
                            n2 = nArray.length - 1;
                            n6 = rowMoveable.moveRowsDown(nArray[0], nArray[n2]) ? 1 : 0;
                        } else {
                            nArray = nArray2[n3];
                            n2 = nArray.length - 1;
                            n6 = rowMoveable.moveRowsUp(nArray[0], nArray[n2]) ? 1 : 0;
                        }
                        if (n6 == 0) break;
                        nArray[0] = nArray[0] + n;
                        int n4 = n2;
                        nArray[n4] = nArray[n4] + n;
                        ++n3;
                    }
                    if (bl2) {
                        n6 = 0;
                        while (n6 < nArray2.length) {
                            nArray = nArray2[n6];
                            n2 = nArray[0];
                            int n5 = nArray[nArray.length - 1];
                            if (n6 == 0) {
                                jTable.setRowSelectionInterval(n2, n5);
                            } else {
                                jTable.addRowSelectionInterval(n2, n5);
                            }
                            ++n6;
                        }
                        if (n > 0) {
                            nArray = nArray2[nArray2.length - 1];
                            n2 = nArray[nArray.length - 1];
                        } else {
                            n2 = nArray2[0][0];
                        }
                        jTable.scrollRectToVisible(jTable.getCellRect(n2, 0, true));
                    }
                }
            }
        };
        if (bl) {
            MouseHeldWrapper mouseHeldWrapper = new MouseHeldWrapper(abstractButton);
            mouseHeldWrapper.addMouseHeldListener(new MouseHeldListener(){

                public void mouseHeld(MouseHeldEvent mouseHeldEvent) {
                    runnable.run();
                }
            });
        } else {
            abstractButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    runnable.run();
                }
            });
        }
    }

    public static void addMoveAllRowsUpListeners(AbstractButton abstractButton, JTable jTable, RowMoveable rowMoveable) {
        TableRowUtil.addMoveAllRowsListeners(abstractButton, jTable, rowMoveable, true);
    }

    public static void addMoveAllRowsDownListeners(AbstractButton abstractButton, JTable jTable, RowMoveable rowMoveable) {
        TableRowUtil.addMoveAllRowsListeners(abstractButton, jTable, rowMoveable, false);
    }

    private static void addMoveAllRowsListeners(final AbstractButton abstractButton, final JTable jTable, final RowMoveable rowMoveable, final boolean bl) {
        TableModelListener tableModelListener = new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                abstractButton.setEnabled(jTable.getRowCount() != 0);
            }
        };
        TableModel tableModel = jTable.getModel();
        tableModelListener.tableChanged(new TableModelEvent(tableModel));
        tableModel.addTableModelListener(tableModelListener);
        abstractButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = jTable.getRowCount();
                if (bl) {
                    rowMoveable.moveRowsUp(0, n - 1);
                } else {
                    rowMoveable.moveRowsDown(0, n - 1);
                }
            }
        });
    }

    public static JButton createMoveUpButton(JTable jTable, RowMoveable rowMoveable, boolean bl, boolean bl2) {
        ArrowIcon arrowIcon = new ArrowIcon(1);
        ArrowIcon arrowIcon2 = new ArrowIcon(1);
        arrowIcon2.setEnabled(false);
        JButton jButton = new JButton(arrowIcon);
        jButton.setDisabledIcon(arrowIcon2);
        TableRowUtil.addRowMoveUpListeners(jButton, jTable, rowMoveable, bl, bl2);
        return jButton;
    }

    public static JButton createMoveAllUpButton(JTable jTable, RowMoveable rowMoveable) {
        ArrowIcon arrowIcon = new ArrowIcon(1);
        ArrowIcon arrowIcon2 = new ArrowIcon(1);
        arrowIcon2.setEnabled(false);
        JButton jButton = new JButton(arrowIcon);
        jButton.setDisabledIcon(arrowIcon2);
        TableRowUtil.addMoveAllRowsUpListeners(jButton, jTable, rowMoveable);
        return jButton;
    }

    public static JButton createMoveDownButton(JTable jTable, RowMoveable rowMoveable, boolean bl, boolean bl2) {
        ArrowIcon arrowIcon = new ArrowIcon(5);
        ArrowIcon arrowIcon2 = new ArrowIcon(5);
        arrowIcon2.setEnabled(false);
        JButton jButton = new JButton(arrowIcon);
        jButton.setDisabledIcon(arrowIcon2);
        TableRowUtil.addRowMoveDownListeners(jButton, jTable, rowMoveable, bl, bl2);
        return jButton;
    }

    public static JButton createMoveAllDownButton(JTable jTable, RowMoveable rowMoveable) {
        ArrowIcon arrowIcon = new ArrowIcon(5);
        ArrowIcon arrowIcon2 = new ArrowIcon(5);
        arrowIcon2.setEnabled(false);
        JButton jButton = new JButton(arrowIcon);
        jButton.setDisabledIcon(arrowIcon2);
        TableRowUtil.addMoveAllRowsDownListeners(jButton, jTable, rowMoveable);
        return jButton;
    }

    private static void addUngroupRowListeners(final AbstractButton abstractButton, final JTable jTable, final RowGroupable rowGroupable) {
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                boolean bl = false;
                int[] nArray = jTable.getSelectedRows();
                int n = nArray.length;
                if (n > 0) {
                    Arrays.sort(nArray);
                    int n2 = 0;
                    while (n2 < n) {
                        if (rowGroupable.getRowGroup(nArray[n2]) != null) {
                            bl = true;
                            break;
                        }
                        ++n2;
                    }
                }
                abstractButton.setEnabled(bl);
            }
        };
        listSelectionListener.valueChanged(new ListSelectionEvent(jTable, 0, 0, false));
        jTable.getSelectionModel().addListSelectionListener(listSelectionListener);
        abstractButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = jTable.getSelectedRows();
                if (nArray.length != 0) {
                    int n;
                    int[][] nArray2 = TableRowUtil.getContiguousSections(nArray);
                    int n2 = 0;
                    while (n2 < nArray2.length) {
                        int[] nArray3 = nArray2[n2];
                        int n3 = nArray3[0];
                        n = nArray3[nArray3.length - 1];
                        rowGroupable.ungroup(n3, n);
                        ++n2;
                    }
                    int n4 = 0;
                    while (n4 < nArray2.length) {
                        int[] nArray4 = nArray2[n4];
                        n = nArray4[0];
                        int n5 = nArray4[nArray4.length - 1];
                        jTable.getSelectionModel().addSelectionInterval(n, n5);
                        ++n4;
                    }
                }
            }
        });
    }

    private static void addGroupRowListeners(final AbstractButton abstractButton, final JTable jTable, final RowGroupable rowGroupable, RowMoveable rowMoveable) {
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                boolean bl = false;
                int[] nArray = jTable.getSelectedRows();
                int n = nArray.length;
                if (n >= 2) {
                    Arrays.sort(nArray);
                    if (nArray[0] == nArray[n - 1] - n + 1) {
                        RowGroup rowGroup = rowGroupable.getRowGroup(nArray[0]);
                        RowGroup rowGroup2 = rowGroupable.getRowGroup(nArray[n - 1]);
                        if (rowGroup == null || rowGroup != rowGroup2 || rowGroup.getFirstRow() != nArray[0] || rowGroup2.getLastRow() != nArray[n - 1]) {
                            bl = true;
                        }
                    }
                }
                abstractButton.setEnabled(bl);
            }
        };
        listSelectionListener.valueChanged(new ListSelectionEvent(jTable, 0, 0, false));
        jTable.getSelectionModel().addListSelectionListener(listSelectionListener);
        abstractButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = jTable.getSelectedRows();
                int n = nArray.length;
                if (nArray.length != 0) {
                    Arrays.sort(nArray);
                    if (nArray[0] != nArray[n - 1] - n + 1) {
                        return;
                    }
                    int n2 = nArray[0];
                    int n3 = nArray[nArray.length - 1];
                    rowGroupable.ungroup(n2, n3);
                    rowGroupable.group(n2, n3);
                    jTable.setRowSelectionInterval(n2, n3);
                }
            }
        });
    }

    public static JButton createGroupButton(JTable jTable, RowGroupable rowGroupable, RowMoveable rowMoveable) {
        JButton jButton = new JButton();
        TableRowUtil.addGroupRowListeners(jButton, jTable, rowGroupable, rowMoveable);
        return jButton;
    }

    public static JButton createUngroupButton(JTable jTable, RowGroupable rowGroupable) {
        JButton jButton = new JButton();
        TableRowUtil.addUngroupRowListeners(jButton, jTable, rowGroupable);
        return jButton;
    }

    private static int[][] getContiguousSections(int[] nArray) {
        Object object;
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        Arrays.sort(nArray2);
        ArrayList<int[][]> arrayList = new ArrayList<int[][]>();
        int n = nArray2[0];
        int n2 = 1;
        while (n2 <= nArray2.length) {
            int n3 = nArray2[n2 - 1];
            if (n2 == nArray2.length || nArray2[n2] != n3 + 1) {
                object = new int[]{n, n3};
                arrayList.add((int[][])object);
                if (n2 != nArray2.length) {
                    n = nArray2[n2];
                }
            }
            ++n2;
        }
        object = new int[arrayList.size()][];
        int n4 = 0;
        while (n4 < ((int[][])object).length) {
            object[n4] = (int[])arrayList.get(n4);
            ++n4;
        }
        return object;
    }
}

