/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.ttk.table;

import com.sun.admin.volmgr.client.ttk.table.RowGroup;
import com.sun.admin.volmgr.client.ttk.table.RowGroupable;
import com.sun.admin.volmgr.client.ttk.table.TableRowHeaderConstraints;
import com.sun.admin.volmgr.client.ttk.table.TableRowHeaderLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public abstract class RowHeaderManager {
    private static final int _SPACING = 0;
    private JTable table;
    private JPanel header;
    private JPanel inner;
    private TableRowHeaderLayout layout;
    private RowGroupable groupable;
    private Hashtable hash = new Hashtable();
    private int spacing;

    public RowHeaderManager(JTable jTable, RowGroupable rowGroupable) {
        this(jTable, rowGroupable, 0);
    }

    public RowHeaderManager(JTable jTable, RowGroupable rowGroupable, int n) {
        this.table = jTable;
        this.groupable = rowGroupable;
        this.spacing = n;
        this.init();
        this.update();
    }

    public JPanel getHeader() {
        return this.header;
    }

    public JPanel getInnerPanel() {
        return this.inner;
    }

    public JTable getTable() {
        return this.table;
    }

    public RowGroupable getRowGroupable() {
        return this.groupable;
    }

    private void init() {
        this.inner = new JPanel();
        this.layout = new TableRowHeaderLayout(this.table, this.spacing);
        this.inner.setLayout(this.layout);
        this.inner.setBorder(new CompoundBorder(new BevelBorder(0), new EmptyBorder(0, 15, 0, 0)));
        this.header = new JPanel();
        this.header.setLayout(new BorderLayout());
        this.header.add((Component)this.inner, "Center");
    }

    private void revalidate(final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                RowHeaderManager.this.inner.invalidate();
                RowHeaderManager.this.inner.validate();
                if (bl) {
                    RowHeaderManager.this.inner.repaint();
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public synchronized void update() {
        Object object;
        Object object2;
        HashSet hashSet = new HashSet(this.hash.keySet());
        RowGroupable rowGroupable = this.getRowGroupable();
        RowGroup[] rowGroupArray = rowGroupable.getAllRowGroups();
        int n = 0;
        while (n < rowGroupArray.length) {
            Object object3;
            TableRowHeaderConstraints tableRowHeaderConstraints;
            object2 = rowGroupArray[n];
            object = (ComponentProps)this.hash.get(object2);
            hashSet.remove(object2);
            int n2 = object2.getFirstRow();
            int n3 = object2.getLastRow();
            if (object == null) {
                tableRowHeaderConstraints = new TableRowHeaderConstraints();
                tableRowHeaderConstraints.setRowGroup((RowGroup)object2);
                object3 = this.getRowHeaderComponent((RowGroup)object2);
                this.inner.add((Component)object3, tableRowHeaderConstraints);
                object = new ComponentProps();
                ((ComponentProps)object).component = object3;
                ((ComponentProps)object).constraints = tableRowHeaderConstraints;
                this.hash.put(object2, object);
            } else {
                tableRowHeaderConstraints = ((ComponentProps)object).constraints;
                object3 = tableRowHeaderConstraints.getRowGroup();
                if (n2 != object3.getFirstRow() || n3 != object3.getLastRow()) {
                    tableRowHeaderConstraints.setRowGroup((RowGroup)object2);
                    this.layout.setConstraints(((ComponentProps)object).component, tableRowHeaderConstraints);
                }
            }
            ++n;
        }
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            ComponentProps componentProps = (ComponentProps)this.hash.get(object);
            this.inner.remove(componentProps.component);
            this.hash.remove(object);
        }
        this.revalidate(hashSet.size() > 0);
    }

    protected void toggleSelection(Component component) {
        TableRowHeaderConstraints tableRowHeaderConstraints = this.layout.getConstraints(component);
        if (tableRowHeaderConstraints == null) {
            throw new IllegalArgumentException("Invalid row header Component");
        }
        RowGroup rowGroup = tableRowHeaderConstraints.getRowGroup();
        int n = rowGroup.getFirstRow();
        int n2 = rowGroup.getLastRow();
        boolean bl = false;
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == n2 - n + 1) {
            Arrays.sort(nArray);
            if (nArray[0] == n && nArray[nArray.length - 1] == n2) {
                bl = true;
            }
        }
        if (bl) {
            this.table.clearSelection();
        } else {
            this.table.setRowSelectionInterval(n, n2);
        }
    }

    protected abstract Component getRowHeaderComponent(RowGroup var1);

    private static class ComponentProps {
        public Component component;
        public TableRowHeaderConstraints constraints;

        private ComponentProps() {
        }
    }
}

