/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.ttk.table;

import com.sun.admin.volmgr.client.ttk.table.EditableRowGroup;
import com.sun.admin.volmgr.client.ttk.table.RowAddable;
import com.sun.admin.volmgr.client.ttk.table.RowGettable;
import com.sun.admin.volmgr.client.ttk.table.RowGroup;
import com.sun.admin.volmgr.client.ttk.table.RowGroupable;
import com.sun.admin.volmgr.client.ttk.table.RowMoveable;
import com.sun.admin.volmgr.client.ttk.table.RowRemovable;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public abstract class GroupableTableModel
extends AbstractTableModel
implements RowGettable,
RowAddable,
RowRemovable,
RowMoveable,
RowGroupable {
    private static boolean BLOCKMOVE = true;
    protected Vector data = new Vector();
    protected String[] columNames;

    public GroupableTableModel(Object[] objectArray) {
        this.addRows(objectArray);
    }

    public GroupableTableModel(Object[] objectArray, String[] stringArray) {
        this(objectArray);
        this.columNames = stringArray;
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    public int getColumnCount() {
        if (this.columNames != null) {
            return this.columNames.length;
        }
        return 0;
    }

    public String getColumnName(int n) {
        try {
            return this.columNames[n];
        }
        catch (Exception exception) {
            return "";
        }
    }

    public int getRowCount() {
        return this.data.size();
    }

    public synchronized Object getRow(int n) {
        this.assertValidRow(n);
        return ((RowData)this.data.get((int)n)).data;
    }

    public synchronized Object[] getRows(int n, int n2) {
        this.assertValidRange(n, n2);
        Object[] objectArray = new Object[n2 - n + 1];
        int n3 = n;
        while (n3 <= n2) {
            objectArray[n3] = ((RowData)this.data.get((int)n3)).data;
            ++n3;
        }
        return objectArray;
    }

    public synchronized Object[] getAllRows() {
        int n = this.data.size() - 1;
        if (n >= 0) {
            return this.getRows(0, n);
        }
        return new Object[0];
    }

    public synchronized void addRow(Object object) {
        this.addRow(this.data.size(), object);
    }

    public synchronized void addRow(int n, Object object) {
        this.addRows(n, new Object[]{object});
    }

    public synchronized void addRows(Object[] objectArray) {
        this.addRows(this.data.size(), objectArray);
    }

    public synchronized void addRows(int n, Object[] objectArray) {
        this.assertValidRow(n, this.data.size() + 1);
        RowData[] rowDataArray = new RowData[objectArray.length];
        int n2 = 0;
        while (n2 < objectArray.length) {
            rowDataArray[n2] = new RowData();
            rowDataArray[n2].data = objectArray[n2];
            ++n2;
        }
        this.addRows(n, rowDataArray);
        this.fireTableStructureChanged();
    }

    private synchronized void addRows(int n, RowData[] rowDataArray) {
        int n2;
        int n3;
        int n4;
        int n5 = rowDataArray.length;
        boolean bl = false;
        RowGroup rowGroup = null;
        if (n != 0 && n != this.data.size()) {
            rowGroup = (EditableRowGroup)this.getRowGroup(n - 1);
            EditableRowGroup editableRowGroup = (EditableRowGroup)this.getRowGroup(n);
            if (rowGroup != null && editableRowGroup == rowGroup) {
                bl = true;
            }
        }
        if (bl) {
            n4 = 0;
            while (n4 < n5) {
                rowDataArray[n4].group = rowGroup;
                ++n4;
            }
            rowGroup.setLastRow(rowGroup.getLastRow() + n5);
            n3 = rowGroup.getLastRow() + 1;
        } else {
            n4 = 0;
            while (n4 < n5) {
                EditableRowGroup editableRowGroup = (EditableRowGroup)rowDataArray[n4].group;
                if (editableRowGroup != null) {
                    n2 = editableRowGroup.getLastRow() - editableRowGroup.getFirstRow();
                    editableRowGroup.setFirstRow(n + n4);
                    editableRowGroup.setLastRow(editableRowGroup.getFirstRow() + n2);
                    n4 += n2;
                }
                ++n4;
            }
            n3 = n + n4;
        }
        n4 = n5 - 1;
        while (n4 >= 0) {
            this.data.add(n, rowDataArray[n4]);
            --n4;
        }
        int n6 = n3;
        n2 = this.data.size();
        while (n6 < n2) {
            EditableRowGroup editableRowGroup = (EditableRowGroup)this.getRowGroup(n6);
            if (editableRowGroup != null) {
                editableRowGroup.setFirstRow(editableRowGroup.getFirstRow() + 1);
                editableRowGroup.setLastRow(editableRowGroup.getLastRow() + 1);
                n6 = editableRowGroup.getLastRow();
            }
            ++n6;
        }
    }

    public synchronized void removeRow(int n) {
        this.removeRows(n, n);
    }

    public synchronized void removeAllRows() {
        int n = this.data.size();
        if (n > 0) {
            this.removeRows(0, n - 1);
        }
    }

    public synchronized void removeRows(int n, int n2) {
        this.assertValidRange(n, n2);
        this.ungroup(n, n2, false, true);
        int n3 = n2;
        while (n3 >= n) {
            this.data.remove(n3);
            --n3;
        }
        int n4 = n2 - n + 1;
        int n5 = n;
        int n6 = this.data.size();
        while (n5 < n6) {
            EditableRowGroup editableRowGroup = (EditableRowGroup)this.getRowGroup(n5);
            if (editableRowGroup != null) {
                if (editableRowGroup.getFirstRow() > n) {
                    editableRowGroup.setFirstRow(editableRowGroup.getFirstRow() - n4);
                }
                editableRowGroup.setLastRow(editableRowGroup.getLastRow() - n4);
                n5 = editableRowGroup.getLastRow();
            }
            ++n5;
        }
        this.fireTableStructureChanged();
    }

    private synchronized void setRowGroup(int n, EditableRowGroup editableRowGroup) {
        ((RowData)this.data.get((int)n)).group = editableRowGroup;
    }

    public synchronized RowGroup getRowGroup(int n) {
        this.assertValidRow(n);
        return ((RowData)this.data.get((int)n)).group;
    }

    public synchronized RowGroup[] getAllRowGroups() {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        int n2 = this.data.size();
        while (n < n2) {
            object = this.getRowGroup(n);
            if (object != null) {
                arrayList.add(object);
                n = object.getLastRow();
            }
            ++n;
        }
        object = new RowGroup[arrayList.size()];
        int n3 = 0;
        while (n3 < ((RowGroup[])object).length) {
            object[n3] = (RowGroup)arrayList.get(n3);
            ++n3;
        }
        return object;
    }

    protected synchronized void group(EditableRowGroup editableRowGroup, int n, int n2) {
        this.assertValidRange(n, n2);
        int n3 = n;
        while (n3 <= n2) {
            if (this.getRowGroup(n3) != null) {
                throw new ArrayIndexOutOfBoundsException("Row " + n3 + " is already in a group");
            }
            ++n3;
        }
        editableRowGroup.setFirstRow(n);
        editableRowGroup.setLastRow(n2);
        int n4 = n;
        while (n4 <= n2) {
            RowData rowData = (RowData)this.data.get(n4);
            rowData.group = editableRowGroup;
            ++n4;
        }
        this.fireTableStructureChanged();
    }

    public synchronized void group(int n, int n2) {
        this.group(this.createEditableRowGroup(), n, n2);
    }

    private synchronized void ungroup(int n, int n2, boolean bl) {
        this.ungroup(n, n2, bl, false);
    }

    private synchronized void ungroup(int n, int n2, boolean bl, boolean bl2) {
        Object object;
        this.assertValidRange(n, n2);
        int n3 = n2 - n + 1;
        boolean bl3 = this.isCompleteGroup(n, n2);
        if (!bl3) {
            EditableRowGroup editableRowGroup = (EditableRowGroup)this.getRowGroup(n);
            object = (EditableRowGroup)this.getRowGroup(n2);
            boolean bl4 = false;
            if (editableRowGroup != null && editableRowGroup == object) {
                if (bl2) {
                    bl4 = true;
                } else {
                    object = (EditableRowGroup)editableRowGroup.getClone();
                    int n4 = n2 + 1;
                    while (n4 <= object.getLastRow()) {
                        this.setRowGroup(n4, (EditableRowGroup)object);
                        ++n4;
                    }
                }
            }
            if (!bl4) {
                if (editableRowGroup != null) {
                    editableRowGroup.setLastRow(n - 1);
                    if (editableRowGroup.getFirstRow() == editableRowGroup.getLastRow()) {
                        this.setRowGroup(editableRowGroup.getFirstRow(), null);
                    }
                }
                if (object != null) {
                    object.setFirstRow(n2 + 1);
                    if (object.getFirstRow() == object.getLastRow()) {
                        this.setRowGroup(object.getFirstRow(), null);
                    }
                }
            }
        }
        int n5 = n;
        while (n5 <= n2) {
            object = (RowData)this.data.get(n5);
            ((RowData)object).group = null;
            ++n5;
        }
        if (bl) {
            this.fireTableStructureChanged();
        }
    }

    public synchronized void ungroup(int n, int n2) {
        this.ungroup(n, n2, true);
    }

    public synchronized void regroup(int n, int n2, int n3) {
        this.assertValidRow(n);
        this.assertValidRange(n2, n3);
        EditableRowGroup editableRowGroup = (EditableRowGroup)this.getRowGroup(n);
        if (editableRowGroup == null) {
            editableRowGroup = this.createEditableRowGroup();
        } else {
            this.ungroup(editableRowGroup.getFirstRow(), editableRowGroup.getLastRow(), false);
        }
        this.group(editableRowGroup, n2, n3);
    }

    public synchronized void moveGroup(int n, int n2) {
        EditableRowGroup editableRowGroup = (EditableRowGroup)this.getRowGroup(n);
        if (editableRowGroup == null) {
            throw new ArrayIndexOutOfBoundsException("Row " + n + " is not in a group");
        }
        this.regroup(n, editableRowGroup.getFirstRow() + n2, editableRowGroup.getLastRow() + n2);
    }

    private boolean exitingGroup(EditableRowGroup editableRowGroup, int n, int n2, int n3) {
        if (editableRowGroup != null) {
            if (n3 == 1 && editableRowGroup.getFirstRow() == n || n3 == -1 && editableRowGroup.getLastRow() == n2) {
                return false;
            }
            int n4 = n;
            while (n4 <= n2) {
                RowGroup rowGroup = this.getRowGroup(n4);
                if (rowGroup == editableRowGroup) {
                    try {
                        rowGroup = this.getRowGroup(n4 + n3);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        rowGroup = null;
                    }
                    if (rowGroup != editableRowGroup) {
                        return true;
                    }
                }
                ++n4;
            }
        }
        return false;
    }

    private boolean isCompleteGroup(int n, int n2) {
        EditableRowGroup editableRowGroup = (EditableRowGroup)this.getRowGroup(n);
        return !(editableRowGroup != null && editableRowGroup.getFirstRow() != n || (editableRowGroup = (EditableRowGroup)this.getRowGroup(n2)) != null && editableRowGroup.getLastRow() != n2);
    }

    public synchronized boolean moveRowsUp(int n, int n2) {
        EditableRowGroup editableRowGroup;
        if (!this.canMoveRowsUp(n, n2)) {
            throw new ArrayIndexOutOfBoundsException("Cannot move rows " + n + '-' + n2 + " beyond table boundary");
        }
        boolean bl = true;
        EditableRowGroup editableRowGroup2 = (EditableRowGroup)this.getRowGroup(n2);
        boolean bl2 = this.exitingGroup(editableRowGroup2, n, n2, -1);
        boolean bl3 = false;
        if (!bl2) {
            bl3 = this.isCompleteGroup(n, n2);
        }
        boolean bl4 = false;
        try {
            editableRowGroup = (EditableRowGroup)this.getRowGroup(n - 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            editableRowGroup = null;
        }
        if (!(editableRowGroup == null || bl2 && editableRowGroup != this.getRowGroup(n))) {
            int n3 = n;
            while (n3 <= n2) {
                EditableRowGroup editableRowGroup3 = (EditableRowGroup)this.getRowGroup(n3 - 1);
                if (editableRowGroup3 == editableRowGroup && (editableRowGroup3 = (EditableRowGroup)this.getRowGroup(n3)) != editableRowGroup) {
                    bl4 = true;
                    break;
                }
                ++n3;
            }
        }
        if (bl2) {
            int n4 = editableRowGroup2.getFirstRow();
            if (BLOCKMOVE) {
                editableRowGroup2.setFirstRow(n2 + 1);
            } else {
                editableRowGroup2.setFirstRow(editableRowGroup2.getFirstRow() + 1);
            }
            if (editableRowGroup2.getLastRow() == editableRowGroup2.getFirstRow()) {
                this.setRowGroup(editableRowGroup2.getLastRow(), null);
            }
            int n5 = editableRowGroup2.getFirstRow() - 1;
            while (n5 >= n4) {
                this.setRowGroup(n5, null);
                --n5;
            }
            bl = false;
        }
        if (bl4) {
            int n6 = editableRowGroup.getLastRow();
            if (BLOCKMOVE) {
                editableRowGroup.setLastRow(n2);
            } else {
                EditableRowGroup editableRowGroup4 = (EditableRowGroup)this.getRowGroup(editableRowGroup.getLastRow() + 1);
                if (editableRowGroup4 == null) {
                    editableRowGroup.setLastRow(editableRowGroup.getLastRow() + 1);
                } else {
                    editableRowGroup.setLastRow(editableRowGroup4.getLastRow());
                }
            }
            int n7 = editableRowGroup.getLastRow();
            while (n7 > n6) {
                this.setRowGroup(n7, editableRowGroup);
                --n7;
            }
            bl = false;
        }
        if (bl) {
            int n8 = n;
            while (n8 <= n2) {
                EditableRowGroup editableRowGroup5;
                RowData rowData = (RowData)this.data.get(n8);
                if (bl3 && (editableRowGroup5 = (EditableRowGroup)rowData.group) != null) {
                    if (n8 == editableRowGroup5.getFirstRow()) {
                        editableRowGroup5.setFirstRow(editableRowGroup5.getFirstRow() - 1);
                    } else if (n8 == editableRowGroup5.getLastRow()) {
                        editableRowGroup5.setLastRow(editableRowGroup5.getLastRow() - 1);
                    }
                }
                this.data.remove(n8);
                this.data.add(n8 - 1, rowData);
                ++n8;
            }
        }
        this.fireTableStructureChanged();
        return bl;
    }

    public synchronized boolean moveRowsDown(int n, int n2) {
        EditableRowGroup editableRowGroup;
        if (!this.canMoveRowsDown(n, n2)) {
            throw new ArrayIndexOutOfBoundsException("Cannot move rows " + n + '-' + n2 + " beyond table boundary");
        }
        boolean bl = true;
        EditableRowGroup editableRowGroup2 = (EditableRowGroup)this.getRowGroup(n);
        boolean bl2 = this.exitingGroup(editableRowGroup2, n, n2, 1);
        boolean bl3 = false;
        if (!bl2) {
            bl3 = this.isCompleteGroup(n, n2);
        }
        boolean bl4 = false;
        try {
            editableRowGroup = (EditableRowGroup)this.getRowGroup(n2 + 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            editableRowGroup = null;
        }
        if (!(editableRowGroup == null || bl2 && editableRowGroup != this.getRowGroup(n2))) {
            int n3 = n2;
            while (n3 >= n) {
                EditableRowGroup editableRowGroup3 = (EditableRowGroup)this.getRowGroup(n3 + 1);
                if (editableRowGroup3 == editableRowGroup && (editableRowGroup3 = (EditableRowGroup)this.getRowGroup(n3)) != editableRowGroup) {
                    bl4 = true;
                    break;
                }
                --n3;
            }
        }
        if (bl2) {
            int n4 = editableRowGroup2.getLastRow();
            if (BLOCKMOVE) {
                editableRowGroup2.setLastRow(n - 1);
            } else {
                editableRowGroup2.setLastRow(editableRowGroup2.getLastRow() - 1);
            }
            if (editableRowGroup2.getFirstRow() == editableRowGroup2.getLastRow()) {
                this.setRowGroup(editableRowGroup2.getFirstRow(), null);
            }
            int n5 = editableRowGroup2.getLastRow() + 1;
            while (n5 <= n4) {
                this.setRowGroup(n5, null);
                ++n5;
            }
            bl = false;
        }
        if (bl4) {
            int n6 = editableRowGroup.getFirstRow();
            if (BLOCKMOVE) {
                editableRowGroup.setFirstRow(n);
            } else {
                EditableRowGroup editableRowGroup4 = (EditableRowGroup)this.getRowGroup(editableRowGroup.getFirstRow() - 1);
                if (editableRowGroup4 == null) {
                    editableRowGroup.setFirstRow(editableRowGroup.getFirstRow() - 1);
                } else {
                    editableRowGroup.setFirstRow(editableRowGroup4.getFirstRow());
                }
            }
            int n7 = editableRowGroup.getFirstRow();
            while (n7 < n6) {
                this.setRowGroup(n7, editableRowGroup);
                ++n7;
            }
            bl = false;
        }
        if (bl) {
            int n8 = n2;
            while (n8 >= n) {
                EditableRowGroup editableRowGroup5;
                RowData rowData = (RowData)this.data.get(n8);
                if (bl3 && (editableRowGroup5 = (EditableRowGroup)rowData.group) != null) {
                    if (n8 == editableRowGroup5.getLastRow()) {
                        editableRowGroup5.setLastRow(editableRowGroup5.getLastRow() + 1);
                    } else if (n8 == editableRowGroup5.getFirstRow()) {
                        editableRowGroup5.setFirstRow(editableRowGroup5.getFirstRow() + 1);
                    }
                }
                this.data.remove(n8);
                this.data.add(n8 + 1, rowData);
                --n8;
            }
        }
        this.fireTableStructureChanged();
        return bl;
    }

    public synchronized boolean moveRowsTo(int n, int n2, int n3) {
        if (!this.canMoveRowsTo(n, n2, n3)) {
            throw new ArrayIndexOutOfBoundsException("Cannot move rows " + n + '-' + n2 + " beyond table boundary");
        }
        if (n == n3) {
            return false;
        }
        int n4 = n2 - n + 1;
        RowData[] rowDataArray = new RowData[n4];
        int n5 = n;
        while (n5 <= n2) {
            rowDataArray[n5 - n] = (RowData)this.data.get(n5);
            ++n5;
        }
        this.removeRows(n, n2);
        if (n3 > n) {
            n3 = n3 <= n2 ? n : (n3 -= n4);
        }
        this.addRows(n3, rowDataArray);
        this.fireTableStructureChanged();
        return true;
    }

    public synchronized boolean canMoveRowsUp(int n, int n2) {
        return this.canMoveRows(n, n2, -1);
    }

    public synchronized boolean canMoveRowsDown(int n, int n2) {
        return this.canMoveRows(n, n2, 1);
    }

    private synchronized boolean canMoveRows(int n, int n2, int n3) {
        try {
            this.assertValidRange(n, n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
        if (n3 < 0 && n - 1 >= 0 || n3 > 0 && n2 + 1 < this.data.size()) {
            return true;
        }
        EditableRowGroup editableRowGroup = (EditableRowGroup)this.getRowGroup(n3 > 0 ? n : n2);
        return this.exitingGroup(editableRowGroup, n, n2, n3);
    }

    public synchronized boolean canMoveRowsTo(int n, int n2, int n3) {
        try {
            this.assertValidRange(n, n2);
            this.assertValidRow(n3, this.data.size() + 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
        return true;
    }

    private void assertValidRow(int n, int n2) {
        if (n < 0 || n >= n2) {
            throw new ArrayIndexOutOfBoundsException("Invalid row: " + n);
        }
    }

    private synchronized void assertValidRow(int n) {
        this.assertValidRow(n, this.data.size());
    }

    private void assertValidRange(int n, int n2) {
        if (n > n2) {
            throw new ArrayIndexOutOfBoundsException("Invalid row range: " + n + '-' + n2);
        }
        this.assertValidRow(n);
        this.assertValidRow(n2);
    }

    protected abstract EditableRowGroup createEditableRowGroup();

    protected static class RowData {
        protected RowGroup group;
        protected Object data;

        protected RowData() {
        }

        public RowGroup getRowGroup() {
            return this.group;
        }

        public Object getData() {
            return this.data;
        }
    }
}

