/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.ttk.icon;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.image.RGBImageFilter;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingConstants;

public class ProhibitIcon
implements Icon,
SwingConstants {
    private static final RGBImageFilter filter = new GrayFilter(true, 50);
    private static final double THICKNESSRATIO = 0.09090909090909091;
    private static final double SQRT = Math.sqrt(2.0);
    private static final double CONST1 = (SQRT + 2.0) / 4.0;
    private static final double CONST2 = (2.0 - SQRT) / 4.0;
    private static final double _SPACING = 2.0;
    private double diameter;
    private Icon innerIcon;
    private Icon disabledInnerIcon;
    private Color color = Color.black;
    private boolean stretch;
    private boolean enabled;

    public ProhibitIcon() {
        this(0);
    }

    public ProhibitIcon(Icon icon) {
        this();
        this.setInnerIcon(icon, true);
    }

    public ProhibitIcon(int n) {
        this.setDiameter(n);
        this.setEnabled(true);
    }

    public void setInnerIcon(Icon icon) {
        this.setInnerIcon(icon, false);
    }

    public void setInnerIcon(Icon icon, boolean bl) {
        int n;
        this.innerIcon = icon;
        if (!bl) {
            return;
        }
        int n2 = icon.getIconWidth();
        double d = n2 > (n = icon.getIconHeight()) ? (double)n2 : (double)n;
        this.setDiameter(2.0 * d / Math.sqrt(2.0) + 4.0);
    }

    public Icon getInnerIcon() {
        return this.innerIcon;
    }

    private Icon getAppropriateIcon() {
        if (this.enabled) {
            return this.innerIcon;
        }
        if (this.innerIcon == null) {
            return null;
        }
        if (this.disabledInnerIcon == null) {
            Image image = GrayFilter.createDisabledImage(((ImageIcon)this.innerIcon).getImage());
            this.disabledInnerIcon = new ImageIcon(image);
        }
        return this.disabledInnerIcon;
    }

    public void setDiameter(double d) {
        this.diameter = d;
    }

    public double getDiameter() {
        return this.diameter;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getAppropriateColor() {
        if (this.enabled) {
            return this.color;
        }
        return ProhibitIcon.getDisabledColor(this.color);
    }

    public void setStretch(boolean bl) {
        this.stretch = bl;
    }

    public boolean getStretch() {
        return this.stretch;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public int getIconHeight() {
        int n;
        int n2 = (int)this.getDiameter();
        Icon icon = this.getInnerIcon();
        if (icon == null) {
            return n2;
        }
        int n3 = icon.getIconHeight();
        int n4 = n3 > (n = icon.getIconWidth()) ? n3 : n;
        return n4 > n2 ? n4 : n2;
    }

    public int getIconWidth() {
        return this.getIconHeight();
    }

    public static int getStretchedDiameter(Component component) {
        int n = component.getSize().height;
        if (component instanceof Container) {
            Insets insets = ((Container)component).getInsets();
            n -= insets.top + insets.bottom;
        }
        int n2 = component.getSize().width;
        if (component instanceof Container) {
            Insets insets = ((Container)component).getInsets();
            n2 -= insets.left + insets.right;
        }
        return n < n2 ? n : n2;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Object object;
        boolean bl = this.getStretch();
        double d = bl ? (double)ProhibitIcon.getStretchedDiameter(component) : this.getDiameter();
        double d2 = 0.09090909090909091 * d;
        if (bl && component instanceof Container) {
            object = ((Container)component).getInsets();
            n = ((Insets)object).left + (int)(((double)(component.getSize().width - ((Insets)object).left - ((Insets)object).right) - d) / 2.0);
            n2 = ((Insets)object).top + (int)(((double)(component.getSize().height - ((Insets)object).top - ((Insets)object).bottom) - d) / 2.0);
        }
        d -= d2;
        graphics.translate(n += (int)(d2 / 2.0), n2 += (int)(d2 / 2.0));
        object = this.getAppropriateIcon();
        if (object != null) {
            int n3 = (int)((d - (double)object.getIconWidth()) / 2.0);
            int n4 = (int)((d - (double)object.getIconHeight()) / 2.0);
            object.paintIcon(component, graphics, n3, n4);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics.setColor(this.getAppropriateColor());
        Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Stroke stroke = graphics2D.getStroke();
        BasicStroke basicStroke = new BasicStroke((float)d2, 0, 0);
        graphics2D.setStroke(basicStroke);
        graphics2D.draw(new Ellipse2D.Double(0.0, 0.0, d, d));
        double d3 = d * CONST1;
        double d4 = d * CONST2;
        graphics2D.draw(new Line2D.Double(d4, d3, d3, d4));
        graphics2D.setStroke(stroke);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object2);
        graphics.translate(-n, -n2);
    }

    private static Color getDisabledColor(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = n << 16 | n2 << 8 | n3;
        n4 = filter.filterRGB(0, 0, n4);
        n = (n4 & 0xFF0000) >> 16;
        n2 = (n4 & 0xFF00) >> 8;
        n3 = n4 & 0xFF;
        Color color2 = new Color(n, n2, n3);
        return color2;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        Container container = jFrame.getContentPane();
        container.setLayout(new BorderLayout());
        ImageIcon imageIcon = new ImageIcon("/home/talley/tmp/stripe_16.gif");
        ProhibitIcon prohibitIcon = new ProhibitIcon(imageIcon);
        JButton jButton = new JButton();
        jButton.setIcon(prohibitIcon);
        jButton.setHorizontalTextPosition(2);
        container.add(jButton);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

