/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.ttk.icon;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingConstants;

public class BracketIcon
implements Icon,
SwingConstants {
    private static final int _THICKNESS = 2;
    private static final float MULTIPLIER = 1.5f;
    private int legLength;
    private int desiredHeight;
    private int thickness;
    private Icon innerIcon;
    private Color color = Color.black;
    private boolean stretch;

    public BracketIcon() {
        this(0, 0);
    }

    public BracketIcon(Icon icon) {
        this((int)((float)icon.getIconWidth() * 1.5f), 0);
        this.setInnerIcon(icon);
    }

    public BracketIcon(int n, int n2) {
        this.setLegLength(n);
        this.setDesiredHeight(n2);
        this.setThickness(2);
    }

    public void setThickness(int n) {
        this.thickness = n;
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setInnerIcon(Icon icon) {
        this.innerIcon = icon;
    }

    public Icon getInnerIcon() {
        return this.innerIcon;
    }

    public void setLegLength(int n) {
        this.legLength = n;
    }

    public int getLegLength() {
        return this.legLength;
    }

    public void setDesiredHeight(int n) {
        this.desiredHeight = n;
    }

    public int getDesiredHeight() {
        return this.desiredHeight;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setStretch(boolean bl) {
        this.stretch = bl;
    }

    public boolean getStretch() {
        return this.stretch;
    }

    public int getIconHeight() {
        int n = this.getDesiredHeight();
        Icon icon = this.getInnerIcon();
        if (icon == null) {
            return n;
        }
        int n2 = icon.getIconHeight();
        int n3 = n2 + 4 * this.getThickness();
        return n3 > n ? n3 : n;
    }

    public int getIconWidth() {
        int n = this.getLegLength();
        Icon icon = this.getInnerIcon();
        if (icon == null) {
            return n;
        }
        int n2 = icon.getIconWidth();
        int n3 = n + (n2 - this.getThickness()) / 2;
        return n3 > n2 ? n3 : n2;
    }

    public static int getStretchedHeight(Component component) {
        int n = component.getSize().height;
        if (component instanceof Container) {
            Insets insets = ((Container)component).getInsets();
            n -= insets.top + insets.bottom;
        }
        return n;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        boolean bl = this.getStretch();
        int n3 = this.getThickness();
        int n4 = this.getIconWidth();
        int n5 = bl ? BracketIcon.getStretchedHeight(component) : this.getIconHeight();
        Icon icon = this.getInnerIcon();
        int n6 = this.getLegLength();
        graphics.setColor(this.getColor());
        if (bl && component instanceof Container) {
            n2 = ((Container)component).getInsets().top;
        }
        graphics.translate(n, n2);
        if (icon == null) {
            this.drawBracket(graphics, n4, n5, n3);
        } else {
            int n7 = n4 - n6;
            graphics.translate(n7, 0);
            this.drawBracket(graphics, n6, n5, n3);
            graphics.translate(-n7, 0);
            icon.paintIcon(component, graphics, 0, (n5 - icon.getIconHeight()) / 2);
        }
        graphics.translate(-n, -n2);
    }

    private void drawBracket(Graphics graphics, int n, int n2, int n3) {
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        int n4 = n - 1;
        int n5 = n2 - 1;
        int n6 = 0;
        while (n6 < n3) {
            nArray[0] = n4;
            nArray[1] = n6;
            nArray[2] = n6;
            nArray[3] = n4;
            nArray2[0] = n6;
            nArray2[1] = n6;
            nArray2[2] = n5 - n6;
            nArray2[3] = n5 - n6;
            graphics.drawPolyline(nArray, nArray2, 4);
            ++n6;
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        Container container = jFrame.getContentPane();
        container.setLayout(new BorderLayout());
        ImageIcon imageIcon = new ImageIcon("/home/talley/tmp/stripe_16.gif");
        BracketIcon bracketIcon = new BracketIcon(imageIcon);
        bracketIcon.setThickness(2);
        bracketIcon.setDesiredHeight(100);
        bracketIcon.setStretch(true);
        JButton jButton = new JButton();
        jButton.setIcon(bracketIcon);
        jButton.setHorizontalTextPosition(2);
        container.add(jButton);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

