/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.ttk;

import com.sun.admin.volmgr.client.ttk.ArrowComponent;
import com.sun.admin.volmgr.client.ttk.text.LongSpinnerModel;
import com.sun.admin.volmgr.client.ttk.text.SpinnerDataModel;
import java.awt.Component;
import java.awt.Container;
import java.text.ParseException;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class Spinner
extends ArrowComponent {
    private SpinnerDataModel model;
    private boolean beepOnError;

    public Spinner() {
        this("");
    }

    public Spinner(String string) {
        this(string, Spinner.createDefaultSpinnerModel());
    }

    public Spinner(SpinnerDataModel spinnerDataModel) {
        this("", spinnerDataModel);
    }

    public Spinner(JTextField jTextField) {
        this(jTextField, Spinner.createDefaultSpinnerModel());
    }

    public Spinner(String string, SpinnerDataModel spinnerDataModel) {
        this(new JTextField(string), spinnerDataModel);
    }

    public Spinner(JTextField jTextField, SpinnerDataModel spinnerDataModel) {
        super(jTextField);
        String string = jTextField.getText();
        this.setSpinnerModel(spinnerDataModel);
        jTextField.setDocument(new SpinnerDocument());
        jTextField.setText(string);
        this.setBeepOnError(true);
    }

    public void setTextField(JTextField jTextField) {
        this.setMainComponent(jTextField);
    }

    public JTextField getTextField() {
        return (JTextField)this.getMainComponent();
    }

    public void setSpinnerModel(SpinnerDataModel spinnerDataModel) {
        this.model = spinnerDataModel;
    }

    public SpinnerDataModel getSpinnerModel() {
        return this.model;
    }

    public void setBeepOnError(boolean bl) {
        this.beepOnError = bl;
    }

    public boolean getBeepOnError() {
        return this.beepOnError;
    }

    protected void errorOccurred() {
        if (this.beepOnError) {
            this.getToolkit().beep();
        }
    }

    protected static SpinnerDataModel createDefaultSpinnerModel() {
        return new LongSpinnerModel();
    }

    private static void setEnabledRecursive(Container container, boolean bl) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component component = componentArray[n];
            component.setEnabled(bl);
            if (component instanceof Container) {
                Spinner.setEnabledRecursive((Container)component, bl);
            }
            ++n;
        }
    }

    public void setEnabled(boolean bl) {
        Spinner.setEnabledRecursive(this, bl);
    }

    public void upArrowPushed() {
        try {
            JTextField jTextField = this.getTextField();
            jTextField.setText(this.getSpinnerModel().incrementValue(jTextField.getText()));
        }
        catch (ParseException parseException) {
            this.errorOccurred();
        }
    }

    public void downArrowPushed() {
        try {
            JTextField jTextField = this.getTextField();
            jTextField.setText(this.getSpinnerModel().decrementValue(jTextField.getText()));
        }
        catch (ParseException parseException) {
            this.errorOccurred();
        }
    }

    public static void main(String[] stringArray) {
        Spinner spinner = new Spinner();
        JFrame jFrame = new JFrame();
        Container container = jFrame.getContentPane();
        container.add(spinner);
        jFrame.pack();
        jFrame.setVisible(true);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("asdfasdf");
        spinner.setEnabled(false);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("asdfasdf");
        spinner.setEnabled(true);
    }

    public class SpinnerDocument
    extends PlainDocument {
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            String string2 = this.getText(0, this.getLength());
            StringBuffer stringBuffer = new StringBuffer(string2);
            try {
                stringBuffer.insert(n, string);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                throw new BadLocationException(string, n);
            }
            String string3 = stringBuffer.toString();
            if (Spinner.this.getSpinnerModel().isValidBeginning(string3)) {
                super.insertString(n, string, attributeSet);
            } else {
                Spinner.this.errorOccurred();
            }
        }
    }
}

