/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.ttk;

import com.sun.admin.volmgr.client.ttk.table.RowGroupable;
import com.sun.admin.volmgr.client.ttk.table.RowMoveable;
import com.sun.admin.volmgr.client.ttk.table.SimpleGroupableTableModel;
import com.sun.admin.volmgr.client.ttk.table.SimpleRowHeaderManager;
import com.sun.admin.volmgr.client.ttk.table.TableRowUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class GroupableMoveableTablePanel
extends JPanel {
    private static final int COMPONENTSPACING = 15;
    private static final int SCROLLPANEHEIGHT = 250;
    private JTable table;
    private JScrollPane scroll;
    private JLabel label;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private JButton groupButton;
    private JButton ungroupButton;
    private RowGroupable groupable;
    private RowMoveable moveable;

    public GroupableMoveableTablePanel(JTable jTable, RowGroupable rowGroupable, RowMoveable rowMoveable) {
        this.table = jTable;
        this.groupable = rowGroupable;
        this.moveable = rowMoveable;
        this.init();
    }

    public JTable getTable() {
        return this.table;
    }

    public JScrollPane getTableScrollPane() {
        return this.scroll;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public JButton getMoveUpButton() {
        return this.moveUpButton;
    }

    public JButton getMoveDownButton() {
        return this.moveDownButton;
    }

    public JButton getGroupButton() {
        return this.groupButton;
    }

    public JButton getUngroupButton() {
        return this.ungroupButton;
    }

    public RowMoveable getRowMoveable() {
        return this.moveable;
    }

    public RowGroupable getRowGroupable() {
        return this.groupable;
    }

    private void init() {
        this.scroll = new JScrollPane(this.table);
        Dimension dimension = this.scroll.getPreferredSize();
        this.scroll.setPreferredSize(new Dimension(dimension.width, 250));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(this.table.getBackground());
        jPanel.add(this.scroll);
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(true);
        this.scroll.setCorner("UPPER_LEFT_CORNER", jPanel2);
        this.scroll.getViewport().setBackground(this.table.getBackground());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        this.label = new JLabel();
        jPanel3.add((Component)this.label, "North");
        jPanel3.add((Component)jPanel, "Center");
        RowMoveable rowMoveable = this.getRowMoveable();
        RowGroupable rowGroupable = this.getRowGroupable();
        JPanel jPanel4 = null;
        JPanel jPanel5 = null;
        JPanel jPanel6 = null;
        if (rowGroupable != null) {
            this.groupButton = TableRowUtil.createGroupButton(this.table, rowGroupable, rowMoveable);
            this.ungroupButton = TableRowUtil.createUngroupButton(this.table, rowGroupable);
            jPanel5 = new JPanel();
            jPanel5.setLayout(new GridLayout(2, 1));
            jPanel5.add(this.groupButton);
            jPanel5.add(this.ungroupButton);
        }
        if (rowMoveable != null) {
            this.moveDownButton = TableRowUtil.createMoveDownButton(this.table, rowMoveable, true, true);
            this.moveUpButton = TableRowUtil.createMoveUpButton(this.table, rowMoveable, true, true);
            jPanel6 = new JPanel();
            jPanel6.setLayout(new GridLayout(2, 1));
            jPanel6.add(this.moveUpButton);
            jPanel6.add(this.moveDownButton);
        }
        if (jPanel5 != null && jPanel6 != null) {
            jPanel4 = new JPanel();
            jPanel4.setLayout(new BorderLayout(15, 15));
            jPanel4.add((Component)jPanel5, "West");
            jPanel4.add((Component)jPanel6, "Center");
        } else if (jPanel5 != null) {
            jPanel4 = jPanel5;
        } else if (jPanel6 != null) {
            jPanel4 = jPanel6;
        }
        this.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)jPanel3, gridBagConstraints);
        if (jPanel4 != null) {
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets.top = 15;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.add((Component)jPanel4, gridBagConstraints);
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        Object[][] objectArray = new String[20][5];
        String[] stringArray2 = new String[objectArray[0].length];
        int n = 0;
        while (n < objectArray.length) {
            object = objectArray[n];
            int n2 = 0;
            while (n2 < ((String[])object).length) {
                if (n == 0) {
                    stringArray2[n2] = n2 + "";
                }
                object[n2] = n + "";
                ++n2;
            }
            ++n;
        }
        object = new SimpleGroupableTableModel(objectArray, stringArray2);
        JTable jTable = new JTable((TableModel)object);
        GroupableMoveableTablePanel groupableMoveableTablePanel = new GroupableMoveableTablePanel(jTable, (RowGroupable)object, (RowMoveable)object);
        final SimpleRowHeaderManager simpleRowHeaderManager = new SimpleRowHeaderManager(jTable, (RowGroupable)object, 1);
        ((AbstractTableModel)object).addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                simpleRowHeaderManager.update();
            }
        });
        groupableMoveableTablePanel.getGroupButton().setText("Group");
        groupableMoveableTablePanel.getUngroupButton().setText("Ungroup");
        groupableMoveableTablePanel.getMoveUpButton().setText("Move up");
        groupableMoveableTablePanel.getMoveDownButton().setText("Move down");
        JPanel jPanel = simpleRowHeaderManager.getHeader();
        JScrollPane jScrollPane = groupableMoveableTablePanel.getTableScrollPane();
        jScrollPane.setRowHeaderView(jPanel);
        JFrame jFrame = new JFrame();
        Container container = jFrame.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)groupableMoveableTablePanel, "Center");
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

