/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.hsps;

import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.volmgr.client.DeviceTableModel;
import com.sun.admin.volmgr.client.DeviceTablePropertySheet;
import com.sun.admin.volmgr.client.hsps.ConfHSPPanel;
import com.sun.admin.volmgr.client.util.GUIUtil;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.wizards.AddHotSpareWizard;
import com.sun.admin.volmgr.client.wizards.ReplaceHotSpareWizard;
import com.sun.admin.volmgr.common.Device;
import com.sun.management.viper.console.gui.VFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;

public class HSPDeviceTablePropertySheet
extends DeviceTablePropertySheet {
    private static final String TITLE = "spares_props_tab";
    private static final String HELPFILE = "HSPDeviceTablePropertySheet.html";
    private Device device;
    private String disksetFlag;
    private JButton addButton;
    private JButton replaceButton;
    private JButton enableButton;
    private JButton removeButton;

    public HSPDeviceTablePropertySheet(Device device) {
        super(TITLE, HELPFILE);
        this.device = device;
        this.initGUI();
    }

    protected synchronized String getDiskSetFlag() {
        if (this.disksetFlag == null) {
            this.disksetFlag = Util.getDiskSetFlag(this.device);
        }
        return this.disksetFlag;
    }

    private void setButtonState() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (Util.getApp().getServiceWrapper().hasVolMgrWriteAuth()) {
            int n = 0;
            int n2 = 0;
            int[] nArray = this.table.getSelectedRows();
            if (nArray.length > 0) {
                int n3 = 0;
                while (n3 < nArray.length) {
                    Device device = (Device)this.model.getRow(n3);
                    Integer n4 = (Integer)device.getProperty("state");
                    if (n4 != null) {
                        int n5 = n4;
                        if (n5 == 2) {
                            ++n;
                        } else if (n5 == 3) {
                            ++n2;
                        }
                    }
                    ++n3;
                }
                if (nArray.length == 1 && n == 0) {
                    bl2 = true;
                }
                if (n2 == nArray.length) {
                    bl3 = true;
                }
                if (n == 0) {
                    bl = true;
                }
            }
        }
        this.removeButton.setEnabled(bl);
        this.replaceButton.setEnabled(bl2);
        this.enableButton.setEnabled(bl3);
    }

    private void addSpare() {
        new Thread(){

            public void run() {
                VFrame vFrame = new VFrame();
                Util.makeModal(GUIUtil.getParentJFrame((Component)((Object)HSPDeviceTablePropertySheet.this)), (Window)vFrame, true);
                AddHotSpareWizard addHotSpareWizard = new AddHotSpareWizard(HSPDeviceTablePropertySheet.this.device);
                addHotSpareWizard.init();
                addHotSpareWizard.setContainer((Component)vFrame);
                vFrame.showCenter((Component)GUIUtil.getAppFrame());
                addHotSpareWizard.start();
            }
        }.start();
    }

    private void replaceSpare(final Device device) {
        new Thread(){

            public void run() {
                VFrame vFrame = new VFrame();
                Util.makeModal(GUIUtil.getParentJFrame((Component)((Object)HSPDeviceTablePropertySheet.this)), (Window)vFrame, true);
                ReplaceHotSpareWizard replaceHotSpareWizard = new ReplaceHotSpareWizard(HSPDeviceTablePropertySheet.this.device, device);
                replaceHotSpareWizard.init();
                replaceHotSpareWizard.setContainer((Component)vFrame);
                vFrame.showCenter((Component)GUIUtil.getAppFrame());
                replaceHotSpareWizard.start();
            }
        }.start();
    }

    private void enableSpare() {
        String string;
        Object object;
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        String[] stringArray = new String[nArray.length];
        String[] stringArray2 = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            object = (Device)this.model.getRow(nArray[n]);
            string = Util.getDeviceBaseName((Device)object);
            stringArray[n] = Util.getResourceString("hsp_enable_spare_cmd", string);
            stringArray2[n] = Util.getBasedir() + "usr/sbin/metahs" + this.getDiskSetFlag() + " -e " + string;
            ++n;
        }
        object = Util.getConfirmListener(stringArray, stringArray2);
        string = Util.getResourceString("sure_enable_hsp_spare");
        ConfHSPPanel confHSPPanel = new ConfHSPPanel(stringArray2, string);
        String string2 = new String(Util.getResourceString("warning_enable_hsp_spare"));
        WarningDialog warningDialog = new WarningDialog(GUIUtil.getParentJFrame((Component)((Object)this)), string2, (JPanel)confHSPPanel, (ActionListener)object, Util.getResourceString("warning_enable"));
    }

    private void removeSpare() {
        String string;
        Object object;
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        String string2 = Util.getDeviceBaseName(this.device);
        String[] stringArray = new String[nArray.length];
        String[] stringArray2 = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            object = (Device)this.model.getRow(nArray[n]);
            string = Util.getDeviceBaseName((Device)object);
            stringArray[n] = Util.getResourceString("hsp_delete_spare_cmd", string);
            stringArray2[n] = Util.getBasedir() + "usr/sbin/metahs" + this.getDiskSetFlag() + " -d " + string2 + " " + string;
            ++n;
        }
        object = Util.getConfirmListener(stringArray, stringArray2);
        string = Util.getResourceString("sure_delete_hsp_spare");
        ConfHSPPanel confHSPPanel = new ConfHSPPanel(stringArray2, string);
        String string3 = new String(Util.getResourceString("warning_delete_hsp_spare"));
        WarningDialog warningDialog = new WarningDialog(GUIUtil.getParentJFrame((Component)((Object)this)), string3, (JPanel)confHSPPanel, (ActionListener)object, Util.getResourceString("warning_delete"));
    }

    protected Device[] getDevices() {
        return Util.getComponentsOf(this.device);
    }

    public void tableSelectionChanged(ListSelectionEvent listSelectionEvent) {
        this.setButtonState();
    }

    protected Component getMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(super.getMainPanel(), "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        this.addButton = new JButton();
        if (!Util.getApp().getServiceWrapper().hasVolMgrWriteAuth()) {
            this.addButton.setEnabled(false);
        } else {
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HSPDeviceTablePropertySheet.this.addSpare();
                }
            });
        }
        Util.initButton(this.addButton, "add_spare");
        jPanel2.add(this.addButton);
        this.removeButton = new JButton();
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HSPDeviceTablePropertySheet.this.removeSpare();
            }
        });
        Util.initButton(this.removeButton, "delete_spare");
        jPanel2.add(this.removeButton);
        final JTable jTable = this.table;
        final DeviceTableModel deviceTableModel = this.model;
        this.replaceButton = new JButton();
        this.replaceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = jTable.getSelectedRows();
                Device device = (Device)deviceTableModel.getRow(nArray[0]);
                HSPDeviceTablePropertySheet.this.replaceSpare(device);
            }
        });
        Util.initButton(this.replaceButton, "replace_spare");
        jPanel2.add(this.replaceButton);
        this.enableButton = new JButton();
        this.enableButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HSPDeviceTablePropertySheet.this.enableSpare();
            }
        });
        Util.initButton(this.enableButton, "enable_spare");
        jPanel2.add(this.enableButton);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    protected void refresh() {
        super.refresh();
        this.setButtonState();
    }
}

