/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.hsps;

import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.volmgr.client.DeviceTablePropertySheet;
import com.sun.admin.volmgr.client.hsps.ConfHSPPanel;
import com.sun.admin.volmgr.client.util.GUIUtil;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.wizards.AttachHSPFromHSPWizard;
import com.sun.admin.volmgr.common.Device;
import com.sun.management.viper.console.gui.VFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;

public class HSPAssocTablePropertySheet
extends DeviceTablePropertySheet {
    private static final String TITLE = "usedby_props_tab";
    private static final String HELPFILE = "HSPAssocTablePropertySheet.html";
    private Device device;
    private String disksetFlag;
    private JButton attachButton;
    private JButton detachButton;

    public HSPAssocTablePropertySheet(Device device) {
        super(TITLE, HELPFILE);
        this.device = device;
        this.initGUI();
    }

    protected synchronized String getDiskSetFlag() {
        if (this.disksetFlag == null) {
            this.disksetFlag = Util.getDiskSetFlag(this.device);
        }
        return this.disksetFlag;
    }

    private void setButtonState() {
        boolean bl = false;
        boolean bl2 = false;
        if (Util.getApp().getServiceWrapper().hasVolMgrWriteAuth()) {
            if (this.table.getSelectedRows().length == 1) {
                bl2 = true;
            }
            bl = true;
        }
        this.attachButton.setEnabled(bl);
        this.detachButton.setEnabled(bl2);
    }

    private void attachHSP() {
        new Thread(){

            public void run() {
                VFrame vFrame = new VFrame();
                Util.makeModal(GUIUtil.getParentJFrame((Component)((Object)HSPAssocTablePropertySheet.this)), (Window)vFrame, true);
                AttachHSPFromHSPWizard attachHSPFromHSPWizard = new AttachHSPFromHSPWizard(HSPAssocTablePropertySheet.this.device);
                attachHSPFromHSPWizard.init();
                attachHSPFromHSPWizard.setContainer((Component)vFrame);
                vFrame.showCenter((Component)GUIUtil.getAppFrame());
                attachHSPFromHSPWizard.start();
            }
        }.start();
    }

    private void detachHSP() {
        String string;
        Object object;
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        String[] stringArray = new String[nArray.length];
        String[] stringArray2 = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            object = (Device)this.model.getRow(nArray[n]);
            string = Util.getDeviceBaseName((Device)object);
            stringArray[n] = Util.getResourceString("hsp_detach_cmd", string);
            stringArray2[n] = Util.getBasedir() + "usr/sbin/metaparam" + this.getDiskSetFlag() + " -h none " + string;
            ++n;
        }
        object = Util.getConfirmListener(stringArray, stringArray2);
        string = Util.getResourceString("sure_detach_hsp");
        ConfHSPPanel confHSPPanel = new ConfHSPPanel(stringArray2, string);
        String string2 = new String(Util.getResourceString("warning_detach_hsp"));
        WarningDialog warningDialog = new WarningDialog(GUIUtil.getParentJFrame((Component)((Object)this)), string2, (JPanel)confHSPPanel, (ActionListener)object, Util.getResourceString("warning_detach"));
    }

    protected Device[] getDevices() {
        Vector vector = Util.getApp().getServiceWrapper().getAllDependents(this.device);
        int n = vector.size() - 1;
        while (n >= 0) {
            Device device = (Device)vector.get(n);
            if ("Diskset".equals(device.getProperty("type"))) {
                vector.remove(n);
            }
            --n;
        }
        return vector.toArray(new Device[vector.size()]);
    }

    public void tableSelectionChanged(ListSelectionEvent listSelectionEvent) {
        this.setButtonState();
    }

    protected Component getMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        this.attachButton = new JButton();
        if (!Util.getApp().getServiceWrapper().hasVolMgrWriteAuth()) {
            this.attachButton.setEnabled(false);
        } else {
            this.attachButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HSPAssocTablePropertySheet.this.attachHSP();
                }
            });
        }
        Util.initButton(this.attachButton, "attach_hsp");
        jPanel.add(this.attachButton);
        this.detachButton = new JButton();
        this.detachButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HSPAssocTablePropertySheet.this.detachHSP();
            }
        });
        Util.initButton(this.detachButton, "detach_hsp");
        jPanel.add(this.detachButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add(super.getMainPanel(), "Center");
        jPanel2.add((Component)jPanel, "South");
        return jPanel2;
    }

    protected void refresh() {
        super.refresh();
        this.setButtonState();
    }
}

