/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.filter;

import com.sun.admin.volmgr.client.filter.DeviceFilterGUIPair;
import com.sun.admin.volmgr.client.ttk.Spinner;
import com.sun.admin.volmgr.client.ttk.text.LongSpinnerModel;
import com.sun.admin.volmgr.client.ttk.text.SpinnerDataModel;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.common.DeviceFilter;
import com.sun.admin.volmgr.common.LongDeviceFilter;
import com.sun.admin.volmgr.common.SizeDeviceFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SizeDeviceFilterGUIPair
extends JPanel
implements DeviceFilterGUIPair {
    private static final String TITLE = "SizeFilterItemGUI_title";
    private static final String[] operatorStrings = new String[]{Util.getResourceString("SizeFilterItemGUI_equals"), Util.getResourceString("SizeFilterItemGUI_doesnotequal"), Util.getResourceString("SizeFilterItemGUI_greater"), Util.getResourceString("SizeFilterItemGUI_greaterequal"), Util.getResourceString("SizeFilterItemGUI_less"), Util.getResourceString("SizeFilterItemGUI_lessequal")};
    private static final LongDeviceFilter.Operator[] operators = new LongDeviceFilter.Operator[]{LongDeviceFilter.ATTR_EQUALS, LongDeviceFilter.ATTR_DOES_NOT_EQUAL, LongDeviceFilter.ATTR_GREATER_THAN, LongDeviceFilter.ATTR_GREATER_THAN_EQUAL_TO, LongDeviceFilter.ATTR_LESS_THAN, LongDeviceFilter.ATTR_LESS_THAN_EQUAL_TO};
    private static final String[] unitStrings = new String[]{Util.getResourceString("SizeFilterItemGUI_blocks"), Util.getResourceString("SizeFilterItemGUI_kb"), Util.getResourceString("SizeFilterItemGUI_mb")};
    private static final long[] units = new long[]{1L, 2L, 2048L};
    private DeviceFilter filter;
    private JComboBox opCombo;
    private JTextField field;
    private Spinner spinner;
    private JComboBox unitCombo;

    public SizeDeviceFilterGUIPair() {
        this.initGUI();
    }

    protected Component getMainPanel() {
        this.opCombo = new JComboBox<String>(operatorStrings);
        this.opCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = SizeDeviceFilterGUIPair.this.opCombo.getSelectedIndex();
                LongDeviceFilter longDeviceFilter = (LongDeviceFilter)SizeDeviceFilterGUIPair.this.getDeviceFilter();
                longDeviceFilter.setOperator(operators[n]);
            }
        });
        this.opCombo.setSelectedIndex(0);
        LongSpinnerModel longSpinnerModel = new LongSpinnerModel(0L, Long.MAX_VALUE);
        this.field = new JTextField(7);
        this.spinner = new Spinner(this.field, (SpinnerDataModel)longSpinnerModel);
        this.field.getDocument().addDocumentListener(new DocumentListener(){

            private void update() {
                SizeDeviceFilterGUIPair.this.setFilterValue();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.update();
            }
        });
        this.unitCombo = new JComboBox<String>(unitStrings);
        this.unitCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SizeDeviceFilterGUIPair.this.setFilterValue();
            }
        });
        this.field.setText("0");
        this.unitCombo.setSelectedIndex(0);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)this.opCombo, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.spinner, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = 0;
        jPanel.add((Component)this.unitCombo, gridBagConstraints);
        return jPanel;
    }

    public void initGUI() {
        this.setLayout(new BorderLayout(15, 15));
        this.add(this.getMainPanel(), "Center");
    }

    private void setFilterValue() {
        LongDeviceFilter longDeviceFilter = (LongDeviceFilter)this.getDeviceFilter();
        long l = units[this.unitCombo.getSelectedIndex()];
        try {
            longDeviceFilter.setValue(l * Long.parseLong(this.field.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getTitle() {
        return TITLE;
    }

    public Component getComponent() {
        return this;
    }

    public void clear() {
        this.field.setText("0");
    }

    public synchronized void setSelected(boolean bl) {
        this.getDeviceFilter().setSelected(bl);
        this.opCombo.setEnabled(bl);
        this.spinner.setEnabled(bl);
        this.unitCombo.setEnabled(bl);
    }

    public synchronized boolean getSelected() {
        return this.getDeviceFilter().getSelected();
    }

    public synchronized DeviceFilter getDeviceFilter() {
        if (this.filter == null) {
            this.filter = new SizeDeviceFilter();
        }
        return this.filter;
    }
}

