/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.disksets;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.volmgr.client.Content;
import com.sun.admin.volmgr.client.VVolMgr;
import com.sun.admin.volmgr.client.disksets.ConfDiskSetPanel;
import com.sun.admin.volmgr.client.disksets.DiskSetFilterControl;
import com.sun.admin.volmgr.client.disksets.VMgrDiskSetsMenuBar;
import com.sun.admin.volmgr.client.disksets.VMgrDiskSetsTBar;
import com.sun.admin.volmgr.client.util.GUIUtil;
import com.sun.admin.volmgr.client.util.HelpCache;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.common.Device;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VFilter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.tree.MutableTreeNode;

public class DiskSetsContent
extends Content {
    private static String[][] columnHeaders = null;
    private VFilter filterControl;
    private boolean stopped = false;

    public DiskSetsContent() {
        this.sortPreferencesKey = this.getClass().getName() + ".sortPreferences";
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)VMgrDiskSetsMenuBar.getMenuBar(this));
        this.rootNode.setToolBar((JToolBar)VMgrDiskSetsTBar.getToolBar(this));
        try {
            this.listProperties = new ListProperties();
            this.listProperties.setFilters(new Vector());
        }
        catch (AdminException adminException) {
            Util.getApp().reportErrorException((Exception)((Object)adminException));
        }
    }

    public String[][] getColumnHeaders() {
        if (columnHeaders == null) {
            Object[][] objectArray = new Object[][]{{Util.getResourceString("setnumber"), new Integer(16)}, {Util.getResourceString("owner"), new Integer(16)}};
            columnHeaders = this.constructColumnHeaders(objectArray);
        }
        return columnHeaders;
    }

    public Hashtable getColumnValues(Device device) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put(Util.getResourceString("setnumber"), device.getProperty("setnumber"));
        Device device2 = Util.getDiskSetOwner(device);
        String string = device2 == null ? Util.getResourceString("diskset_owner_none") : Util.getDeviceBaseName(device2);
        hashtable.put(Util.getResourceString("owner"), string);
        return hashtable;
    }

    public Device[] getDevices() {
        Vector vector = Util.getApp().getServiceWrapper().getDevices("Diskset", this.getListProperties());
        if (vector != null) {
            int n = vector.size() - 1;
            while (n >= 0) {
                Device device = (Device)vector.get(n);
                String string = Util.getDeviceBaseName(device);
                if (string != null && (string.equals("") || string.equals("*disks*"))) {
                    vector.remove(n);
                }
                --n;
            }
        }
        return vector.toArray(new Device[vector.size()]);
    }

    public void deleteSelected() {
        Serializable serializable;
        Device device;
        Object object;
        Object object2;
        String[] stringArray;
        String[] stringArray2;
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            Object object3;
            int n3;
            stringArray2 = (String[])vector.get(n);
            stringArray = (String[])stringArray2.getPayload();
            object2 = Util.getDeviceBaseName((Device)stringArray);
            object = Util.getApp().getServiceWrapper().getAntecedents((Device)stringArray, "DriveInDiskGroup");
            if (object != null) {
                int n4 = 0;
                n3 = ((Vector)object).size();
                while (n4 < n3) {
                    device = (Device)((Vector)object).get(n4);
                    object3 = Util.getDeviceBaseName(device);
                    arrayList.add(Util.getBasedir() + "usr/sbin/metaset -s " + (String)object2 + " -d -f " + (String)object3);
                    arrayList2.add(Util.getResourceString("diskset_delete_disk_cmd", object2));
                    ++n4;
                }
            }
            if ((serializable = Util.getApp().getServiceWrapper().getAntecedents((Device)stringArray, "HostInDiskGroup")) != null) {
                n3 = 0;
                int n5 = ((Vector)serializable).size();
                while (n3 < n5) {
                    object3 = (Device)((Vector)serializable).get(n3);
                    String string = Util.getDeviceBaseName((Device)object3);
                    arrayList.add(Util.getBasedir() + "usr/sbin/metaset -s " + (String)object2 + " -d -h " + string);
                    arrayList2.add(Util.getResourceString("diskset_delete_host_cmd", object2));
                    ++n3;
                }
            }
            ++n;
        }
        stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        stringArray = arrayList2.toArray(new String[arrayList2.size()]);
        object2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Util.executeCommands(stringArray2, stringArray);
            }
        };
        object = Util.getResourceString("sure_delete_diskset");
        serializable = new ConfDiskSetPanel(stringArray2, (String)object);
        String string = new String(Util.getResourceString("warning_delete_diskset"));
        device = new WarningDialog(GUIUtil.getAppFrame(), string, (JPanel)serializable, (ActionListener)object2, Util.getResourceString("warning_delete"));
    }

    public String whatAmI() {
        return Util.getResourceString("disksets");
    }

    public void updateStatusBar() {
        String string = Util.getResourceString("DiskSetsListContents", new Integer(this.getDataCache().size()));
        Util.getApp().setStatusBar(string);
    }

    public boolean isFilteringSupported() {
        return true;
    }

    public synchronized VFilter getFilterControl() {
        if (this.isFilteringSupported() && this.filterControl == null) {
            this.filterControl = new DiskSetFilterControl(this);
        }
        return this.filterControl;
    }

    public void appendToResultsPane(Device[] deviceArray) {
        Object object;
        Object object2;
        if (deviceArray.length == 0) {
            return;
        }
        ProgressPanel progressPanel = new ProgressPanel(GUIUtil.getAppFrame(), 2, 30, true, true);
        progressPanel.setTitle(Util.getResourceString("device_refresh_progress_title"));
        progressPanel.setRange(0, deviceArray.length);
        progressPanel.setVisible(true);
        progressPanel.setStopListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiskSetsContent.this.stopped = true;
            }
        });
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        int n = 0;
        while (n < deviceArray.length) {
            if (this.stopped) {
                this.stopped = false;
                break;
            }
            object2 = Util.getDeviceFullName(deviceArray[n]);
            object = Util.getResourceString("diskset_refresh_loading_device", object2);
            progressPanel.setText((String)object);
            progressPanel.setValue(n + 1);
            VMgrDiskSetsMenuBar vMgrDiskSetsMenuBar = VMgrDiskSetsMenuBar.getMenuBar(this);
            VScopeNode vScopeNode = new VScopeNode(null, null, null, null, null, vMgrDiskSetsMenuBar.getPopupMenu(), Util.getSmallIcon(deviceArray[n]), Util.getLargeIcon(deviceArray[n]), (String)object2, (String)object2, null, -1, (Object)deviceArray[n]);
            vScopeNode.setToolTipText(Util.getResourceString("tooltip_content_type") + " " + Util.getResourceString("Diskset") + "  " + Util.getResourceString("tooltip_content_name") + " " + (String)object2);
            vScopeNode.setHTMLText(HelpCache.getHelpText(deviceArray[n]));
            vScopeNode.setColumnValues(this.getColumnValues(deviceArray[n]));
            this.rootNode.add((MutableTreeNode)vScopeNode);
            this.vDataCache.addElement(deviceArray[n]);
            ++n;
        }
        object2 = Util.getApp();
        object = new VConsoleEvent(object2, "vconsole.updatescope", (Object)this.getTreeNode());
        ((VVolMgr)object2).fireConsoleAction((VConsoleEvent)object);
        progressPanel.dispose();
    }

    public void clear(boolean bl) {
        this.clearSelection();
        this.getDataCache().removeAllElements();
        System.gc();
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)VMgrDiskSetsMenuBar.getMenuBar(this));
        this.rootNode.setToolBar((JToolBar)VMgrDiskSetsTBar.getToolBar(this));
        this.getTreeNode().setInternalRoot(this.rootNode);
        if (bl) {
            VVolMgr vVolMgr = Util.getApp();
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)vVolMgr, "vconsole.updatescope", (Object)this.treeNode);
            vVolMgr.fireConsoleAction(vConsoleEvent);
        }
        this.bRefresh = true;
    }

    public void distributeReplicas() {
        Object object;
        Object object2;
        Object object3;
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        int n = vector.size();
        final String[] stringArray = new String[n];
        final String[] stringArray2 = new String[n];
        int n2 = 0;
        int n3 = vector.size();
        while (n2 < n3) {
            object3 = (VScopeNode)vector.get(n2);
            object2 = (Device)object3.getPayload();
            object = Util.getDeviceBaseName((Device)object2);
            stringArray[n2] = Util.getBasedir() + "usr/sbin/metaset -s " + (String)object + " -b";
            stringArray2[n2] = Util.getResourceString("diskset_dist_replicas_cmd", object);
            ++n2;
        }
        object3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Util.executeCommands(stringArray, stringArray2);
            }
        };
        object2 = Util.getResourceString("sure_dist_diskset_replicas");
        object = new ConfDiskSetPanel(stringArray, (String)object2);
        String string = new String(Util.getResourceString("warning_dist_diskset_replicas"));
        WarningDialog warningDialog = new WarningDialog(GUIUtil.getAppFrame(), string, (JPanel)object, (ActionListener)object3, Util.getResourceString("warning_distribute"));
    }

    public void releaseOwnership() {
        Object object;
        Object object2;
        Object object3;
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        int n = vector.size();
        final String[] stringArray = new String[n];
        final String[] stringArray2 = new String[n];
        int n2 = 0;
        int n3 = vector.size();
        while (n2 < n3) {
            object3 = (VScopeNode)vector.get(n2);
            object2 = (Device)object3.getPayload();
            object = Util.getDeviceBaseName((Device)object2);
            stringArray[n2] = Util.getBasedir() + "usr/sbin/metaset -s " + (String)object + " -r";
            stringArray2[n2] = Util.getResourceString("diskset_dist_replicas_cmd", object);
            ++n2;
        }
        object3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Util.executeCommands(stringArray, stringArray2);
            }
        };
        object2 = Util.getResourceString("sure_release_diskset");
        object = new ConfDiskSetPanel(stringArray, (String)object2);
        String string = new String(Util.getResourceString("warning_release_diskset"));
        WarningDialog warningDialog = new WarningDialog(GUIUtil.getAppFrame(), string, (JPanel)object, (ActionListener)object3, Util.getResourceString("warning_release"));
    }

    public void takeOwnership() {
        Object object;
        Object object2;
        Object object3;
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        int n = vector.size();
        final String[] stringArray = new String[n];
        final String[] stringArray2 = new String[n];
        int n2 = 0;
        int n3 = vector.size();
        while (n2 < n3) {
            object3 = (VScopeNode)vector.get(n2);
            object2 = (Device)object3.getPayload();
            object = Util.getDeviceBaseName((Device)object2);
            stringArray[n2] = Util.getBasedir() + "usr/sbin/metaset -s " + (String)object + " -t";
            stringArray2[n2] = Util.getResourceString("diskset_dist_replicas_cmd", object);
            ++n2;
        }
        object3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Util.executeCommands(stringArray, stringArray2);
            }
        };
        object2 = Util.getResourceString("sure_take_diskset");
        object = new ConfDiskSetPanel(stringArray, (String)object2);
        String string = new String(Util.getResourceString("warning_take_diskset"));
        WarningDialog warningDialog = new WarningDialog(GUIUtil.getAppFrame(), string, (JPanel)object, (ActionListener)object3, Util.getResourceString("warning_take"));
    }
}

