/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ChangeAppState;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.VCommonInfo;
import com.sun.admin.volmgr.client.ApplicationContext;
import com.sun.admin.volmgr.client.Content;
import com.sun.admin.volmgr.client.NavigationSelectionListener;
import com.sun.admin.volmgr.client.PerfmonServiceWrapper;
import com.sun.admin.volmgr.client.ServiceWrapper;
import com.sun.admin.volmgr.client.TreeNodeData;
import com.sun.admin.volmgr.client.VMgrRootTBar;
import com.sun.admin.volmgr.client.VolActionsListener;
import com.sun.admin.volmgr.client.VolMgrRefreshListener;
import com.sun.admin.volmgr.client.VolMgrTree;
import com.sun.admin.volmgr.client.disksets.VMgrDiskSetsMenuBar;
import com.sun.admin.volmgr.client.disksets.VMgrDiskSetsTBar;
import com.sun.admin.volmgr.client.hsps.VMgrHSPsMenuBar;
import com.sun.admin.volmgr.client.hsps.VMgrHSPsTBar;
import com.sun.admin.volmgr.client.metadb.VMgrMetadbMenuBar;
import com.sun.admin.volmgr.client.metadb.VMgrMetadbTBar;
import com.sun.admin.volmgr.client.util.GUIUtil;
import com.sun.admin.volmgr.client.volumes.VMgrVolumesMenuBar;
import com.sun.admin.volmgr.client.volumes.VMgrVolumesTBar;
import com.sun.admin.volmgr.common.VolException;
import com.sun.management.viper.CriticalStopException;
import com.sun.management.viper.Tool;
import com.sun.management.viper.ToolContext;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.VException;
import com.sun.management.viper.VIdentity;
import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VLogEvent;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VDisplayModel;
import com.sun.management.viper.util.ResourceManager;
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.Vector;

public class VVolMgr
implements Tool,
PropertyChangeListener,
VConsoleActionListener {
    private ServiceWrapper wrapper;
    private PerfmonServiceWrapper perfVolMgr;
    private VConsoleProperties properties = null;
    private VDisplayModel displayModel = null;
    private ApplicationContext appContext = null;
    private ToolInfrastructure infrastructure = null;
    private boolean bRunning = false;
    private Vector consoleListeners = new Vector();
    private Vector navigationSelectionListeners = new Vector();
    private int busyCount = 0;
    private Component glassPane;
    private VolMgrTree tree;
    private ResourceBundle bundle;
    private ResourceBundle cisBundle;
    private AdminException initException;
    private Clipboard vmClipBoard = new Clipboard("vmgr");
    private static VVolMgr instance;
    private static VolMgrRefreshListener svmRefreshListener;

    public VVolMgr() {
        instance = this;
        try {
            this.bundle = ResourceManager.getBundle((String)"com.sun.admin.volmgr.client.resources.Resources", this.getClass());
        }
        catch (Exception exception) {
            this.reportErrorException(exception);
        }
        try {
            this.cisBundle = ResourceManager.getBundle((String)VCommonInfo.resourceClass, this.getClass());
        }
        catch (Exception exception) {
            this.reportErrorException(exception);
        }
        this.tree = new VolMgrTree();
    }

    public static VVolMgr getLastInstance() {
        return instance;
    }

    public ApplicationContext getApplicationContext() {
        return this.appContext;
    }

    public VConsoleProperties getProperties() {
        return this.properties;
    }

    public VDisplayModel getDisplayModel() {
        return this.displayModel;
    }

    public VolMgrTree getTree() {
        return this.tree;
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    public ResourceBundle getCisBundle() {
        return this.cisBundle;
    }

    public void setStatusBar(String string) {
        if (string.length() == 0) {
            string = " ";
        }
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.updateselinfo", (Object)string);
        this.fireConsoleAction(vConsoleEvent);
    }

    public void addConsoleActionListener(VConsoleActionListener vConsoleActionListener) {
        if (vConsoleActionListener != null) {
            this.consoleListeners.addElement(vConsoleActionListener);
        }
    }

    public void fireConsoleAction(VConsoleEvent vConsoleEvent) {
        int n = 0;
        while (n < this.consoleListeners.size()) {
            VConsoleActionListener vConsoleActionListener = (VConsoleActionListener)this.consoleListeners.elementAt(n);
            vConsoleActionListener.consoleAction(vConsoleEvent);
            ++n;
        }
    }

    public void addNavigationSelectionListener(NavigationSelectionListener navigationSelectionListener) {
        this.navigationSelectionListeners.addElement(navigationSelectionListener);
    }

    private void fireToolStopped() {
        int n = 0;
        while (n < this.navigationSelectionListeners.size()) {
            NavigationSelectionListener navigationSelectionListener = (NavigationSelectionListener)this.navigationSelectionListeners.elementAt(n);
            navigationSelectionListener.toolStopped();
            ++n;
        }
    }

    private void fireToolDestroyed() {
        int n = 0;
        while (n < this.navigationSelectionListeners.size()) {
            NavigationSelectionListener navigationSelectionListener = (NavigationSelectionListener)this.navigationSelectionListeners.elementAt(n);
            navigationSelectionListener.toolDestroyed();
            ++n;
        }
    }

    private void fireNavigationSelection(VConsoleEvent vConsoleEvent) {
        int n = 0;
        while (n < this.navigationSelectionListeners.size()) {
            NavigationSelectionListener navigationSelectionListener = (NavigationSelectionListener)this.navigationSelectionListeners.elementAt(n);
            navigationSelectionListener.valueChanged((VScopeNode)vConsoleEvent.getPayload());
            ++n;
        }
    }

    public VScopeNode getScopeNode() {
        return this.tree.getRootNode();
    }

    public VScopeNode getCurrentNode() {
        return this.tree.getCurrentNode();
    }

    public ServiceWrapper getServiceWrapper() {
        return this.wrapper;
    }

    public PerfmonServiceWrapper getPerfVolMgr() {
        return this.perfVolMgr;
    }

    public ToolInfrastructure getToolInfrastructure() {
        return this.infrastructure;
    }

    public Clipboard getClipBoard() {
        return this.vmClipBoard;
    }

    public String getAuthenticatedUser() {
        String string = null;
        VIdentity vIdentity = this.infrastructure.getIdentity();
        if (vIdentity != null) {
            string = vIdentity.getName();
        }
        return string;
    }

    public void reportErrorException(Exception exception) {
        VException vException;
        String string = "";
        while (exception != null) {
            if (exception instanceof VException) {
                vException = (VException)exception;
                string = string + "\n" + vException.getLocalizedMessage();
                if (vException.isEmbeddedException()) {
                    exception = vException.getEmbeddedException();
                    continue;
                }
                exception = null;
                continue;
            }
            string = string + "\n" + exception.getMessage();
            exception = null;
        }
        vException = new ErrorDialog(GUIUtil.getAppFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"ErrorTitle"), string);
    }

    public void init(ToolInfrastructure toolInfrastructure) throws CriticalStopException {
        this.infrastructure = toolInfrastructure;
        try {
            this.wrapper = this.appContext.getServiceWrapper(toolInfrastructure);
        }
        catch (AdminException adminException) {
            this.initException = adminException;
            String string = "<HTML><BODY>";
            string = string + ResourceStrings.getString((ResourceBundle)this.bundle, (String)"DESCRIPTION");
            string = string + "</p><p>" + adminException.getLocalizedMessage() + "</p>";
            string = string + "</BODY></HTML>";
            ChangeAppState.setErrorState((VScopeNode)this.getScopeNode(), (String)string);
            String string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"err_log_summary");
            String string3 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"err_log_message");
            String string4 = adminException.getLocalizedMessage();
            VLogEvent vLogEvent = new VLogEvent((Object)this, 30, new Date(), string2, string3, string4, (Throwable)adminException, null);
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.logevent", (Object)vLogEvent);
            this.fireConsoleAction(vConsoleEvent);
            return;
        }
        try {
            this.perfVolMgr = this.appContext.getPerfmonServiceWrapper(toolInfrastructure);
        }
        catch (AdminException adminException) {
            this.initException = adminException;
            String string = "<HTML><BODY>";
            string = string + ResourceStrings.getString((ResourceBundle)this.bundle, (String)"DESCRIPTION");
            string = string + "</p><p>" + adminException.getLocalizedMessage() + "</p>";
            string = string + "</BODY></HTML>";
            ChangeAppState.setErrorState((VScopeNode)this.getScopeNode(), (String)string);
            String string5 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"err_log_summary");
            String string6 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"err_log_message");
            String string7 = adminException.getLocalizedMessage();
            VLogEvent vLogEvent = new VLogEvent((Object)this, 30, new Date(), string5, string6, string7, (Throwable)adminException, null);
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.logevent", (Object)vLogEvent);
            this.fireConsoleAction(vConsoleEvent);
            return;
        }
        if (!this.wrapper.hasVolMgrReadAuth()) {
            String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"warn_log_detail");
            this.initException = new VolException(string);
            String string8 = "<HTML><BODY>";
            string8 = string8 + ResourceStrings.getString((ResourceBundle)this.bundle, (String)"DESCRIPTION");
            string8 = string8 + "</p><p>" + this.initException.getLocalizedMessage() + "</p>";
            string8 = string8 + "</BODY></HTML>";
            ChangeAppState.setWarningState((VScopeNode)this.getScopeNode(), (String)string8);
            String string9 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"warn_log_summary");
            String string10 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"warn_log_message");
            VLogEvent vLogEvent = new VLogEvent((Object)this, 20, new Date(), string9, string10, this.initException.getLocalizedMessage(), (Throwable)this.initException, null);
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.logevent", (Object)vLogEvent);
            this.fireConsoleAction(vConsoleEvent);
            return;
        }
        try {
            svmRefreshListener = new VolMgrRefreshListener(toolInfrastructure, "Refresh");
        }
        catch (Exception exception) {
            System.err.println("Unable to listen to SMC message channel Refresh: " + exception.getMessage());
        }
    }

    public void start() throws CriticalStopException {
        this.bRunning = true;
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.scopeselected", (Object)this.displayModel.getSelectedNavigationNode());
        this.fireNavigationSelection(vConsoleEvent);
    }

    public void stop() throws CriticalStopException {
        this.bRunning = false;
        this.fireToolStopped();
    }

    public void destroy() {
        this.fireToolDestroyed();
    }

    public int runCommandLine(String[] stringArray, InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        return -1;
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        this.properties = vConsoleProperties;
        if (vConsoleProperties != null) {
            VScopeNode vScopeNode;
            VScopeNode vScopeNode2;
            VScopeNode vScopeNode3;
            VScopeNode vScopeNode4;
            this.displayModel = (VDisplayModel)vConsoleProperties.getPropertyObject("vconsole.displaymodel");
            vConsoleProperties.addPropertyChangeListener((PropertyChangeListener)this);
            VScopeNode vScopeNode5 = this.getScopeNode();
            if (vScopeNode5 != null) {
                ((VMgrRootTBar)vScopeNode5.getToolBar()).setProperties(vConsoleProperties);
            }
            if ((vScopeNode4 = (VScopeNode)this.getScopeNode().getChildAt(0)) != null) {
                ((VMgrVolumesTBar)vScopeNode4.getToolBar()).setProperties(vConsoleProperties);
                ((VMgrVolumesMenuBar)vScopeNode4.getMenuBar()).setProperties(vConsoleProperties);
            }
            if ((vScopeNode3 = (VScopeNode)this.getScopeNode().getChildAt(1)) != null) {
                ((VMgrHSPsTBar)vScopeNode3.getToolBar()).setProperties(vConsoleProperties);
                ((VMgrHSPsMenuBar)vScopeNode3.getMenuBar()).setProperties(vConsoleProperties);
            }
            if ((vScopeNode2 = (VScopeNode)this.getScopeNode().getChildAt(2)) != null) {
                ((VMgrMetadbTBar)vScopeNode2.getToolBar()).setProperties(vConsoleProperties);
                ((VMgrMetadbMenuBar)vScopeNode2.getMenuBar()).setProperties(vConsoleProperties);
            }
            if ((vScopeNode = (VScopeNode)this.getScopeNode().getChildAt(3)) != null) {
                ((VMgrDiskSetsTBar)vScopeNode.getToolBar()).setProperties(vConsoleProperties);
                ((VMgrDiskSetsMenuBar)vScopeNode.getMenuBar()).setProperties(vConsoleProperties);
            }
        }
    }

    public void setToolContext(ToolContext toolContext) {
        this.appContext = new ApplicationContext(toolContext);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("vconsole.displaymodel")) {
            this.displayModel = (VDisplayModel)propertyChangeEvent.getNewValue();
        }
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
        if (!this.bRunning) {
            return;
        }
        String string = vConsoleEvent.getID();
        if (string.equals("vconsole.refresh")) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "FullRefresh");
            VolActionsListener volActionsListener = new VolActionsListener(false);
            volActionsListener.actionPerformed(actionEvent);
        } else if (string.equals("vconsole.sechelpselection")) {
            Vector vector = (Vector)vConsoleEvent.getPayload();
            TreeNodeData treeNodeData = (TreeNodeData)this.getCurrentNode().getPayload();
            Content content = treeNodeData.getContent();
            content.onSelection(vector);
        } else if (string.equals("vconsole.scopechildopened")) {
            TreeNodeData treeNodeData = (TreeNodeData)this.getCurrentNode().getPayload();
            Content content = treeNodeData.getContent();
            content.onDoubleClick();
        } else if (string.equals("vconsole.sortup") || string.equals("vconsole.sortdown")) {
            TreeNodeData treeNodeData = (TreeNodeData)this.getCurrentNode().getPayload();
            Content content = treeNodeData.getContent();
            content.saveSortPreferences();
        } else if (string.equals("vconsole.displayproperties")) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "ViewProps");
            VolActionsListener volActionsListener = new VolActionsListener(false);
            volActionsListener.actionPerformed(actionEvent);
        } else if (string.equals("vconsole.delete")) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "Delete");
            VolActionsListener volActionsListener = new VolActionsListener(false);
            volActionsListener.actionPerformed(actionEvent);
        }
    }
}

