/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client;

import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.volmgr.client.InterlacePanel;
import com.sun.admin.volmgr.client.StripeComponent;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.management.viper.console.gui.propsheet.VPropertySheet;
import java.awt.BorderLayout;
import java.awt.Component;

public class StripeInterlacePropertySheet
extends VPropertySheet {
    private InterlacePanel panel;
    private StripeComponent stripe;

    public StripeInterlacePropertySheet(String string) {
        this.setTitle(Util.getResourceString("general_props_tab"));
        this.setHelpHTML(string);
        FlowArea flowArea = new FlowArea(Util.getResourceString("add_wiz_interlace_header"));
        this.panel = new InterlacePanel();
        this.setLayout(new BorderLayout(15, 15));
        this.add((Component)flowArea, "North");
        this.add(this.panel, "Center");
    }

    public StripeInterlacePropertySheet(String string, StripeComponent stripeComponent) {
        this(string);
        this.setStripeComponent(stripeComponent);
    }

    public void setStripeComponent(StripeComponent stripeComponent) {
        this.stripe = stripeComponent;
        this.panel.setInterlaceInBlocks(stripeComponent.getInterlaceInBlocks());
    }

    public StripeComponent getStripeComponent() {
        return this.stripe;
    }

    public boolean apply() {
        if (!this.panel.isValidInterlace()) {
            Util.DeviceSize deviceSize = Util.getSizeInGreatestUnits(16L, 1001);
            Util.DeviceSize deviceSize2 = Util.getSizeInGreatestUnits(204800L, 1001);
            Object[] objectArray = new Object[]{Util.getUnitText(deviceSize.size, deviceSize.units), Util.getUnitText(deviceSize2.size, deviceSize2.units)};
            String string = Util.getResourceString("invalid_interlace_value", objectArray);
            new ErrorDialog(null, string);
            return false;
        }
        this.getStripeComponent().setInterlaceInBlocks(this.panel.getInterlaceInBlocks());
        return true;
    }

    public void reset() {
    }

    public void start() {
    }

    public boolean stop() {
        return true;
    }
}

