/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client;

import com.sun.admin.volmgr.client.StripeInterlacePropertySheetEditor;
import com.sun.admin.volmgr.client.StripeRowGroup;
import com.sun.admin.volmgr.client.ttk.icon.BracketIcon;
import com.sun.admin.volmgr.client.util.GUIUtil;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.management.viper.console.gui.VFrame;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class StripeComponent
extends JPanel {
    private StripeRowGroup group;
    private JLabel stripeLabel;
    private StripeInterlacePropertySheetEditor editor;
    private VFrame interlaceDialog;

    public StripeComponent(StripeRowGroup stripeRowGroup) {
        this.group = stripeRowGroup;
        BracketIcon bracketIcon = new BracketIcon(Util.getSmallIcon("Stripe"));
        bracketIcon.setStretch(true);
        this.stripeLabel = new JLabel(Util.getResourceString("Stripe"));
        this.stripeLabel.setIcon(bracketIcon);
        this.stripeLabel.setHorizontalTextPosition(2);
        this.stripeLabel.setIconTextGap(10);
        this.stripeLabel.setCursor(Cursor.getPredefinedCursor(12));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.right = 10;
        this.setLayout(new GridBagLayout());
        JButton jButton = new JButton("...");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VFrame vFrame = StripeComponent.this.getInterlaceDialog();
                StripeComponent.this.editor.setStripeComponent(StripeComponent.this);
                StripeComponent.this.editor.setVisible(true);
            }
        });
        Border border = jButton.getBorder();
        if (border instanceof CompoundBorder) {
            jButton.setBorder(((CompoundBorder)border).getOutsideBorder());
        }
        this.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.stripeLabel, gridBagConstraints);
        this.updateToolTip();
    }

    public void setInterlaceInBlocks(long l) {
        this.group.setInterlaceInBlocks(l);
        this.updateToolTip();
    }

    public long getInterlaceInBlocks() {
        return this.group.getInterlaceInBlocks();
    }

    public synchronized VFrame getInterlaceDialog() {
        if (this.interlaceDialog == null) {
            this.interlaceDialog = new VFrame();
            Util.makeModal(GUIUtil.getParentJFrame(this), (Window)this.interlaceDialog);
            this.editor = new StripeInterlacePropertySheetEditor();
            this.editor.setContainer((Component)this.interlaceDialog);
            this.interlaceDialog.showCenter((Component)GUIUtil.getAppFrame());
            this.editor.start();
            this.interlaceDialog.setSize(new Dimension(500, 300));
        }
        return this.interlaceDialog;
    }

    protected void updateToolTip() {
        Util.DeviceSize deviceSize = Util.getSizeInGreatestUnits(this.getInterlaceInBlocks(), 1001);
        this.stripeLabel.setToolTipText(Util.getResourceString("volume_add_wiz_review_interlace_label") + Util.getUnitText(deviceSize.size, deviceSize.units));
    }

    public void addStripeListener(MouseListener mouseListener) {
        this.stripeLabel.addMouseListener(mouseListener);
    }

    public void removeStripeListener(MouseListener mouseListener) {
        this.stripeLabel.removeMouseListener(mouseListener);
    }
}

