/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client;

import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.volmgr.common.Device;
import com.sun.admin.volmgr.common.util.CommandResult;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.VPermission;
import com.sun.management.viper.services.Authorization;
import com.sun.management.viper.services.ServiceList;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.util.Vector;

public abstract class ServiceWrapper {
    public static final String VOLMGR_WRITE_RIGHT = "solaris.admin.volmgr.write";
    public static final String VOLMGR_READ_RIGHT = "solaris.admin.volmgr.read";
    protected PermissionCollection permissionCollection;

    public void init(Object object, Object object2) throws Exception {
        ToolInfrastructure toolInfrastructure = (ToolInfrastructure)object2;
        Authorization authorization = (Authorization)toolInfrastructure.getServiceByName(ServiceList.AUTHORIZATION);
        try {
            this.permissionCollection = authorization.readUserPermissions((Principal)toolInfrastructure.getIdentity());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean hasVolMgrWriteAuth() {
        try {
            if (this.permissionCollection == null) {
                return false;
            }
            VPermission vPermission = new VPermission(VOLMGR_WRITE_RIGHT);
            if (this.permissionCollection.implies((Permission)vPermission)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean hasVolMgrReadAuth() {
        try {
            if (this.permissionCollection == null) {
                return false;
            }
            VPermission vPermission = new VPermission(VOLMGR_READ_RIGHT);
            if (this.permissionCollection.implies((Permission)vPermission)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public abstract Device[] getAvailableSlices(Device var1);

    public abstract String getBasedir();

    public abstract CommandResult[] exec(String[] var1);

    public abstract Vector getAvailableDisks();

    public abstract Vector getAllAntecedents(Device var1);

    public abstract Vector getAllDependents(Device var1);

    public abstract Vector getAntecedents(Device var1, String var2);

    public abstract Vector getDependents(Device var1, String var2);

    public abstract Vector getDevices(String var1);

    public abstract Vector getDevices(String var1, ListProperties var2);

    public abstract Device[] getDevicesAvailableForUseAs(String var1, String var2);

    public abstract Device[] getDevicesAvailableForAttach(String var1, String var2);

    public abstract int[] getUsedVolumeNumbers(String var1);

    public abstract int[] getUsedHspNumbers(String var1);

    public abstract void flushDeviceCache();

    public abstract boolean canCreateSps(Device var1, int var2, long var3);

    public abstract long getFreeSpace(Device var1);

    public abstract int getNumberOfPossibleSps(Device var1, long var2);

    public abstract long getPosssibleSpSize(Device var1, int var2);
}

