/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client;

import com.sun.admin.volmgr.client.GeneralPropertySheet;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.common.Device;
import javax.swing.Icon;
import javax.swing.JLabel;

public class GeneralDevicePropertySheet
extends GeneralPropertySheet {
    private static final String TITLE = "general_props_tab";
    private static final String BORDERTITLE = "device_info_props_title";
    private Device device;
    private Icon icon;
    private String diskset;
    private JLabel nameValue;
    private JLabel typeValue;
    private JLabel disksetValue;

    public GeneralDevicePropertySheet(Device device, String string) {
        super(TITLE, string, BORDERTITLE);
        this.device = device;
        this.icon = Util.getLargeIcon(device);
    }

    public Device getDevice() {
        return this.device;
    }

    public String getDeviceName() {
        return Util.getDeviceBaseName(this.device);
    }

    public String getDeviceType() {
        return Util.getResourceString((String)this.device.getProperty("type"));
    }

    public synchronized String getDeviceDiskSet() {
        if (this.diskset == null) {
            this.diskset = Util.getDisplayableDiskSetName(this.device);
        }
        return this.diskset;
    }

    protected GeneralPropertySheet.LabeledComponent[] getLabeledComponents() {
        this.nameValue = new JLabel();
        this.typeValue = new JLabel();
        this.disksetValue = new JLabel();
        return new GeneralPropertySheet.LabeledComponent[]{new GeneralPropertySheet.LabeledComponent("name_prop", this.nameValue), new GeneralPropertySheet.LabeledComponent("type_prop", this.typeValue), new GeneralPropertySheet.LabeledComponent("diskset_prop", this.disksetValue)};
    }

    protected Icon getMainIcon() {
        return this.icon;
    }

    protected void refresh() {
        this.nameValue.setText(this.getDeviceName());
        this.typeValue.setText(this.getDeviceType());
        this.disksetValue.setText(this.getDeviceDiskSet());
    }
}

