/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client;

import com.sun.admin.volmgr.client.DeviceTable;
import com.sun.admin.volmgr.client.DeviceTableModel;
import com.sun.admin.volmgr.client.SimplePropertySheet;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.common.Device;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class DeviceTablePropertySheet
extends SimplePropertySheet {
    protected JTable table;
    protected DeviceTableModel model;
    protected String[] propKeys;

    public DeviceTablePropertySheet(String string, String string2) {
        this(string, string2, null);
    }

    public DeviceTablePropertySheet(String string, String string2, String[] stringArray) {
        super(string, string2);
        this.propKeys = stringArray;
    }

    protected abstract Device[] getDevices();

    protected void tableSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    protected Component getMainPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.model = this.propKeys == null ? new DeviceTableModel(new Device[0]) : new DeviceTableModel(new Device[0], this.propKeys);
        this.table = new DeviceTable(this.model);
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    int[] nArray = DeviceTablePropertySheet.this.table.getSelectedRows();
                    if (nArray.length != 1) {
                        return;
                    }
                    Device device = (Device)DeviceTablePropertySheet.this.model.getRow(nArray[0]);
                    Util.viewProperties(device);
                }
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                DeviceTablePropertySheet.this.tableSelectionChanged(listSelectionEvent);
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.table);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBackground(this.table.getBackground());
        jPanel2.add(jScrollPane);
        jPanel.add((Component)jPanel2, "Center");
        jScrollPane.getViewport().setBackground(this.table.getBackground());
        return jPanel;
    }

    protected void refresh() {
        this.model.removeAllRows();
        this.model.addRows(this.getDevices());
    }
}

