/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client;

import com.sun.admin.volmgr.client.ttk.table.ManagedRowTableModel;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.common.Device;
import java.util.HashMap;

public class DeviceTableModel
extends ManagedRowTableModel {
    private static String[] _PROPKEYS = new String[]{"name", "type", "size"};
    protected String[] propKeys;
    protected HashMap cache = new HashMap();

    public DeviceTableModel(Device[] deviceArray, String[] stringArray) {
        super(deviceArray, DeviceTableModel.propKeysToColumnNames(stringArray));
        this.propKeys = stringArray;
    }

    public DeviceTableModel(Device[] deviceArray) {
        this(deviceArray, _PROPKEYS);
    }

    public synchronized void clearCache() {
        this.cache.clear();
    }

    public synchronized boolean moveRowsDown(int n, int n2) {
        this.clearCache();
        return super.moveRowsDown(n, n2);
    }

    public synchronized boolean moveRowsTo(int n, int n2, int n3) {
        this.clearCache();
        return super.moveRowsTo(n, n2, n3);
    }

    public synchronized boolean moveRowsUp(int n, int n2) {
        this.clearCache();
        return super.moveRowsUp(n, n2);
    }

    public synchronized void removeAllRows() {
        this.clearCache();
        super.removeAllRows();
    }

    public synchronized void removeRow(int n) {
        this.clearCache();
        super.removeRow(n);
    }

    public synchronized void removeRows(int n, int n2) {
        this.clearCache();
        super.removeRows(n, n2);
    }

    public synchronized Object getValueAt(int n, int n2) {
        Object[] objectArray = null;
        String string = n + "x" + n2;
        if (this.cache.containsKey(string)) {
            objectArray = (Object[])this.cache.get(string);
        } else {
            try {
                boolean bl = "name".equals(this.propKeys[n2]);
                Device device = (Device)this.getRow(n);
                objectArray = Util.formatProperty(device, this.propKeys[n2]);
                if (bl) {
                    objectArray = new Object[]{objectArray, Util.getSmallIcon(device)};
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cache.put(string, objectArray);
        }
        return objectArray;
    }

    private static String[] propKeysToColumnNames(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = Util.getResourceString(stringArray[n].replace(' ', '_'));
            ++n;
        }
        return stringArray2;
    }
}

