/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.volmgr.client.PerfmonServiceWrapper;
import com.sun.admin.volmgr.client.ServiceWrapper;
import com.sun.admin.volmgr.client.ViperServiceWrapper;
import com.sun.admin.volmgr.client.WbemPerfmonServiceWrapper;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.common.VolException;
import com.sun.admin.volmgr.server.SVMServicesIF;
import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.ToolContext;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.client.ExternalClientList;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.client.CIMClient;
import javax.wbem.client.CIMSecurityException;

public class ApplicationContext {
    private ToolContext toolContext;

    public ApplicationContext(ToolContext toolContext) {
        this.toolContext = toolContext;
    }

    public String getManagementServerName() {
        AdminMgmtScope adminMgmtScope = (AdminMgmtScope)this.toolContext.getParameter("ToolContext.MGMTSCOPE");
        return adminMgmtScope.getMgmtServerName();
    }

    private String getServiceType() {
        String string = "Viper";
        try {
            String string2 = System.getProperty("volmgr.serviceType");
            if (string2 != null) {
                string = string2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public ServiceWrapper getServiceWrapper(ToolInfrastructure toolInfrastructure) throws AdminException {
        String string = this.getServiceType();
        String string2 = "com.sun.admin.volmgr.client." + string + "ServiceWrapper";
        ServiceWrapper serviceWrapper = null;
        try {
            serviceWrapper = (ServiceWrapper)Class.forName(string2).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new VolException("EXM_GUI_SERVICE_NOT_REACHABLE", string, Util.getResourceString("BEANNAME"), string2);
        }
        catch (Exception exception) {
            VolException volException = new VolException("EXM_GUI_CANT_GET_SERVICE_WRAPPER", string, Util.getResourceString("BEANNAME"), string2);
            volException.addArg(exception.getMessage());
            throw volException;
        }
        try {
            if (serviceWrapper instanceof ViperServiceWrapper) {
                SVMServicesIF sVMServicesIF = (SVMServicesIF)toolInfrastructure.getServiceByName("com.sun.admin.volmgr.server.SVMServices");
                serviceWrapper.init(sVMServicesIF, toolInfrastructure);
            }
        }
        catch (Exception exception) {
            throw new VolException("EXM_GUI_CANT_CONNECT_TO_SERVER", Util.getResourceString("BEANNAME"), exception.getMessage());
        }
        return serviceWrapper;
    }

    private String getPerfmonServiceType() {
        String string = "Wbem";
        try {
            String string2 = System.getProperty("volmgr.perfmonServiceType");
            if (string2 != null) {
                string = string2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public PerfmonServiceWrapper getPerfmonServiceWrapper(ToolInfrastructure toolInfrastructure) throws AdminException {
        String string = this.getPerfmonServiceType();
        String string2 = "com.sun.admin.volmgr.client." + string + "PerfmonServiceWrapper";
        PerfmonServiceWrapper perfmonServiceWrapper = null;
        try {
            perfmonServiceWrapper = (PerfmonServiceWrapper)Class.forName(string2).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new VolException("EXM_GUI_SERVICE_NOT_REACHABLE", string, Util.getResourceString("BEANNAME"), string2);
        }
        catch (Exception exception) {
            VolException volException = new VolException("EXM_GUI_CANT_GET_SERVICE_WRAPPER", string, Util.getResourceString("BEANNAME"), string2);
            volException.addArg(exception.getMessage());
            throw volException;
        }
        int n = 2;
        int n2 = 1;
        while (n2 <= n) {
            block13: {
                try {
                    if (perfmonServiceWrapper instanceof WbemPerfmonServiceWrapper) {
                        String string3 = toolInfrastructure.getIdentity().getAuthenHost();
                        CIMNameSpace cIMNameSpace = new CIMNameSpace(string3, "root\\cimv2");
                        Object[] objectArray = new Object[]{cIMNameSpace, new String("cim-rmi")};
                        CIMClient cIMClient = (CIMClient)toolInfrastructure.getExternalClient(ExternalClientList.JAVAXWBEM, objectArray);
                        perfmonServiceWrapper.init(cIMClient, toolInfrastructure);
                        break;
                    }
                }
                catch (CIMSecurityException cIMSecurityException) {
                    String string4 = cIMSecurityException.getID();
                    if (string4.equals("CIM_ERR_ACCESS_DENIED")) {
                        throw new VolException("EXM_CIM_ERR_ACCESS_DENIED");
                    }
                    if (string4.equals("INVALID_CREDENTIAL")) {
                        throw new VolException("EXM_INVALID_CREDENTIAL");
                    }
                    if (string4.equals("NO_SUCH_PRINCIPAL")) {
                        throw new VolException("EXM_NO_SUCH_PRINCIPAL");
                    }
                    if (string4.equals("CANNOT_ASSUME_ROLE")) {
                        throw new VolException("EXM_CANNOT_ASSUME_ROLE");
                    }
                    throw new VolException("EXM_GENERIC_CIMSEC");
                }
                catch (Exception exception) {
                    if (exception.getMessage().equals("TIMED_OUT") && n2 <= n) break block13;
                    if (exception.getMessage().equals("NO_CIMOM")) {
                        throw new VolException("EXM_GUI_CANT_CONNECT_NO_CIMOM", Util.getResourceString("BEANNAME"));
                    }
                    throw new VolException("EXM_GUI_CANT_CONNECT_TO_SERVER", Util.getResourceString("BEANNAME"), exception.getMessage());
                }
            }
            ++n2;
        }
        return perfmonServiceWrapper;
    }
}

