/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.server;

import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.volmgr.common.Device;
import com.sun.admin.volmgr.common.DeviceFilter;
import com.sun.admin.volmgr.common.DeviceProperties;
import com.sun.admin.volmgr.common.util.Command;
import com.sun.admin.volmgr.common.util.CommandResult;
import com.sun.admin.volmgr.server.SVM;
import com.sun.admin.volmgr.server.SVMEvent;
import com.sun.admin.volmgr.server.SVMEventListener;
import com.sun.admin.volmgr.server.SVMRefreshMessenger;
import com.sun.admin.volmgr.server.SVMServicesIF;
import com.sun.management.viper.CriticalStopException;
import com.sun.management.viper.ServiceInfrastructure;
import com.sun.management.viper.VException;
import com.sun.management.viper.VIdentity;
import com.sun.management.viper.VMessage;
import com.sun.management.viper.VService;
import com.sun.management.viper.services.Authorization;
import com.sun.management.viper.services.Log;
import com.sun.management.viper.services.LogException;
import com.sun.management.viper.services.MessageException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class SVMServices
extends VService
implements SVMServicesIF {
    private static final String MSGRESOURCECLASS = "com.sun.admin.volmgr.common.resources.LogMessages";
    private SVM svm = SVM.instance();
    private SVMRefreshMessenger messenger;
    private Log logSvc;
    private Authorization authsvc;
    private VIdentity userIdent;
    static /* synthetic */ Class class$com$sun$management$viper$services$Log;

    public void init(ServiceInfrastructure serviceInfrastructure) throws CriticalStopException {
        super.init(serviceInfrastructure);
        Log log = this.getLogSvc();
        try {
            this.messenger = new SVMRefreshMessenger(serviceInfrastructure, "Refresh");
            this.svm.addEventListener(new SVMEventListener(){

                public void handleSVMEvent(SVMEvent sVMEvent) {
                    VMessage vMessage = new VMessage("Refresh Server", "Refresh", new Date(), (Object)sVMEvent);
                    try {
                        SVMServices.this.messenger.sendMessage(vMessage);
                    }
                    catch (MessageException messageException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception exception) {
            try {
                this.writeLog(300, "LM_3000", "LM_3000", null, null);
            }
            catch (LogException logException) {
                // empty catch block
            }
        }
    }

    public boolean canCreateSps(Device device, int n, long l) throws RemoteException {
        return this.svm.canCreateSps(device, n, l);
    }

    public String getBasedir() throws RemoteException {
        return this.svm.getBasedir();
    }

    public Vector getAvailableDisks() throws RemoteException {
        return this.svm.getAvailableDisks();
    }

    public Device[] getAvailableSlices(Device device) throws RemoteException {
        return this.svm.getAvailableSlices(device);
    }

    public CommandResult[] exec(String[] stringArray, boolean bl) throws RemoteException {
        Command command = new Command(stringArray);
        command.exec(bl);
        return command.getResults();
    }

    public Vector getAllAntecedents(Device device) throws RemoteException {
        return this.svm.getAllAntecedents(device);
    }

    public Vector getAllDependents(Device device) throws RemoteException {
        return this.svm.getAllDependents(device);
    }

    public Vector getAntecedents(Device device, String string) throws RemoteException {
        return this.svm.getAntecedents(device, string);
    }

    public Vector getDependents(Device device, String string) throws RemoteException {
        return this.svm.getDependents(device, string);
    }

    public Vector getDevices(String string) throws RemoteException {
        return this.svm.getDevices(string);
    }

    public Device updateState(Device device) throws RemoteException {
        return this.svm.updateState(device);
    }

    public Vector getDevices(String string, ListProperties listProperties) throws RemoteException {
        return this.getFilteredDevices(this.svm.getDevices(string), listProperties);
    }

    public long getFreeSpace(Device device) throws RemoteException {
        return this.svm.getFreeSpace(device);
    }

    public int getNumberOfPossibleSps(Device device, long l) throws RemoteException {
        return this.svm.getNumberOfPossibleSps(device, l);
    }

    public long getPosssibleSpSize(Device device, int n) throws RemoteException {
        return this.svm.getPossibleSpSize(device, n);
    }

    public int[] getUsedVolumeNumbers(String string) {
        if (string == null) {
            string = "";
        }
        Vector vector = new Vector();
        this.getDeviceNames("Concat", string, vector);
        this.getDeviceNames("Stripe", string, vector);
        this.getDeviceNames("Mirror", string, vector);
        this.getDeviceNames("Raid", string, vector);
        this.getDeviceNames("Trans", string, vector);
        this.getDeviceNames("SoftPartition", string, vector);
        int[] nArray = new int[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.get(n);
            int n2 = string2.lastIndexOf("d");
            if (n2 != -1) {
                String string3 = string2.substring(++n2);
                nArray[n] = Integer.valueOf(string3);
            }
            ++n;
        }
        return nArray;
    }

    public int[] getUsedHspNumbers(String string) {
        if (string == null) {
            string = "";
        }
        Vector vector = new Vector();
        this.getDeviceNames("Hsp", string, vector);
        int[] nArray = new int[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.get(n);
            int n2 = string2.lastIndexOf("p");
            if (n2 != -1) {
                String string3 = string2.substring(++n2);
                nArray[n] = Integer.valueOf(string3);
            }
            ++n;
        }
        return nArray;
    }

    private void getDeviceNames(String string, String string2, Vector vector) {
        Vector vector2 = null;
        try {
            vector2 = this.svm.getDevices(string);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (vector2 != null) {
            int n = 0;
            while (n < vector2.size()) {
                String string3;
                Device device = (Device)vector2.get(n);
                String string4 = this.getDiskSetName(device);
                if (string4 != null && string4.equals(string2) && (string3 = (String)device.getProperty("name")) != null) {
                    vector.add(string3);
                }
                ++n;
            }
        }
    }

    private String getDiskSetName(Device device) {
        if (device == null) {
            return null;
        }
        Boolean bl = (Boolean)device.getProperty("top level device");
        if (bl != null && bl.booleanValue()) {
            String string = (String)device.getProperty("type");
            String string2 = "ExtentInDiskGroup";
            if (string.equals("Hsp")) {
                string2 = "ExtentRedundancyComponent";
            }
            Vector vector = null;
            try {
                vector = this.svm.getDependents(device, string2);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (vector != null) {
                int n = 0;
                while (n < vector.size()) {
                    Device device2 = (Device)vector.get(n);
                    string = (String)device2.getProperty("type");
                    if (string.equals("Diskset")) {
                        return (String)device2.getProperty("name");
                    }
                    ++n;
                }
            }
            return null;
        }
        String string = (String)device.getProperty("trans component type");
        String string3 = "BasedOn";
        if (string != null && string.equals("log")) {
            string3 = "TransLogOn";
        }
        Vector vector = null;
        try {
            vector = this.svm.getDependents(device, string3);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (vector != null && vector.size() > 0) {
            return this.getDiskSetName((Device)vector.get(0));
        }
        return null;
    }

    public Device[] getDevicesAvailableForAttach(String string, String string2) throws RemoteException {
        Device device;
        if (!("Concat".equals(string) || "Stripe".equals(string) || "Raid".equals(string))) {
            throw new RemoteException("Invalid type: " + string);
        }
        if (string2 == null) {
            string2 = "";
        }
        if ((device = this.getDiskset(string2)) == null) {
            return new Device[0];
        }
        Vector<Device> vector = new Vector<Device>();
        Device[] deviceArray = this.getAvailableSlices(device);
        int n = 0;
        while (n < deviceArray.length) {
            Device device2 = deviceArray[n];
            if (this.useSliceForMD(device2, string)) {
                if (string.equals("Concat")) {
                    String string3 = (String)device2.getProperty("mountpoint");
                    if (string3 == null || string3.length() == 0) {
                        vector.add(device2);
                    }
                } else {
                    vector.add(device2);
                }
            }
            ++n;
        }
        this.getAvailableSliceBasedSPs(string2, vector);
        return vector.toArray(new Device[vector.size()]);
    }

    public Device[] getDevicesAvailableForUseAs(String string, String string2) throws RemoteException {
        if (string.equals("Diskset")) {
            Vector vector = this.getAvailableDisks();
            ArrayList<Device> arrayList = new ArrayList<Device>();
            if (vector != null) {
                int n = 0;
                while (n < vector.size()) {
                    Device device = (Device)vector.get(n);
                    Vector vector2 = this.getAntecedents(device, "ResidesOn");
                    boolean bl = false;
                    if (vector2 != null) {
                        int n2 = 0;
                        while (n2 < vector2.size()) {
                            Device device2 = (Device)vector2.get(n2);
                            String string3 = (String)device2.getProperty("mountpoint");
                            if (string3 != null && string3.length() > 0) {
                                bl = true;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (!bl) {
                        arrayList.add(device);
                    }
                    ++n;
                }
            }
            return arrayList.toArray(new Device[arrayList.size()]);
        }
        if (string2 == null) {
            return new Device[0];
        }
        Device device = this.getDiskset(string2);
        if (device == null && !string.equals("Metadb")) {
            return new Device[0];
        }
        Vector<Cloneable> vector = new Vector<Cloneable>();
        if (string.equals("Metadb")) {
            Device[] deviceArray = this.getAvailableSlices(device);
            int n = 0;
            while (n < deviceArray.length) {
                Device device3 = deviceArray[n];
                if (this.useSliceForDB(device3)) {
                    vector.add(device3);
                }
                ++n;
            }
        } else if (string.equals("Concat") || string.equals("Stripe") || string.equals("Raid") || string.equals("Hsp")) {
            Device[] deviceArray = this.getAvailableSlices(device);
            int n = 0;
            while (n < deviceArray.length) {
                Device device4 = deviceArray[n];
                if (this.useSliceForMD(device4, string)) {
                    vector.add(device4);
                }
                ++n;
            }
            if (!string.equals("Hsp")) {
                this.getAvailableSliceBasedSPs(string2, vector);
            }
        } else if (string.equals("Trans") || string.equals("master")) {
            String string4;
            Vector vector3 = this.getAntecedents(device, "ExtentInDiskGroup");
            if (vector3 != null) {
                int n = 0;
                while (n < vector3.size()) {
                    Device device5 = (Device)vector3.get(n);
                    string4 = (String)device5.getProperty("type");
                    if (string4.equals("Raid") || string4.equals("Mirror") || string4.equals("Stripe") || string4.equals("Concat")) {
                        Vector vector4 = this.getDependents(device5, "ResidesOn");
                        Vector vector5 = this.getDependents(device5, "BasedOn");
                        if ((vector4 == null || vector4.isEmpty()) && (vector5 == null || vector5.isEmpty())) {
                            vector.addElement(device5);
                        }
                    }
                    ++n;
                }
            }
            Device[] deviceArray = this.getDevicesAvailableForUseAs("Concat", string2);
            int n = 0;
            while (n < deviceArray.length) {
                string4 = (String)deviceArray[n].getProperty("mountpoint");
                if (string4 == null || !string4.equals("swap")) {
                    vector.add(deviceArray[n]);
                }
                ++n;
            }
        } else if (string.equals("log")) {
            Vector vector6 = this.getAntecedents(device, "ExtentInDiskGroup");
            if (vector6 != null) {
                int n = 0;
                while (n < vector6.size()) {
                    Device device6 = (Device)vector6.get(n);
                    String string5 = (String)device6.getProperty("type");
                    if (string5.equals("Raid") || string5.equals("Mirror") || string5.equals("Stripe") || string5.equals("Concat")) {
                        String string6;
                        Vector vector7 = this.getDependents(device6, "ResidesOn");
                        Vector vector8 = this.getDependents(device6, "BasedOn");
                        if (!(vector7 != null && !vector7.isEmpty() || vector8 != null && !vector8.isEmpty() || (string6 = (String)device6.getProperty("mountpoint")) != null && string6.length() != 0)) {
                            vector.addElement(device6);
                        }
                    }
                    ++n;
                }
            }
            Device[] deviceArray = this.getDevicesAvailableForUseAs("Raid", string2);
            int n = 0;
            while (n < deviceArray.length) {
                vector.add(deviceArray[n]);
                ++n;
            }
        } else if (string.equals("Mirror")) {
            Vector vector9 = this.getAntecedents(device, "ExtentInDiskGroup");
            if (vector9 != null) {
                int n = 0;
                while (n < vector9.size()) {
                    Device device7 = (Device)vector9.get(n);
                    String string7 = (String)device7.getProperty("type");
                    if (string7.equals("Stripe") || string7.equals("Concat")) {
                        Vector vector10 = this.getDependents(device7, "ResidesOn");
                        Vector vector11 = this.getDependents(device7, "BasedOn");
                        if ((vector10 == null || vector10.isEmpty()) && (vector11 == null || vector11.isEmpty())) {
                            vector.addElement(device7);
                        }
                    }
                    ++n;
                }
            }
        } else if (string.equals("SoftPartition")) {
            Cloneable cloneable;
            Device[] deviceArray = this.getAvailableSlices(device);
            int n = 0;
            while (n < deviceArray.length) {
                cloneable = deviceArray[n];
                if (this.useSliceForMD((Device)cloneable, string)) {
                    vector.add(cloneable);
                }
                ++n;
            }
            vector.addAll(this.getAvailableSPDisks(device));
            cloneable = this.getAntecedents(device, "DriveInDiskGroup");
            if (cloneable != null) {
                int n3 = 0;
                while (n3 < ((Vector)cloneable).size()) {
                    Device device8 = (Device)((Vector)cloneable).get(n3);
                    Vector vector12 = this.getAntecedents(device8, "ResidesOn");
                    if (vector12 != null) {
                        int n4 = 0;
                        while (n4 < vector12.size()) {
                            Device device9 = (Device)vector12.get(n4);
                            Vector vector13 = this.getDependents(device9, "BasedOn");
                            if (vector13 != null) {
                                int n5 = 0;
                                while (n5 < vector13.size()) {
                                    Device device10 = (Device)vector13.get(n5);
                                    String string8 = (String)device10.getProperty("type");
                                    if (string8.equals("Extent")) {
                                        vector.add(device9);
                                        break;
                                    }
                                    ++n5;
                                }
                            }
                            ++n4;
                        }
                    }
                    ++n3;
                }
            }
            Vector vector14 = this.getDevices("Concat");
            this.getMDForSP(string2, vector14, vector);
            vector14 = this.getDevices("Stripe");
            this.getMDForSP(string2, vector14, vector);
            vector14 = this.getDevices("Raid");
            this.getMDForSP(string2, vector14, vector);
            vector14 = this.getDevices("Mirror");
            this.getMDForSP(string2, vector14, vector);
        }
        return vector.toArray(new Device[vector.size()]);
    }

    private ArrayList getAvailableSPDisks(Device device) throws RemoteException {
        ArrayList<Device> arrayList = new ArrayList<Device>();
        if (device == null) {
            return arrayList;
        }
        Integer n = (Integer)device.getProperty("setnumber");
        if (n == null) {
            return arrayList;
        }
        Vector vector = n == 0 ? this.getAvailableDisks() : this.getAntecedents(device, "DriveInDiskGroup");
        int n2 = 0;
        while (n2 < vector.size()) {
            Device device2 = (Device)vector.get(n2);
            if (this.svm.canCreateSps(device2, 1, 1L)) {
                arrayList.add(device2);
            }
            ++n2;
        }
        return arrayList;
    }

    private void getMDForSP(String string, Vector vector, Vector vector2) throws RemoteException {
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                String string2;
                Device device = (Device)vector.get(n);
                String string3 = this.getDiskSetName(device);
                if (string3.equals(string) && ((string2 = (String)device.getProperty("mountpoint")) == null || string2.length() <= 0)) {
                    Vector vector3 = this.getDependents(device, "BasedOn");
                    if (vector3 != null && vector3.size() > 0) {
                        Device device2 = (Device)vector3.get(0);
                        String string4 = (String)device2.getProperty("type");
                        if (string4.equals("Extent")) {
                            vector2.addElement(device);
                        }
                    } else {
                        vector2.addElement(device);
                    }
                }
                ++n;
            }
        }
    }

    private void getAvailableSliceBasedSPs(String string, Vector vector) throws RemoteException {
        Vector vector2 = this.getDevices("SoftPartition");
        if (vector2 != null) {
            int n = 0;
            while (n < vector2.size()) {
                Vector vector3;
                String string2;
                Boolean bl;
                Device device = (Device)vector2.get(n);
                String string3 = this.getDiskSetName(device);
                if (string3.equals(string) && (bl = (Boolean)device.getProperty("on slice")) != null && bl.booleanValue() && ((string2 = (String)device.getProperty("mountpoint")) == null || string2.length() <= 0) && ((vector3 = this.getDependents(device, "BasedOn")) == null || vector3.size() == 0)) {
                    vector.addElement(device);
                }
                ++n;
            }
        }
    }

    private Device getDiskset(String string) throws RemoteException {
        Vector vector = this.getDevices("Diskset");
        if (vector == null) {
            return null;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Device device = (Device)enumeration.nextElement();
            String string2 = (String)device.getProperty("name");
            if (!string2.equals(string)) continue;
            return device;
        }
        return null;
    }

    private boolean useSliceForDB(Device device) throws RemoteException {
        Cloneable cloneable;
        long l = 0L;
        Long l2 = (Long)device.getProperty("slice size");
        if (l2 != null) {
            l = l2;
        }
        if (l == 0L) {
            return false;
        }
        String string = (String)device.getProperty("mountpoint");
        if (string != null && string.length() > 0) {
            return false;
        }
        String string2 = (String)device.getProperty("name");
        Vector vector = this.getDevices("Metadb");
        if (vector == null) {
            vector = new Vector();
        }
        boolean bl = false;
        int n = 0;
        while (n < vector.size()) {
            cloneable = (Device)vector.get(n);
            String string3 = (String)((DeviceProperties)cloneable).getProperty("name");
            if (string2.equals(string3)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (bl) {
            return false;
        }
        cloneable = this.getOverlapSlices(device);
        int n2 = 0;
        while (n2 < ((Vector)cloneable).size()) {
            Device device2 = (Device)((Vector)cloneable).get(n2);
            string = (String)device2.getProperty("mountpoint");
            if (string != null && string.length() > 0) {
                return false;
            }
            Vector vector2 = this.getDependents(device2, "ResidesOn");
            if (vector2 != null) {
                int n3 = 0;
                while (n3 < vector2.size()) {
                    Device device3 = (Device)vector2.get(n3);
                    String string4 = (String)device3.getProperty("type");
                    if (string4.equals("Metadb")) {
                        return false;
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        return true;
    }

    private boolean useSliceForMD(Device device, String string) throws RemoteException {
        Object object;
        long l = 0L;
        Long l2 = (Long)device.getProperty("slice size");
        if (l2 != null) {
            l = l2;
        }
        if (l == 0L) {
            return false;
        }
        if ((string.equals("Stripe") || string.equals("Raid") || string.equals("SoftPartition") || string.equals("Hsp")) && (object = (String)device.getProperty("mountpoint")) != null && ((String)object).length() > 0) {
            return false;
        }
        object = this.getOverlapSlices(device);
        int n = 0;
        while (n < ((Vector)object).size()) {
            Device device2 = (Device)((Vector)object).get(n);
            Vector vector = this.getDependents(device2, "BasedOn");
            if (vector != null && vector.size() > 0) {
                return false;
            }
            String string2 = (String)device2.getProperty("mountpoint");
            if (string2 != null && string2.length() > 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private Vector getOverlapSlices(Device device) throws RemoteException {
        Cloneable cloneable;
        Vector vector = this.getDependents(device, "ResidesOn");
        if (vector == null) {
            return new Vector();
        }
        Cloneable cloneable2 = null;
        int n = 0;
        while (n < vector.size()) {
            cloneable = (Device)vector.get(n);
            String string = (String)((DeviceProperties)cloneable).getProperty("type");
            if (string.equals("Disk")) {
                cloneable2 = cloneable;
                break;
            }
            ++n;
        }
        if (cloneable2 == null) {
            return new Vector();
        }
        cloneable = this.getAntecedents((Device)cloneable2, "ResidesOn");
        if (cloneable == null) {
            return new Vector();
        }
        long l = 0L;
        Long l2 = (Long)device.getProperty("slice start block");
        if (l2 != null) {
            l = l2;
        }
        long l3 = 0L;
        l2 = (Long)device.getProperty("slice size");
        if (l2 != null) {
            l3 = l2;
        }
        Vector<Device> vector2 = new Vector<Device>();
        int n2 = 0;
        while (n2 < ((Vector)cloneable).size()) {
            Device device2 = (Device)((Vector)cloneable).get(n2);
            String string = (String)device2.getProperty("type");
            if (string.equals("Slice") && !device.equals(device2)) {
                long l4 = 0L;
                l2 = (Long)device2.getProperty("slice start block");
                if (l2 != null) {
                    l4 = l2;
                }
                long l5 = 0L;
                l2 = (Long)device2.getProperty("slice size");
                if (l2 != null) {
                    l5 = l2;
                }
                if (l5 != 0L) {
                    if (l <= l4) {
                        if (l + l3 > l4) {
                            vector2.add(device2);
                        }
                    } else if (l4 + l5 > l) {
                        vector2.add(device2);
                    }
                }
            }
            ++n2;
        }
        return vector2;
    }

    private Vector getFilteredDevices(Vector vector, ListProperties listProperties) {
        if (vector == null || listProperties == null) {
            return vector;
        }
        Vector vector2 = listProperties.getFilters();
        if (listProperties.getFilters() == null) {
            return vector;
        }
        Vector<Device> vector3 = new Vector<Device>();
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            block8: {
                Device device = (Device)vector.get(n);
                int n3 = 0;
                while (n3 < vector2.size()) {
                    block7: {
                        DeviceFilter deviceFilter;
                        try {
                            deviceFilter = (DeviceFilter)vector2.get(n3);
                        }
                        catch (ClassCastException classCastException) {
                            break block7;
                        }
                        deviceFilter.setDevice(device);
                        deviceFilter.setSvm(this.svm);
                        if (!deviceFilter.matches()) break block8;
                    }
                    ++n3;
                }
                vector3.add(device);
            }
            ++n;
        }
        return vector3;
    }

    public synchronized Log getLogSvc() {
        if (this.logSvc == null) {
            try {
                this.logSvc = (Log)this.inf.getServiceByName((class$com$sun$management$viper$services$Log == null ? (class$com$sun$management$viper$services$Log = SVMServices.class$("com.sun.management.viper.services.Log")) : class$com$sun$management$viper$services$Log).getName());
            }
            catch (VException vException) {
                // empty catch block
            }
        }
        return this.logSvc;
    }

    private void writeLog(int n, String string, String string2, String[] stringArray, String string3) throws LogException {
        if (this.logSvc == null) {
            throw new LogException("Could not initialize log service");
        }
        int n2 = stringArray != null ? stringArray.length : 0;
        String[] stringArray2 = new String[2 + n2];
        stringArray2[0] = this.inf.getIdentity().getName();
        try {
            stringArray2[1] = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (stringArray != null) {
            System.arraycopy(stringArray, 0, stringArray2, 2, stringArray.length);
        }
        try {
            this.logSvc.writeLog("SOURCE", "application", n, string, string2, stringArray2, MSGRESOURCECLASS, string3);
        }
        catch (RemoteException remoteException) {
            throw new LogException(remoteException.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

