/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.common;

import com.sun.admin.volmgr.common.Device;
import com.sun.admin.volmgr.common.DeviceFilter;
import com.sun.admin.volmgr.server.SVMAPI;
import java.io.Serializable;
import java.util.ArrayList;

public class InUseAsDeviceFilter
extends DeviceFilter {
    public static Usage USAGE_FILESYSTEM = new Usage(1000);
    public static Usage USAGE_SUBMIRROR = new Usage(1001);
    public static Usage USAGE_TRANSLOG = new Usage(1002);
    public static Usage USAGE_TRANSMASTER = new Usage(1003);
    private Usage usage;

    public InUseAsDeviceFilter() {
    }

    public InUseAsDeviceFilter(Device device, SVMAPI sVMAPI, boolean bl, Usage usage) {
        super(device, sVMAPI, bl);
        this.setUsage(usage);
    }

    public void setUsage(Usage usage) {
        this.usage = usage;
    }

    public Usage getUsage() {
        return this.usage;
    }

    public boolean matches() {
        Object object;
        Object object2;
        if (!this.getSelected()) {
            return true;
        }
        Device device = this.getDevice();
        SVMAPI sVMAPI = this.getSvm();
        Usage usage = this.getUsage();
        if (device == null || sVMAPI == null || usage == null) {
            return true;
        }
        ArrayList arrayList = new ArrayList();
        try {
            arrayList.addAll(sVMAPI.getDependents(device, "BasedOn"));
            arrayList.addAll(sVMAPI.getDependents(device, "ResidesOn"));
        }
        catch (Exception exception) {
            return false;
        }
        Object object3 = device.getProperty("type");
        if (usage.equals(USAGE_FILESYSTEM)) {
            String string = (String)device.getProperty("mountpoint");
            if (string != null && !string.equals("")) {
                return true;
            }
        } else if (usage.equals(USAGE_SUBMIRROR)) {
            if (object3.equals("Concat") || object3.equals("Stripe")) {
                int n = 0;
                int n2 = arrayList.size();
                while (n < n2) {
                    Device device2 = (Device)arrayList.get(n);
                    String string = (String)device2.getProperty("type");
                    if ("Mirror".equals(string)) {
                        return true;
                    }
                    ++n;
                }
            }
        } else if (usage.equals(USAGE_TRANSLOG) ? "log".equals(object2 = device.getProperty("trans component type")) : usage.equals(USAGE_TRANSMASTER) && "master".equals(object = device.getProperty("trans component type"))) {
            return true;
        }
        return false;
    }

    public static class Usage
    implements Serializable {
        private int id;

        private Usage(int n) {
            this.id = n;
        }

        public int getId() {
            return this.id;
        }

        public boolean equals(Object object) {
            try {
                return ((Usage)object).getId() == this.getId();
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
    }
}

