/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.wizards.cards;

import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.volmgr.client.ttk.RowLayout;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.wizards.HasDiskSet;
import com.sun.admin.volmgr.client.wizards.cards.SimpleVWizardCard;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DiskSetNameCard
extends SimpleVWizardCard {
    public static final String TITLE = "diskset_add_wiz_name_title";
    public static final String HEADER = "diskset_add_wiz_name_header";
    private static final String HELPFILE = "DiskSetNameCard.html";
    private HasDiskSet hasDiskSet;
    private JTextField nameField;

    public DiskSetNameCard(HasDiskSet hasDiskSet) {
        super(TITLE, HELPFILE, HEADER);
        this.hasDiskSet = hasDiskSet;
        this.initGUI();
    }

    protected Component getMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(15, 15));
        jPanel.add(super.getMainPanel(), "North");
        this.nameField = new JTextField(20);
        JLabel jLabel = new JLabel();
        Util.initLabel(jLabel, "diskset_add_wiz_name_label", this.nameField);
        JPanel jPanel2 = new JPanel(new RowLayout(RowLayout.LEFT));
        jPanel2.add((Component)jLabel, RowLayout.VCENTER);
        jPanel2.add((Component)this.nameField, RowLayout.VCENTER);
        jPanel.add((Component)jPanel2, "Center");
        return jPanel;
    }

    public void refresh() {
        this.nameField.setText(this.hasDiskSet.getDiskSetName());
    }

    public boolean stop(boolean bl) {
        if (bl) {
            String string = this.nameField.getText().trim();
            if (!this.isValidName(string)) {
                String string2 = Util.getResourceString("invalid_diskset_name", string);
                new ErrorDialog(null, string2);
                return false;
            }
            this.nameField.setText(string);
            this.hasDiskSet.setDiskSetName(string);
        } else {
            this.hasDiskSet.setDiskSetName(null);
        }
        return true;
    }

    protected boolean isValidName(String string) {
        if (string == null || string.equals("") || string.length() > 50) {
            return false;
        }
        char[] cArray = new char[]{'!', '&', '(', ')', '|', '`', '\'', '<', '>', '[', '{', ' ', '*', '?', '/'};
        Arrays.sort(cArray);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (Arrays.binarySearch(cArray, c) >= 0) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

