/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.wizards.cards;

import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.wizards.cards.ReviewCard;
import com.sun.admin.volmgr.client.wizards.command.VolumeCommandFactory;
import com.sun.admin.volmgr.common.Device;
import javax.swing.JLabel;

public class AttachConcatStripeReviewCard
extends ReviewCard {
    private static String TITLE = "ConcatCompReviewCard_title";
    private static final String HELPFILE = "AttachConcatStripeReviewCard.html";
    private static String HEADER = "ConcatCompReviewCard_header";
    private static String COMMENT = "add_concat_comp_cmd";
    private VolumeCommandFactory factory;
    private JLabel interlaceValue;

    public AttachConcatStripeReviewCard(VolumeCommandFactory volumeCommandFactory) {
        super(TITLE, HELPFILE, HEADER, COMMENT);
        this.factory = volumeCommandFactory;
        this.initGUI();
    }

    public String getInterlace() {
        long l = this.factory.getInterlaceInBlocks();
        Util.DeviceSize deviceSize = Util.getSizeInGreatestUnits(l, 1001, 1003);
        String string = deviceSize.size + " ";
        switch (deviceSize.units) {
            case 1001: {
                string = string + Util.getResourceString("blocks");
                break;
            }
            case 1002: {
                string = string + Util.getResourceString("kilobytes");
                break;
            }
            case 1003: {
                string = string + Util.getResourceString("megabytes");
            }
        }
        return string;
    }

    protected String getDeviceName() {
        return this.factory.getDeviceName();
    }

    protected String getDeviceDiskSetName() {
        return this.factory.getDiskSetName();
    }

    protected Device[] getDevices() {
        return this.factory.getComponents();
    }

    protected String[] getCommands() {
        return this.factory.getMetattachStripeCommands();
    }

    protected ReviewCard.LabeledComponent[] getLabeledComponents() {
        ReviewCard.LabeledComponent[] labeledComponentArray = super.getLabeledComponents();
        this.interlaceValue = new JLabel();
        return new ReviewCard.LabeledComponent[]{labeledComponentArray[0], labeledComponentArray[1], new ReviewCard.LabeledComponent("volume_add_wiz_review_interlace_label", this.interlaceValue), labeledComponentArray[2], labeledComponentArray[3]};
    }

    public void refresh() {
        super.refresh();
        this.interlaceValue.setText(this.getInterlace());
    }
}

