/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.volumes;

import com.sun.admin.volmgr.client.GeneralPropertySheet;
import com.sun.admin.volmgr.client.util.GUIUtil;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.wizards.SetMirrorParamsWizard;
import com.sun.admin.volmgr.common.Device;
import com.sun.management.viper.console.gui.VFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MirrorParamPropertySheet
extends GeneralPropertySheet {
    private static final String TITLE = "params_props_tab";
    private static final String HELPFILE = "MirrorParamPropertySheet.html";
    private static final String BORDERTITLE = "device_param_props_title";
    private Device mirror;
    private JLabel passNumValue;
    private JLabel readOptValue;
    private JLabel writeOptValue;

    public MirrorParamPropertySheet(Device device) {
        super(TITLE, HELPFILE, BORDERTITLE);
        this.mirror = device;
        this.initGUI();
    }

    public Device getMirror() {
        return this.mirror;
    }

    public String getMirrorPassNumber() {
        Integer n = (Integer)this.mirror.getProperty("passnumber");
        return n.toString();
    }

    public String getMirrorReadOptions() {
        Integer n = (Integer)this.mirror.getProperty("readoption");
        return Util.getDisplayableReadOption(n);
    }

    public String getMirrorWriteOptions() {
        Integer n = (Integer)this.mirror.getProperty("writeoption");
        return Util.getDisplayableWriteOption(n);
    }

    private void changeParams() {
        new Thread(){

            public void run() {
                VFrame vFrame = new VFrame();
                Util.makeModal(GUIUtil.getParentJFrame((Component)((Object)MirrorParamPropertySheet.this)), (Window)vFrame, true);
                SetMirrorParamsWizard setMirrorParamsWizard = new SetMirrorParamsWizard(MirrorParamPropertySheet.this.mirror);
                setMirrorParamsWizard.init();
                setMirrorParamsWizard.setContainer((Component)vFrame);
                vFrame.showCenter((Component)GUIUtil.getAppFrame());
                setMirrorParamsWizard.start();
            }
        }.start();
    }

    protected GeneralPropertySheet.LabeledComponent[] getLabeledComponents() {
        this.passNumValue = new JLabel();
        this.readOptValue = new JLabel();
        this.writeOptValue = new JLabel();
        return new GeneralPropertySheet.LabeledComponent[]{new GeneralPropertySheet.LabeledComponent("passnum_prop", this.passNumValue), new GeneralPropertySheet.LabeledComponent("readoption_prop", this.readOptValue), new GeneralPropertySheet.LabeledComponent("writeoption_prop", this.writeOptValue)};
    }

    protected Component getMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        JButton jButton = new JButton();
        if (!Util.getApp().getServiceWrapper().hasVolMgrWriteAuth()) {
            jButton.setEnabled(false);
        } else {
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MirrorParamPropertySheet.this.changeParams();
                }
            });
        }
        Util.initButton(jButton, "set_params");
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add(super.getMainPanel(), "North");
        jPanel2.add((Component)jPanel, "Center");
        return jPanel2;
    }

    protected void refresh() {
        this.passNumValue.setText(this.getMirrorPassNumber());
        this.readOptValue.setText(this.getMirrorReadOptions());
        this.writeOptValue.setText(this.getMirrorWriteOptions());
    }
}

