/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.util;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.sort.Compare;
import com.sun.admin.cis.common.sort.Sort;
import com.sun.admin.volmgr.client.ServiceWrapper;
import com.sun.admin.volmgr.client.VVolMgr;
import com.sun.admin.volmgr.client.components.DiskPropDialog;
import com.sun.admin.volmgr.client.components.HostPropDialog;
import com.sun.admin.volmgr.client.components.SlicePropDialog;
import com.sun.admin.volmgr.client.components.SoftPartitionPropDialog;
import com.sun.admin.volmgr.client.disksets.DiskSetPropDialog;
import com.sun.admin.volmgr.client.hsps.HSPPropDialog;
import com.sun.admin.volmgr.client.metadb.MetadbPropDialog;
import com.sun.admin.volmgr.client.util.DeviceCompare;
import com.sun.admin.volmgr.client.util.GUIUtil;
import com.sun.admin.volmgr.client.volumes.ConcatStripePropDialog;
import com.sun.admin.volmgr.client.volumes.MirrorPropDialog;
import com.sun.admin.volmgr.client.volumes.RAIDPropDialog;
import com.sun.admin.volmgr.client.volumes.TransPropDialog;
import com.sun.admin.volmgr.common.Device;
import com.sun.admin.volmgr.common.DeviceProperties;
import com.sun.admin.volmgr.common.util.CommandResult;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.gui.VFrame;
import com.sun.management.viper.console.gui.propsheet.VPropertySheetEditor;
import com.sun.management.viper.util.ConsoleUtility;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class Util {
    private static VVolMgr app = VVolMgr.getLastInstance();
    private static ResourceBundle bundle = app.getResourceBundle();
    private static ServiceWrapper wrapper = app.getServiceWrapper();
    private static final int SMALLICON = 16;
    private static final int LARGEICON = 32;
    public static final String AVAILABLE_SPACE = "availablespace";
    public static final String MDDB_FLAGS_STRING = "RSFDMaWm  pc luo tB";
    public static final int HSS_UNUSED = 0;
    public static final int HSS_AVAILABLE = 1;
    public static final int HSS_RESERVED = 2;
    public static final int HSS_BROKEN = 3;
    public static final int RUS_INIT = 1;
    public static final int RUS_OKAY = 2;
    public static final int RUS_ERRED = 4;
    public static final int RUS_LAST_ERRED = 8;
    public static final int RUS_DOI = 16;
    public static final int RUS_REGEN = 32;
    public static final int RCS_INIT = 1;
    public static final int RCS_OKAY = 2;
    public static final int RCS_ERRED = 4;
    public static final int RCS_LAST_ERRED = 8;
    public static final int RCS_RESYNC = 16;
    public static final int RCS_INIT_ERRED = 32;
    public static final int RCS_REGEN = 64;
    public static final int MD_RI_INPROGRESS = 1;
    public static final int MD_GROW_INPROGRESS = 2;
    public static final int CS_OKAY = 1;
    public static final int CS_ERRED = 2;
    public static final int CS_RESYNC = 4;
    public static final int CS_LAST_ERRED = 8;
    public static final int LDL_ERROR = 1;
    public static final int LDL_HERROR = 2;
    public static final int TRANS_NEED_OPEN = 1;
    public static final int TRANS_OPENED = 2;
    public static final int TRANS_DETACHING = 4;
    public static final int TRANS_DETACHED = 8;
    public static final int TRANS_DETACH_SKIP = 16;
    public static final int TRANS_ATTACHING = 32;
    public static final int TRANS_ROLL_ON_WRITE = 64;
    public static final int TRANS_NEED_SCANROLL = 128;
    public static final int SMS_UNUSED = 0;
    public static final int SMS_RUNNING = 1;
    public static final int SMS_COMP_ERRED = 2;
    public static final int SMS_COMP_RESYNC = 4;
    public static final int SMS_ATTACHED = 8;
    public static final int SMS_ATTACHED_RESYNC = 16;
    public static final int SMS_OFFLINE = 32;
    public static final int SMS_OFFLINE_RESYNC = 64;
    public static final int SMS_ALL_ERRED = 128;
    public static final int SMS_INUSE = 65535;
    public static final int SMS_LIMPING = 6;
    public static final int SMS_IGNORE = 16384;
    public static final int SMS_ACTIVE = 87;
    public static final int MD_SM_RESYNC_TARGET = 1;
    public static final int MD_UN_RESYNC_ACTIVE = 65536;
    public static final int MD_UN_WAR = 131072;
    public static final int MD_UN_OFFLINE_SM = 262144;
    public static final int MD_UN_OPT_NOT_DONE = 524288;
    public static final int MD_UN_KEEP_DIRTY = 786432;
    public static final int MD_UN_RESYNC_CANCEL = 0x100000;
    public static final int MD_UN_REPLAYED = 0x200000;
    public static final int MD_UN_RENAMING = 0x400000;
    public static final int MD_UN_MOD_INPROGRESS = 0x490000;
    private static Hashtable iconCache = new Hashtable();
    public static final Comparator deviceNameComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            String string = (String)((Device)object).getProperty("name");
            String string2 = (String)((Device)object2).getProperty("name");
            return string.compareTo(string2);
        }

        public boolean equals(Object object) {
            return false;
        }
    };
    private static String baseDir = null;

    private Util() {
    }

    public static String getBasedir() {
        if (baseDir == null) {
            baseDir = app.getServiceWrapper().getBasedir();
        }
        return baseDir;
    }

    public static ImageIcon loadImageIcon(String string) {
        ImageIcon imageIcon = (ImageIcon)iconCache.get(string);
        if (imageIcon != null) {
            return imageIcon;
        }
        String string2 = "images/" + string;
        imageIcon = ConsoleUtility.loadImageIcon((String)string2, app.getClass());
        iconCache.put(string, imageIcon);
        return imageIcon;
    }

    private static ImageIcon getIcon(String string, int n) {
        return Util.loadImageIcon(string.toLowerCase() + '_' + n + ".gif");
    }

    public static ImageIcon getSmallIcon(String string) {
        return Util.getIcon(string, 16);
    }

    public static ImageIcon getSmallIcon(Device device) {
        return Util.getSmallIcon((String)device.get("type"));
    }

    public static ImageIcon getLargeIcon(String string) {
        return Util.getIcon(string, 32);
    }

    public static ImageIcon getLargeIcon(Device device) {
        return Util.getLargeIcon((String)device.get("type"));
    }

    public static ActionString initLabel(JLabel jLabel, String string) {
        ActionString actionString = Util.getActionString(string);
        jLabel.setText(actionString.getString());
        return actionString;
    }

    public static ActionString initLabel(JLabel jLabel, String string, Component component) {
        ActionString actionString = Util.initLabel(jLabel, string);
        jLabel.setDisplayedMnemonic(actionString.getMnemonic());
        jLabel.setLabelFor(component);
        return actionString;
    }

    public static ActionString initButton(AbstractButton abstractButton, String string) {
        ActionString actionString = Util.getActionString(string);
        abstractButton.setText(actionString.getString());
        abstractButton.setMnemonic(actionString.getMnemonic());
        return actionString;
    }

    public static void viewProperties(final Device device) {
        Thread thread = new Thread(){

            public void run() {
                GUIUtil.waitOn();
                VFrame vFrame = new VFrame();
                VPropertySheetEditor vPropertySheetEditor = Util.getPropertyDialog(device);
                if (vPropertySheetEditor != null) {
                    vPropertySheetEditor.setContainer((Component)vFrame);
                    vFrame.showCenter((Component)GUIUtil.getAppFrame());
                    vPropertySheetEditor.setVisible(true);
                    vPropertySheetEditor.start();
                }
                GUIUtil.waitOff();
            }
        };
        thread.start();
    }

    public static VPropertySheetEditor getPropertyDialog(Device device) {
        if (app == null || device == null) {
            return null;
        }
        String string = (String)device.getProperty("type");
        if (string.equals("Trans")) {
            return new TransPropDialog(device);
        }
        if (string.equals("Mirror")) {
            return new MirrorPropDialog(device);
        }
        if (string.equals("Concat") || string.equals("Stripe")) {
            return new ConcatStripePropDialog(device);
        }
        if (string.equals("Raid")) {
            return new RAIDPropDialog(device);
        }
        if (string.equals("Disk")) {
            return new DiskPropDialog(device);
        }
        if (string.equals("Slice") || string.equals("HotSpare")) {
            return new SlicePropDialog(device);
        }
        if (string.equals("SoftPartition")) {
            return new SoftPartitionPropDialog(device);
        }
        if (string.equals("Host")) {
            return new HostPropDialog(device);
        }
        if (string.equals("Hsp")) {
            return new HSPPropDialog(device);
        }
        if (string.equals("Metadb")) {
            return new MetadbPropDialog(device);
        }
        if (string.equals("Diskset")) {
            return new DiskSetPropDialog(device);
        }
        return null;
    }

    public static void logCommands(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = Util.getResourceString(string);
        if (string2 != null) {
            stringBuffer.append("# ").append(string2).append("\n");
        }
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]).append("\n");
            ++n;
        }
        stringBuffer.append("\n");
        app.fireConsoleAction(new VConsoleEvent((Object)app, "vconsole.appendcommandlog", (Object)stringBuffer.toString()));
    }

    private static String[] executeCommands(String[] stringArray) {
        CommandResult[] commandResultArray = Util.getApp().getServiceWrapper().exec(stringArray);
        ArrayList<String> arrayList = new ArrayList<String>(commandResultArray.length);
        int n = 0;
        while (n < commandResultArray.length) {
            if (commandResultArray[n].getExitCode() != 0) {
                String string = Util.getResourceString("CommandResult_general", commandResultArray[n].toString(Util.getResourceString("CommandResult_command"), Util.getResourceString("CommandResult_exitcode"), Util.getResourceString("CommandResult_stdout"), Util.getResourceString("CommandResult_stderr")));
                new ErrorDialog(null, string);
                break;
            }
            arrayList.add(stringArray[n]);
            ++n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean executeCommands(String[] stringArray, String string) {
        String[] stringArray2 = Util.executeCommands(stringArray);
        Util.logCommands(stringArray, string);
        return stringArray2.length == stringArray.length;
    }

    public static boolean executeCommands(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = Util.executeCommands(stringArray);
        int n = 0;
        while (n < stringArray3.length) {
            String string;
            try {
                string = stringArray2[n];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string = "";
            }
            Util.logCommands(new String[]{stringArray[n]}, string);
            ++n;
        }
        return stringArray3.length == stringArray.length;
    }

    public static int getNextAvailableVolumeNumber(String string) {
        Object object;
        Cloneable cloneable;
        Vector vector;
        if (string == null) {
            string = "";
        }
        if ((vector = app.getServiceWrapper().getDevices("Diskset")) == null || vector.isEmpty()) {
            return 0;
        }
        Cloneable cloneable2 = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            cloneable = (Device)enumeration.nextElement();
            object = (String)((DeviceProperties)cloneable).getProperty("name");
            if (!((String)object).equals(string)) continue;
            cloneable2 = cloneable;
            break;
        }
        if (cloneable2 == null) {
            return 0;
        }
        cloneable = app.getServiceWrapper().getAntecedents((Device)cloneable2, "ExtentInDiskGroup");
        if (cloneable == null || ((Vector)cloneable).isEmpty()) {
            return 0;
        }
        object = new Vector();
        enumeration = ((Vector)cloneable).elements();
        while (enumeration.hasMoreElements()) {
            Device device = (Device)enumeration.nextElement();
            String string2 = (String)device.getProperty("type");
            if (string2.equals("Metadb")) continue;
            String string3 = (String)device.getProperty("name");
            int n = Integer.parseInt(string3.substring(string3.lastIndexOf("d") + 1));
            ((Vector)object).addElement(new Integer(n));
        }
        Sort.sort((Vector)object, (Compare)new DeviceCompare());
        int n = 0;
        enumeration = ((Vector)object).elements();
        while (enumeration.hasMoreElements()) {
            int n2 = (Integer)enumeration.nextElement();
            if (n2 > n) {
                return n;
            }
            ++n;
        }
        return n;
    }

    public static int getNextAvailableHSPNumber(String string) {
        Object object;
        Cloneable cloneable;
        Vector vector;
        if (string == null) {
            string = "";
        }
        if ((vector = app.getServiceWrapper().getDevices("Diskset")) == null || vector.isEmpty()) {
            return 0;
        }
        Cloneable cloneable2 = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            cloneable = (Device)enumeration.nextElement();
            object = (String)((DeviceProperties)cloneable).getProperty("name");
            if (!((String)object).equals(string)) continue;
            cloneable2 = cloneable;
            break;
        }
        if (cloneable2 == null) {
            return 0;
        }
        cloneable = app.getServiceWrapper().getAntecedents((Device)cloneable2, "ExtentRedundancyComponent");
        if (cloneable == null || ((Vector)cloneable).isEmpty()) {
            return 0;
        }
        object = new Vector();
        enumeration = ((Vector)cloneable).elements();
        while (enumeration.hasMoreElements()) {
            Device device = (Device)enumeration.nextElement();
            String string2 = (String)device.getProperty("name");
            int n = Integer.parseInt(string2.substring(string2.lastIndexOf("p") + 1));
            ((Vector)object).addElement(new Integer(n));
        }
        Sort.sort((Vector)object, (Compare)new DeviceCompare());
        int n = 0;
        enumeration = ((Vector)object).elements();
        while (enumeration.hasMoreElements()) {
            int n2 = (Integer)enumeration.nextElement();
            if (n2 > n) {
                return n;
            }
            ++n;
        }
        return n;
    }

    public static long getDeviceSize(Device device) {
        Object object = device.getProperty("type");
        boolean bl = "Slice".equals(object) || "HotSpare".equals(object);
        Long l = (Long)device.getProperty(bl ? "slice size" : "size");
        if (l == null) {
            return 0L;
        }
        return l;
    }

    public static String getReadableSizeWithUnits(long l) {
        String[] stringArray = new String[]{"param_bytes", "param_kilobytes", "param_megabytes", "param_gigabytes", "param_terabytes"};
        double d = 1023.995;
        long l2 = 1L;
        int n = 0;
        while (n < stringArray.length) {
            if (n == stringArray.length - 1 || (double)l < d) break;
            l2 *= 1024L;
            d *= 1024.0;
            ++n;
        }
        return Util.getResourceString(stringArray[n], (double)Math.round((double)l / (double)l2 * 100.0) / 100.0 + "");
    }

    public static String getDeviceSizeWithUnits(Device device) {
        return Util.getReadableSizeWithUnits(Util.getDeviceSize(device) * 512L);
    }

    public static long getDeviceAvailableSpace(Device device) {
        return app.getServiceWrapper().getFreeSpace(device);
    }

    public static boolean isAVolume(Device device) {
        Object object = device.getProperty("type");
        return "Trans".equals(object) || "Mirror".equals(object) || "Concat".equals(object) || "Stripe".equals(object) || "Raid".equals(object) || "SoftPartition".equals(object);
    }

    private static String getRecursiveDependentMountPoint(Device device) {
        String string = (String)device.getProperty("mountpoint");
        if (string != null && !string.equals("")) {
            return string;
        }
        Vector vector = app.getServiceWrapper().getAllDependents(device);
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            Device device2 = (Device)vector.get(n);
            string = Util.getRecursiveDependentMountPoint(device2);
            if (string != null) {
                return string;
            }
            ++n;
        }
        return null;
    }

    public static boolean canBeRenamed(Device device) {
        return Util.isAVolume(device) && Util.getRecursiveDependentMountPoint(device) == null;
    }

    public static String getDeviceUsage(Device device) {
        Vector vector;
        if (device == null) {
            return "";
        }
        String string = null;
        String string2 = (String)device.getProperty("mountpoint");
        if (string2 != null && !string2.equals("")) {
            string = string2;
        }
        if ((vector = app.getServiceWrapper().getAllDependents(device)) != null) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                Device device2 = (Device)vector.get(n);
                String string3 = (String)device2.getProperty("name");
                String string4 = (String)device2.getProperty("type");
                if (!string4.equals("Diskset")) {
                    String string5 = null;
                    if (string4.equals("Trans")) {
                        String string6 = (String)device.getProperty("trans component type");
                        if (string6 != null) {
                            if (string6.equals("master")) {
                                string5 = Util.getResourceString("master_use", string3);
                            } else if (string6.equals("log")) {
                                string5 = Util.getResourceString("log_use", string3);
                            }
                        }
                    } else if (string4.equals("Mirror")) {
                        string5 = Util.getResourceString("submirror_use", string3);
                    } else if (string4.equals("Concat") || string4.equals("Stripe") || string4.equals("Raid")) {
                        string5 = Util.getResourceString("component_use", string3);
                    } else if (string4.equals("Hsp")) {
                        string5 = Util.getResourceString("hsp_use", string3);
                    } else if (string4.equals("Metadb")) {
                        string5 = Util.getResourceString("replica_use");
                    }
                    string = string == null ? string5 : string + ", " + string5;
                }
                ++n;
            }
        }
        if (string == null) {
            string = Util.getResourceString("no_use");
        }
        return string;
    }

    public static String formatProperty(Device device, String string) {
        String string2;
        if (device == null || string == null) {
            return "";
        }
        if (string.equals("size") || string.equals("slice size")) {
            return Util.getDeviceSizeWithUnits(device);
        }
        if (string.equals(AVAILABLE_SPACE)) {
            return Util.getReadableSizeWithUnits(Util.getDeviceAvailableSpace(device) * 512L);
        }
        Object object = device.getProperty(string);
        if (object == null) {
            return "";
        }
        if (string.equals("state")) {
            String string3 = (String)device.getProperty("type");
            int n = (Integer)object;
            if (string3 != null) {
                if (string3.equals("SoftPartition")) {
                    return Util.getSoftPartitionState(n);
                }
                if (string3.equals("Metadb")) {
                    return Util.getMetadbState(device, n);
                }
                if (string3.equals("Trans")) {
                    return Util.getTransState(device, n);
                }
                if (string3.equals("Mirror")) {
                    String string4 = (String)device.getProperty("trans component type");
                    if (string4 != null && string4.equals("log")) {
                        return Util.getTransLogState(device, n);
                    }
                    return "";
                }
                if (string3.equals("Concat") || string3.equals("Stripe")) {
                    String string5 = (String)device.getProperty("trans component type");
                    if (Util.isaSubmirror(device)) {
                        return Util.getSubmirrorState(device, n);
                    }
                    if (string5 != null && string5.equals("log")) {
                        return Util.getTransLogState(device, n);
                    }
                    return "";
                }
                if (string3.equals("Raid")) {
                    String string6 = (String)device.getProperty("trans component type");
                    if (string6 != null && string6.equals("log")) {
                        return Util.getTransLogState(device, n);
                    }
                    return Util.getRAIDState(device, n);
                }
                if (string3.equals("HotSpare")) {
                    return Util.getSpareState(device, n);
                }
                if (string3.equals("Slice")) {
                    String string7 = (String)device.getProperty("trans component type");
                    if (Util.isaRAIDComponent(device)) {
                        return Util.getRAIDCompState(device, n);
                    }
                    if (Util.isPartOfSimpleMetaDevice(device)) {
                        return Util.getStripeCompState(device, n);
                    }
                    if (string7 != null && string7.equals("log")) {
                        return Util.getTransLogState(device, n);
                    }
                    return "";
                }
            }
        } else if (string.equals("percent done") && (string2 = (String)device.getProperty("type")) != null) {
            Integer n = (Integer)device.getProperty("flags");
            int n2 = 0;
            if (n != null) {
                n2 = n;
            }
            int n3 = 0;
            Integer n4 = (Integer)device.getProperty("state");
            if (n4 != null) {
                n3 = n4;
            }
            if (string2.equals("Mirror")) {
                if ((n3 & 0x10000) > 0) {
                    return Util.getResourceString("resyncinprogress", object);
                }
                return "";
            }
            if (string2.equals("Raid")) {
                if (n3 == 32) {
                    return Util.getResourceString("regeninprogress", object);
                }
                if ((n2 & 1) > 0) {
                    return Util.getResourceString("resyncinprogress", object);
                }
                if ((n2 & 2) > 0) {
                    return Util.getResourceString("initinprogress", object);
                }
                return "";
            }
        }
        return Util.getResourceString(object.toString());
    }

    public static String getStripeCompState(Device device, int n) {
        if (device == null) {
            return "";
        }
        switch (n) {
            case 1: {
                return Util.getResourceString("okay");
            }
            case 2: {
                return Util.getResourceString("maintenance");
            }
            case 8: {
                return Util.getResourceString("last_errored");
            }
            case 4: {
                return Util.getResourceString("resyncing");
            }
        }
        return Util.getResourceString("invalid");
    }

    public static String getRAIDCompState(Device device, int n) {
        if (device == null) {
            return "";
        }
        switch (n) {
            case 1: {
                return Util.getResourceString("initializing");
            }
            case 2: {
                return Util.getResourceString("okay");
            }
            case 4: 
            case 32: {
                return Util.getResourceString("maintenance");
            }
            case 8: {
                return Util.getResourceString("last_errored");
            }
            case 16: {
                return Util.getResourceString("resyncing");
            }
        }
        return Util.getResourceString("invalid");
    }

    public static String getSpareState(Device device, int n) {
        if (device == null) {
            return "";
        }
        switch (n) {
            case 0: {
                return Util.getResourceString("unused");
            }
            case 1: {
                return Util.getResourceString("available");
            }
            case 2: {
                return Util.getResourceString("inuse");
            }
            case 3: {
                return Util.getResourceString("broken");
            }
        }
        return Util.getResourceString("invalid");
    }

    public static String getRAIDState(Device device, int n) {
        if (device == null) {
            return "";
        }
        switch (n) {
            case 1: {
                return Util.getResourceString("initializing");
            }
            case 2: {
                return Util.getResourceString("okay");
            }
            case 4: 
            case 8: {
                return Util.getResourceString("needs_maintenance");
            }
            case 16: {
                return Util.getResourceString("init_failed");
            }
            case 32: {
                return Util.getResourceString("regen");
            }
        }
        return Util.getResourceString("invalid");
    }

    public static String getSoftPartitionState(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "creating";
                break;
            }
            case 1: {
                string = "attaching";
                break;
            }
            case 2: {
                string = "deleting";
                break;
            }
            case 3: {
                string = "okay";
                break;
            }
            case 4: {
                string = "error";
                break;
            }
            case 5: {
                string = "recovering";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        return Util.getResourceString(string);
    }

    public static String getMetadbState(Device device, int n) {
        if (device == null) {
            return "";
        }
        String string = new String("");
        int n2 = 0;
        while (n2 < MDDB_FLAGS_STRING.length()) {
            string = (n & 1 << n2) != 0 ? string + MDDB_FLAGS_STRING.charAt(n2) : string + " ";
            ++n2;
        }
        return string;
    }

    public static String getTransState(Device device, int n) {
        if (device == null) {
            return "";
        }
        int n2 = 0;
        Integer n3 = (Integer)device.getProperty("flags");
        if (n3 != null) {
            n2 = n3;
        }
        if ((n2 & 8) > 0) {
            return Util.getResourceString("detached");
        }
        if ((n2 & 4) > 0) {
            return Util.getResourceString("detaching");
        }
        if ((n2 & 0x20) > 0) {
            return Util.getResourceString("attaching");
        }
        return Util.getTransLogState(device, n);
    }

    public static String getTransLogState(Device device, int n) {
        if (device == null) {
            return "";
        }
        int n2 = 0;
        Integer n3 = (Integer)device.getProperty("trans flags");
        if (n3 != null) {
            n2 = n3;
        }
        if ((n2 & 1) > 0) {
            return Util.getResourceString("error");
        }
        if ((n2 & 2) > 0) {
            return Util.getResourceString("harderror");
        }
        return Util.getResourceString("okay");
    }

    public static String getSubmirrorState(Device device, int n) {
        Object object;
        if (device == null) {
            return "";
        }
        int n2 = 0;
        Integer n3 = (Integer)device.getProperty("flags");
        if (n3 != null) {
            n2 = n3;
        }
        DeviceProperties deviceProperties = null;
        Vector vector = app.getServiceWrapper().getDependents(device, "BasedOn");
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Device device2 = (Device)enumeration.nextElement();
                object = (String)device2.getProperty("type");
                if (!((String)object).equals("Mirror")) continue;
                deviceProperties = device2;
                break;
            }
        }
        if (deviceProperties == null) {
            return "";
        }
        boolean bl = (n2 & 1) > 0;
        int n4 = 0;
        object = (Integer)deviceProperties.getProperty("state");
        if (object != null) {
            n4 = (Integer)object;
        }
        if ((n & 1) > 0 && ((n4 & 0x80000) <= 0 || (n4 & 0x80000) > 0 && !bl)) {
            return Util.getResourceString("okay");
        }
        if ((n & 0x54) > 0 || (n4 & 0x80000) > 0) {
            if ((n4 & 0x10000) > 0) {
                return Util.getResourceString("resyncing");
            }
            return Util.getResourceString("needs_maintenance");
        }
        if ((n & 0x2A) > 0) {
            return Util.getResourceString("needs_maintenance");
        }
        return "";
    }

    public static boolean isaSubmirror(Device device) {
        if (device == null) {
            return false;
        }
        Vector vector = app.getServiceWrapper().getDependents(device, "BasedOn");
        if (vector != null && vector.size() > 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Device device2 = (Device)enumeration.nextElement();
                String string = (String)device2.getProperty("type");
                if (!string.equals("Mirror")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isaRAIDComponent(Device device) {
        if (device == null) {
            return false;
        }
        Vector vector = app.getServiceWrapper().getDependents(device, "BasedOn");
        if (vector != null && vector.size() > 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Device device2 = (Device)enumeration.nextElement();
                String string = (String)device2.getProperty("type");
                if (!string.equals("Raid")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPartOfSimpleMetaDevice(Device device) {
        if (device == null) {
            return false;
        }
        Vector vector = app.getServiceWrapper().getDependents(device, "BasedOn");
        if (vector != null && vector.size() > 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Device device2 = (Device)enumeration.nextElement();
                String string = (String)device2.getProperty("type");
                if (!string.equals("Stripe") && !string.equals("Concat")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canMountRoot(Device device) {
        Vector vector;
        String string = (String)device.getProperty("type");
        if (string.equals("Mirror")) {
            Vector vector2 = app.getServiceWrapper().getAntecedents(device, "BasedOn");
            if (vector2 != null && vector2.size() > 0) {
                Enumeration enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    Device device2 = (Device)enumeration.nextElement();
                    Vector vector3 = app.getServiceWrapper().getAntecedents(device2, "BasedOn");
                    if (vector3 == null || vector3.size() == 1) continue;
                    return false;
                }
                return true;
            }
        } else if (string.equals("Stripe") && (vector = app.getServiceWrapper().getAntecedents(device, "BasedOn")) != null && vector.size() == 1) {
            return true;
        }
        return false;
    }

    public static Double formatDouble(double d) {
        MessageFormat messageFormat = new MessageFormat("{0,number,.##}");
        Object[] objectArray = new Object[]{new Double(d)};
        return new Double(messageFormat.format(objectArray));
    }

    public static String getUnitText(int n) {
        switch (n) {
            case 1001: {
                return Util.getResourceString("blocks");
            }
            case 1002: {
                return Util.getResourceString("kilobytes");
            }
            case 1003: {
                return Util.getResourceString("megabytes");
            }
            case 1004: {
                return Util.getResourceString("gigabytes");
            }
            case 1005: {
                return Util.getResourceString("terabytes");
            }
        }
        return Util.getResourceString("units_unknown");
    }

    public static String getUnitText(long l, int n) {
        switch (n) {
            case 1001: {
                return Util.getResourceString("param_blocks", Long.toString(l));
            }
            case 1002: {
                return Util.getResourceString("param_kilobytes", Long.toString(l));
            }
            case 1003: {
                return Util.getResourceString("param_megabytes", Long.toString(l));
            }
            case 1004: {
                return Util.getResourceString("param_gigabytes", Long.toString(l));
            }
            case 1005: {
                return Util.getResourceString("param_terabytes", Long.toString(l));
            }
        }
        return Util.getResourceString("units_unknown");
    }

    public static ComponentListener makeModal(JFrame jFrame, Window window) {
        return Util.makeModal(jFrame, window, false);
    }

    public static ComponentListener makeModal(final JFrame jFrame, Window window, boolean bl) {
        final MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                jFrame.getToolkit().beep();
            }
        };
        ComponentAdapter componentAdapter = new ComponentAdapter(){
            private boolean hidden = true;
            private Cursor origCursor;
            private Component glassPane = jFrame.getGlassPane();

            public synchronized void componentShown(ComponentEvent componentEvent) {
                if (!this.hidden) {
                    return;
                }
                this.origCursor = this.glassPane.getCursor();
                this.glassPane.setCursor(Cursor.getPredefinedCursor(3));
                this.glassPane.addMouseListener(mouseAdapter);
                this.glassPane.setVisible(true);
                this.hidden = false;
            }

            public synchronized void componentHidden(ComponentEvent componentEvent) {
                if (this.hidden) {
                    return;
                }
                this.glassPane.setCursor(this.origCursor);
                this.glassPane.removeMouseListener(mouseAdapter);
                this.glassPane.setVisible(false);
                this.hidden = true;
            }
        };
        if (bl) {
            componentAdapter.componentShown(null);
        }
        window.addComponentListener(componentAdapter);
        return componentAdapter;
    }

    public static ActionListener getConfirmListener(final String[] stringArray, final String[] stringArray2) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Util.executeCommands(stringArray2, stringArray);
            }
        };
    }

    public static Object[] getCombinedArray(Object[][] objectArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            n += objectArray[n2].length;
            ++n2;
        }
        Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType().getComponentType(), n);
        int n3 = 0;
        int n4 = 0;
        while (n3 < objectArray.length) {
            System.arraycopy(objectArray[n3], 0, objectArray2, n4, objectArray[n3].length);
            n4 += objectArray[n3].length;
            ++n3;
        }
        return objectArray2;
    }

    public static String[] getDeviceNameArray(Device[] deviceArray) {
        String[] stringArray = new String[deviceArray.length];
        int n = 0;
        while (n < deviceArray.length) {
            Device device = deviceArray[n];
            if (device != null) {
                stringArray[n] = (String)device.getProperty("name");
            }
            ++n;
        }
        return stringArray;
    }

    private static Device getTypeFromAssociation(Device device, Object object, String string, boolean bl) {
        Vector vector;
        Vector vector2 = vector = bl ? app.getServiceWrapper().getDependents(device, string) : app.getServiceWrapper().getAntecedents(device, string);
        if (vector != null) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                Object object2;
                Device device2 = (Device)vector.get(n);
                if (device2 != null && object.equals(object2 = device2.getProperty("type"))) {
                    return device2;
                }
                ++n;
            }
        }
        return null;
    }

    private static Device getDiskSetFromVolume(Device device) {
        Device device2 = Util.getTypeFromAssociation(device, "Diskset", "ExtentInDiskGroup", true);
        if (device2 != null) {
            return device2;
        }
        Vector vector = app.getServiceWrapper().getAllDependents(device);
        if (vector != null) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                Device device3 = (Device)vector.get(n);
                device2 = Util.getDiskSet(device3);
                if (device2 != null) {
                    return device2;
                }
                ++n;
            }
        }
        return null;
    }

    private static Device getDiskSetFromHSP(Device device) {
        return Util.getTypeFromAssociation(device, "Diskset", "ExtentRedundancyComponent", true);
    }

    private static Device getDiskSetFromDisk(Device device) {
        return Util.getTypeFromAssociation(device, "Diskset", "DriveInDiskGroup", true);
    }

    private static Device getDiskSetFromSlice(Device device) {
        Device device2 = Util.getTypeFromAssociation(device, "Disk", "ResidesOn", true);
        if (device2 != null) {
            return Util.getDiskSetFromDisk(device2);
        }
        return null;
    }

    private static Device getDiskSetFromHost(Device device) {
        return Util.getTypeFromAssociation(device, "Diskset", "HostInDiskGroup", true);
    }

    public static Device getDiskSet(Device device) {
        Object object = device.getProperty("type");
        if ("Diskset".equals(object)) {
            return device;
        }
        if ("Concat".equals(object) || "Stripe".equals(object) || "Raid".equals(object) || "Mirror".equals(object) || "Trans".equals(object) || "Metadb".equals(object) || "SoftPartition".equals(object)) {
            return Util.getDiskSetFromVolume(device);
        }
        if ("Hsp".equals(object)) {
            return Util.getDiskSetFromHSP(device);
        }
        if ("Disk".equals(object)) {
            return Util.getDiskSetFromDisk(device);
        }
        if ("Slice".equals(object) || "HotSpare".equals(object)) {
            return Util.getDiskSetFromSlice(device);
        }
        if ("Host".equals(object)) {
            return Util.getDiskSetFromHost(device);
        }
        return null;
    }

    public static String getDiskSetName(Device device) {
        String string = null;
        Device device2 = Util.getDiskSet(device);
        if (device2 != null) {
            string = Util.getDeviceFullName(device2);
        }
        return string;
    }

    public static String getDisplayableDiskSetName(Device device) {
        String string = Util.getDiskSetName(device);
        if (string == null || string.equals("")) {
            string = Util.getResourceString("diskset_none");
        }
        return string;
    }

    public static String getDiskSetFlag(Device device) {
        String string = Util.getDiskSetName(device);
        if (string != null && !string.equals("")) {
            return " -s " + string;
        }
        return "";
    }

    public static Device getHSPFromSlice(Device device) {
        return Util.getTypeFromAssociation(device, "Hsp", "ExtentRedundancyComponent", true);
    }

    public static Device getHSPFromVolume(Device device) {
        return Util.getTypeFromAssociation(device, "Hsp", "ExtentRedundancyComponent", false);
    }

    public static Device getHSP(Device device) {
        Object object = device.getProperty("type");
        if ("Hsp".equals(object)) {
            return device;
        }
        if ("Concat".equals(object) || "Stripe".equals(object) || "Raid".equals(object) || "Mirror".equals(object) || "Trans".equals(object) || "Metadb".equals(object)) {
            return Util.getHSPFromVolume(device);
        }
        if ("Slice".equals(object) || "HotSpare".equals(object)) {
            return Util.getHSPFromSlice(device);
        }
        return null;
    }

    public static String getDisplayableHSPName(Device device) {
        String string;
        Device device2 = Util.getHSP(device);
        if (device2 != null && !(string = Util.getDeviceFullName(device2)).equals("")) {
            return string;
        }
        return Util.getResourceString("hsp_none");
    }

    private static Device[] getComponentsOfVolume(Device device) {
        Vector vector = app.getServiceWrapper().getAntecedents(device, "BasedOn");
        return vector.toArray(new Device[vector.size()]);
    }

    private static Device[] getComponentsOfHSP(Device device) {
        Vector vector = app.getServiceWrapper().getAntecedents(device, "ExtentRedundancyComponent");
        return vector.toArray(new Device[vector.size()]);
    }

    private static Device[] getComponentsOfDiskSet(Device device) {
        Vector vector = app.getServiceWrapper().getAntecedents(device, "DriveInDiskGroup");
        return vector.toArray(new Device[vector.size()]);
    }

    private static Device[] getComponentsOfDiskOrMetaDB(Device device) {
        Vector vector = app.getServiceWrapper().getAntecedents(device, "ResidesOn");
        return vector.toArray(new Device[vector.size()]);
    }

    public static Device[] getComponentsOf(Device device) {
        Object object = device.getProperty("type");
        if ("Concat".equals(object) || "Stripe".equals(object) || "Raid".equals(object) || "Mirror".equals(object)) {
            return Util.getComponentsOfVolume(device);
        }
        if ("Metadb".equals(object) || "Disk".equals(object)) {
            return Util.getComponentsOfDiskOrMetaDB(device);
        }
        if ("Hsp".equals(object)) {
            return Util.getComponentsOfHSP(device);
        }
        if ("Diskset".equals(object)) {
            return Util.getComponentsOfDiskSet(device);
        }
        return null;
    }

    public static String getDeviceBaseName(Device device) {
        int n;
        String string = (String)device.getProperty("name");
        if (string != null && (n = string.indexOf(47)) != -1) {
            String string2 = string.substring(n + 1);
            int n2 = string.indexOf("of ");
            if (n2 != -1) {
                String string3 = string.substring(0, n2 + 3);
                string2 = string3 + string2;
            }
            string = string2;
        }
        return string;
    }

    public static String getDeviceFullName(Device device) {
        return (String)device.getProperty("name");
    }

    public static String getResourceString(String string) {
        return ResourceStrings.getString((ResourceBundle)bundle, (String)string);
    }

    public static String getResourceString(String string, Object[] objectArray) {
        String string2 = Util.getResourceString(string);
        return MessageFormat.format(string2, objectArray);
    }

    public static String getResourceString(String string, Object object) {
        return Util.getResourceString(string, new Object[]{object});
    }

    public static ActionString getActionString(String string) {
        return new ActionString(bundle, string);
    }

    public static VVolMgr getApp() {
        return app;
    }

    public static boolean isExternalLink(String string) {
        if (string.equals(":Back")) {
            return false;
        }
        if (string.indexOf(":/") >= 0) {
            return true;
        }
        if (string.indexOf("/") >= 0) {
            return true;
        }
        return !string.endsWith(".html");
    }

    public static boolean isInnerStripe(Device device) {
        String string = Util.getDeviceFullName(device);
        return string.startsWith("Stripe ");
    }

    public static String getDisplayableReadOption(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "readoption_roundrobin";
                break;
            }
            case 1: {
                string = "readoption_geometric";
                break;
            }
            case 2: {
                string = "readoption_first";
                break;
            }
            default: {
                string = "readoption_unknown";
            }
        }
        return Util.getResourceString(string);
    }

    public static String getDisplayableWriteOption(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "writeoption_parallel";
                break;
            }
            case 1: {
                string = "writeoption_serial";
                break;
            }
            default: {
                string = "writeoption_unknown";
            }
        }
        return Util.getResourceString(string);
    }

    public static boolean isLocalDiskSet(Device device) {
        Object object = device.getProperty("type");
        if (!"Diskset".equals(object)) {
            return false;
        }
        Object object2 = device.getProperty("name");
        return "".equals(object2);
    }

    public static int getReplicaCount(String string) {
        Vector vector = Util.getApp().getServiceWrapper().getDevices("Metadb");
        if (vector == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        int n3 = vector.size();
        while (n2 < n3) {
            String string2;
            Device device = (Device)vector.get(n2);
            Device device2 = Util.getDiskSet(device);
            if (device2 != null && (string2 = Util.getDeviceFullName(device2)) != null && string2.equals(string)) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public static int getLocalReplicaCount() {
        return Util.getReplicaCount("");
    }

    public static DeviceSize getSizeInGreatestUnits(long l, int n) {
        return Util.getSizeInGreatestUnits(l, n, 1005);
    }

    public static DeviceSize getSizeInGreatestUnits(long l, int n, int n2) {
        if (l == 0L) {
            return new DeviceSize(0L, 1001);
        }
        switch (n) {
            case 1001: {
                if (n2 == 1001 || l % 2L != 0L) break;
                l /= 2L;
            }
            case 1002: {
                if (n2 == 1002 || l % 1024L != 0L) {
                    n = 1002;
                    break;
                }
                l /= 1024L;
            }
            case 1003: {
                if (n2 == 1003 || l % 1024L != 0L) {
                    n = 1003;
                    break;
                }
                l /= 1024L;
            }
            case 1004: {
                if (n2 == 1004 || l % 1024L != 0L) {
                    n = 1004;
                    break;
                }
                l /= 1024L;
            }
            case 1005: {
                n = 1005;
            }
        }
        return new DeviceSize(l, n);
    }

    public static Device[] getParentDevicesFromSoftPartition(Device device) {
        Vector vector = app.getServiceWrapper().getAntecedents(device, "BasedOn");
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            Device device2 = (Device)vector.get(n);
            Object object = device2.getProperty("type");
            if (object.equals("Extent")) {
                Vector vector2 = app.getServiceWrapper().getAntecedents(device2, "BasedOn");
                return vector2.toArray(new Device[vector2.size()]);
            }
            ++n;
        }
        return new Device[0];
    }

    public static Device[] getHostsFromDevice(Device device) {
        Device device2 = Util.getDiskSet(device);
        if (device2 == null) {
            return new Device[0];
        }
        Vector vector = Util.getApp().getServiceWrapper().getAntecedents(device2, "HostInDiskGroup");
        return vector.toArray(new Device[vector.size()]);
    }

    public static Device getDiskSetOwner(Device device) {
        Device[] deviceArray = Util.getHostsFromDevice(device);
        Device device2 = null;
        int n = 0;
        while (n < deviceArray.length) {
            Boolean bl = (Boolean)deviceArray[n].getProperty("owner");
            if (bl.booleanValue()) {
                device2 = deviceArray[n];
                break;
            }
            ++n;
        }
        return device2;
    }

    public static boolean areSameHost(String string, String string2) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            InetAddress[] inetAddressArray = InetAddress.getAllByName(string2);
            int n = 0;
            while (n < inetAddressArray.length) {
                if (inetAddress.equals(inetAddressArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    public static boolean serverOwnsDiskSet(Device device) {
        Device device2 = Util.getDiskSet(device);
        Device device3 = Util.getDiskSetOwner(device2);
        if (device3 != null) {
            return Util.areSameHost(Util.getDeviceBaseName(device3), Util.getManagementServerName());
        }
        return false;
    }

    public static boolean serverOwnsAllDiskSets() {
        Vector vector = Util.getApp().getServiceWrapper().getDevices("Diskset");
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            Device device = (Device)vector.get(n);
            if (!Util.serverOwnsDiskSet(device)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static Device[] getOwnedDiskSets() {
        Vector vector = Util.getApp().getServiceWrapper().getDevices("Diskset");
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Device device = (Device)iterator.next();
            if (Util.serverOwnsDiskSet(device)) continue;
            iterator.remove();
        }
        return vector.toArray(new Device[vector.size()]);
    }

    public static String getManagementServerName() {
        return app.getApplicationContext().getManagementServerName();
    }

    public static double getDeviceSizeDifferenceAsPercentage(Device[] deviceArray) {
        long l = -1L;
        long l2 = -1L;
        int n = 0;
        while (n < deviceArray.length) {
            long l3 = Util.getDeviceSize(deviceArray[n]);
            if (l == -1L || l3 < l) {
                l = l3;
            }
            if (l2 == -1L || l3 > l2) {
                l2 = l3;
            }
            ++n;
        }
        if (l <= 0L || l2 <= 0L) {
            return 0.0;
        }
        double d = l;
        double d2 = l2;
        return (d2 - d) / d;
    }

    public static long getDeviceSizeDifferenceInBlocks(Device[] deviceArray) {
        long l = -1L;
        long l2 = -1L;
        int n = 0;
        while (n < deviceArray.length) {
            long l3 = Util.getDeviceSize(deviceArray[n]);
            if (l == -1L || l3 < l) {
                l = l3;
            }
            if (l2 == -1L || l3 > l2) {
                l2 = l3;
            }
            ++n;
        }
        if (l < 0L || l2 < 0L) {
            return 0L;
        }
        return l2 - l;
    }

    public static boolean areSizeDifferencesSignificant(Device[] deviceArray) {
        return Util.getDeviceSizeDifferenceAsPercentage(deviceArray) >= 0.1 || (double)Util.getDeviceSizeDifferenceInBlocks(deviceArray) >= 204800.0;
    }

    public static class DeviceSize {
        public long size;
        public int units;

        public DeviceSize(long l, int n) {
            this.size = l;
            this.units = n;
        }
    }
}

