/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.disksets;

import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.volmgr.client.DeviceTablePropertySheet;
import com.sun.admin.volmgr.client.disksets.ConfDiskSetPanel;
import com.sun.admin.volmgr.client.util.GUIUtil;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.wizards.AddDiskSetHostWizard;
import com.sun.admin.volmgr.common.Device;
import com.sun.management.viper.console.gui.VFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;

public class DiskSetHostTablePropertySheet
extends DeviceTablePropertySheet {
    private static final String TITLE = "hosts_props_tab";
    private static final String HELPFILE = "DiskSetHostTablePropertySheet.html";
    private Device device;
    private static String[] propKeys = new String[]{"name", "owner"};
    private JButton addButton;
    private JButton deleteButton;

    public DiskSetHostTablePropertySheet(Device device) {
        super(TITLE, HELPFILE, propKeys);
        this.device = device;
        this.initGUI();
    }

    private void setButtonState() {
        boolean bl = false;
        boolean bl2 = false;
        if (Util.getApp().getServiceWrapper().hasVolMgrWriteAuth() && Util.serverOwnsDiskSet(this.device)) {
            bl = true;
            if (this.table.getSelectedRows().length > 0) {
                bl2 = true;
            }
        }
        this.addButton.setEnabled(bl);
        this.deleteButton.setEnabled(bl2);
    }

    private void deleteHosts() {
        String string;
        Object object;
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        String string2 = Util.getDeviceBaseName(this.device);
        String[] stringArray = new String[nArray.length];
        String[] stringArray2 = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            object = (Device)this.model.getRow(nArray[n]);
            string = Util.getDeviceBaseName((Device)object);
            stringArray[n] = Util.getResourceString("diskset_delete_host_cmd", string);
            stringArray2[n] = Util.getBasedir() + "usr/sbin/metaset -s " + string2 + " -d -h " + string;
            ++n;
        }
        object = Util.getConfirmListener(stringArray, stringArray2);
        string = Util.getResourceString("sure_delete_diskset_host");
        ConfDiskSetPanel confDiskSetPanel = new ConfDiskSetPanel(stringArray2, string);
        String string3 = new String(Util.getResourceString("warning_delete_diskset_host"));
        WarningDialog warningDialog = new WarningDialog(GUIUtil.getParentJFrame((Component)((Object)this)), string3, (JPanel)confDiskSetPanel, (ActionListener)object, Util.getResourceString("warning_delete"));
    }

    private void addHosts() {
        new Thread(){

            public void run() {
                VFrame vFrame = new VFrame();
                Util.makeModal(GUIUtil.getParentJFrame((Component)((Object)DiskSetHostTablePropertySheet.this)), (Window)vFrame, true);
                AddDiskSetHostWizard addDiskSetHostWizard = new AddDiskSetHostWizard(DiskSetHostTablePropertySheet.this.device);
                addDiskSetHostWizard.init();
                addDiskSetHostWizard.setContainer((Component)vFrame);
                vFrame.showCenter((Component)GUIUtil.getAppFrame());
                addDiskSetHostWizard.start();
            }
        }.start();
    }

    protected Device[] getDevices() {
        return Util.getHostsFromDevice(this.device);
    }

    public void tableSelectionChanged(ListSelectionEvent listSelectionEvent) {
        this.setButtonState();
    }

    protected Component getMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        this.addButton = new JButton();
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiskSetHostTablePropertySheet.this.addHosts();
            }
        });
        Util.initButton(this.addButton, "add_host");
        jPanel.add(this.addButton);
        this.deleteButton = new JButton();
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiskSetHostTablePropertySheet.this.deleteHosts();
            }
        });
        Util.initButton(this.deleteButton, "delete_host");
        jPanel.add(this.deleteButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add(super.getMainPanel(), "Center");
        jPanel2.add((Component)jPanel, "South");
        return jPanel2;
    }

    protected void refresh() {
        super.refresh();
        this.setButtonState();
    }
}

