/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import opencard.core.OpenCardRuntimeException;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.service.CardChannel;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceOperationFailedException;
import opencard.core.service.CardServiceRegistry;
import opencard.core.service.CardServiceScheduler;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalFactory;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.Slot;
import opencard.core.util.OpenCardConfigurationProvider;
import opencard.core.util.OpenCardPropertyLoadingException;
import opencard.core.util.Tracer;

public final class SmartCard
implements CTListener {
    private Tracer itracer = new Tracer((Object)this, class$opencard$core$service$SmartCard == null ? (class$opencard$core$service$SmartCard = SmartCard.class$("opencard.core.service.SmartCard")) : class$opencard$core$service$SmartCard);
    private static Tracer ctracer = new Tracer(class$opencard$core$service$SmartCard == null ? (class$opencard$core$service$SmartCard = SmartCard.class$("opencard.core.service.SmartCard")) : class$opencard$core$service$SmartCard);
    private static final boolean SMARTCARD_CLOSED = false;
    private static final boolean SMARTCARD_OPEN = true;
    private boolean smartCardState = false;
    private CardServiceScheduler scheduler = null;
    private CardID card_id = null;
    private CardTerminal card_terminal = null;
    private Slot card_slot = null;
    private CardChannel mutexCardChannel = null;
    private static boolean OCFisStarted = false;
    private static boolean loaderClassUsed = false;
    private Vector allocatedCS = new Vector();
    private static HashMap smartCardCache = null;
    private static HashMap schedulers = null;
    private static int refCount_ = 0;
    static /* synthetic */ Class class$opencard$core$service$SmartCard;

    public SmartCard(CardServiceScheduler cardServiceScheduler, CardID cardID) {
        ctracer.debug("<init>", "scheduler " + cardServiceScheduler + ", cid " + cardID);
        this.scheduler = cardServiceScheduler;
        this.card_id = cardID;
        this.card_slot = cardID.getSlot();
        this.card_terminal = cardID.getSlot().getCardTerminal();
        this.smartCardState = true;
        CardTerminalRegistry.getRegistry().addCTListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CardID reset() throws CardTerminalException {
        CardID cardID;
        block2: {
            this.itracer.debug("reset", "");
            CardChannel cardChannel = null;
            try {
                cardChannel = this.scheduler.allocateCardChannel(null, true);
                cardID = this.card_id = this.scheduler.getSlotChannel().reset(999999);
                Object var4_3 = null;
                if (cardChannel == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var4_4 = null;
                    if (cardChannel == null) break block3;
                    this.scheduler.releaseCardChannel(cardChannel);
                }
                throw throwable;
            }
            this.scheduler.releaseCardChannel(cardChannel);
        }
        return cardID;
    }

    public static boolean isStarted() {
        return OCFisStarted;
    }

    public static void shutdown() throws CardTerminalException {
        Object object;
        ctracer.debug("<shutdown>", "shutdown OpenCard");
        --refCount_;
        Iterator iterator = smartCardCache.values().iterator();
        while (iterator.hasNext()) {
            object = (SmartCard)iterator.next();
            ((SmartCard)object).close();
        }
        smartCardCache = null;
        schedulers = null;
        if (refCount_ == 0) {
            object = CardTerminalRegistry.getRegistry();
            Enumeration enumeration = ((CardTerminalRegistry)object).getCardTerminals();
            while (enumeration.hasMoreElements()) {
                CardTerminal cardTerminal = (CardTerminal)enumeration.nextElement();
                ((CardTerminalRegistry)object).remove(cardTerminal);
            }
            OCFisStarted = false;
        }
    }

    public static synchronized void start() throws OpenCardPropertyLoadingException, ClassNotFoundException, CardServiceException, CardTerminalException {
        if (!OCFisStarted) {
            ctracer.debug("<start>", "startup opencard");
            smartCardCache = new HashMap();
            schedulers = new HashMap();
            Properties properties = System.getProperties();
            String string = properties.getProperty("OpenCard.loaderClassName", "opencard.opt.util.OpenCardPropertyFileLoader");
            if (string != null && string.length() > 0) {
                ctracer.debug("<start>", "use loader class: " + string);
                try {
                    Class<?> clazz = Class.forName(string);
                    OpenCardConfigurationProvider openCardConfigurationProvider = (OpenCardConfigurationProvider)clazz.newInstance();
                    openCardConfigurationProvider.loadProperties();
                    ctracer.debug("<start>", "loader loaded properties: ");
                    loaderClassUsed = true;
                }
                catch (InstantiationException instantiationException) {
                    throw new CardServiceOperationFailedException(instantiationException.toString());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new CardServiceOperationFailedException(illegalAccessException.toString());
                }
            } else {
                ctracer.debug("<start>", "did not use a loader class!");
            }
            SmartCard.configureTerminalRegistry();
            SmartCard.configureServiceRegistry();
            OCFisStarted = true;
        } else {
            ctracer.debug("<start>", "already configured");
        }
        ++refCount_;
        ctracer.debug("<start>", "finished");
    }

    private static void configureServiceRegistry() throws CardServiceException {
        CardServiceRegistry cardServiceRegistry = CardServiceRegistry.getRegistry();
        StringTokenizer stringTokenizer = SmartCard.getRegistryEntry("OpenCard.services");
        if (stringTokenizer != null) {
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreElements()) {
                String string = (String)stringTokenizer.nextElement();
                try {
                    Class<?> clazz = Class.forName(string);
                    CardServiceFactory cardServiceFactory = (CardServiceFactory)clazz.newInstance();
                    cardServiceRegistry.add(cardServiceFactory);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ctracer.error("<configureServiceRegistry>", classNotFoundException.getMessage());
                }
                catch (InstantiationException instantiationException) {
                    ctracer.error("<configureServiceRegistry>", instantiationException.getMessage());
                    stringBuffer.append("\nClass \"").append(string).append("\" not instantiatable");
                }
                catch (IllegalAccessException illegalAccessException) {
                    ctracer.error("<configureServiceRegistry>", illegalAccessException.getMessage());
                    stringBuffer.append("\nClass \"").append(string).append("\" constructor not accessible");
                }
            }
            if (stringBuffer.length() > 0) {
                throw new CardServiceException(stringBuffer.toString());
            }
        } else {
            ctracer.debug("configureServiceRegistry", "no services entry in properties");
        }
    }

    private static void configureTerminalRegistry() throws ClassNotFoundException, CardTerminalException {
        CardTerminalRegistry cardTerminalRegistry = CardTerminalRegistry.getRegistry();
        StringTokenizer stringTokenizer = SmartCard.getRegistryEntry("OpenCard.terminals");
        Hashtable hashtable = new Hashtable();
        if (stringTokenizer != null) {
            while (stringTokenizer.hasMoreElements()) {
                String string = (String)stringTokenizer.nextElement();
                SmartCard.handleTerminalFactoryEntries(string, hashtable, cardTerminalRegistry);
            }
        } else {
            ctracer.debug("configureTerminalRegistry", "no terminals in properties");
        }
    }

    private static StringTokenizer getRegistryEntry(String string) {
        StringTokenizer stringTokenizer = null;
        String string2 = System.getProperty(string);
        ctracer.debug("getRegistryEntry", "tag " + string + " = " + string2);
        if (string2 != null) {
            stringTokenizer = new StringTokenizer(string2);
        }
        return stringTokenizer;
    }

    private static void handleTerminalFactoryEntries(String string, Hashtable hashtable, CardTerminalRegistry cardTerminalRegistry) throws ClassNotFoundException, CardTerminalException {
        CardTerminalFactory cardTerminalFactory = null;
        String[] stringArray = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        int n = stringTokenizer.countTokens();
        if (n > 0) {
            stringArray = new String[n - 1];
            int n2 = 0;
            String string2 = null;
            while (stringTokenizer.hasMoreElements()) {
                if (n2 == 0) {
                    string2 = (String)stringTokenizer.nextElement();
                } else {
                    stringArray[n2 - 1] = (String)stringTokenizer.nextElement();
                }
                ++n2;
            }
            cardTerminalFactory = (CardTerminalFactory)hashtable.get(string2);
            if (cardTerminalFactory == null) {
                try {
                    Class<?> clazz = Class.forName(string2);
                    cardTerminalFactory = (CardTerminalFactory)clazz.newInstance();
                    hashtable.put(string2, cardTerminalFactory);
                    cardTerminalFactory.createCardTerminals(cardTerminalRegistry, stringArray);
                }
                catch (InstantiationException instantiationException) {
                    throw new CardTerminalException(instantiationException.toString());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new CardTerminalException(illegalAccessException.toString());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ctracer.debug("handleTerminalFactoryEntries", "Class not found Exception" + classNotFoundException.getMessage());
                }
            } else {
                cardTerminalFactory.createCardTerminals(cardTerminalRegistry, stringArray);
            }
        }
    }

    public CardService getCardService(Class clazz, boolean bl) throws ClassNotFoundException, CardServiceException {
        CardService cardService = null;
        this.itracer.debug("getCardService", "(" + clazz + ")");
        this.assertSmartCardOpen();
        cardService = CardServiceRegistry.getRegistry().getCardServiceInstance(clazz, this.card_id, this.scheduler, this, bl);
        if (this.mutexCardChannel != null && this.mutexCardChannel.isOpen()) {
            cardService.setCardChannel(this.mutexCardChannel);
        }
        this.allocatedCS.addElement(cardService);
        return cardService;
    }

    public CardID getCardID() {
        this.assertSmartCardOpen();
        return this.card_id;
    }

    public synchronized void beginMutex() throws InterruptedException, CardTerminalException {
        this.assertSmartCardOpen();
        this.mutexCardChannel = this.scheduler.allocateCardChannel(this, true);
        if (this.mutexCardChannel == null) {
            throw new InterruptedException("beginMutex");
        }
        Enumeration enumeration = this.allocatedCS.elements();
        while (enumeration.hasMoreElements()) {
            CardService cardService = (CardService)enumeration.nextElement();
            cardService.setCardChannel(this.mutexCardChannel);
        }
    }

    public synchronized void endMutex() {
        this.assertSmartCardOpen();
        this.scheduler.releaseCardChannel(this.mutexCardChannel);
        this.mutexCardChannel = null;
        Enumeration enumeration = this.allocatedCS.elements();
        while (enumeration.hasMoreElements()) {
            CardService cardService = (CardService)enumeration.nextElement();
            cardService.setCardChannel(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws CardTerminalException {
        if (!this.smartCardState) {
            return;
        }
        this.itracer.debug("close", "SmartCard closing");
        if (this.mutexCardChannel != null) {
            this.endMutex();
        }
        HashMap hashMap = smartCardCache;
        synchronized (hashMap) {
            smartCardCache.remove(this);
        }
        this.smartCardState = false;
        this.scheduler.releaseSmartCard(this);
        CardTerminalRegistry.getRegistry().removeCTListener(this);
    }

    protected void finalize() {
        if (this.smartCardState) {
            try {
                this.close();
            }
            catch (CardTerminalException cardTerminalException) {
                this.itracer.error("finalize", cardTerminalException.toString());
            }
        }
    }

    private void assertSmartCardOpen() {
        if (!this.smartCardState) {
            throw new OpenCardRuntimeException("SmartCard closed");
        }
    }

    public synchronized void cardRemoved(CardTerminalEvent cardTerminalEvent) throws CardTerminalException {
        if (cardTerminalEvent.getSlot() == this.card_slot) {
            this.close();
        }
    }

    public void cardInserted(CardTerminalEvent cardTerminalEvent) {
    }

    public void addCTListener(CTListener cTListener) {
        this.card_terminal.addCTListener(cTListener);
    }

    public void removeCTListener(CTListener cTListener) {
        this.card_terminal.removeCTListener(cTListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SmartCard getSmartCard(CardTerminalEvent cardTerminalEvent) throws CardTerminalException {
        Object object;
        ctracer.debug("getSmartCard", "event " + cardTerminalEvent);
        Slot slot = cardTerminalEvent.getSlot();
        CardServiceScheduler cardServiceScheduler = null;
        HashMap hashMap = schedulers;
        synchronized (hashMap) {
            cardServiceScheduler = (CardServiceScheduler)schedulers.get(slot);
            if (cardServiceScheduler == null) {
                object = (CardTerminal)cardTerminalEvent.getSource();
                cardServiceScheduler = new CardServiceScheduler(((CardTerminal)object).openSlotChannel(slot));
                schedulers.put(slot, cardServiceScheduler);
            }
        }
        ctracer.debug("getSmartCard", "using CardServiceScheduler " + cardServiceScheduler);
        object = cardServiceScheduler.createSmartCard(slot.getCardID());
        if (object != null) {
            HashMap hashMap2 = smartCardCache;
            synchronized (hashMap2) {
                smartCardCache.put(object, "");
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void releaseScheduler(CardServiceScheduler cardServiceScheduler) {
        ctracer.debug("releaseScheduler", "releasing scheduler " + cardServiceScheduler);
        HashMap hashMap = schedulers;
        synchronized (hashMap) {
            schedulers.remove(cardServiceScheduler.getSlotChannel().getSlot());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

